/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.config.ClientSetting;
import oracle.ide.config.IdeSettings;
import oracle.ide.controls.GridBagConstraints2;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.DynamicPropertySet;
import oracle.javatools.util.DynamicPropertySetImpl;
import oracle.jdeveloper.cm.CMUtils;
import oracle.jdeveloper.cm.ConnectionDescriptor;
import oracle.jdeveloper.cm.ConnectionManager;
import oracle.jdeveloper.cm.ConnectionType;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdeveloper.cm.dt.ConnectionEditor;

public class ConnectionPanelUI
extends JPanel
implements ItemListener,
ActionListener {
    private String[] _types;
    private boolean _oracleOnly;
    private BorderLayout mainLayout;
    private JPanel subPanel;
    private GridBagLayout subLayout;
    private JWrappedLabel connectionPrompt;
    private JLabel connectionLabel;
    protected JComboBox connectionsCombo;
    private DefaultComboBoxModel connectionsModel;
    protected JButton newButton;
    private JButton editButton;
    private GridBagLayout detailsLayout;
    private JPanel detailsPanel;
    private JLabel usernameLabel;
    private JLabel usernameField;
    private JLabel driverLabel;
    private JLabel driverField;
    private JLabel urlLabel;
    private JLabel urlField;
    public static final String CONN_PANEL_SETTINGS_KEY = "ConnectionPanelSettings";
    public static final String LAST_CONNECTION_KEY = "lastConnection";

    void $init$() {
        this.mainLayout = new BorderLayout();
        this.subPanel = new JPanel();
        this.subLayout = new GridBagLayout();
        this.connectionPrompt = new JWrappedLabel();
        this.connectionLabel = new JLabel();
        this.connectionsCombo = new JComboBox();
        this.connectionsModel = new NonNullableComboBoxModel();
        this.newButton = new JButton();
        this.editButton = new JButton();
        this.detailsLayout = new GridBagLayout();
        this.detailsPanel = new JPanel();
        this.usernameLabel = new JLabel();
        this.usernameField = new JLabel();
        this.driverLabel = new JLabel();
        this.driverField = new JLabel();
        this.urlLabel = new JLabel();
        this.urlField = new JLabel();
    }

    protected ConnectionPanelUI() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ConnectionPanelUI(String string, boolean bl) {
        this();
        String[] stringArray;
        if (string == null) {
            if (bl) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "JDBC";
            } else {
                String[] stringArray3 = new String[4];
                stringArray3[0] = "JDBC";
                stringArray3[1] = "OTHER_JDBC";
                stringArray3[2] = "JDBC_ODBC";
                stringArray = stringArray3;
                stringArray3[3] = "ORACLE_LITE";
            }
        } else {
            String[] stringArray4 = new String[1];
            stringArray = stringArray4;
            stringArray4[0] = string;
        }
        String[] stringArray5 = stringArray;
        this.setConnectionInfo(stringArray5, bl);
    }

    public ConnectionPanelUI(String string) {
        this();
        String[] stringArray = null;
        try {
            stringArray = ConnectionManager.getInstance().getConnectionTypeNamesForClass(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setConnectionInfo(stringArray, false);
    }

    public ConnectionPanelUI(String[] stringArray) {
        this();
        this.setConnectionInfo(stringArray, false);
    }

    public void setCanAddNull(boolean bl) {
        boolean bl2 = this.connectionsModel instanceof NonNullableComboBoxModel ^ true;
        NonNullableComboBoxModel nonNullableComboBoxModel = null;
        if (bl && !bl2) {
            nonNullableComboBoxModel = new DefaultComboBoxModel();
        } else if (!bl && bl2) {
            nonNullableComboBoxModel = new NonNullableComboBoxModel();
        }
        if (nonNullableComboBoxModel != null) {
            DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.connectionsCombo.getModel();
            int n = 0;
            while (n < defaultComboBoxModel.getSize()) {
                nonNullableComboBoxModel.addElement(defaultComboBoxModel.getElementAt(n));
                ++n;
            }
            this.connectionsModel = nonNullableComboBoxModel;
            this.connectionsCombo.setModel(nonNullableComboBoxModel);
            this._enableButtons();
        }
    }

    public Component getDefaultFocusComponent() {
        if (this.connectionsCombo.getItemCount() < 1) {
            return this.newButton;
        }
        return this.connectionsCombo;
    }

    public JComboBox getConnCombo() {
        return this.connectionsCombo;
    }

    private void setConnectionInfo(String[] stringArray, boolean bl) {
        this._types = stringArray;
        this._oracleOnly = bl;
        if (stringArray != null) {
            boolean bl2 = false;
            ConnectionManager connectionManager = ConnectionManager.getInstance();
            int n = 0;
            while (n < stringArray.length) {
                ConnectionType connectionType = connectionManager.getConnectionType(stringArray[n]);
                if ("CLASS_DATABASE".equals(connectionType.getConnectionClassName())) {
                    bl2 = true;
                    break;
                }
                ++n;
            }
            this.driverLabel.setVisible(bl2);
            this.driverField.setVisible(bl2);
        }
        if (this.resetConnections() > 0) {
            this.connectionsCombo.setSelectedIndex(0);
            ItemEvent itemEvent = new ItemEvent(this.connectionsCombo, 701, new Integer(0), 1);
            this.itemStateChanged(itemEvent);
        }
    }

    public int resetConnections() {
        if (this.connectionsModel.getSize() > 0) {
            this.removeListeners();
            this.connectionsModel.removeAllElements();
            this.connectionsCombo.setSelectedIndex(-1);
            this.addListeners();
        }
        Object[] objectArray = new String[]{};
        int n = objectArray.length;
        if (this._types != null) {
            ConnectionManager connectionManager = ConnectionManager.getInstance();
            try {
                int n2 = 0;
                while (n2 < this._types.length) {
                    int n3;
                    String[] stringArray = connectionManager.getConnectionNames(this._types[n2], this._oracleOnly);
                    int n4 = n3 = stringArray == null ? 0 : stringArray.length;
                    if (n3 > 0) {
                        Object[] objectArray2 = objectArray;
                        objectArray = new String[n + n3];
                        if (n > 0) {
                            System.arraycopy(objectArray2, 0, objectArray, 0, n);
                        }
                        System.arraycopy(stringArray, 0, objectArray, n, n3);
                        n = objectArray.length;
                    }
                    ++n2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Arrays.sort(objectArray);
        int n5 = 0;
        while (n5 < n) {
            this.connectionsModel.addElement(objectArray[n5]);
            ++n5;
        }
        return objectArray.length;
    }

    public static String getConnection(String string, String string2, String string3, String string4, boolean bl) {
        ConnectionPanelUI connectionPanelUI = new ConnectionPanelUI();
        HelpSystem.getHelpSystem().registerTopic((JComponent)connectionPanelUI, "f1_sql_view_connect_html");
        JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)connectionPanelUI, (Component)connectionPanelUI.getDefaultFocusComponent(), (String)string);
        connectionPanelUI.connectionsCombo.addItemListener(new 1(connectionPanelUI, jEWTDialog));
        jEWTDialog.setOKButtonEnabled(false);
        connectionPanelUI.setConnectionPrompt(string2);
        String[] stringArray = null;
        try {
            stringArray = ConnectionManager.getInstance().getConnectionTypeNamesForClass(string4);
        }
        catch (Exception exception) {
            // empty catch block
        }
        connectionPanelUI.setConnectionInfo(stringArray, bl);
        if (string3 != null) {
            connectionPanelUI.setConnectionName(string3);
        }
        return WizardLauncher.runDialog((JDialog)jEWTDialog) ? connectionPanelUI.getConnectionName() : null;
    }

    private void jbInit() throws Exception {
        this.connectionPrompt.setText(ConnectionArb.getString(106));
        this.connectionPrompt.setBorder(BorderFactory.createEmptyBorder(0, 0, 15, 0));
        ResourceUtils.resLabel((JLabel)this.connectionLabel, (Component)this.connectionsCombo, (String)ConnectionArb.getString(105));
        this.connectionsCombo.setModel(this.connectionsModel);
        ResourceUtils.resButton((AbstractButton)this.newButton, (String)ConnectionArb.getString(100));
        ResourceUtils.resButton((AbstractButton)this.editButton, (String)ConnectionArb.getString(101));
        this.editButton.setEnabled(false);
        this.usernameLabel.setText(ConnectionArb.getString(103));
        this.usernameLabel.setEnabled(false);
        this.driverLabel.setText(ConnectionArb.getString(102));
        this.driverLabel.setEnabled(false);
        this.urlLabel.setText(ConnectionArb.getString(104));
        this.urlLabel.setEnabled(false);
        this.detailsPanel.setBorder(BorderFactory.createEtchedBorder());
        this.detailsPanel.setLayout(this.detailsLayout);
        this.detailsPanel.add((Component)this.usernameLabel, new GridBagConstraints2(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.detailsPanel.add((Component)this.usernameField, new GridBagConstraints2(1, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.detailsPanel.add((Component)this.driverLabel, new GridBagConstraints2(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.detailsPanel.add((Component)this.driverField, new GridBagConstraints2(1, 1, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.detailsPanel.add((Component)this.urlLabel, new GridBagConstraints2(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.detailsPanel.add((Component)this.urlField, new GridBagConstraints2(1, 2, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.subPanel.setLayout(this.subLayout);
        this.subPanel.add((Component)this.connectionLabel, new GridBagConstraints2(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.subPanel.add((Component)this.connectionsCombo, new GridBagConstraints2(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.subPanel.add((Component)this.newButton, new GridBagConstraints2(2, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.subPanel.add((Component)this.detailsPanel, new GridBagConstraints2(0, 1, 2, 2, 1.0, 1.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.subPanel.add((Component)this.editButton, new GridBagConstraints2(2, 1, 1, 1, 0.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.setLayout(this.mainLayout);
        this.add((Component)this.connectionPrompt, "North");
        this.add((Component)this.subPanel, "Center");
        this.addListeners();
    }

    private void addListeners() {
        this.connectionsCombo.addItemListener(this);
        this.newButton.addActionListener(this);
        this.editButton.addActionListener(this);
    }

    private void removeListeners() {
        this.connectionsCombo.removeItemListener(this);
        this.newButton.removeActionListener(this);
        this.editButton.removeActionListener(this);
    }

    public String getConnectionName() {
        return (String)this.connectionsModel.getSelectedItem();
    }

    public void setConnectionName(String string) {
        if (this.connectionsModel.getIndexOf(string) != -1) {
            this.connectionsModel.setSelectedItem(string);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        try {
            ConnectionManager connectionManager = ConnectionManager.getInstance();
            String string = (String)this.connectionsModel.getSelectedItem();
            ConnectionDescriptor connectionDescriptor = connectionManager.getConnectionDescriptor(string);
            boolean bl = connectionDescriptor != null;
            this.editButton.setEnabled(bl);
            this.usernameLabel.setEnabled(bl);
            this.usernameField.setText(bl ? connectionDescriptor.getProperty("user") : null);
            this.driverLabel.setEnabled(bl);
            this.driverField.setText(bl ? connectionDescriptor.getProperty("JdbcDriver") : null);
            this.urlLabel.setEnabled(bl);
            this.urlField.setText(bl ? CMUtils.getUrl((String)"JDBC", (ConnectionDescriptor)connectionDescriptor) : null);
        }
        catch (Exception exception) {
            this.usernameLabel.setEnabled(false);
            this.usernameField.setText(null);
            this.driverLabel.setEnabled(false);
            this.driverField.setText(null);
            this.urlLabel.setEnabled(false);
            this.urlField.setText(null);
            this.editButton.setEnabled(false);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl = actionEvent.getSource() == this.editButton;
        int n = bl ? 2 : 1;
        this.editButton.setEnabled(false);
        this.newButton.setEnabled(false);
        ConnectionEditor connectionEditor = new ConnectionEditor();
        if (connectionEditor == null) {
            this._enableButtons();
            return;
        }
        if (connectionEditor.runConnectionEditor(this.getConnectionName(), n, this._types)) {
            String string;
            ConnectionDescriptor connectionDescriptor = connectionEditor.getConnectionDescriptor();
            String string2 = string = connectionDescriptor != null ? connectionDescriptor.getConnectionName() : null;
            if (string != null && this.resetConnections() > 0) {
                if (bl) {
                    this.connectionsCombo.setSelectedIndex(-1);
                }
                this.setConnectionName(string);
            }
        }
        this._enableButtons();
    }

    public void setConnectionPrompt(String string) {
        if (string == null) {
            this.remove((Component)this.connectionPrompt);
        } else {
            this.connectionPrompt.setText(string);
            this.add((Component)this.connectionPrompt, "North");
        }
        this.validate();
    }

    public void enableActiveComponents(boolean bl) {
        this.usernameLabel.setEnabled(bl);
        this.usernameField.setEnabled(bl);
        this.driverLabel.setEnabled(bl);
        this.driverField.setEnabled(bl);
        this.urlLabel.setEnabled(bl);
        this.urlField.setEnabled(bl);
        this.connectionLabel.setEnabled(bl);
        this.connectionsCombo.setEnabled(bl);
        if (bl) {
            this._enableButtons();
        } else {
            this.newButton.setEnabled(false);
            this.editButton.setEnabled(false);
        }
    }

    protected void _enableButtons() {
        this.newButton.setEnabled(true);
        this.editButton.setEnabled(ModelUtil.hasLength((String)((String)this.connectionsModel.getSelectedItem())));
    }

    public void loadSettings() {
        String string = null;
        IdeSettings ideSettings = Ide.getSettings();
        DynamicPropertySet dynamicPropertySet = (DynamicPropertySet)ideSettings.getData(CONN_PANEL_SETTINGS_KEY);
        if (dynamicPropertySet != null && ModelUtil.hasLength((String)(string = (String)dynamicPropertySet.getProperty(LAST_CONNECTION_KEY))) && this.connectionsModel.getIndexOf(string) >= 0) {
            this.connectionsCombo.setSelectedItem(string);
        }
    }

    public void saveSettings() {
        String string = (String)this.connectionsCombo.getSelectedItem();
        if (ModelUtil.hasLength((String)string)) {
            IdeSettings ideSettings = Ide.getSettings();
            DynamicPropertySet dynamicPropertySet = (DynamicPropertySet)ideSettings.getData(CONN_PANEL_SETTINGS_KEY);
            if (dynamicPropertySet == null) {
                dynamicPropertySet = new DynamicPropertySetImpl();
                ClientSetting.findOrCreate((String)"oracle.onlinedb").putData(CONN_PANEL_SETTINGS_KEY, (Copyable)dynamicPropertySet);
            }
            dynamicPropertySet.setProperty(LAST_CONNECTION_KEY, (Object)string);
        }
    }

    public static final class 1
    implements ItemListener {
        private final /* synthetic */ ConnectionPanelUI v$panel;
        private final /* synthetic */ JEWTDialog v$dlg;

        public void itemStateChanged(ItemEvent itemEvent) {
            boolean bl = this.v$panel.connectionsCombo.getSelectedIndex() != -1;
            this.v$dlg.setOKButtonEnabled(bl);
        }

        public 1(ConnectionPanelUI connectionPanelUI, JEWTDialog jEWTDialog) {
            this.v$dlg = jEWTDialog;
            this.v$panel = connectionPanelUI;
        }
    }
}

