/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt.wizard;

import java.util.ArrayList;
import java.util.ListIterator;
import oracle.ide.dialogs.MessageDialog;
import oracle.javatools.db.Database;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdeveloper.cm.dt.wizard.DBWizardFactory;

public final class DBWizardFactoryRegistry {
    private static ArrayList _factories = new ArrayList();

    private DBWizardFactoryRegistry() {
    }

    public static void registerDBWizardFactory(Class clazz, DBWizardFactory dBWizardFactory) {
        _factories.add(new Entry(clazz, dBWizardFactory));
    }

    public static DBWizardFactory getDBWizardFactory(Database database) {
        if (database != null) {
            Class<?> clazz = database.getClass();
            ListIterator listIterator = _factories.listIterator(_factories.size());
            while (listIterator.hasPrevious()) {
                Entry entry = (Entry)listIterator.previous();
                if (!entry._dbClass.isAssignableFrom(clazz)) continue;
                return entry._factory;
            }
        }
        return null;
    }

    public static void showUnsupportedDBError(String string, String string2) {
        String string3 = ConnectionArb.format(495, string, string2);
        MessageDialog.error(null, (Object)string3, (String)ConnectionArb.getString(496), null);
    }

    private static class Entry {
        Class _dbClass;
        DBWizardFactory _factory;

        Entry(Class clazz, DBWizardFactory dBWizardFactory) {
            this._dbClass = clazz;
            this._factory = dBWizardFactory;
        }
    }
}

