/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import oracle.ide.component.NewFilePanel;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.ResourceUtils;
import oracle.ide.wizard.FinishPanel;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DDLGenerator;
import oracle.javatools.db.Ddl;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.ValidationException;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdevimpl.cm.dt.sqlplus.SqlNode;
import oracle.jdevimpl.cm.dt.wizards.CmWizardsArb;

public class SchemaObjectFinishPanel
extends FinishPanel
implements ActionListener {
    private JPanel pnlMain;
    private BorderLayout layMain;
    private JMultiLineLabel lblTop;
    private JPanel pnlSQL;
    private GridBagLayout laySQL;
    private JLabel lblSQL;
    private JScrollPane scrSQL;
    private JButton btnSave;
    private JTextArea txtSQL;

    void $init$() {
        this.pnlMain = new JPanel();
        this.layMain = new BorderLayout();
        this.lblTop = new JMultiLineLabel();
        this.pnlSQL = new JPanel();
        this.laySQL = new GridBagLayout();
        this.lblSQL = new JLabel();
        this.scrSQL = new JScrollPane();
        this.btnSave = new JButton();
        this.txtSQL = new JTextArea();
    }

    public SchemaObjectFinishPanel() {
        this(false);
    }

    public SchemaObjectFinishPanel(boolean bl) {
        this.$init$();
        try {
            this.jbInit(bl);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit(boolean bl) throws Exception {
        if (bl) {
            this.layoutComponents((JPanel)((Object)this), bl);
        } else {
            this.layoutComponents(this.pnlMain, bl);
            this.setFinishComponent(this.pnlMain);
        }
    }

    private void layoutComponents(JPanel jPanel, boolean bl) {
        jPanel.setLayout(this.layMain);
        this.lblTop.setText(CmWizardsArb.getString(bl ? 177 : 176));
        this.lblTop.setPreferredAspectRatio(0.0f);
        this.pnlSQL.setLayout(this.laySQL);
        ResourceUtils.resLabel((JLabel)this.lblSQL, (Component)this.txtSQL, (String)CmWizardsArb.getString(178));
        this.btnSave.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this.btnSave, (String)CmWizardsArb.getString(179));
        this.txtSQL.setEditable(false);
        jPanel.add((Component)this.lblTop, "North");
        this.pnlSQL.add((Component)this.lblSQL, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.scrSQL.getViewport().add((Component)this.txtSQL, null);
        this.pnlSQL.add((Component)this.scrSQL, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.pnlSQL.add((Component)this.btnSave, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.pnlSQL, "Center");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        URLChooser uRLChooser = DialogUtil.newURLChooser();
        uRLChooser.clearChooseableURLFilters();
        uRLChooser.setURLFilter(SqlNode.SQL_FILTER);
        URL uRL = null;
        while (uRLChooser.showSaveDialog((Component)((Object)this)) == 0) {
            uRL = uRLChooser.getSelectedURL();
            if (!ModelUtil.hasLength((String)URLFileSystem.getSuffix((URL)uRL))) {
                String string = URLFileSystem.getPath((URL)uRL);
                uRL = URLFactory.replacePathPart((URL)uRL, (String)(string + ".sql"));
            }
            try {
                uRL = NewFilePanel.validateURL((Component)((Object)this), (URL)uRL, (String)ConnectionArb.getString(303), (boolean)true);
            }
            catch (TraversalException traversalException) {
                traversalException.showMessageDialog((Component)((Object)this));
                break;
            }
            if (uRL == null) continue;
        }
        if (uRL != null) {
            try {
                OutputStream outputStream = URLFileSystem.openOutputStream((URL)uRL);
                BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, IdeUtil.getIdeEncoding()));
                bufferedWriter.write(this.txtSQL.getText());
                ((Writer)bufferedWriter).flush();
                ((Writer)bufferedWriter).close();
            }
            catch (IOException iOException) {
                ExceptionDialog.showExceptionDialog((Component)((Object)this), (Throwable)iOException, (String)CmWizardsArb.getString(180), (String)CmWizardsArb.getString(181), null);
            }
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        SchemaObject schemaObject = (SchemaObject)traversableContext.get("NewObject");
        SchemaObject schemaObject2 = (SchemaObject)traversableContext.get("OriginalObject");
        DBObjectProvider dBObjectProvider = (DBObjectProvider)traversableContext.get("DBObjectProvider");
        try {
            if (schemaObject2 == null) {
                dBObjectProvider.validateObject((DBObject)schemaObject);
            } else {
                dBObjectProvider.validateObject((DBObject)schemaObject2, (DBObject)schemaObject);
            }
        }
        catch (ValidationException validationException) {
            ExceptionDialog.showExceptionDialog((Component)((Object)this), (Throwable)validationException);
        }
        DDLGenerator dDLGenerator = (DDLGenerator)traversableContext.get("DDlGenerator");
        String string = schemaObject2 == null ? this._generateSQL(dDLGenerator.getCreateDDL(schemaObject, false, false)) : this._generateSQL(dDLGenerator.getUpdateDDL(schemaObject2, schemaObject));
        this.txtSQL.setText(string);
        this.setFinishText(schemaObject2 == null ? CmWizardsArb.format(175, schemaObject.getType().toLowerCase()) : null);
    }

    private String _generateSQL(Ddl ... ddlArray) {
        StringBuffer stringBuffer = new StringBuffer();
        Ddl[] ddlArray2 = ddlArray;
        int n = 0;
        while (n < ddlArray2.length) {
            Ddl ddl = ddlArray2[n];
            stringBuffer.append(ddl.getDdl());
            ++n;
        }
        return stringBuffer.toString();
    }
}

