/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.panels;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.bali.ewt.shuttle.ListPicker;
import oracle.bali.ewt.shuttle.Shuttle;
import oracle.bali.ewt.shuttle.ShuttleEvent;
import oracle.bali.ewt.shuttle.ShuttleListener;
import oracle.ide.Ide;
import oracle.ide.config.ClientSetting;
import oracle.ide.config.IdeSettings;
import oracle.ide.controls.GridBagConstants;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.controls.UpperCaseTextField;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.ide.util.SwingWorker;
import oracle.ide.wizard.WizardCallbacks;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.DynamicPropertySet;
import oracle.javatools.util.DynamicPropertySetImpl;
import oracle.jdeveloper.cm.CMException;
import oracle.jdeveloper.cm.ConnectionDescriptor;
import oracle.jdeveloper.cm.ConnectionManager;
import oracle.jdeveloper.cm.JdbcConnectionWrapper;
import oracle.jdeveloper.cm.ds.db.DatabaseFactory;
import oracle.jdeveloper.cm.dt.ui.DBObjectRenderer;
import oracle.jdeveloper.resource.PanelsArb;
import oracle.jdevimpl.cm.dt.wizards.CmWizardsArb;

public abstract class SelectDatabaseObjectsPanel
extends DefaultTraversablePanel
implements FocusListener,
ShuttleListener,
ListSelectionListener,
DocumentListener,
ActionListener,
GridBagConstants {
    protected JPanel dbObjPanel;
    protected final JTextField filterField;
    public static final String FILTER_FIELD_NAME = "Filter Field";
    protected final JCheckBox autoQueryCheck;
    public static final String AUTO_QUERY_CHECK_NAME = "Auto Query Checkbox";
    protected final JComboBox schemaCombo;
    public static final String SCHEMA_COMBO_NAME = "Schema Combo";
    protected final JButton queryButton;
    public static final String QUERY_BUTTON_NAME = "Query Button";
    protected final JCheckBox tablesCheck;
    public static final String TABLES_CHECK_NAME = "Tables Checkbox";
    protected final JCheckBox viewsCheck;
    public static final String VIEWS_CHECK_NAME = "Views Checkbox";
    protected final JCheckBox synonymsCheck;
    public static final String SYNONYMS_CHECK_NAME = "Synonyms Checkbox";
    protected final JCheckBox snapshotsCheck;
    public static final String SNAPSHOTS_CHECK_NAME = "Snapshots Checkbox";
    protected Shuttle _shuttle;
    protected ListPicker _availableTablesPicker;
    protected JPanel _dbObjQueryAlertPanel;
    protected final DefaultListModel availableTablesModel;
    protected final JList availableTablesList;
    public static final String AVAILABLE_TABLES_LIST_NAME = "Available Tables List";
    protected final DefaultListModel chosenTablesModel;
    protected final JList chosenTablesList;
    public static final String CHOSEN_TABLES_LIST_NAME = "Chosen Tables List";
    private JPanel entityPanel;
    protected final JLabel entityNameLabel;
    protected final JTextField entityNameField;
    public static final String ENTITY_FIELD_NAME = "Entity Field";
    private final JPanel statusPanel;
    private final JLabel statusLabel;
    private JPanel errorPanel;
    private JWrappedLabel errorLabel;
    private boolean _errorPanelShown;
    protected boolean _initialized;
    protected String _connectionUrl;
    protected WizardCallbacks _wizardCallbacks;
    protected Namespace _namespace;
    protected DBObjectProvider _dbObjectProvider;
    protected SwingWorker _connWorker;
    protected SwingWorker _schemaWorker;
    protected SwingWorker _tableWorker;
    protected DatabaseMetaData _metaData;
    protected Database _database;
    protected String _currSchema;
    protected String _currTableFilter;
    protected ArrayList _queriedTablesList;
    protected Set _chosenTablesSet;
    protected boolean _includeSnapshotsCheck;
    protected boolean _snapshotsIncluded;
    protected boolean _includeEntityField;
    protected boolean _entityFieldIncluded;
    protected boolean _canSelectViews;
    protected boolean _viewSelectIncluded;
    protected boolean _canSelectSynonyms;
    protected boolean _synonymSelectIncluded;
    protected static final DataFlavor TABLE_FLAVOR = new DataFlavor(String.class, "java.lang.String");
    private static final String DB_OBJECT_PROVIDER_URL = "Offline Database Connection";
    private static final String DB_OBJECT_PROVIDER = "_dbObjectProvider";
    public static final String CURR_CONN_NAME = "currConnName";
    public static final String DATABASE_METADATA = "databaseMetadata";
    public static final String CHOSEN_TABLES = "chosenTables";
    public static final String SELECT_DB_OBJECTS_SETTINGS_KEY = "selectDatabaseObjectsSettings";
    public static final String SETTINGS_AUTO_QUERY_KEY = "autoQuery";
    public static final String SETTINGS_QUERY_TABLES_KEY = "queryTables";
    public static final String SETTINGS_QUERY_VIEWS_KEY = "queryViews";
    public static final String SETTINGS_QUERY_SYNONYMS_KEY = "querySynonyms";
    public static final String SETTINGS_QUERY_SNAPSHOTS_KEY = "querySnapshots";
    protected static final int VERTICAL_SPACE_SIZE = 5;
    private Timer _timer;

    void $init$() {
        this.filterField = new UpperCaseTextField();
        this.autoQueryCheck = new JCheckBox();
        this.schemaCombo = new JComboBox();
        this.queryButton = new JButton();
        this.tablesCheck = new JCheckBox();
        this.viewsCheck = new JCheckBox();
        this.synonymsCheck = new JCheckBox();
        this.snapshotsCheck = new JCheckBox();
        this.availableTablesModel = new DefaultListModel();
        this.availableTablesList = new JList(this.availableTablesModel);
        this.chosenTablesModel = new DefaultListModel();
        this.chosenTablesList = new JList(this.chosenTablesModel);
        this.entityNameLabel = new JLabel();
        this.entityNameField = new JTextField();
        this.statusPanel = new JPanel(new GridBagLayout());
        this.statusLabel = new JLabel();
        this._currTableFilter = "";
        this._chosenTablesSet = new HashSet();
        this._canSelectViews = true;
        this._canSelectSynonyms = true;
    }

    public SelectDatabaseObjectsPanel() {
        this.$init$();
        try {
            this.layoutComponents();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setHelpID(this.getHelpID());
        this.statusLabel.setForeground(SystemColor.BLUE);
    }

    private void layoutComponents() throws Exception {
        this.setLayout(new GridBagLayout());
        this.dbObjPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        this.filterField.setDoubleBuffered(false);
        JLabel jLabel3 = new JLabel();
        this.tablesCheck.setSelected(true);
        this.viewsCheck.setSelected(false);
        this.synonymsCheck.setSelected(false);
        this.snapshotsCheck.setSelected(false);
        this.statusPanel.add((Component)this.statusLabel, this.gbc(0, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.dbObjPanel.add((Component)jLabel2, this.gbc(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(this.getVerticalSpaceSize(), 0, 0, 5), 0, 0));
        this.dbObjPanel.add((Component)this.filterField, this.gbc(1, 0, 3, 1, 1.0, 0.0, 17, 2, new Insets(this.getVerticalSpaceSize(), 0, 0, 5), 0, 0));
        this.dbObjPanel.add((Component)this.autoQueryCheck, this.gbc(4, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(this.getVerticalSpaceSize(), 0, 0, 5), 0, 0));
        this.dbObjPanel.add((Component)jLabel, this.gbc(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(this.getVerticalSpaceSize(), 0, 0, 5), 0, 0));
        this.dbObjPanel.add((Component)this.schemaCombo, this.gbc(1, 1, 3, 1, 1.0, 0.0, 17, 2, new Insets(this.getVerticalSpaceSize(), 0, 0, 5), 0, 0));
        this.dbObjPanel.add((Component)this.queryButton, this.gbc(4, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(this.getVerticalSpaceSize(), 0, 0, 5), 0, 0));
        this.dbObjPanel.add((Component)jLabel3, this.gbc(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(this.getVerticalSpaceSize(), 0, 0, 5), 0, 0));
        this.dbObjPanel.add((Component)this.tablesCheck, this.gbc(1, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(this.getVerticalSpaceSize(), 0, 0, 5), 0, 0));
        this.maybeIncludeViewsCheck();
        this.maybeIncludeSynonymCheck();
        this.maybeIncludeSnapshotsCheck();
        this.add(this.dbObjPanel, this.gbc(0, 0, 2, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.showDbObjQueryAlert(false);
        this.add(this.statusPanel, this.gbc(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jLabel3.setText(PanelsArb.getString((int)5));
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this.filterField, (String)PanelsArb.getString((int)7));
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.schemaCombo, (String)PanelsArb.getString((int)6));
        ResourceUtils.resButton((AbstractButton)this.autoQueryCheck, (String)PanelsArb.getString((int)8));
        ResourceUtils.resButton((AbstractButton)this.queryButton, (String)PanelsArb.getString((int)9));
        ResourceUtils.resButton((AbstractButton)this.tablesCheck, (String)PanelsArb.getString((int)12));
        ResourceUtils.resButton((AbstractButton)this.viewsCheck, (String)PanelsArb.getString((int)13));
        ResourceUtils.resButton((AbstractButton)this.synonymsCheck, (String)PanelsArb.getString((int)14));
        ResourceUtils.resButton((AbstractButton)this.snapshotsCheck, (String)PanelsArb.getString((int)15));
        ResourceUtils.resLabel((JLabel)this.entityNameLabel, (Component)this.entityNameField, (String)PanelsArb.getString((int)17));
        this.assignComponentNames();
        this.filterField.getDocument().addDocumentListener(this);
        this.schemaCombo.addActionListener(this);
        this.autoQueryCheck.addActionListener(this);
        this.queryButton.addActionListener(this);
        this.tablesCheck.addActionListener(this);
        this.viewsCheck.addActionListener(this);
        this.synonymsCheck.addActionListener(this);
        this.snapshotsCheck.addActionListener(this);
        this.entityNameField.addFocusListener(this);
    }

    protected void assignComponentNames() {
        this.filterField.setName(FILTER_FIELD_NAME);
        this.autoQueryCheck.setName(AUTO_QUERY_CHECK_NAME);
        this.schemaCombo.setName(SCHEMA_COMBO_NAME);
        this.queryButton.setName(QUERY_BUTTON_NAME);
        this.tablesCheck.setName(TABLES_CHECK_NAME);
        this.viewsCheck.setName(VIEWS_CHECK_NAME);
        this.synonymsCheck.setName(SYNONYMS_CHECK_NAME);
        this.snapshotsCheck.setName(SNAPSHOTS_CHECK_NAME);
        this.availableTablesList.setName(AVAILABLE_TABLES_LIST_NAME);
        this.chosenTablesList.setName(CHOSEN_TABLES_LIST_NAME);
        this.entityNameField.setName(ENTITY_FIELD_NAME);
    }

    protected JComponent getListControl() {
        if (this._shuttle == null) {
            this._shuttle = new Shuttle();
            JLabel jLabel = new JLabel();
            JLabel jLabel2 = new JLabel();
            if (this._availableTablesPicker == null) {
                this._availableTablesPicker = new 7(this.availableTablesList);
            }
            6 var3_3 = new 6(this.chosenTablesList);
            this._availableTablesPicker.setItemsSorted(true);
            var3_3.setItemsSorted(true);
            this._shuttle.setFromPicker((ItemPicker)this._availableTablesPicker);
            this._shuttle.setToPicker((ItemPicker)var3_3);
            this._shuttle.setMode(this.getShuttleMode());
            this._shuttle.add((Component)jLabel, (Object)"FromHeader");
            this._shuttle.add((Component)jLabel2, (Object)"ToHeader");
            ResourceUtils.resLabel((JLabel)jLabel, (Component)this.availableTablesList, (String)PanelsArb.getString((int)10));
            ResourceUtils.resLabel((JLabel)jLabel2, (Component)this.chosenTablesList, (String)PanelsArb.getString((int)11));
            this._shuttle.addShuttleListener((ShuttleListener)this);
            this.availableTablesList.addListSelectionListener(this);
            this.chosenTablesList.addListSelectionListener(this);
        }
        return this._shuttle;
    }

    private void showDbObjQueryAlert(boolean bl) {
        if (bl) {
            if (this._dbObjQueryAlertPanel == null) {
                this._dbObjQueryAlertPanel = new JPanel(new GridBagLayout());
                this._dbObjQueryAlertPanel.setBorder(BorderFactory.createEtchedBorder());
                JWrappedLabel jWrappedLabel = new JWrappedLabel(CmWizardsArb.getString(322));
                this._dbObjQueryAlertPanel.add((Component)jWrappedLabel, this.gbc(1, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5)));
            }
            JComponent jComponent = this.getListControl();
            this.remove(jComponent);
            this.add(this._dbObjQueryAlertPanel, this.gbc(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 5, 0), 0, 0));
        } else {
            if (this._dbObjQueryAlertPanel != null) {
                this.remove(this._dbObjQueryAlertPanel);
            }
            this.add(this.getListControl(), this.gbc(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.updateUI();
    }

    protected int getShuttleMode() {
        return 1;
    }

    protected Transferable[] convertSelectedAvailableItems(Transferable[] transferableArray) {
        return transferableArray;
    }

    protected void filterQueriedTables(ArrayList arrayList) {
    }

    protected int getVerticalSpaceSize() {
        return 5;
    }

    protected void setIncludeSnapshotsCheck(boolean bl) {
        this._includeSnapshotsCheck = bl;
        this.maybeIncludeSnapshotsCheck();
    }

    private void maybeIncludeSnapshotsCheck() {
        if (this._includeSnapshotsCheck && !this._snapshotsIncluded) {
            if (this.dbObjPanel != null) {
                this.dbObjPanel.add((Component)this.snapshotsCheck, this.gbc(4, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(this.getVerticalSpaceSize(), 0, 0, 5), 0, 0));
                this._snapshotsIncluded = true;
            }
        } else if (!this._includeSnapshotsCheck && this._snapshotsIncluded && this.dbObjPanel != null) {
            this.dbObjPanel.remove(this.snapshotsCheck);
            this._snapshotsIncluded = false;
        }
    }

    protected void setIncludeEntityField(boolean bl) {
        this._includeEntityField = bl;
        this.maybeShowEntityField(bl);
    }

    private void maybeShowEntityField(boolean bl) {
        if (this._includeEntityField) {
            if (bl && !this._entityFieldIncluded) {
                if (this.entityPanel == null) {
                    this.entityPanel = new JPanel(new GridBagLayout());
                    this.entityPanel.add((Component)this.entityNameLabel, this.gbc(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
                    this.entityPanel.add((Component)this.entityNameField, this.gbc(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
                }
                this.add(this.entityPanel, this.gbc(1, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            } else if (!bl && this._entityFieldIncluded) {
                this.remove(this.entityPanel);
                this._entityFieldIncluded = false;
            } else {
                return;
            }
            this._entityFieldIncluded = bl;
            this.entityPanel.updateUI();
            this.updateUI();
        }
    }

    protected boolean getIncludeTablesCheck() {
        return this.tablesCheck.isSelected();
    }

    protected boolean getIncludeViewsCheck() {
        return this.viewsCheck.isSelected();
    }

    protected boolean getIncludeSynonymsCheck() {
        return this.synonymsCheck.isSelected();
    }

    protected void setCanSelectViews(boolean bl) {
        this._canSelectViews = bl;
        this.maybeIncludeViewsCheck();
    }

    private void maybeIncludeViewsCheck() {
        if (this._canSelectViews && !this._viewSelectIncluded) {
            if (this.dbObjPanel != null) {
                this.dbObjPanel.add((Component)this.viewsCheck, this.gbc(2, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(this.getVerticalSpaceSize(), 0, 0, 5), 0, 0));
                this._viewSelectIncluded = true;
            }
        } else if (!this._canSelectViews && this._viewSelectIncluded && this.dbObjPanel != null) {
            this.dbObjPanel.remove(this.viewsCheck);
            this._viewSelectIncluded = false;
            this.viewsCheck.setSelected(false);
        }
    }

    protected void setCanSelectSynonyms(boolean bl) {
        this._canSelectSynonyms = bl;
        this.maybeIncludeSynonymCheck();
    }

    private void maybeIncludeSynonymCheck() {
        if (this._canSelectSynonyms && !this._synonymSelectIncluded) {
            if (this.dbObjPanel != null) {
                this.dbObjPanel.add((Component)this.synonymsCheck, this.gbc(3, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(this.getVerticalSpaceSize(), 0, 0, 5), 0, 0));
                this._synonymSelectIncluded = true;
            }
        } else if (!this._canSelectSynonyms && this._synonymSelectIncluded && this.dbObjPanel != null) {
            this.dbObjPanel.remove(this.synonymsCheck);
            this._synonymSelectIncluded = false;
            this.synonymsCheck.setSelected(false);
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        this._wizardCallbacks = traversableContext.getWizardCallbacks();
        if (!this._initialized) {
            this.loadSettings();
            this._initialized = true;
        }
        if (this._wizardCallbacks == null || traversableContext.getDirection() == 1) {
            this.setConnection(traversableContext);
        } else if (this._includeEntityField && this.chosenTablesList != null) {
            this.valueChanged(new ListSelectionEvent(this.chosenTablesList, 0, 0, true));
        }
        this._namespace = traversableContext;
        if (this._wizardCallbacks != null) {
            this._wizardCallbacks.wizardSetInitialFocus((Component)this.filterField);
        }
        this.setNextEnabled();
        if (!this.autoQueryCheck.isSelected() && this.availableTablesList.getModel().getSize() == 0 && this.chosenTablesList.getModel().getSize() == 0) {
            this.showDbObjQueryAlert(true);
        }
    }

    private void setConnection(TraversableContext traversableContext) {
        boolean bl = true;
        String string = (String)traversableContext.get(CURR_CONN_NAME);
        this._dbObjectProvider = SelectDatabaseObjectsPanel.getDBObjectProvider(traversableContext);
        if (this._dbObjectProvider == null && ModelUtil.hasLength((String)string)) {
            try {
                this._dbObjectProvider = DatabaseFactory.createDatabase(string);
            }
            catch (CMException cMException) {
                // empty catch block
            }
        }
        if (this.connectionChanged()) {
            JComponent jComponent = this.getListControl();
            if (jComponent instanceof Shuttle) {
                Shuttle shuttle = (Shuttle)jComponent;
                ItemPicker itemPicker = shuttle.getToPicker();
                Object[] objectArray = itemPicker.getAllSelectableItems();
                if (ModelUtil.hasNonNullElement((Object[])objectArray)) {
                    itemPicker.removeSelectedItems();
                }
            } else {
                this.chosenTablesModel.removeAllElements();
            }
            this.doSetConnection(string);
        }
    }

    private boolean connectionChanged() {
        boolean bl = true;
        String string = null;
        if (this._dbObjectProvider != null) {
            if (this._dbObjectProvider instanceof Database) {
                Database database = (Database)this._dbObjectProvider;
                Connection connection = database.getConnection();
                StringBuffer stringBuffer = new StringBuffer();
                try {
                    stringBuffer.append(database.getConnectionName());
                    stringBuffer.append(':');
                    stringBuffer.append(database.getUserName());
                }
                catch (DBException dBException) {
                    // empty catch block
                }
                string = stringBuffer.toString();
            } else {
                string = DB_OBJECT_PROVIDER_URL;
            }
        }
        if (ModelUtil.hasLength((String)this._connectionUrl) && this._connectionUrl.equals(string)) {
            bl = false;
        } else {
            this._connectionUrl = string;
        }
        return bl;
    }

    public static DBObjectProvider getDBObjectProvider(TraversableContext traversableContext) {
        return (DBObjectProvider)traversableContext.get(DB_OBJECT_PROVIDER);
    }

    public static void setDBObjectProvider(DBObjectProvider dBObjectProvider, TraversableContext traversableContext) {
        traversableContext.findAndReplace(DB_OBJECT_PROVIDER, (Object)dBObjectProvider);
    }

    protected void loadSettings() {
        this.loadSettings(SELECT_DB_OBJECTS_SETTINGS_KEY);
    }

    protected void loadSettings(String string) {
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        DynamicPropertySet dynamicPropertySet = (DynamicPropertySet)Ide.getSettings().getData(string);
        if (dynamicPropertySet == null && !SELECT_DB_OBJECTS_SETTINGS_KEY.equals(string)) {
            dynamicPropertySet = (DynamicPropertySet)Ide.getSettings().getData(SELECT_DB_OBJECTS_SETTINGS_KEY);
        }
        if (dynamicPropertySet != null) {
            bl = Boolean.TRUE.equals(dynamicPropertySet.getProperty(SETTINGS_AUTO_QUERY_KEY, (Object)Boolean.FALSE));
            bl2 = Boolean.TRUE.equals(dynamicPropertySet.getProperty(SETTINGS_QUERY_TABLES_KEY, (Object)Boolean.TRUE));
            bl3 = Boolean.TRUE.equals(dynamicPropertySet.getProperty(SETTINGS_QUERY_VIEWS_KEY, (Object)Boolean.FALSE));
            bl4 = Boolean.TRUE.equals(dynamicPropertySet.getProperty(SETTINGS_QUERY_SYNONYMS_KEY, (Object)Boolean.FALSE));
            bl5 = Boolean.TRUE.equals(dynamicPropertySet.getProperty(SETTINGS_QUERY_SNAPSHOTS_KEY, (Object)Boolean.FALSE));
        }
        this.autoQueryCheck.setSelected(bl);
        this.queryButton.setEnabled(bl ^ true);
        this.tablesCheck.setSelected(bl2);
        if (this.viewsCheck != null) {
            this.viewsCheck.setSelected(bl3);
        }
        if (this.synonymsCheck != null) {
            this.synonymsCheck.setSelected(bl4);
        }
        if (this.snapshotsCheck != null) {
            this.snapshotsCheck.setSelected(bl5);
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        this.savePendingEntityNameChanges();
        traversableContext.put(DATABASE_METADATA, (Object)this._metaData);
        SelectDatabaseObjectsPanel.setDBObjectProvider(this._dbObjectProvider, traversableContext);
        traversableContext.put(CHOSEN_TABLES, (Object)this._chosenTablesSet.toArray());
        this.saveSettings();
    }

    protected void saveSettings() {
        this.saveSettings(SELECT_DB_OBJECTS_SETTINGS_KEY);
    }

    protected void saveSettings(String string) {
        IdeSettings ideSettings = Ide.getSettings();
        DynamicPropertySet dynamicPropertySet = (DynamicPropertySet)ideSettings.getData(string);
        if (dynamicPropertySet == null) {
            dynamicPropertySet = new DynamicPropertySetImpl();
            ClientSetting.findOrCreate((String)"oracle.onlinedb").putData(string, (Copyable)dynamicPropertySet);
        }
        dynamicPropertySet.setProperty(SETTINGS_AUTO_QUERY_KEY, (Object)(this.autoQueryCheck.isSelected() ? Boolean.TRUE : Boolean.FALSE));
        dynamicPropertySet.setProperty(SETTINGS_QUERY_TABLES_KEY, (Object)(this.tablesCheck.isSelected() ? Boolean.TRUE : Boolean.FALSE));
        if (this.viewsCheck != null) {
            dynamicPropertySet.setProperty(SETTINGS_QUERY_VIEWS_KEY, (Object)(this.viewsCheck.isSelected() ? Boolean.TRUE : Boolean.FALSE));
        }
        if (this.synonymsCheck != null) {
            dynamicPropertySet.setProperty(SETTINGS_QUERY_SYNONYMS_KEY, (Object)(this.synonymsCheck.isSelected() ? Boolean.TRUE : Boolean.FALSE));
        }
        if (this.snapshotsCheck != null) {
            dynamicPropertySet.setProperty(SETTINGS_QUERY_SNAPSHOTS_KEY, (Object)(this.snapshotsCheck.isSelected() ? Boolean.TRUE : Boolean.FALSE));
        }
    }

    protected abstract void savePendingEntityNameChanges() throws TraversalException;

    private boolean selectTables(Transferable[] transferableArray) {
        Object object;
        if (ModelUtil.hasNonNullElement((Object[])transferableArray) && (object = this.addSelectedObjects(transferableArray)) != null) {
            this.chosenTablesList.setSelectedValue(object, true);
        }
        return true;
    }

    protected abstract Object addSelectedObjects(Transferable[] var1);

    private void deselectTables(Transferable[] transferableArray) {
        if (ModelUtil.hasNonNullElement((Object[])transferableArray)) {
            this.removeSelectedObjects(transferableArray);
        }
    }

    protected abstract void removeSelectedObjects(Transferable[] var1);

    protected void doSetConnection(String string) {
        if (this._connWorker != null) {
            this._connWorker.interrupt();
        }
        this.setConnecting(string);
        String string2 = null;
        this.setError(null);
        this.setStatus(null);
        if (ModelUtil.hasLength((String)string)) {
            this._metaData = null;
            this.availableTablesList.setListData(new Object[0]);
            this.schemaCombo.removeAllItems();
            this.schemaCombo.setEnabled(false);
            this.setNextEnabled();
            this._connWorker = new 5(this, string);
            this._connWorker.start();
        } else {
            string2 = PanelsArb.format((int)2, (Object)string);
        }
        if (ModelUtil.hasLength((String)string2)) {
            this.setError(string2);
            this._metaData = null;
        }
    }

    private DatabaseMetaData _doSetConnection(String string) {
        DatabaseMetaData databaseMetaData = null;
        String string2 = null;
        try {
            JdbcConnectionWrapper jdbcConnectionWrapper = (JdbcConnectionWrapper)ConnectionManager.getInstance().getConnection(string);
            if (jdbcConnectionWrapper != null) {
                Connection connection = jdbcConnectionWrapper.getJdbcConnection();
                this._metaData = databaseMetaData = connection.getMetaData();
                this._currSchema = null;
                ConnectionDescriptor connectionDescriptor = jdbcConnectionWrapper.getDescriptor();
                if (connectionDescriptor != null) {
                    this._currSchema = connectionDescriptor.getUsername();
                }
                if (!ModelUtil.hasLength((String)this._currSchema) && this._metaData != null) {
                    this._currSchema = this._metaData.getUserName();
                }
                if (!ModelUtil.hasLength((String)this._currSchema)) {
                    this._currSchema = null;
                } else if (this.forceUppercaseSchema()) {
                    this._currSchema = this._currSchema.toUpperCase();
                }
                this.querySchemas();
            } else {
                string2 = PanelsArb.format((int)2, (Object)string);
            }
        }
        catch (Throwable throwable) {
            string2 = PanelsArb.format((int)1, (Object)string);
            string2 = string2 + ": " + throwable.getLocalizedMessage();
        }
        if (ModelUtil.hasLength((String)string2)) {
            this.setError(string2);
            this._metaData = null;
        }
        return this._metaData;
    }

    synchronized void setConnecting(String string) {
        this.setStatus(PanelsArb.format((int)3, (Object)string));
    }

    private Timer getTimer() {
        if (this._timer == null) {
            4 var1_1 = new 4();
            this._timer = new Timer(250, var1_1);
            this._timer.setRepeats(false);
        }
        return this._timer;
    }

    protected boolean forceUppercaseSchema() {
        return true;
    }

    protected synchronized void queryTables() {
        this.setError(null);
        if (this._metaData == null) {
            return;
        }
        this._currTableFilter = this.filterField.getText();
        if (this._tableWorker != null) {
            this._tableWorker.interrupt();
        }
        this.setQueryingTables(true);
        this._tableWorker = new 3();
        this._tableWorker.start();
    }

    protected synchronized ArrayList doQueryTables(String string) {
        block14: {
            this._queriedTablesList = new ArrayList();
            boolean bl = this.tablesCheck.isSelected();
            boolean bl2 = this.viewsCheck.isSelected();
            boolean bl3 = this.synonymsCheck.isSelected();
            try {
                boolean bl4;
                string = string.trim();
                if (!string.endsWith("%")) {
                    string = string + "%";
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                if (bl) {
                    arrayList.add("TABLE");
                }
                if (bl2) {
                    arrayList.add("VIEW");
                }
                if (bl3) {
                    arrayList.add("SYNONYM");
                }
                String[] stringArray = null;
                if (arrayList.size() <= 0) break block14;
                stringArray = arrayList.toArray(new String[arrayList.size()]);
                ResultSet resultSet = this._metaData.getTables(null, this._currSchema, string, stringArray);
                try {
                    bl4 = resultSet.isBeforeFirst();
                }
                catch (Exception exception) {
                    bl4 = true;
                }
                if (!bl4 && this._currSchema != null && !this._currSchema.equals(this._currSchema.toUpperCase()) && (resultSet = this._metaData.getTables(null, this._currSchema.toUpperCase(), string, stringArray)).isBeforeFirst()) {
                    this._currSchema = this._currSchema.toUpperCase();
                }
                if (this._metaData == null) break block14;
                while (resultSet.next()) {
                    String string2;
                    String string3 = resultSet.getString("TABLE_NAME");
                    if (string3.startsWith("BIN$") || (string2 = resultSet.getString("TABLE_TYPE")) == null || !(bl && string2.equals("TABLE") || bl2 && string2.equals("VIEW")) && (!bl3 || !string2.equals("SYNONYM"))) continue;
                    StringBuffer stringBuffer = new StringBuffer();
                    if (this._currSchema == null) {
                        try {
                            String string4 = resultSet.getString("TABLE_SCHEM");
                            if (ModelUtil.hasLength((String)string4)) {
                                stringBuffer.append(string4);
                                stringBuffer.append('.');
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    stringBuffer.append(string3);
                    this._queriedTablesList.add(stringBuffer.toString());
                }
            }
            catch (Exception exception) {
                ArrayList arrayList = null;
                return arrayList;
            }
        }
        return new ArrayList(this._queriedTablesList);
    }

    protected void querySchemas() {
        if (this._metaData == null) {
            return;
        }
        if (this._schemaWorker != null) {
            this._schemaWorker.interrupt();
        }
        SelectDatabaseObjectsPanel selectDatabaseObjectsPanel = this;
        this._schemaWorker = new 2(this, selectDatabaseObjectsPanel);
        this._schemaWorker.start();
    }

    protected ArrayList doQuerySchemas() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(PanelsArb.getString((int)16));
        try {
            ResultSet resultSet = this._metaData.getSchemas();
            resultSet.setFetchSize(100);
            if (this._metaData != null) {
                while (resultSet.next()) {
                    arrayList.add(resultSet.getString("TABLE_SCHEM"));
                }
            }
        }
        catch (Exception exception) {
            ArrayList arrayList2 = null;
            return arrayList2;
        }
        return arrayList;
    }

    void setStatus(String string) {
        SelectDatabaseObjectsPanel selectDatabaseObjectsPanel = this;
        SwingUtilities.invokeLater(new 1(this, string, (JPanel)((Object)selectDatabaseObjectsPanel)));
    }

    void setError(String string) {
        if (ModelUtil.hasLength((String)string)) {
            if (!this._errorPanelShown) {
                if (this.errorPanel == null) {
                    this.errorPanel = new JPanel(new GridBagLayout());
                }
                this.add(this.errorPanel, this.gbc(0, 3, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            }
            if (this.errorLabel != null) {
                this.errorPanel.remove((Component)this.errorLabel);
            }
            this.errorLabel = new JWrappedLabel(string);
            DBObjectRenderer.setToolTipText((JComponent)this.errorLabel, string);
            this.errorLabel.setForeground(SystemColor.BLUE);
            this.errorPanel.add((Component)this.errorLabel, this.gbc(0, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
            this.errorLabel.revalidate();
            this.errorLabel.updateUI();
            this.errorPanel.updateUI();
            this._errorPanelShown = true;
        } else if (this._errorPanelShown) {
            this.remove(this.errorPanel);
            this._errorPanelShown = false;
        } else {
            return;
        }
        this.updateUI();
    }

    private void setNextEnabled() {
        Boolean bl;
        Boolean bl2 = bl = this.chosenTablesModel.getSize() > 0 ? Boolean.TRUE : Boolean.FALSE;
        if (this._wizardCallbacks != null) {
            this._wizardCallbacks.wizardEnableButtons(null, bl, Boolean.FALSE);
        }
    }

    synchronized void setQueryingTables(boolean bl) {
        if (bl) {
            this.setStatus(PanelsArb.getString((int)4));
        } else {
            this.setStatus(null);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.schemaCombo)) {
            this._currSchema = (String)this.schemaCombo.getSelectedItem();
            if (!ModelUtil.hasLength((String)this._currSchema) || PanelsArb.getString((int)16).equals(this._currSchema)) {
                this._currSchema = null;
            }
        } else if (object.equals(this.autoQueryCheck)) {
            if (this.autoQueryCheck.isSelected()) {
                this.showDbObjQueryAlert(false);
                this.queryButton.setEnabled(false);
            } else {
                this.queryButton.setEnabled(true);
            }
        }
        if (object.equals(this.queryButton) || this.autoQueryCheck.isSelected()) {
            this.showDbObjQueryAlert(false);
            this.queryTables();
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        if (this.autoQueryCheck.isSelected()) {
            this.getTimer().restart();
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        if (this.autoQueryCheck.isSelected()) {
            this.getTimer().restart();
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        if (this.autoQueryCheck.isSelected()) {
            this.getTimer().restart();
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        Object object = listSelectionEvent.getSource();
        if (object.equals(this.chosenTablesList) || object.equals(this.availableTablesList)) {
            try {
                this.savePendingEntityNameChanges();
                this._scrollList(this.chosenTablesList);
            }
            catch (TraversalException traversalException) {
                traversalException.showMessageDialog((Component)((Object)this));
            }
        }
    }

    private void _scrollList(JList jList) {
        int n = jList.getMinSelectionIndex();
        jList.ensureIndexIsVisible(n);
        this.setNextEnabled();
    }

    public void shuttleItemsMoved(ShuttleEvent shuttleEvent) {
        this.setNextEnabled();
    }

    public void shuttleItemsRemoved(ShuttleEvent shuttleEvent) {
        this.setNextEnabled();
    }

    public void shuttleItemsReordered(ShuttleEvent shuttleEvent) {
    }

    protected JCheckBox getSynonymsCheck() {
        return this.synonymsCheck;
    }

    protected JCheckBox getTablesCheck() {
        return this.tablesCheck;
    }

    protected JCheckBox getViewsCheck() {
        return this.viewsCheck;
    }

    protected JCheckBox getSnapshotsCheck() {
        return this.snapshotsCheck;
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        try {
            this.savePendingEntityNameChanges();
            this.chosenTablesList.updateUI();
        }
        catch (TraversalException traversalException) {
            MessageDialog.error((Component)((Object)this), (Object)PanelsArb.getString((int)18), (String)PanelsArb.getString((int)19), null);
        }
    }

    static void mav$deselectTables(SelectDatabaseObjectsPanel selectDatabaseObjectsPanel, Transferable[] transferableArray) {
        selectDatabaseObjectsPanel.deselectTables(transferableArray);
    }

    static boolean mav$selectTables(SelectDatabaseObjectsPanel selectDatabaseObjectsPanel, Transferable[] transferableArray) {
        return selectDatabaseObjectsPanel.selectTables(transferableArray);
    }

    static DatabaseMetaData mav$_doSetConnection(SelectDatabaseObjectsPanel selectDatabaseObjectsPanel, String string) {
        return selectDatabaseObjectsPanel._doSetConnection(string);
    }

    static JLabel ra$statusLabel(SelectDatabaseObjectsPanel selectDatabaseObjectsPanel) {
        return selectDatabaseObjectsPanel.statusLabel;
    }

    static JPanel ra$statusPanel(SelectDatabaseObjectsPanel selectDatabaseObjectsPanel) {
        return selectDatabaseObjectsPanel.statusPanel;
    }

    public final class 7
    extends ListPicker {
        public boolean addSelectedItems(Transferable[] transferableArray) {
            return super.addSelectedItems(SelectDatabaseObjectsPanel.this.convertSelectedAvailableItems(transferableArray));
        }

        public 7(JList jList) {
            super(jList);
        }
    }

    public final class 6
    extends ListPicker {
        public boolean addSelectedItems(Transferable[] transferableArray) {
            return SelectDatabaseObjectsPanel.mav$selectTables(SelectDatabaseObjectsPanel.this, transferableArray);
        }

        public void removeSelectedItems() {
            Transferable[] transferableArray = this.getSelectedItems();
            SelectDatabaseObjectsPanel.mav$deselectTables(SelectDatabaseObjectsPanel.this, transferableArray);
            super.removeSelectedItems();
        }

        public void removeAllSelectableItems() {
            Transferable[] transferableArray = this.getAllSelectableItems();
            SelectDatabaseObjectsPanel.mav$deselectTables(SelectDatabaseObjectsPanel.this, transferableArray);
            super.removeAllSelectableItems();
        }

        public 6(JList jList) {
            super(jList);
        }
    }

    public final class 5
    extends SwingWorker {
        private final /* synthetic */ String v$connName;
        final /* synthetic */ SelectDatabaseObjectsPanel this$0;

        public Object construct() {
            return SelectDatabaseObjectsPanel.mav$_doSetConnection(this.this$0, this.v$connName);
        }

        public void finished() {
            DatabaseMetaData databaseMetaData = (DatabaseMetaData)this.get();
            if (databaseMetaData != null) {
                this.this$0._metaData = databaseMetaData;
            }
        }

        public 5(SelectDatabaseObjectsPanel selectDatabaseObjectsPanel, String string) {
            this.v$connName = string;
            this.this$0 = selectDatabaseObjectsPanel;
        }
    }

    public final class 4
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            SelectDatabaseObjectsPanel.this.queryTables();
        }
    }

    public final class 3
    extends SwingWorker {
        public Object construct() {
            return SelectDatabaseObjectsPanel.this.doQueryTables(SelectDatabaseObjectsPanel.this._currTableFilter);
        }

        public void finished() {
            ArrayList arrayList;
            if (SelectDatabaseObjectsPanel.this._metaData != null && (arrayList = (ArrayList)this.get()) != null) {
                SelectDatabaseObjectsPanel.this.filterQueriedTables(arrayList);
                Object[] objectArray = arrayList.toArray();
                Arrays.sort(objectArray);
                SelectDatabaseObjectsPanel.this.availableTablesList.setListData(objectArray);
                if (SelectDatabaseObjectsPanel.this.availableTablesList.getModel().getSize() > 0) {
                    SelectDatabaseObjectsPanel.this.availableTablesList.setSelectedIndex(0);
                }
                SelectDatabaseObjectsPanel.this.setQueryingTables(false);
            }
        }
    }

    public final class 2
    extends SwingWorker {
        private final /* synthetic */ ActionListener v$al;
        final /* synthetic */ SelectDatabaseObjectsPanel this$0;

        public Object construct() {
            return this.this$0.doQuerySchemas();
        }

        public void finished() {
            if (this.this$0._metaData != null) {
                ArrayList arrayList = (ArrayList)this.get();
                if (arrayList != null) {
                    DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(arrayList.toArray());
                    this.this$0.schemaCombo.setModel(defaultComboBoxModel);
                    if (ModelUtil.hasLength((String)this.this$0._currSchema)) {
                        this.this$0.schemaCombo.removeActionListener(this.v$al);
                        if (defaultComboBoxModel.getIndexOf(this.this$0._currSchema) < 0 && defaultComboBoxModel.getIndexOf(this.this$0._currSchema.toUpperCase()) >= 0) {
                            this.this$0._currSchema = this.this$0._currSchema.toUpperCase();
                        }
                        this.this$0.schemaCombo.setSelectedItem(this.this$0._currSchema);
                        if (this.this$0.schemaCombo.getSelectedIndex() == 0) {
                            this.this$0._currSchema = null;
                        }
                        this.this$0.schemaCombo.addActionListener(this.v$al);
                    } else {
                        this.this$0.schemaCombo.setSelectedIndex(0);
                    }
                }
                this.this$0.schemaCombo.setEnabled(true);
                if (this.this$0.autoQueryCheck.isSelected()) {
                    this.this$0.queryTables();
                }
            }
        }

        public 2(SelectDatabaseObjectsPanel selectDatabaseObjectsPanel, ActionListener actionListener) {
            this.v$al = actionListener;
            this.this$0 = selectDatabaseObjectsPanel;
        }
    }

    public final class 1
    implements Runnable {
        private final /* synthetic */ String v$msg;
        private final /* synthetic */ JPanel v$thisPanel;
        final /* synthetic */ SelectDatabaseObjectsPanel this$0;

        public void run() {
            SelectDatabaseObjectsPanel.ra$statusLabel(this.this$0).setText(this.v$msg);
            SelectDatabaseObjectsPanel.ra$statusPanel(this.this$0).updateUI();
            this.v$thisPanel.updateUI();
        }

        public 1(SelectDatabaseObjectsPanel selectDatabaseObjectsPanel, String string, JPanel jPanel) {
            this.v$thisPanel = jPanel;
            this.v$msg = string;
            this.this$0 = selectDatabaseObjectsPanel;
        }
    }
}

