/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cm.dt;

import java.net.URL;
import oracle.ide.model.Node;
import oracle.ide.model.Recognizer;
import oracle.ide.model.RecognizerException;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.cm.dt.CmUtil;
import oracle.jdeveloper.cm.dt.ConnectionNode;
import oracle.jdeveloper.cm.dt.ConnectionsProvider;
import oracle.jdeveloper.cm.dt.browser.ConnectionBrowser;
import oracle.jdeveloper.cm.dt.browser.jdbc.JdbcNodeFactory;

public final class ConnectionRecognizer
extends Recognizer {
    ConnectionRecognizer() {
    }

    public Class recognize(URL uRL) {
        Class clazz = null;
        if (CmUtil.isCMUrl(uRL)) {
            String string = CmUtil.getDbObjectType(uRL);
            if (!("JAVA CLASS".equals(string) || "JAVA RESOURCE".equals(string) || "JAVA SOURCE".equals(string))) {
                clazz = JdbcNodeFactory.getNodeClass(uRL);
            }
        } else if (ConnectionRecognizer._isPlsFileURL(uRL)) {
            clazz = Recognizer.getDefaultNodeType();
        }
        return clazz;
    }

    public Node create(URL uRL, Class clazz) throws IllegalAccessException, InstantiationException {
        if (ConnectionRecognizer._isPlsFileURL(uRL) && clazz == Recognizer.getDefaultNodeType()) {
            return super.create(uRL, clazz);
        }
        if (!CmUtil.isCMUrl(uRL)) {
            return null;
        }
        String string = CmUtil.getConnName(uRL);
        ConnectionsProvider connectionsProvider = ConnectionsProvider.getInstance();
        ConnectionNode connectionNode = connectionsProvider.getConnectionNode(string);
        connectionNode.ensureOpen();
        ConnectionBrowser connectionBrowser = connectionNode.getConnectionBrowser();
        if (connectionBrowser == null) {
            return null;
        }
        return connectionBrowser.create(uRL);
    }

    public URL validate(URL uRL, URL uRL2) throws RecognizerException {
        if (!CmUtil.isCMUrl(uRL2) && !ConnectionRecognizer._isPlsFileURL(uRL2)) {
            throw new RecognizerException();
        }
        return uRL;
    }

    public boolean canConvert(URL uRL, URL uRL2) {
        if (uRL == null || uRL2 == null) {
            return false;
        }
        if (!CmUtil.isCMUrl(uRL)) {
            return false;
        }
        return ConnectionRecognizer._isFileURL(uRL2);
    }

    private static boolean _isFileURL(URL uRL) {
        if (uRL == null) {
            return false;
        }
        String string = uRL.getProtocol();
        return string.equalsIgnoreCase("file");
    }

    private static boolean _isPlsFileURL(URL uRL) {
        String string;
        return ConnectionRecognizer._isFileURL(uRL) && (string = URLFileSystem.getSuffix((URL)uRL)) != null && string.equalsIgnoreCase(".pls");
    }
}

