/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cm.dt;

import java.io.File;
import java.net.URL;
import oracle.ide.Ide;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.migration.Migrator;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.ModelUtil;
import oracle.jdeveloper.cm.ConnectionDescriptor;
import oracle.jdeveloper.cm.ConnectionManager;
import oracle.jdeveloper.cm.ConnectionStore;
import oracle.jdeveloper.cm.DefaultConnectionStore;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.JLibraryManager;
import oracle.jdeveloper.library.Library;
import oracle.jdevimpl.cm.dt.cnpanels.Oc4jPanel;
import oracle.jdevimpl.cm.dt.config.ConnectionOptions;
import oracle.jdevimpl.cm.dt.config.OtherJdbcDriverEntry;

public class ConnectionsMigrator
implements Migrator {
    private static final int APPSRV_CONNECTIONS = 0;
    private static final int DB_CONNECTIONS = 1;
    private static final int DB_PREFS = 2;
    private boolean[] _selected;

    void $init$() {
        this._selected = new boolean[]{true, true, true};
    }

    public ConnectionsMigrator() {
        this.$init$();
    }

    public int[] getMigrationCategories() {
        return new int[]{0, 1, 2};
    }

    public String getDescription(int n) {
        String string = null;
        switch (n) {
            case 0: {
                string = ConnectionArb.getString(507);
                break;
            }
            case 1: {
                string = ConnectionArb.getString(508);
                break;
            }
            case 2: {
                string = "Database Connection Preferences";
            }
        }
        return string;
    }

    public boolean canMigrate(int n, File file) {
        boolean bl = false;
        if (n == 0 || n == 1) {
            File file2 = new File(file, "IDEConnections.xml");
            bl = file2.exists() && file2.canRead();
        } else if (n == 2) {
            bl = true;
        }
        return bl;
    }

    public void setSelected(int n, boolean bl) {
        this._selected[n] = bl;
    }

    public boolean isSelected(int n) {
        return this._selected[n];
    }

    public String[] migrate(File file, File file2) {
        if (this._selected[2]) {
            Ide.addIdeListener((IdeListener)new 1());
        }
        String[] stringArray = new String[]{};
        if (this._selected[0] || this._selected[1]) {
            File file3 = new File(file, "IDEConnections.xml");
            File file4 = new File(file2, "IDEConnections.xml");
            ConnectionManager connectionManager = ConnectionManager.getPrivateInstance();
            connectionManager.setConnectionStore((ConnectionStore)new DefaultConnectionStore(file3.getAbsolutePath(), true));
            ConnectionManager connectionManager2 = ConnectionManager.getPrivateInstance();
            try {
                if (this._selected[1]) {
                    String[] stringArray2 = connectionManager.getConnectionNamesForClass("CLASS_DATABASE");
                    int n = 0;
                    while (n < stringArray2.length) {
                        ConnectionDescriptor connectionDescriptor = connectionManager.getConnectionDescriptor(stringArray2[n]);
                        connectionManager2.putConnectionDescriptor(connectionDescriptor.getConnectionName(), connectionDescriptor);
                        ++n;
                    }
                }
                if (this._selected[0]) {
                    String[] stringArray3 = connectionManager.getConnectionNamesForClass("CLASS_APPSERVER");
                    int n = 0;
                    while (n < stringArray3.length) {
                        ConnectionDescriptor connectionDescriptor = connectionManager.getConnectionDescriptor(stringArray3[n]);
                        if ("OC4J".equals(connectionDescriptor.getConnectionType())) {
                            String string = connectionDescriptor.getProperty("OC4J_HOME");
                            boolean bl = true;
                            URL uRL = URLFactory.newFileURL((String)string);
                            if (uRL != null && ModelUtil.areDifferent((Object)string, (Object)Oc4jPanel.getDefaultOc4jHome())) {
                                URL uRL2;
                                boolean bl2 = true;
                                if (URLFileSystem.exists((URL)uRL) && URLFileSystem.exists((URL)(uRL2 = URLFactory.newURL((URL)uRL, (String)"admin.jar")))) {
                                    bl2 = false;
                                }
                                boolean bl3 = bl = bl2 && this._promptForReset(stringArray3[n], string);
                            }
                            if (bl) {
                                connectionDescriptor.remove((Object)"OC4J_HOME");
                            }
                        }
                        connectionManager2.putConnectionDescriptor(connectionDescriptor.getConnectionName(), connectionDescriptor);
                        ++n;
                    }
                }
                connectionManager2.deployToFile(file4.getAbsolutePath(), false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return stringArray;
    }

    private boolean _promptForReset(String string, String string2) {
        boolean bl = false;
        String string3 = ConnectionArb.format(509, string, string2);
        return MessageDialog.confirm(null, (Object)string3, (String)ConnectionArb.getString(510), null);
    }

    public final class 1
    implements IdeListener {
        public void addinsLoaded(IdeEvent ideEvent) {
            ConnectionOptions connectionOptions = (ConnectionOptions)((Object)Ide.getSettings().getData("ConnectionOptions"));
            for (OtherJdbcDriverEntry otherJdbcDriverEntry : connectionOptions.getDriverRegistry()) {
                JLibrary jLibrary;
                String string = otherJdbcDriverEntry.getDriverLibrary();
                if (string == null || (jLibrary = JLibraryManager.findLibrary((Object)string)) == null) continue;
                otherJdbcDriverEntry.setDriverLibraryInstance((Library)jLibrary);
                otherJdbcDriverEntry.setDriverLibrary(null);
            }
        }

        public void mainWindowOpened(IdeEvent ideEvent) {
        }

        public void mainWindowClosing(IdeEvent ideEvent) {
        }
    }
}

