/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cm.dt;

import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import java.util.ResourceBundle;
import oracle.ide.Ide;
import oracle.jdeveloper.cm.CMException;
import oracle.jdeveloper.cm.ConnectInfoPrompter;
import oracle.jdeveloper.cm.ConnectionDescriptor;
import oracle.jdeveloper.cm.ConnectionManager;
import oracle.jdeveloper.cm.JdbcConnectionWrapper;
import oracle.jdevimpl.cm.dt.JdbcClassLoaderFactory;

public class IdeJdbcConnectionWrapper
extends JdbcConnectionWrapper {
    private static final ResourceBundle bundle = ResourceBundle.getBundle("oracle.jdeveloper.cm.ConnectionRtBundle");

    public IdeJdbcConnectionWrapper(ConnectionDescriptor connectionDescriptor, ConnectInfoPrompter connectInfoPrompter, ConnectionManager connectionManager) throws CMException {
        super(connectionDescriptor, connectInfoPrompter, connectionManager);
    }

    protected Connection createConnectionImpl(String string, String string2, Properties properties) throws ClassNotFoundException, IllegalAccessException, InstantiationException, SQLException {
        ClassLoader classLoader = JdbcClassLoaderFactory.getClassLoader(string);
        Class<?> clazz = classLoader != null ? Class.forName(string, true, classLoader) : Class.forName(string);
        Driver driver = (Driver)clazz.newInstance();
        String string3 = System.getProperty("jdbc.terminal", "UNKNOWN");
        String string4 = "UNKNOWN";
        try {
            string4 = System.getProperty("jdbc.machine", InetAddress.getLocalHost().getHostName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string5 = System.getProperty("user.name", "UNKNOWN");
        String string6 = System.getProperty("jdbc.program", Ide.getProgramShortName());
        String string7 = System.getProperty("jdbc.pid", ManagementFactory.getRuntimeMXBean().getName());
        properties.setProperty("v$session.terminal", string3);
        properties.setProperty("v$session.machine", string4);
        properties.setProperty("v$session.osuser", string5);
        properties.setProperty("v$session.program", string6);
        properties.setProperty("v$session.process", string7);
        Connection connection = driver.connect(string2, properties);
        if (connection == null) {
            throw new SQLException(bundle.getString("ERROR_INVALID_URL"), "08001");
        }
        return connection;
    }
}

