/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cm.dt;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import oracle.ide.util.ModelUtil;
import oracle.jdeveloper.cm.CMException;
import oracle.jdeveloper.cm.ConnectInfoPrompter;
import oracle.jdeveloper.cm.ConnectionDescriptor;
import oracle.jdeveloper.cm.ConnectionWrapper;
import oracle.oc4j.admin.deploy.spi.exceptions.ExtendedDeploymentManagerCreationException;

public class J2EEConnectionWrapper
implements ConnectionWrapper {
    private static final String[] DEPLOYMENT_FACTORIES = new String[]{"oracle.oc4j.admin.deploy.spi.factories.Oc4jDeploymentFactory", "oracle.oc4j.admin.deploy.spi.factories.IasDeploymentFactory", "oracle.oc4j.admin.deploy.spi.factories.Oc4jLocalDeploymentFactory", "oracle.oc4j.admin.deploy.spi.factories.ClusterDeploymentFactory"};
    private static final String OC4J_JMX_PROVIDER = "oracle.oc4j.admin.jmx.remote";
    private ConnectionDescriptor _desc;
    private ConnectInfoPrompter _prompt;
    private DeploymentManager _depMgr;
    private JMXConnector _jmxConn;
    private static final List _presentations = Arrays.asList("JSR88", "JSR160");

    J2EEConnectionWrapper(ConnectionDescriptor connectionDescriptor, ConnectInfoPrompter connectInfoPrompter) {
        this._desc = connectionDescriptor;
        this._prompt = connectInfoPrompter;
    }

    public final ConnectionDescriptor getDescriptor() {
        return this._desc;
    }

    public final Object getPresentation(String string) throws CMException {
        if ("JSR88".equals(string)) {
            if (this._depMgr == null) {
                this._depMgr = this._getDeploymentManager();
            }
            return this._depMgr;
        }
        if ("JSR160".equals(string)) {
            if (this._jmxConn == null) {
                this._jmxConn = this._getJMXConnector();
            }
            return this._jmxConn;
        }
        return null;
    }

    public final boolean containsPresentation(String string) {
        return _presentations.contains(string);
    }

    public final Iterator getPresentationIterator() {
        return _presentations.iterator();
    }

    public final void closeConnection() {
        if (this._depMgr != null) {
            this._depMgr.release();
            this._depMgr = null;
        }
        if (this._jmxConn != null) {
            try {
                this._jmxConn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public final void testPresentation(String string) throws CMException {
        JMXConnector jMXConnector;
        if ("JSR88".equals(string)) {
            DeploymentManager deploymentManager = this._getDeploymentManager();
            if (deploymentManager != null) {
                deploymentManager.release();
            }
        } else if ("JSR160".equals(string) && (jMXConnector = this._getJMXConnector()) != null) {
            try {
                jMXConnector.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private DeploymentManager _getDeploymentManager() throws CMException {
        DeploymentFactory deploymentFactory = null;
        String string = this._desc.getProperty("JSR88_DEPLOYMENT_URL");
        if (string == null) {
            throw new CMException("No deployment URL specified.");
        }
        int n = 0;
        while (n < DEPLOYMENT_FACTORIES.length) {
            try {
                Class<?> clazz = Class.forName(DEPLOYMENT_FACTORIES[n]);
                DeploymentFactory deploymentFactory2 = (DeploymentFactory)clazz.newInstance();
                if (deploymentFactory2.handlesURI(string)) {
                    deploymentFactory = deploymentFactory2;
                    break;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new CMException((Exception)classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                throw new CMException((Exception)instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new CMException((Exception)illegalAccessException);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            ++n;
        }
        DeploymentManager deploymentManager = null;
        try {
            if (this._desc.getProperty("JSR88_DISCONNECTED_DEPLOYMENT") != null) {
                deploymentManager = deploymentFactory.getDisconnectedDeploymentManager(string);
            } else {
                String string2 = this._desc.getUsername();
                String string3 = this._desc.getPassword();
                deploymentManager = deploymentFactory.getDeploymentManager(string, string2, string3);
            }
        }
        catch (DeploymentManagerCreationException deploymentManagerCreationException) {
            Throwable throwable;
            Throwable throwable2;
            DeploymentManagerCreationException deploymentManagerCreationException2;
            Throwable throwable3;
            Throwable throwable4 = deploymentManagerCreationException;
            if (deploymentManagerCreationException instanceof DeploymentManagerCreationException && (throwable3 = deploymentManagerCreationException.getCause()) instanceof ExtendedDeploymentManagerCreationException) {
                deploymentManagerCreationException2 = (DeploymentManagerCreationException)throwable3;
            }
            if (deploymentManagerCreationException2 instanceof ExtendedDeploymentManagerCreationException && (throwable2 = ((ExtendedDeploymentManagerCreationException)deploymentManagerCreationException2).getTargetException()) instanceof Exception && (throwable = (throwable4 = (Exception)throwable2).getCause()) != null) {
                throwable4 = new Exception(throwable4.getMessage() + ":\n " + throwable.getMessage(), throwable);
            }
            throw new CMException((Exception)throwable4);
        }
        return deploymentManager;
    }

    private JMXConnector _getJMXConnector() throws CMException {
        String string = this._desc.getProperty("JMX_CONNECTOR_HOST");
        if ("".equals(string)) {
            string = null;
        }
        String string2 = this._desc.getProperty("JMX_CONNECTOR_PORT");
        int n = 0;
        try {
            if (ModelUtil.hasLength((String)string2)) {
                n = Integer.parseInt(string2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new CMException((Exception)numberFormatException);
        }
        String string3 = this._desc.getProperty("JMX_CONNECTOR_PATH");
        if (string3 == null) {
            string3 = "";
        }
        JMXServiceURL jMXServiceURL = this.getJMXServiceURL(string, n, string3);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("jmx.remote.protocol.provider.pkgs", OC4J_JMX_PROVIDER);
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        hashMap2.put("login", this._desc.getProperty("user"));
        hashMap2.put("password", this._desc.getProperty("password"));
        hashMap.put("jmx.remote.credentials", hashMap2);
        JMXConnector jMXConnector = null;
        try {
            jMXConnector = JMXConnectorFactory.connect(jMXServiceURL, hashMap);
        }
        catch (IOException iOException) {
            throw new CMException((Exception)iOException);
        }
        return jMXConnector;
    }

    protected JMXServiceURL getJMXServiceURL(String string, int n, String string2) throws CMException {
        JMXServiceURL jMXServiceURL;
        try {
            jMXServiceURL = new JMXServiceURL("rmi", string, n, string2);
        }
        catch (MalformedURLException malformedURLException) {
            throw new CMException((Exception)malformedURLException);
        }
        return jMXServiceURL;
    }
}

