/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cm.dt.browser.j2ee;

import java.awt.Component;
import javax.enterprise.deploy.shared.CommandType;
import javax.swing.JMenuItem;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuManager;
import oracle.ide.controls.ToggleAction;
import oracle.ide.model.Element;
import oracle.ide.navigator.NavigatorManager;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdeveloper.cm.dt.browser.j2ee.DeployedObjectNode;
import oracle.jdeveloper.cm.dt.browser.j2ee.Jsr77Exception;
import oracle.jdeveloper.cm.dt.browser.j2ee.StateManageableObject;

public class J2EEController
implements Controller,
ContextMenuListener {
    private static J2EEController INSTANCE;
    public static final int START_COMMAND_NAME;
    public static final int STOP_COMMAND_NAME;
    public static final int UNDEPLOY_COMMAND_NAME;
    private static final IdeAction ACTION_START;
    private static final IdeAction ACTION_STOP;
    private static final IdeAction ACTION_UNDEPLOY;
    private JMenuItem menuStart;
    private JMenuItem menuStop;
    private JMenuItem menuUndeploy;
    private boolean _menusBuilt;

    static {
        START_COMMAND_NAME = Ide.findOrCreateCmdID((String)"j2ee-start-application");
        STOP_COMMAND_NAME = Ide.findOrCreateCmdID((String)"j2ee-stop-application");
        UNDEPLOY_COMMAND_NAME = Ide.findOrCreateCmdID((String)"j2ee-undeploy-application");
        ACTION_START = IdeAction.get((int)START_COMMAND_NAME, (String)StringUtils.stripMnemonic((String)ConnectionArb.getString(612)), (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)ConnectionArb.getString(612))));
        ACTION_STOP = IdeAction.get((int)STOP_COMMAND_NAME, (String)StringUtils.stripMnemonic((String)ConnectionArb.getString(613)), (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)ConnectionArb.getString(613))));
        ACTION_UNDEPLOY = IdeAction.get((int)UNDEPLOY_COMMAND_NAME, (String)StringUtils.stripMnemonic((String)ConnectionArb.getString(614)), (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)ConnectionArb.getString(614))));
    }

    public static final J2EEController getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new J2EEController();
        }
        return INSTANCE;
    }

    private J2EEController() {
        NavigatorManager navigatorManager = NavigatorManager.getConnectionNavigatorManager();
        navigatorManager.addContextMenuListener((ContextMenuListener)this, null);
        ACTION_START.addController((Controller)this);
        ACTION_STOP.addController((Controller)this);
        ACTION_UNDEPLOY.addController((Controller)this);
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        DeployedObjectNode deployedObjectNode = J2EEController.getNode(context);
        if (deployedObjectNode != null) {
            int n = ideAction.getCommandId();
            if (n == START_COMMAND_NAME) {
                this._modifyApplicationState(deployedObjectNode, CommandType.START);
            } else if (n == STOP_COMMAND_NAME) {
                this._modifyApplicationState(deployedObjectNode, CommandType.STOP);
            } else if (n == UNDEPLOY_COMMAND_NAME) {
                this._modifyApplicationState(deployedObjectNode, CommandType.UNDEPLOY);
            }
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        DeployedObjectNode deployedObjectNode = J2EEController.getNode(context);
        if (deployedObjectNode != null) {
            StateManageableObject stateManageableObject = deployedObjectNode.getManageableObject();
            int n = ideAction.getCommandId();
            if (n == START_COMMAND_NAME) {
                ideAction.setEnabled(stateManageableObject != null && stateManageableObject.getState() == 3);
                return true;
            }
            if (n == STOP_COMMAND_NAME) {
                ideAction.setEnabled(stateManageableObject != null && stateManageableObject.getState() == 1);
                return true;
            }
            if (n == UNDEPLOY_COMMAND_NAME) {
                ideAction.setEnabled(stateManageableObject != null && stateManageableObject.canUndeploy());
                return true;
            }
        }
        return false;
    }

    public void menuWillShow(ContextMenu contextMenu) {
        Context context = contextMenu.getContext();
        DeployedObjectNode deployedObjectNode = J2EEController.getNode(context);
        if (deployedObjectNode != null && deployedObjectNode.getManageableObject() != null) {
            this.buildMenus((MenuManager)contextMenu);
            contextMenu.add((Component)this.menuStart);
            contextMenu.add((Component)this.menuStop);
            contextMenu.add((Component)this.menuUndeploy);
        }
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    private void buildMenus(MenuManager menuManager) {
        if (!this._menusBuilt) {
            this.menuStart = menuManager.createMenuItem((ToggleAction)ACTION_START);
            this.menuStop = menuManager.createMenuItem((ToggleAction)ACTION_STOP);
            this.menuUndeploy = menuManager.createMenuItem((ToggleAction)ACTION_UNDEPLOY);
            this._menusBuilt = true;
        }
    }

    private void _modifyApplicationState(DeployedObjectNode deployedObjectNode, CommandType commandType) {
        StateManageableObject stateManageableObject = deployedObjectNode.getManageableObject();
        try {
            if (CommandType.START.equals((Object)commandType) && stateManageableObject != null) {
                stateManageableObject.start();
            } else if (CommandType.STOP.equals((Object)commandType) && stateManageableObject != null) {
                stateManageableObject.stop();
            } else if (CommandType.UNDEPLOY.equals((Object)commandType)) {
                stateManageableObject.undeploy();
            }
        }
        catch (Jsr77Exception jsr77Exception) {
            // empty catch block
        }
    }

    private static DeployedObjectNode getNode(Context context) {
        Element[] elementArray = context != null ? context.getSelection() : null;
        return elementArray != null && elementArray.length == 1 && elementArray[0] instanceof DeployedObjectNode ? (DeployedObjectNode)elementArray[0] : null;
    }
}

