/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cm.dt.browser.jdbc;

import java.awt.Component;
import java.awt.Window;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.IdeAction;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.editor.EditorUtil;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.ide.model.Subject;
import oracle.ide.model.TextNode;
import oracle.ide.model.UpdateMessage;
import oracle.ide.util.FastStringBuffer;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ModelUtil;
import oracle.ideri.util.Product;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.db.BinaryObject;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBObjectProviderAdapter;
import oracle.javatools.db.DBObjectProviderListener;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.ora.RecycledObject;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdeveloper.ProfileIDs;
import oracle.jdeveloper.cm.CMException;
import oracle.jdeveloper.cm.ConnectionDescriptor;
import oracle.jdeveloper.cm.ConnectionManager;
import oracle.jdeveloper.cm.ds.db.DBUtil;
import oracle.jdeveloper.cm.ds.db.DatabaseFactory;
import oracle.jdeveloper.cm.dt.CmUtil;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdeveloper.cm.dt.ConnectionBrowsable;
import oracle.jdeveloper.cm.dt.JdbcConnectionFactory;
import oracle.jdeveloper.cm.dt.browser.CBBaseFolder;
import oracle.jdeveloper.cm.dt.browser.ConnectionBrowser;
import oracle.jdeveloper.cm.dt.browser.DatabaseBrowser;
import oracle.jdeveloper.cm.dt.browser.Filterable;
import oracle.jdeveloper.cm.dt.browser.Refreshable;
import oracle.jdeveloper.cm.dt.browser.SchemaFolderFilter;
import oracle.jdeveloper.cm.dt.browser.jdbc.DatabaseNode;
import oracle.jdeveloper.cm.dt.browser.jdbc.DatabaseObject;
import oracle.jdeveloper.cm.dt.browser.jdbc.JdbcNodeFactory;
import oracle.jdeveloper.cm.dt.browser.jdbc.PlSqlFolder;
import oracle.jdeveloper.cm.dt.browser.jdbc.RecycledObjectNode;
import oracle.jdeveloper.cm.dt.browser.jdbc.SchemaFolder;
import oracle.jdeveloper.cm.dt.dialog.SQLErrorDialog;
import oracle.jdeveloper.cm.dt.net.JDevCmURLFileSystemHelper;
import oracle.jdeveloper.cm.dt.wizard.DBWizardFactory;
import oracle.jdeveloper.cm.dt.wizard.DBWizardFactoryRegistry;
import oracle.jdeveloper.profiler.ProfilerAPI;
import oracle.jdevimpl.cm.dt.DatabaseAddin;
import oracle.jdevimpl.cm.dt.browser.jdbc.JdbcBrowserController;
import oracle.jdevimpl.cm.dt.browser.jdbc.OtherSchemas;

public class JdbcBrowser
extends DBObjectProviderAdapter
implements DatabaseBrowser {
    protected ConnectionBrowsable _parentNode;
    protected Database _db;
    private SchemaFolder currUser;
    private OtherSchemas others;
    private String _username;
    private static final String DB_OBJECT_TYPE = "DBObjectType";
    private static final String DB_OBJECT_URL = "DBObjectURL";
    private static JdbcBrowserController _controller;

    public static final JdbcBrowser getBrowser(ConnectionBrowsable connectionBrowsable) {
        JdbcBrowser jdbcBrowser = null;
        if (connectionBrowsable != null) {
            ConnectionBrowser connectionBrowser = connectionBrowsable.getConnectionBrowser();
            jdbcBrowser = connectionBrowser instanceof JdbcBrowser ? (JdbcBrowser)connectionBrowser : null;
        }
        return jdbcBrowser;
    }

    public JdbcBrowser() {
        if (_controller == null) {
            _controller = JdbcBrowserController.getInstance();
        }
        DatabaseAddin.initializeDBAddins();
    }

    public void setUsername(String string) {
        this._username = string;
    }

    public String getUsername() {
        return this._username;
    }

    public final void openConnectionBrowser(ConnectionBrowsable connectionBrowsable) throws CMException {
        int n = -1;
        if (ProfileIDs.PROFILE_DOCONNECT) {
            n = ProfilerAPI.startEvent((int)3406);
        }
        String string = connectionBrowsable.getConnectionName();
        Connection connection = null;
        try {
            try {
                connection = JdbcConnectionFactory.getInstance().findOrCreateConnection(string);
                this._parentNode = connectionBrowsable;
                this._db = DatabaseFactory.createDatabase(string, connection);
                this.loadChildren(string);
                this._db.addProviderListener((DBObjectProviderListener)this);
            }
            catch (Exception exception) {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
                this._cleanupClose();
                throw exception instanceof CMException ? (CMException)((Object)exception) : new CMException(exception);
            }
            catch (Throwable throwable) {
                if (throwable instanceof ThreadDeath) {
                    throw (ThreadDeath)throwable;
                }
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this._cleanupClose();
                throw new CMException(throwable.toString());
            }
        }
        finally {
            if (ProfileIDs.PROFILE_DOCONNECT) {
                ProfilerAPI.endEvent((int)n, (String)string);
            }
        }
    }

    protected void loadChildren(String string) throws DBException {
        String string2 = this._db.getUserName();
        this.setUsername(string2);
        this.currUser = JdbcBrowser.createSchemaFolder(string, this._db, string2);
        this.others = new OtherSchemas(CmUtil.getSchemaURL(string, null, "<others>"), this._db, string2);
    }

    protected static final SchemaFolder createSchemaFolder(String string, Database database, String string2) {
        URL uRL = CmUtil.getSchemaURL(string, null, string2);
        SchemaFolder schemaFolder = new SchemaFolder(uRL, database);
        return schemaFolder;
    }

    protected boolean supportsPublicSchema() {
        return false;
    }

    public final void closeConnectionBrowser() {
        this._cleanupClose();
        this._parentNode = null;
    }

    public void refresh() {
        try {
            ConnectionBrowsable connectionBrowsable = this._parentNode;
            this.closeConnectionBrowser();
            this.openConnectionBrowser(connectionBrowsable);
        }
        catch (CMException cMException) {
            // empty catch block
        }
    }

    public ConnectionDescriptor getConnectionDescriptor() {
        ConnectionDescriptor connectionDescriptor = null;
        String string = this._parentNode.getConnectionName();
        try {
            ConnectionManager connectionManager = ConnectionManager.getInstance();
            connectionDescriptor = connectionManager.getConnectionDescriptor(string);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return connectionDescriptor;
    }

    public Database getDatabase() {
        return this._db;
    }

    public final Iterator getChildren() {
        return new ChildIterator(this.currUser, this.others, null);
    }

    public CBBaseFolder getNodeByType(String string, String string2) {
        SchemaFolder schemaFolder = ModelUtil.areEqual((Object)string, (Object)this._username) ? this.currUser : this.others.getSchema(string);
        return schemaFolder != null ? schemaFolder.getNodeByType(string2) : null;
    }

    protected boolean isConnectedOracleSchema(URL uRL) {
        return false;
    }

    final void menuWillShow(Element[] elementArray, ContextMenu contextMenu) {
        if (JdbcBrowser.arrayInstanceOf(elementArray, DatabaseNode.class)) {
            boolean bl = true;
            boolean bl2 = true;
            int n = 0;
            while (n < elementArray.length) {
                DatabaseNode databaseNode = (DatabaseNode)elementArray[n];
                if ("RECYCLEBIN".equals(databaseNode.getObjectType())) {
                    RecycledObject recycledObject = ((RecycledObjectNode)databaseNode).getRecycledObject();
                    if (recycledObject == null && !"TABLE".equals(recycledObject.getOriginalType())) {
                        bl = false;
                    }
                } else {
                    bl2 = false;
                    bl = false;
                }
                ++n;
            }
            if (bl2) {
                contextMenu.add((Component)JdbcBrowserController.MENU_PURGE);
                _controller.update((IdeAction)JdbcBrowserController.MENU_PURGE.getAction(), contextMenu.getContext());
            }
            if (bl) {
                contextMenu.add((Component)JdbcBrowserController.MENU_UNDROP);
                _controller.update((IdeAction)JdbcBrowserController.MENU_UNDROP.getAction(), contextMenu.getContext());
            }
            if (elementArray.length == 1) {
                DatabaseNode databaseNode = (DatabaseNode)elementArray[0];
                String string = databaseNode.getObjectType();
                if ("SEQUENCE".equals(string) || "INDEX".equals(string) || "TABLE".equals(string) || "VIEW".equals(string) || "TRIGGER".equals(string)) {
                    JMenuItem jMenuItem = JdbcBrowserController.MENU_EDITOBJECT;
                    Action action = jMenuItem.getAction();
                    action.putValue(DB_OBJECT_TYPE, string);
                    URL uRL = databaseNode.getNode().getURL();
                    SchemaObject schemaObject = this.getObject(uRL);
                    if (schemaObject != null) {
                        action.putValue(DB_OBJECT_URL, uRL);
                        DBWizardFactory dBWizardFactory = DBWizardFactoryRegistry.getDBWizardFactory(this._db);
                        action.setEnabled(dBWizardFactory != null ? dBWizardFactory.canEditDBObject(contextMenu.getContext(), this._db, (DBObject)schemaObject) : false);
                        contextMenu.add((Component)jMenuItem, JDeveloperMenuConstants.SECTION_EDIT_PROPERTIES_CTXT_MENU);
                    }
                }
                if (databaseNode instanceof PlSqlFolder && "PACKAGE".equals(string)) {
                    contextMenu.add((Component)JdbcBrowserController.MENU_NEWBODY, 1.0f);
                    _controller.update((IdeAction)JdbcBrowserController.MENU_NEWBODY.getAction(), contextMenu.getContext());
                }
            }
        }
        if (JdbcBrowser.arrayInstanceOf(elementArray, Filterable.class, true) && ((Filterable)elementArray[0]).canBeFiltered()) {
            JMenuItem jMenuItem = JdbcBrowserController.MENU_FILTER;
            contextMenu.add((Component)jMenuItem, JDeveloperMenuConstants.SECTION_CONNECTION_WINDOW_FILTER_CTXT);
        }
        if (JdbcBrowser.arrayInstanceOf(elementArray, CBBaseFolder.class)) {
            CBBaseFolder cBBaseFolder = elementArray.length == 1 ? (CBBaseFolder)elementArray[0] : null;
            contextMenu.add((Component)JdbcBrowserController.MENU_REFRESH, JDeveloperMenuConstants.SECTION_CONNECTION_WINDOW_FILTER_CTXT);
            if (cBBaseFolder != null) {
                URL uRL = cBBaseFolder.getURL();
                String string = CmUtil.getDbObjectType(uRL);
                AbstractButton abstractButton = null;
                boolean bl = this.isConnectedOracleSchema(uRL);
                DBWizardFactory dBWizardFactory = DBWizardFactoryRegistry.getDBWizardFactory(this._db);
                if (bl && dBWizardFactory.isCreateSupported(string)) {
                    String string2 = dBWizardFactory.getCreateLabel(string);
                    abstractButton = JdbcBrowserController.MENU_NEWOBJECT;
                    Action action = abstractButton.getAction();
                    action.putValue("Name", StringUtils.stripMnemonic((String)string2));
                    action.putValue("MnemonicKey", new Integer(StringUtils.getMnemonicKeyCode((String)string2)));
                    action.putValue("SmallIcon", DBUtil.getNodeIcon(string));
                }
                if (abstractButton != null) {
                    contextMenu.add(abstractButton, 1.0f);
                    IdeAction ideAction = (IdeAction)abstractButton.getAction();
                    ideAction.putValue(DB_OBJECT_TYPE, (Object)string);
                    _controller.update(ideAction, contextMenu.getContext());
                }
            }
        } else if (!Product.isRaptor() && this._isDroppable(elementArray)) {
            contextMenu.add((Component)JdbcBrowserController.MENU_DROP);
            _controller.update((IdeAction)JdbcBrowserController.MENU_DROP.getAction(), contextMenu.getContext());
        }
    }

    boolean update(IdeAction ideAction, Context context) {
        boolean bl = false;
        if (ideAction != null) {
            Element[] elementArray = context != null ? context.getSelection() : null;
            int n = ideAction.getCommandId();
            if (n == 20 || n == JdbcBrowserController.DROP_COMMAND_NAME) {
                ideAction.setEnabled(this._isDroppable(elementArray));
                bl = true;
            } else if (n == JdbcBrowserController.NEWOBJECT_COMMAND) {
                DBWizardFactory dBWizardFactory = DBWizardFactoryRegistry.getDBWizardFactory(this.getDatabase());
                ideAction.setEnabled(dBWizardFactory != null && dBWizardFactory.canCreateDBObject(context, this.getDatabase(), (String)ideAction.getValue(DB_OBJECT_TYPE)));
                bl = true;
            } else if (n == JdbcBrowserController.NEW_BODY_COMMAND_NAME) {
                PlSqlFolder plSqlFolder;
                boolean bl2 = false;
                if (elementArray != null && elementArray.length == 1 && elementArray[0] instanceof PlSqlFolder && (plSqlFolder = (PlSqlFolder)elementArray[0]).getBody() == null) {
                    bl2 = true;
                }
                ideAction.setEnabled(bl2);
                bl = true;
            } else if (n == JdbcBrowserController.PURGE_COMMAND_NAME) {
                boolean bl3 = true;
                int n2 = 0;
                while (n2 < elementArray.length) {
                    if (elementArray[n2] instanceof RecycledObjectNode) {
                        if (!((RecycledObjectNode)elementArray[0]).getRecycledObject().canPurge()) {
                            bl3 = false;
                            break;
                        }
                    } else {
                        bl3 = false;
                        break;
                    }
                    ++n2;
                }
                ideAction.setEnabled(bl3);
                bl = true;
            } else if (n == JdbcBrowserController.UNDROP_COMMAND_NAME) {
                boolean bl4 = true;
                int n3 = 0;
                while (n3 < elementArray.length) {
                    if (elementArray[n3] instanceof RecycledObjectNode) {
                        if (!((RecycledObjectNode)elementArray[0]).getRecycledObject().canUndrop()) {
                            bl4 = false;
                            break;
                        }
                    } else {
                        bl4 = false;
                        break;
                    }
                    ++n3;
                }
                ideAction.setEnabled(bl4);
                bl = true;
            }
        }
        return bl;
    }

    boolean handleEvent(IdeAction ideAction, Context context) {
        boolean bl = false;
        int n = ideAction.getCommandId();
        if (n == JdbcBrowserController.DROP_COMMAND_NAME || n == 20) {
            bl = this._dropObjectCmd(context);
        } else if (n == JdbcBrowserController.NEW_BODY_COMMAND_NAME) {
            bl = this._doCreateBody(context);
        } else if (n == JdbcBrowserController.NEWOBJECT_COMMAND) {
            DBWizardFactory dBWizardFactory = DBWizardFactoryRegistry.getDBWizardFactory(this._db);
            if (dBWizardFactory != null) {
                bl = dBWizardFactory.createDBObject(context, this._db, (String)ideAction.getValue(DB_OBJECT_TYPE));
            }
        } else if (n == JdbcBrowserController.EDITOBJECT_COMMAND) {
            DBWizardFactory dBWizardFactory = DBWizardFactoryRegistry.getDBWizardFactory(this._db);
            if (dBWizardFactory != null) {
                SchemaObject schemaObject = this.getObject((URL)ideAction.getValue(DB_OBJECT_URL));
                bl = dBWizardFactory.editDBObject(context, this._db, (DBObject)schemaObject);
            }
            this.notifyNodeObservers(context);
        } else if (n == JdbcBrowserController.PURGE_COMMAND_NAME) {
            bl = this._purgeObjectCmd(context);
        } else if (n == JdbcBrowserController.UNDROP_COMMAND_NAME) {
            bl = this._unDropObjectCmd(context);
        }
        return bl;
    }

    private void notifyNodeObservers(Context context) {
        URL uRL = ((Locatable)context.getElement()).getURL();
        Node node = JdbcNodeFactory.getNode(this._db, uRL);
        UpdateMessage updateMessage = new UpdateMessage(UpdateMessage.CONTENT_MODIFIED, (Object)this);
        node.notifyObservers((Object)node, updateMessage);
    }

    private boolean _isDroppable(Element[] elementArray) {
        boolean bl;
        block10: {
            block12: {
                block11: {
                    bl = false;
                    if (!JdbcBrowser.arrayInstanceOf(elementArray, SchemaFolder.class)) break block11;
                    int n = 0;
                    while (n < elementArray.length) {
                        Schema schema = null;
                        try {
                            schema = this._db.getSchema(((SchemaFolder)elementArray[n]).getName());
                        }
                        catch (DBException dBException) {
                            // empty catch block
                        }
                        bl = this._db.hasPriviledge("SCHEMA", schema, "DELETE");
                        if (!bl) {
                            ++n;
                            continue;
                        }
                        break block10;
                    }
                    break block10;
                }
                if (!JdbcBrowser.arrayInstanceOf(elementArray, DatabaseNode.class)) break block12;
                String string = ((DatabaseNode)elementArray[0]).getObjectType();
                String string2 = CmUtil.getSchema(((DatabaseNode)elementArray[0]).getNode().getURL());
                int n = 1;
                while (n < elementArray.length) {
                    String string3 = ((DatabaseNode)elementArray[n]).getObjectType();
                    String string4 = CmUtil.getSchema(((DatabaseNode)elementArray[n]).getNode().getURL());
                    if (ModelUtil.areDifferent((Object)string, (Object)string3) || ModelUtil.areDifferent((Object)string2, (Object)string4)) {
                        return false;
                    }
                    ++n;
                }
                try {
                    if ("RECYCLEBIN".equals(string)) {
                        bl = false;
                        break block10;
                    }
                    bl = this._db.hasPriviledge(string, this._db.getSchema(string2), "DELETE");
                }
                catch (Exception exception) {}
                break block10;
            }
            if (!JdbcBrowser.arrayInstanceOf(elementArray, Locatable.class)) break block10;
            bl = true;
            int n = 0;
            while (n < elementArray.length && bl) {
                URL uRL = ((Locatable)elementArray[n]).getURL();
                String string = CmUtil.isCMUrl(uRL) ? CmUtil.getDbObjectType(uRL) : null;
                bl = "JAVA CLASS".equals(string) || "JAVA RESOURCE".equals(string) || "JAVA SOURCE".equals(string);
                ++n;
            }
        }
        return bl;
    }

    private String getDBType(String string) {
        return "PACKAGE_FOLDER".equals(string) ? "PACKAGE" : ("TYPE_FOLDER".equals(string) ? "TYPE" : string);
    }

    private boolean _dropObjectCmd(Element element) {
        URL uRL = ((Locatable)element).getURL();
        String string = this.getDBType(CmUtil.getDbObjectType(uRL));
        return "SCHEMA".equals(string) ? this._dropSchema(element) : this._dropObject(element);
    }

    /*
     * Unable to fully structure code
     */
    private boolean _dropSchema(Element var1_1) {
        block8: {
            var2_2 = ((Locatable)var1_1).getURL();
            var3_3 = CmUtil.getUserName(var2_2);
            try {
                var4_4 = this._db.getSchema(var3_3);
                if (var3_3 == null) {
                    MessageDialog.information(null, (Object)ConnectionArb.format(321, var3_3), (String)ConnectionArb.getString(322), null);
                    this.others.removeSchema(var3_3);
                    var14_5 = true;
                    return var14_5;
                }
                var5_6 = ConnectionArb.getString(309);
                var6_7 = ConnectionArb.format(320, var3_3);
                if (!MessageDialog.confirm(null, (Object)var6_7, (String)var5_6, null, (boolean)true)) break block8;
                var7_8 = new 5(this, var4_4, var3_3);
                var7_8.setTitle(ConnectionArb.getString(457));
                var7_8.setMessage(ConnectionArb.format(458, var3_3));
                var7_8.setCancelable(false);
                try {
                    var7_8.start(true);
                    break block8;
                }
                catch (ProgressException var8_9) {
                    var9_10 = var8_9.getCause();
                    ** while (var9_10 instanceof CMException)
                }
lbl-1000:
                // 1 sources

                {
                    if (!((CMException)var9_10).isWrapper()) break;
                    var9_10 = ((CMException)var9_10).unwrap();
                    continue;
                }
lbl26:
                // 2 sources

                if (var9_10 instanceof DBException) {
                    throw (DBException)var9_10;
                }
                throw new DBException(var9_10);
            }
            catch (DBException var10_11) {
                var11_12 = var10_11.getCause();
                var12_13 = ConnectionArb.getString(323);
                var13_14 = IdeUtil.getMainWindow();
                if (var11_12 instanceof SQLException) {
                    SQLErrorDialog.showErrorDialog(var13_14, var12_13, (SQLException)var11_12);
                }
                ExceptionDialog.showExceptionDialog((Window)var13_14, (Exception)var10_11, (String)var12_13, (String)var10_11.getLocalizedMessage());
            }
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private boolean _dropObject(Element var1_1) {
        block14: {
            var2_2 = ((Locatable)var1_1).getURL();
            var3_3 = var1_1 instanceof RecycledObjectNode;
            var4_4 = this.getDBType(CmUtil.getDbObjectType(var2_2));
            var5_5 = CmUtil.getUserName(var2_2);
            var6_6 = JDevCmURLFileSystemHelper.getRealName(var4_4, CmUtil.getName(var2_2));
            var7_7 = CmUtil.getConnName(var2_2);
            var8_8 = CmUtil.getCatalog(var2_2);
            var9_9 = var3_3 != false ? ((RecycledObjectNode)var1_1).getRecycledObject().getOriginalName() : var6_6;
            v0 = var10_10 = ("PACKAGE".equals(var4_4) != false || "TYPE".equals(var4_4) != false) && "Body".equals(CmUtil.getSubType(var2_2)) != false;
            var11_11 = var10_10 != false ? CmUtil.getNodeURL(var7_7, var8_8, var5_5, "PACKAGE".equals(var4_4) != false ? "PACKAGE_FOLDER" : "TYPE_FOLDER", var6_6) : CmUtil.getFolderURL(var7_7, var8_8, var5_5, var4_4);
            var12_12 = new String[]{var3_3 != false ? ((RecycledObjectNode)var1_1).getRecycledObject().getOriginalType() : var4_4, var5_5, var9_9};
            try {
                var13_13 = this._db.getSchema(var5_5);
                var14_14 = this._db.getObject(var4_4, var13_13, var6_6);
                if (var14_14 == null) {
                    if (var3_3) {
                        MessageDialog.information(null, (Object)ConnectionArb.format(318, var12_12), (String)ConnectionArb.getString(319), null);
                    } else {
                        MessageDialog.information(null, (Object)ConnectionArb.format(312, var12_12), (String)ConnectionArb.getString(313), null);
                    }
                    JdbcBrowser.closeElement(var1_1);
                    if (CmUtil.isFolder(var11_11)) {
                        var15_15 = this.getNodeByType(var5_5, var4_4);
                        if (var15_15 != null) {
                            var15_15.remove(var1_1);
                            UpdateMessage.fireChildRemoved((Subject)var15_15, (Element)var1_1);
                        } else {
                            var16_16 = JdbcNodeFactory.getNode(this._db, var11_11);
                            UpdateMessage.fireStructureChanged((Subject)var16_16);
                        }
                    }
                    var26_17 = true;
                    return var26_17;
                }
                var17_18 = var3_3 != false ? ConnectionArb.getString(314) : ConnectionArb.getString(309);
                v1 = var18_19 = var3_3 != false ? ConnectionArb.format(315, var12_12) : ConnectionArb.format(310, var12_12);
                if (!MessageDialog.confirm(null, (Object)var18_19, (String)var17_18, null, (boolean)true)) {
                    var27_20 = true;
                    return var27_20;
                }
                var19_21 = new 4(this, var4_4, var5_5, var6_6, var7_7, var14_14, var3_3, (String[])var12_12, var11_11, var1_1);
                var19_21.setTitle(ConnectionArb.getString(457));
                var19_21.setMessage(ConnectionArb.format(458, var9_9));
                var19_21.setCancelable(false);
                try {
                    var19_21.start(true);
                    break block14;
                }
                catch (ProgressException var20_22) {
                    var21_23 = var20_22.getCause();
                    ** while (var21_23 instanceof CMException)
                }
lbl-1000:
                // 1 sources

                {
                    if (!((CMException)var21_23).isWrapper()) break;
                    var21_23 = ((CMException)var21_23).unwrap();
                    continue;
                }
lbl50:
                // 2 sources

                if (var21_23 instanceof DBException) {
                    throw (DBException)var21_23;
                }
                throw new DBException(var21_23);
            }
            catch (DBException var22_24) {
                var23_25 = var22_24.getCause();
                var24_26 = ConnectionArb.getString(323);
                var25_27 = IdeUtil.getMainWindow();
                if (var23_25 instanceof SQLException) {
                    SQLErrorDialog.showErrorDialog(var25_27, var24_26, (SQLException)var23_25);
                }
                ExceptionDialog.showExceptionDialog((Window)var25_27, (Exception)var22_24, (String)var24_26, (String)var22_24.getLocalizedMessage());
            }
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private boolean _unDropObject(RecycledObjectNode var1_1) {
        block11: {
            var2_2 = var1_1.getURL();
            var3_3 = this.getDBType(CmUtil.getDbObjectType(var2_2));
            var4_4 = CmUtil.getUserName(var2_2);
            var5_5 = JDevCmURLFileSystemHelper.getRealName(var3_3, CmUtil.getName(var2_2));
            var6_6 = CmUtil.getConnName(var2_2);
            var7_7 = CmUtil.getCatalog(var2_2);
            var8_8 = var1_1.getRecycledObject().getOriginalName();
            var9_9 = CmUtil.getFolderURL(var6_6, var7_7, var4_4, var3_3);
            var10_10 = new String[]{var1_1.getRecycledObject().getOriginalType(), var4_4, var8_8};
            try {
                var11_11 = this._db.getSchema(var4_4);
                var12_12 = this._db.getObject(var3_3, var11_11, var5_5);
                if (var12_12 == null) {
                    MessageDialog.information(null, (Object)ConnectionArb.format(318, var10_10), (String)ConnectionArb.getString(319), null);
                    JdbcBrowser.closeElement((Element)var1_1);
                    if (CmUtil.isFolder(var9_9)) {
                        var13_13 = this.getNodeByType(var4_4, var3_3);
                        if (var13_13 != null) {
                            var13_13.remove((Element)var1_1);
                            UpdateMessage.fireChildRemoved((Subject)var13_13, (Element)var1_1);
                        } else {
                            var14_14 = JdbcNodeFactory.getNode(this._db, var9_9);
                            UpdateMessage.fireStructureChanged((Subject)var14_14);
                        }
                    }
                    var22_15 = true;
                    return var22_15;
                }
                var15_16 = new 3(this, var12_12, (String[])var10_10, var1_1);
                var15_16.setTitle(ConnectionArb.getString(459));
                var15_16.setMessage(ConnectionArb.format(460, var8_8));
                var15_16.setCancelable(false);
                try {
                    var15_16.start(true);
                    break block11;
                }
                catch (ProgressException var16_17) {
                    var17_18 = var16_17.getCause();
                    ** while (var17_18 instanceof CMException)
                }
lbl-1000:
                // 1 sources

                {
                    if (!((CMException)var17_18).isWrapper()) break;
                    var17_18 = ((CMException)var17_18).unwrap();
                    continue;
                }
lbl40:
                // 2 sources

                if (var17_18 instanceof DBException) {
                    throw (DBException)var17_18;
                }
                throw new DBException(var17_18);
            }
            catch (DBException var18_19) {
                var19_20 = var18_19.getCause();
                var20_21 = ConnectionArb.getString(323);
                var21_22 = IdeUtil.getMainWindow();
                if (var19_20 instanceof SQLException) {
                    SQLErrorDialog.showErrorDialog(var21_22, var20_21, (SQLException)var19_20);
                }
                ExceptionDialog.showExceptionDialog((Window)var21_22, (Exception)var18_19, (String)var20_21, (String)var18_19.getLocalizedMessage());
            }
        }
        return true;
    }

    private boolean _dropObjectCmd(Context context) {
        boolean bl = false;
        Element[] elementArray = context.getSelection();
        if (elementArray == null || elementArray.length == 0) {
            elementArray = new Element[]{context.getElement()};
        }
        if (JdbcBrowser.arrayInstanceOf(elementArray, DatabaseNode.class) || this._isDroppable(elementArray)) {
            bl = true;
            int n = elementArray.length;
            int n2 = 0;
            while (n2 < n) {
                if (!this._dropObjectCmd(elementArray[n2])) {
                    bl = false;
                    break;
                }
                ++n2;
            }
        }
        return bl;
    }

    private boolean _purgeObjectCmd(Context context) {
        boolean bl = false;
        Element[] elementArray = context.getSelection();
        if (elementArray == null || elementArray.length == 0) {
            elementArray = new Element[]{context.getElement()};
        }
        if (JdbcBrowser.arrayInstanceOf(elementArray, RecycledObjectNode.class)) {
            bl = true;
            int n = elementArray.length;
            int n2 = 0;
            while (n2 < n) {
                if (!this._dropObject((Element)((RecycledObjectNode)elementArray[n2]))) {
                    bl = false;
                    break;
                }
                ++n2;
            }
        }
        return bl;
    }

    private boolean _unDropObjectCmd(Context context) {
        boolean bl = false;
        Element[] elementArray = context.getSelection();
        if (elementArray == null || elementArray.length == 0) {
            elementArray = new Element[]{context.getElement()};
        }
        if (JdbcBrowser.arrayInstanceOf(elementArray, RecycledObjectNode.class)) {
            bl = true;
            int n = elementArray.length;
            int n2 = 0;
            while (n2 < n) {
                if (!this._unDropObject((RecycledObjectNode)elementArray[n2])) {
                    bl = false;
                    break;
                }
                ++n2;
            }
        }
        return bl;
    }

    static void refreshFolder(Refreshable refreshable) {
        refreshable.refresh();
        if (refreshable instanceof Subject) {
            UpdateMessage.fireStructureChanged((Subject)((Subject)refreshable));
        }
    }

    private boolean _doCreateBody(Context context) {
        Element element = context.getElement();
        if (element instanceof PlSqlFolder) {
            PlSqlFolder plSqlFolder = (PlSqlFolder)element;
            URL uRL = plSqlFolder.getURL();
            String string = plSqlFolder.getBodyType();
            String string2 = CmUtil.getName(uRL);
            String string3 = CmUtil.getSchema(uRL);
            String string4 = plSqlFolder.getObjectType();
            String string5 = CmUtil.getConnName(uRL);
            if ("PACKAGE BODY".equals(string)) {
                String string6 = this.getBodyText(string, string2);
                URL uRL2 = CmUtil.getNodeURL(string5, null, string3, string4, string2, "Body");
                Node node = JdbcNodeFactory.getNode(this._db, uRL2);
                if (node instanceof TextNode) {
                    node.addNodeListener((NodeListener)new 2(this, plSqlFolder, node));
                    TextBuffer textBuffer = null;
                    try {
                        textBuffer = ((TextNode)node).acquireTextBuffer();
                        textBuffer.beginEdit();
                        textBuffer.removeToEnd(0);
                        textBuffer.append(string6.toCharArray());
                    }
                    finally {
                        if (textBuffer != null) {
                            textBuffer.endEdit();
                            ((TextNode)node).releaseTextBuffer();
                        }
                    }
                }
                if (node != null) {
                    SwingUtilities.invokeLater(new 1(this, node));
                }
            }
        }
        return true;
    }

    private String getBodyText(String string, String string2) {
        FastStringBuffer fastStringBuffer = new FastStringBuffer();
        fastStringBuffer.append("CREATE OR REPLACE ");
        fastStringBuffer.append(string);
        fastStringBuffer.append(" ");
        fastStringBuffer.append("\"");
        fastStringBuffer.append(string2);
        fastStringBuffer.append("\"");
        fastStringBuffer.append(" AS\n");
        fastStringBuffer.append("END;\n");
        return fastStringBuffer.toString();
    }

    public InputStream getInputStream(URL uRL) throws IOException {
        InputStream inputStream;
        block5: {
            inputStream = null;
            String string = CmUtil.getDbObjectType(uRL);
            String string2 = CmUtil.getUserName(uRL);
            String string3 = JDevCmURLFileSystemHelper.getRealName(string, CmUtil.getName(uRL));
            try {
                Schema schema = this._db.getSchema(string2);
                String string4 = this._db.getDatabaseSource(string, schema, string3);
                if (string4 != null) {
                    byte[] byArray;
                    try {
                        byArray = string4.getBytes(IdeUtil.getIdeEncoding());
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        byArray = string4.getBytes();
                    }
                    inputStream = new ByteArrayInputStream(byArray);
                    break block5;
                }
                SchemaObject schemaObject = this._db.getObject(string, schema, string3);
                inputStream = schemaObject instanceof BinaryObject ? ((BinaryObject)schemaObject).getInputStream() : new ByteArrayInputStream(new byte[0]);
            }
            catch (DBException dBException) {
                throw new IOException(dBException.getLocalizedMessage());
            }
        }
        return inputStream;
    }

    public OutputStream getOutputStream(URL uRL) throws IOException {
        throw new IOException("Outputstream not supported");
    }

    public Node create(URL uRL) {
        if (!CmUtil.isCMUrl(uRL)) {
            return null;
        }
        Node node = null;
        node = CmUtil.isFolder(uRL) ? JdbcNodeFactory.getFolder(uRL, this._db, null) : JdbcNodeFactory.getNode(this._db, uRL);
        return node;
    }

    private void _cleanupClose() {
        if (this.others != null) {
            try {
                this.others.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.others = null;
        if (this.currUser != null) {
            try {
                this.currUser.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.currUser = null;
        if (this._db != null) {
            this._db.close();
        }
        this._db = null;
        if (this._parentNode != null) {
            JdbcConnectionFactory.getInstance().closeConnection(this._parentNode.getConnectionName());
        }
    }

    private SchemaObject getObject(URL uRL) {
        SchemaObject schemaObject = null;
        try {
            schemaObject = this._db.getObject(CmUtil.getDbObjectType(uRL), this._db.getSchema(CmUtil.getSchema(uRL)), CmUtil.getName(uRL));
        }
        catch (DBException dBException) {
            // empty catch block
        }
        return schemaObject;
    }

    static boolean arrayInstanceOf(Element[] elementArray, Class clazz) {
        return JdbcBrowser.arrayInstanceOf(elementArray, clazz, false);
    }

    static boolean arrayInstanceOf(Element[] elementArray, Class clazz, boolean bl) {
        if (elementArray == null || elementArray.length == 0) {
            return false;
        }
        if (bl && elementArray.length > 1) {
            return false;
        }
        int n = 0;
        while (n < elementArray.length) {
            Class<?> clazz2;
            Class<?> clazz3 = clazz2 = elementArray[n] != null ? elementArray[n].getClass() : null;
            if (clazz2 == null || !clazz.isAssignableFrom(clazz2)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    static void closeElement(Element element) {
        Folder folder;
        if (element instanceof Folder && (!((folder = (Folder)element) instanceof CBBaseFolder) || ((CBBaseFolder)folder).isOpen())) {
            Iterator iterator = element.getChildren();
            while (iterator.hasNext()) {
                JdbcBrowser.closeElement((Element)iterator.next());
            }
        }
        if (element instanceof Node) {
            Node node = (Node)element;
            try {
                node.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void schemaRemoved(DBObjectProvider dBObjectProvider, Schema schema) {
        String string = schema.getName();
        this.others.removeSchema(string);
    }

    public void schemaAdded(DBObjectProvider dBObjectProvider, Schema schema) {
        String string = schema.getName();
        this.others.addSchema(string);
    }

    public SchemaFolderFilter getDefaultFilter() {
        return new SchemaFolderFilter(null);
    }

    static OtherSchemas ra$others(JdbcBrowser jdbcBrowser) {
        return jdbcBrowser.others;
    }

    public final class 5
    extends ProgressRunnable {
        private final /* synthetic */ Schema v$schema;
        private final /* synthetic */ String v$sName;
        final /* synthetic */ JdbcBrowser this$0;

        protected Object doWork() throws CMException {
            try {
                this.this$0._db.deleteSchema(this.v$schema, true);
            }
            catch (DBException dBException) {
                throw new CMException((Exception)((Object)dBException));
            }
            return Boolean.TRUE;
        }

        protected void finish(Object object) {
            JdbcBrowser.ra$others(this.this$0).removeSchema(this.v$sName);
        }

        public 5(JdbcBrowser jdbcBrowser, Schema schema, String string) {
            this.v$sName = string;
            this.v$schema = schema;
            this.this$0 = jdbcBrowser;
        }
    }

    public final class 4
    extends ProgressRunnable {
        private final /* synthetic */ String v$type;
        private final /* synthetic */ String v$schema;
        private final /* synthetic */ String v$name;
        private final /* synthetic */ String v$connName;
        private final /* synthetic */ SchemaObject v$obj;
        private final /* synthetic */ boolean v$isRecycled;
        private final /* synthetic */ String[] v$params;
        private final /* synthetic */ URL v$parentURL;
        private final /* synthetic */ Element v$element;
        final /* synthetic */ JdbcBrowser this$0;

        protected Object doWork() throws CMException {
            boolean bl = false;
            if ("JAVA CLASS".equals(this.v$type) || "JAVA SOURCE".equals(this.v$type) || "JAVA RESOURCE".equals(this.v$type)) {
                bl = DatabaseObject.drop(this.v$type, this.v$schema, this.v$name, this.v$connName);
            } else {
                try {
                    this.this$0._db.deleteObject(this.v$obj, false);
                    bl = true;
                }
                catch (DBException dBException) {
                    throw new CMException((Exception)((Object)dBException));
                }
            }
            return bl;
        }

        protected void finish(Object object) {
            if (Boolean.FALSE.equals(object)) {
                String string = this.v$isRecycled ? ConnectionArb.format(316, this.v$params) : ConnectionArb.format(311, this.v$params);
                String string2 = this.v$isRecycled ? ConnectionArb.getString(324) : ConnectionArb.getString(323);
                MessageDialog.error(null, (Object)string, (String)string2, null);
            } else if (Boolean.TRUE.equals(object)) {
                if (!CmUtil.isFolder(this.v$parentURL)) {
                    Node node = JdbcNodeFactory.getNode(this.this$0._db, this.v$parentURL);
                    UpdateMessage.fireStructureChanged((Subject)node);
                }
                JdbcBrowser.closeElement(this.v$element);
            }
        }

        public 4(JdbcBrowser jdbcBrowser, String string, String string2, String string3, String string4, SchemaObject schemaObject, boolean bl, String[] stringArray, URL uRL, Element element) {
            this.v$element = element;
            this.v$parentURL = uRL;
            this.v$params = stringArray;
            this.v$isRecycled = bl;
            this.v$obj = schemaObject;
            this.v$connName = string4;
            this.v$name = string3;
            this.v$schema = string2;
            this.v$type = string;
            this.this$0 = jdbcBrowser;
        }
    }

    public final class 3
    extends ProgressRunnable {
        private final /* synthetic */ SchemaObject v$obj;
        private final /* synthetic */ String[] v$params;
        private final /* synthetic */ RecycledObjectNode v$element;
        final /* synthetic */ JdbcBrowser this$0;

        protected Object doWork() throws CMException {
            boolean bl = false;
            try {
                this.this$0._db.undeleteObject(this.v$obj);
                bl = true;
            }
            catch (DBException dBException) {
                throw new CMException((Exception)((Object)dBException));
            }
            return bl;
        }

        protected void finish(Object object) {
            if (Boolean.FALSE.equals(object)) {
                String string = ConnectionArb.format(317, this.v$params);
                String string2 = ConnectionArb.getString(325);
                MessageDialog.error(null, (Object)string, (String)string2, null);
            } else if (Boolean.TRUE.equals(object)) {
                JdbcBrowser.closeElement((Element)this.v$element);
            }
        }

        public 3(JdbcBrowser jdbcBrowser, SchemaObject schemaObject, String[] stringArray, RecycledObjectNode recycledObjectNode) {
            this.v$element = recycledObjectNode;
            this.v$params = stringArray;
            this.v$obj = schemaObject;
            this.this$0 = jdbcBrowser;
        }
    }

    public final class 2
    extends NodeListener {
        private final /* synthetic */ PlSqlFolder v$folder;
        private final /* synthetic */ Node v$node;
        final /* synthetic */ JdbcBrowser this$0;

        public void nodeSaved(NodeEvent nodeEvent) {
            this.v$folder.updateBody(true);
        }

        public void nodeClosed(NodeEvent nodeEvent) {
            this.v$node.removeNodeListener((NodeListener)this);
        }

        public 2(JdbcBrowser jdbcBrowser, PlSqlFolder plSqlFolder, Node node) {
            this.v$node = node;
            this.v$folder = plSqlFolder;
            this.this$0 = jdbcBrowser;
        }
    }

    public final class 1
    implements Runnable {
        private final /* synthetic */ Node v$node;
        final /* synthetic */ JdbcBrowser this$0;

        public void run() {
            EditorUtil.openDefaultEditorInFrame((Node)this.v$node);
        }

        public 1(JdbcBrowser jdbcBrowser, Node node) {
            this.v$node = node;
            this.this$0 = jdbcBrowser;
        }
    }

    private static class ChildIterator
    implements Iterator {
        private Iterator _iter;
        private OtherSchemas _others;

        private ChildIterator(SchemaFolder schemaFolder, OtherSchemas otherSchemas) {
            this._iter = schemaFolder.getChildren();
            this._others = otherSchemas;
        }

        public boolean hasNext() {
            return this._iter != null || this._others != null;
        }

        public Object next() {
            OtherSchemas otherSchemas = null;
            if (this._iter != null) {
                otherSchemas = this._iter.next();
                if (!this._iter.hasNext()) {
                    this._iter = null;
                }
            } else {
                otherSchemas = this._others;
                this._others = null;
            }
            if (otherSchemas == null) {
                throw new NoSuchElementException();
            }
            return otherSchemas;
        }

        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        ChildIterator(SchemaFolder schemaFolder, OtherSchemas otherSchemas, 1 var3_3) {
            this(schemaFolder, otherSchemas);
        }

        public final class 1 {
        }
    }
}

