/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cm.dt.browser.jdbc;

import java.awt.EventQueue;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.util.IdeUtil;
import oracle.javatools.buffer.ReadWriteLock;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.cm.CMException;
import oracle.jdeveloper.cm.ds.db.DBUtil;
import oracle.jdeveloper.cm.dt.CmUtil;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdeveloper.cm.dt.browser.Filterable;
import oracle.jdeveloper.cm.dt.browser.Refreshable;
import oracle.jdeveloper.cm.dt.browser.jdbc.SchemaFolder;
import oracle.jdeveloper.cm.dt.dialog.ExceptionDialogRunnable;
import oracle.jdevimpl.cm.dt.browser.jdbc.JdbcBrowser;

public class OtherSchemas
extends Node
implements Filterable,
Refreshable {
    private Map<String, SchemaFolder> _schemas;
    private String _uname;
    private Database _db;
    private boolean _schemasWithObjects;

    OtherSchemas(URL uRL, Database database, String string) {
        this._uname = string;
        this._db = database;
        this.setURL(uRL);
    }

    public boolean canBeFiltered() {
        return true;
    }

    public boolean isFiltered() {
        return false;
    }

    public Iterator getChildren() {
        this.ensureOpen();
        return this._schemas == null ? Collections.EMPTY_SET.iterator() : this._schemas.values().iterator();
    }

    public boolean mayHaveChildren() {
        return true;
    }

    public String getShortLabel() {
        return "Other Users";
    }

    public Icon getIcon() {
        return DBUtil.getFolderIcon("SCHEMA");
    }

    protected void openImpl() throws IOException {
        super.openImpl();
        if (this._schemas == null) {
            this.loadSchemas();
        }
    }

    Database getDatabase() {
        return this._db;
    }

    String getOwningUser() {
        return this._uname;
    }

    void setSchemasWithObjects(boolean bl) {
        this._schemasWithObjects = bl;
    }

    boolean isSchemasWithObjects() {
        return this._schemasWithObjects;
    }

    private void loadSchemas() throws IOException {
        1 var1_1 = new 1();
        var1_1.setTitle(ConnectionArb.getString(455));
        var1_1.setMessage("Loading Schemas...");
        var1_1.setCancelable(true);
        try {
            var1_1.start(true);
        }
        catch (ProgressException progressException) {
            Exception exception = (Exception)progressException.getCause();
            IOException iOException = exception instanceof IOException ? (IOException)exception : new ExceptionWrapper(exception, null);
            throw iOException;
        }
    }

    protected void closeImpl() throws IOException {
        if (this._schemas != null) {
            this._schemas.clear();
            this._schemas = null;
        }
        super.closeImpl();
    }

    protected void reportOpenException(Exception exception) {
        if (exception instanceof ExceptionWrapper) {
            exception = (Exception)exception.getCause();
        }
        Exception exception2 = exception;
        IdeUtil.runNow((Runnable)new ExceptionDialogRunnable(exception2));
    }

    SchemaFolder getSchema(String string) {
        this.ensureOpen();
        return this._schemas.get(string);
    }

    void addSchema(String string) {
        if (this.isOpen()) {
            SchemaFolder schemaFolder = JdbcBrowser.createSchemaFolder(CmUtil.getConnName(this.getURL()), this._db, string);
            this._schemas.put(string, schemaFolder);
        }
    }

    void removeSchema(String string) {
        SchemaFolder schemaFolder;
        if (this.isOpen() && (schemaFolder = this._schemas.remove(string)) != null) {
            JdbcBrowser.closeElement((Element)schemaFolder);
            UpdateMessage.fireChildRemoved((Subject)this, (Element)schemaFolder);
        }
    }

    public void refresh() {
        if (this.isOpen()) {
            ReadWriteLock readWriteLock = this._getReadWriteLockInternal();
            readWriteLock.writeLock();
            try {
                try {
                    this._schemas.clear();
                    this._schemas = null;
                    this.loadSchemas();
                    UpdateMessage.fireStructureChanged((Subject)this);
                }
                catch (IOException iOException) {
                    EventQueue.invokeLater(new ExceptionDialogRunnable(iOException));
                }
            }
            finally {
                readWriteLock.writeUnlock();
            }
        }
    }

    static void wa$_schemas(OtherSchemas otherSchemas, Map map) {
        otherSchemas._schemas = map;
    }

    static Database ra$_db(OtherSchemas otherSchemas) {
        return otherSchemas._db;
    }

    static boolean ra$_schemasWithObjects(OtherSchemas otherSchemas) {
        return otherSchemas._schemasWithObjects;
    }

    static String ra$_uname(OtherSchemas otherSchemas) {
        return otherSchemas._uname;
    }

    public final class oracle.jdevimpl.cm.dt.browser.jdbc.OtherSchemas$1
    extends ProgressRunnable {
        protected Object doWork() throws IOException {
            HashMap<String, SchemaFolder> hashMap = new HashMap<String, SchemaFolder>();
            String string = CmUtil.getConnName(OtherSchemas.this.getURL());
            try {
                Schema[] schemaArray = OtherSchemas.ra$_db(OtherSchemas.this).listSchemas(OtherSchemas.ra$_schemasWithObjects(OtherSchemas.this));
                Schema schema = OtherSchemas.ra$_db(OtherSchemas.this).getSchema(OtherSchemas.ra$_uname(OtherSchemas.this));
                Schema[] schemaArray2 = schemaArray;
                int n = 0;
                while (n < schemaArray2.length) {
                    Schema schema2 = schemaArray2[n];
                    if (ModelUtil.areDifferent((Object)schema2, (Object)schema)) {
                        String string2 = schema2.getName();
                        hashMap.put(string2, JdbcBrowser.createSchemaFolder(string, OtherSchemas.ra$_db(OtherSchemas.this), string2));
                    }
                    ++n;
                }
            }
            catch (DBException dBException) {
                Throwable throwable = dBException.getCause();
                CMException cMException = throwable instanceof Exception ? new CMException((Exception)throwable) : new CMException((Exception)((Object)dBException));
                throw new ExceptionWrapper((Exception)((Object)cMException), null);
            }
            return hashMap;
        }

        protected void finish(Object object) {
            if (object instanceof Map) {
                OtherSchemas.wa$_schemas(OtherSchemas.this, (Map)object);
            } else {
                try {
                    OtherSchemas.this.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                SwingUtilities.invokeLater(new 1());
            }
        }

        public final class 1
        implements Runnable {
            public void run() {
                UpdateMessage.fireObjectClosed((Subject)OtherSchemas.this);
            }
        }
    }

    private static class ExceptionWrapper
    extends IOException {
        private ExceptionWrapper(Exception exception) {
            this.initCause(exception);
        }

        ExceptionWrapper(Exception exception, 1 var2_2) {
            this(exception);
        }

        ExceptionWrapper(Exception exception, oracle.jdevimpl.cm.dt.browser.jdbc.OtherSchemas$1 var2_2) {
            this(exception);
        }

        public final class 1 {
        }
    }
}

