/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cm.dt.browser.jdbc;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import oracle.ide.Ide;
import oracle.ide.controls.OverlayIcon;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.UpdateMessage;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdeveloper.cm.dt.browser.SchemaFolderFilter;
import oracle.jdeveloper.cm.dt.browser.jdbc.SchemaFolder;
import oracle.jdevimpl.cm.dt.browser.jdbc.BaseConnFilter;
import oracle.jdevimpl.cm.dt.browser.jdbc.DummyEntry;
import oracle.jdevimpl.cm.dt.browser.jdbc.LargeFetchComparator;
import oracle.jdevimpl.cm.dt.browser.jdbc.LargeFetchSupport;
import oracle.jdevimpl.cm.dt.browser.jdbc.LimitIterator;
import oracle.jdevimpl.cm.dt.browser.jdbc.ObjectIterator;
import oracle.jdevimpl.cm.dt.browser.jdbc.OtherSchemas;
import oracle.jdevimpl.cm.dt.config.ConnectionOptions;

public class OtherSchemasFilter
extends BaseConnFilter
implements LargeFetchSupport {
    private Set _visibleSchemas;
    private List _children;
    private boolean _showAll;
    private boolean _onlyOwnedObjects;
    private Element _dummyElement;
    private Comparator comp;

    void $init$() {
        this._dummyElement = new DummyEntry();
    }

    public OtherSchemasFilter() {
        this.$init$();
    }

    public Comparator getComparator() {
        if (this.comp == null) {
            this.comp = new LargeFetchComparator(super.getComparator());
        }
        return this.comp;
    }

    public boolean isShowAll() {
        return this._showAll;
    }

    public void setShowAll(boolean bl) {
        if (this._showAll != bl) {
            this._showAll = bl;
            this.updateCache();
        }
    }

    /*
     * Unable to fully structure code
     */
    public Iterator getChildren() {
        block2: {
            if (this._children != null) break block2;
            this._children = new ArrayList<E>();
            this.loadCachedFilter();
            var1_1 = (OtherSchemas)this.getOwner().getData();
            var1_1.setSchemasWithObjects(this._onlyOwnedObjects);
            var2_2 = var1_1.getChildren();
            if (this._visibleSchemas != null) ** GOTO lbl18
            while (var2_2.hasNext()) {
                this._children.add(var2_2.next());
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                var3_3 = (SchemaFolder)var2_2.next();
                var4_4 = var3_3.getName();
                if (!this._visibleSchemas.contains(var4_4)) continue;
                this._children.add(var3_3);
lbl18:
                // 3 sources

                ** while (var2_2.hasNext())
            }
        }
        var5_5 = new LimitIterator(this._children.iterator());
        return this._showAll != false || this.isFiltered() != false ? var5_5 : new ObjectIterator(var5_5, this._dummyElement);
    }

    public TNode childrenAdded(UpdateMessage updateMessage, TNode tNode, TreeExplorer treeExplorer) {
        for (SchemaFolder schemaFolder : updateMessage.getAddObjects()) {
            if (this._visibleSchemas != null && !this._visibleSchemas.contains(schemaFolder.getName())) continue;
            this._children.add(schemaFolder);
            TNode tNode2 = treeExplorer.addChild((Element)schemaFolder, tNode, treeExplorer.getTreeModel());
            this.cache(tNode2);
        }
        return tNode;
    }

    public TNode childrenRemoved(UpdateMessage updateMessage, TNode tNode, TreeExplorer treeExplorer) {
        for (SchemaFolder schemaFolder : updateMessage.getRemoveObjects()) {
            TNode tNode2;
            if (!this._children.remove(schemaFolder) || (tNode2 = this.lookup((Element)schemaFolder)) == null) continue;
            treeExplorer.removeChild(tNode2, treeExplorer.getTreeModel());
        }
        return tNode;
    }

    public void closeChildren() {
        if (this._children != null) {
            this._children.clear();
            this._children = null;
        }
        this.clearCache();
    }

    public Icon getIcon() {
        Icon icon = this.getOwner().getData().getIcon();
        if (this.isFiltered()) {
            icon = new OverlayIcon(new Icon[]{icon, ConnectionArb.getIcon(490)});
        }
        return icon;
    }

    protected Object getKey(Object object) {
        return object instanceof Locatable ? ((Locatable)object).getURL() : null;
    }

    public void setFilter(SchemaFolderFilter schemaFolderFilter) {
        HashSet<String> hashSet;
        String[] stringArray = null;
        boolean bl = false;
        if (schemaFolderFilter != null) {
            stringArray = schemaFolderFilter.getFilter();
            bl = this._onlyOwnedObjects != schemaFolderFilter.isVisibleObjectsOnly();
            this._onlyOwnedObjects = schemaFolderFilter.isVisibleObjectsOnly();
        }
        HashSet<String> hashSet2 = hashSet = stringArray != null ? new HashSet<String>(Arrays.asList(stringArray)) : null;
        if (ModelUtil.areDifferent((Object)this._visibleSchemas, hashSet)) {
            this._visibleSchemas = hashSet;
            bl = true;
        }
        if (bl) {
            OtherSchemas otherSchemas = (OtherSchemas)this.getOwner().getData();
            otherSchemas.setSchemasWithObjects(this._onlyOwnedObjects);
            otherSchemas.refresh();
        }
        this.updateCache();
    }

    public SchemaFolderFilter getFilter() {
        Object[] objectArray = null;
        if (this._visibleSchemas != null) {
            objectArray = this._visibleSchemas.toArray(new String[this._visibleSchemas.size()]);
            Arrays.sort(objectArray);
        }
        SchemaFolderFilter schemaFolderFilter = new SchemaFolderFilter((String[])objectArray);
        schemaFolderFilter.setShowAll(this._showAll);
        schemaFolderFilter.setVisibleObjectsOnly(this._onlyOwnedObjects);
        return schemaFolderFilter;
    }

    public boolean isFiltered() {
        return this._visibleSchemas != null || this._onlyOwnedObjects;
    }

    private final void updateCache() {
        URL uRL;
        ConnectionOptions connectionOptions = (ConnectionOptions)((Object)Ide.getSettings().getData("ConnectionOptions"));
        if (connectionOptions != null && (uRL = this.getURL()) != null) {
            SchemaFolderFilter schemaFolderFilter = this.getFilter();
            if (schemaFolderFilter == null || ModelUtil.areEqual((Object)schemaFolderFilter, (Object)this.getDefaultFilter())) {
                connectionOptions.uncacheFilter(uRL);
            } else {
                connectionOptions.cacheFilter(uRL, schemaFolderFilter);
            }
        }
    }

    protected SchemaFolderFilter getDefaultFilter() {
        SchemaFolderFilter schemaFolderFilter = new SchemaFolderFilter(null);
        schemaFolderFilter.setVisibleObjectsOnly(false);
        return schemaFolderFilter;
    }

    private final void loadCachedFilter() {
        URL uRL;
        ConnectionOptions connectionOptions = (ConnectionOptions)((Object)Ide.getSettings().getData("ConnectionOptions"));
        if (connectionOptions != null && (uRL = this.getURL()) != null) {
            this._visibleSchemas = null;
            SchemaFolderFilter schemaFolderFilter = (SchemaFolderFilter)connectionOptions.getFilter(uRL);
            if (schemaFolderFilter == null) {
                schemaFolderFilter = this.getDefaultFilter();
            } else if (ModelUtil.areEqual((Object)schemaFolderFilter, (Object)this.getDefaultFilter())) {
                connectionOptions.uncacheFilter(uRL);
            }
            if (schemaFolderFilter != null) {
                String[] stringArray = schemaFolderFilter.getFilter();
                this._visibleSchemas = stringArray != null ? new HashSet<String>(Arrays.asList(stringArray)) : null;
                this._showAll = schemaFolderFilter.isShowAll();
                this._onlyOwnedObjects = schemaFolderFilter.isVisibleObjectsOnly();
            }
        }
    }

    private URL getURL() {
        Element element = this.getOwner().getData();
        return element instanceof Locatable ? ((Locatable)element).getURL() : null;
    }
}

