/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cm.dt.browser.jndi;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.naming.Context;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import oracle.ide.model.Node;
import oracle.jdeveloper.cm.CMException;
import oracle.jdeveloper.cm.ConnectionDescriptor;
import oracle.jdeveloper.cm.ConnectionManager;
import oracle.jdeveloper.cm.ConnectionWrapper;
import oracle.jdeveloper.cm.dt.CmUtil;
import oracle.jdeveloper.cm.dt.ConnectionBrowsable;
import oracle.jdeveloper.cm.dt.browser.CBBaseFolder;
import oracle.jdeveloper.cm.dt.browser.ConnectionBrowser;
import oracle.jdeveloper.cm.dt.browser.jndi.JndiApplicationsFolder;

public final class JNDIBrowser
implements ConnectionBrowser {
    private List _childList;
    private ConnectionBrowsable _parentNode;

    void $init$() {
        this._childList = null;
        this._parentNode = null;
    }

    public void openConnectionBrowser(ConnectionBrowsable connectionBrowsable) throws CMException {
        try {
            String string = connectionBrowsable.getConnectionName();
            this._parentNode = connectionBrowsable;
            this._childList = new ArrayList(1);
            ConnectionManager connectionManager = ConnectionManager.getInstance();
            ConnectionWrapper connectionWrapper = connectionManager.getConnection(string);
            Context context = (Context)connectionWrapper.getPresentation("JNDI");
            this._childList.add(JNDIBrowser.getAppRoot(string, context));
            this._testContext(context);
        }
        catch (CMException cMException) {
            throw cMException;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void closeConnectionBrowser() {
        this._childList.clear();
        this._childList = null;
        this._parentNode = null;
    }

    public void refresh() {
        try {
            ConnectionBrowsable connectionBrowsable = this._parentNode;
            this.closeConnectionBrowser();
            this.openConnectionBrowser(connectionBrowsable);
        }
        catch (CMException cMException) {
            // empty catch block
        }
    }

    public ConnectionDescriptor getConnectionDescriptor() {
        ConnectionDescriptor connectionDescriptor = null;
        String string = this._parentNode.getConnectionName();
        try {
            ConnectionManager connectionManager = ConnectionManager.getInstance();
            connectionDescriptor = connectionManager.getConnectionDescriptor(string);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return connectionDescriptor;
    }

    public Iterator getChildren() {
        if (this._childList != null) {
            return this._childList.iterator();
        }
        return null;
    }

    public Collection getChildrenList() {
        return this._childList;
    }

    public InputStream getInputStream(URL uRL) throws IOException {
        return new ByteArrayInputStream(new byte[0]);
    }

    public OutputStream getOutputStream(URL uRL) throws IOException {
        throw new IOException("Outputstream not supported");
    }

    public Node create(URL uRL) {
        return null;
    }

    private static CBBaseFolder getAppRoot(String string, Context context) {
        JndiApplicationsFolder jndiApplicationsFolder = new JndiApplicationsFolder(string, context);
        jndiApplicationsFolder.setURL(CmUtil.getFolderURL(string, null, null, "JSERVER OBJECTS"));
        return jndiApplicationsFolder;
    }

    private void _testContext(Context context) throws CMException {
        try {
            NamingEnumeration<NameClassPair> namingEnumeration = context.list("");
            namingEnumeration.close();
        }
        catch (NamingException namingException) {
            throw new CMException((Exception)namingException);
        }
        catch (Exception exception) {
            throw new CMException(exception);
        }
    }

    public JNDIBrowser() {
        this.$init$();
    }
}

