/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cm.dt.cnpanels;

import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import javax.swing.JComponent;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.WizardCallbacks;
import oracle.jdeveloper.cm.ConnectionDescriptor;

abstract class ConnectionPanel
extends DefaultTraversablePanel {
    private static final String CONNECTION_DESCRIPTOR = "connection-descriptor";
    private static final String ALLOWED_TYPES = "allowed-types";
    private static final String IS_ACTION_CREATE = "is-action-create";
    private static final String IS_APP_SERVER_CATEGORY = "is-app-server-category";
    private static final String ORIGINAL_NAME = "original-name";

    protected final void entryInit(TraversableContext traversableContext, Boolean bl, Component component) {
        WizardCallbacks wizardCallbacks = traversableContext.getWizardCallbacks();
        if (wizardCallbacks != null) {
            wizardCallbacks.wizardEnableButtons(null, null, bl);
            if (component != null) {
                wizardCallbacks.wizardSetInitialFocus(component);
            }
        }
    }

    protected final void exitInit(TraversableContext traversableContext) throws TraversalException {
        int n = traversableContext.getDirection();
        if (n == 1 || n == 0) {
            this.validatePanel(traversableContext);
        }
    }

    protected void validatePanel(TraversableContext traversableContext) throws TraversalException {
    }

    protected static String getAbsolutePath(String string) {
        File file = new File(string);
        try {
            String string2 = file.getCanonicalPath();
            return string2;
        }
        catch (IOException iOException) {
            String string3 = file.getAbsolutePath();
            return string3;
        }
    }

    static final void shrinkPreferredWidth(JComponent jComponent) {
        Dimension dimension = jComponent.getPreferredSize();
        dimension.width = 1;
        jComponent.setPreferredSize(dimension);
    }

    static final ConnectionDescriptor getConnectionDescriptor(Namespace namespace) {
        return (ConnectionDescriptor)namespace.find(CONNECTION_DESCRIPTOR);
    }

    static final void setConnectionDescriptor(Namespace namespace, ConnectionDescriptor connectionDescriptor) {
        namespace.findAndReplace(CONNECTION_DESCRIPTOR, (Object)connectionDescriptor);
    }

    static final String[] getAllowedTypes(Namespace namespace) {
        return (String[])namespace.find(ALLOWED_TYPES);
    }

    static final void setAllowedTypes(Namespace namespace, String[] stringArray) {
        namespace.findAndReplace(ALLOWED_TYPES, (Object)stringArray);
    }

    static final boolean isActionCreate(Namespace namespace) {
        return ConnectionPanel.getBoolean(namespace, IS_ACTION_CREATE, true);
    }

    static final void setActionCreate(Namespace namespace, boolean bl) {
        namespace.findAndReplace(IS_ACTION_CREATE, (Object)bl);
    }

    static final boolean isAppServerCategory(Namespace namespace) {
        return ConnectionPanel.getBoolean(namespace, IS_APP_SERVER_CATEGORY, false);
    }

    static final void setAppServerCategory(Namespace namespace, boolean bl) {
        namespace.findAndReplace(IS_APP_SERVER_CATEGORY, (Object)bl);
    }

    static final String getOriginalName(Namespace namespace) {
        return (String)namespace.find(ORIGINAL_NAME);
    }

    static final void setOriginalName(Namespace namespace, String string) {
        namespace.findAndReplace(ORIGINAL_NAME, (Object)string);
    }

    private static boolean getBoolean(Namespace namespace, String string, boolean bl) {
        Boolean bl2 = (Boolean)namespace.find(string);
        return bl2 != null ? bl2 : bl;
    }

    ConnectionPanel() {
    }
}

