/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cm.dt.cnpanels;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.Iterator;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.ide.wizard.WizardCallbacks;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.cm.ConnectionDescriptor;
import oracle.jdeveloper.cm.ConnectionManager;
import oracle.jdeveloper.cm.ConnectionType;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdevimpl.cm.dt.cnpanels.ConnectionPanel;
import oracle.jdevimpl.cm.dt.cnpanels.ConnectionPanelException;

class ConnectionTypePanel
extends ConnectionPanel
implements ItemListener {
    private final JComboBox cmbType;
    private final JTextField fldConnName;
    private transient boolean _alreadyInited;
    private transient String[] _allowedTypes;
    private transient boolean _isAppServer;
    private transient String _originalName;
    private transient WizardCallbacks _wc;

    void $init$() {
        this.cmbType = new JComboBox();
        this.fldConnName = new JTextField();
        this._alreadyInited = false;
    }

    ConnectionTypePanel() {
        this.$init$();
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.cmbType, (String)ConnectionArb.getString(32));
        JLabel jLabel2 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this.fldConnName, (String)ConnectionArb.getString(33));
        MultiLineLabel multiLineLabel = new MultiLineLabel();
        multiLineLabel.setTextWrapper(WordWrapper.getTextWrapper());
        multiLineLabel.setText(ConnectionArb.getString(35));
        this.cmbType.addItemListener(this);
        this.setLayout(new GridBagLayout());
        Insets insets = new Insets(5, 5, 5, 5);
        Insets insets2 = new Insets(0, 5, 5, 5);
        int n = 0;
        this.add((Component)multiLineLabel, this.gbc(0, n++, 1, 1, 1.0, 0.0, 18, 2, insets));
        this.add(jLabel2, this.gbc(0, n++, 1, 1, 0.0, 0.0, 18, 0, insets));
        this.add(this.fldConnName, this.gbc(0, n++, 1, 1, 0.0, 0.0, 18, 2, insets2));
        this.add(jLabel, this.gbc(0, n++, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 5, 5)));
        this.add(this.cmbType, this.gbc(0, n++, 1, 1, 0.0, 1.0, 18, 0, insets2));
    }

    public void onEntry(TraversableContext traversableContext) {
        this.entryInit(traversableContext, Boolean.FALSE, this.fldConnName);
        this._wc = traversableContext.getWizardCallbacks();
        this._isAppServer = ConnectionTypePanel.isAppServerCategory((Namespace)traversableContext);
        this._allowedTypes = ConnectionTypePanel.getAllowedTypes((Namespace)traversableContext);
        this._initDriverModel();
        this.setHelpID(this._isAppServer ? "f1_depappsvrtype_html" : "f1_idewcxntype_html");
        ConnectionDescriptor connectionDescriptor = ConnectionTypePanel.getConnectionDescriptor((Namespace)traversableContext);
        String string = connectionDescriptor.getConnectionType();
        ConnectionType connectionType = ConnectionManager.getInstance().getConnectionType(string);
        this.cmbType.setSelectedItem(connectionType);
        if (ConnectionTypePanel.isActionCreate((Namespace)traversableContext)) {
            this.cmbType.setEnabled(true);
        } else {
            this.cmbType.setEnabled(false);
        }
        this._originalName = connectionDescriptor.getConnectionName();
        this.fldConnName.setText(this._originalName);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        this.exitInit(traversableContext);
        ConnectionDescriptor connectionDescriptor = ConnectionTypePanel.getConnectionDescriptor((Namespace)traversableContext);
        String string = connectionDescriptor.getConnectionType();
        String string2 = this.getSelectedTypeName();
        if (string2 != null && ModelUtil.areDifferent((Object)string, (Object)string2)) {
            connectionDescriptor.clear();
            connectionDescriptor.put((Object)"ConnectionType", (Object)string2);
        }
        String string3 = this.fldConnName.getText();
        connectionDescriptor.put((Object)"ConnectionName", (Object)string3);
    }

    public Object getExitTransition() {
        return this.getSelectedTypeName();
    }

    private String getSelectedTypeName() {
        ConnectionType connectionType = (ConnectionType)this.cmbType.getSelectedItem();
        return connectionType != null ? connectionType.getTypeName() : null;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this._wc != null && itemEvent.getStateChange() == 1) {
            this._wc.wizardUpdateExpectedTransition(this.getExitTransition());
        }
    }

    protected void validatePanel(TraversableContext traversableContext) throws ConnectionPanelException {
        String string = this.fldConnName.getText();
        this._checkName(string);
        this._validateConnectionName(string);
    }

    private void _checkName(String string) throws ConnectionPanelException {
        if (string == null || string.length() == 0) {
            this.fldConnName.setText(this._originalName);
            throw new ConnectionPanelException(ConnectionArb.getString(34));
        }
        char[] cArray = string.toCharArray();
        boolean bl = false;
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n && !bl) {
            bl = !Character.isJavaIdentifierPart(cArray[n2]) && cArray[n2] != '-';
            ++n2;
        }
        if (bl) {
            throw new ConnectionPanelException(ConnectionArb.getString(126));
        }
    }

    private void _initDriverModel() {
        if (this._alreadyInited) {
            return;
        }
        this._alreadyInited = true;
        try {
            DefaultComboBoxModel<ConnectionType> defaultComboBoxModel = new DefaultComboBoxModel<ConnectionType>();
            Iterator iterator = ConnectionManager.getInstance().getConnectionTypes();
            while (iterator.hasNext()) {
                ConnectionType connectionType;
                Object e = iterator.next();
                if (!(e instanceof ConnectionType) || !this._isAllowedType(connectionType = (ConnectionType)e)) continue;
                defaultComboBoxModel.addElement(connectionType);
            }
            if (defaultComboBoxModel.getSize() < 1) {
                iterator = ConnectionManager.getInstance().getConnectionTypes();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    defaultComboBoxModel.addElement((ConnectionType)e);
                }
            }
            this.cmbType.setModel(defaultComboBoxModel);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean _isAllowedType(ConnectionType connectionType) {
        boolean bl = false;
        if (this._allowedTypes != null) {
            String string = connectionType.getTypeName();
            int n = this._allowedTypes.length;
            int n2 = 0;
            while (n2 < n && !bl) {
                if (this._allowedTypes[n2].toString().equals(string)) {
                    bl = true;
                }
                ++n2;
            }
        } else {
            bl = true;
        }
        return bl;
    }

    private void _validateConnectionName(String string) throws ConnectionPanelException {
        if (this._originalName != null && !string.equalsIgnoreCase(this._originalName)) {
            ConnectionDescriptor connectionDescriptor = null;
            String[] stringArray = null;
            try {
                ConnectionManager connectionManager = ConnectionManager.getInstance();
                connectionDescriptor = connectionManager.getConnectionDescriptor(string);
                stringArray = connectionManager.getConnectionTypeNamesForClass(this._isAppServer ? "CLASS_APPSERVER" : "CLASS_DATABASE");
            }
            catch (IOException iOException) {
                ExceptionDialog.showExceptionDialog((Component)((Object)this), (Throwable)iOException, (String)ConnectionArb.getString(129));
                throw new ConnectionPanelException();
            }
            if (connectionDescriptor != null) {
                String string2 = connectionDescriptor.getConnectionType();
                boolean bl = false;
                if (stringArray != null) {
                    int n = stringArray.length - 1;
                    while (n >= 0) {
                        if (ModelUtil.areEqual((Object)stringArray[n], (Object)string2)) {
                            bl = true;
                            break;
                        }
                        --n;
                    }
                }
                if (bl) {
                    if (!MessageDialog.confirm((Component)((Object)this), (Object)ConnectionArb.format(127, string), (String)ConnectionArb.getString(128), null, (boolean)true)) {
                        throw new ConnectionPanelException();
                    }
                } else {
                    throw new ConnectionPanelException(ConnectionArb.format(this._isAppServer ? 131 : 130, string));
                }
            }
        }
    }
}

