/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cm.dt.cnpanels;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.controls.WholeNumberField;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.cm.ConnectionDescriptor;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdevimpl.cm.dt.cnpanels.ConnectionPanel;
import oracle.jdevimpl.cm.dt.cnpanels.ConnectionPanelException;

class IasRemoteDcmPanel
extends ConnectionPanel {
    private static final int DEFAULT_EM_PORT_10G_UNIX = 1156;
    private static final int DEFAULT_EM_PORT_10G_WIN32 = 18100;
    private final JTextField tfDcmServletHostName;
    private final WholeNumberField tfDcmServletHttpPort;
    private final JTextField tfRemoteOracleHome;
    private final JTextField tfOc4jInstanceName;

    void $init$() {
        this.tfDcmServletHostName = new JTextField();
        this.tfDcmServletHttpPort = new WholeNumberField(5);
        this.tfRemoteOracleHome = new JTextField();
        this.tfOc4jInstanceName = new JTextField();
    }

    IasRemoteDcmPanel() {
        this.$init$();
        JWrappedLabel jWrappedLabel = new JWrappedLabel(ConnectionArb.getString(364));
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.tfDcmServletHostName, (String)ConnectionArb.getString(365));
        JLabel jLabel2 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this.tfDcmServletHttpPort, (String)ConnectionArb.getString(366));
        JLabel jLabel3 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel3, (Component)this.tfRemoteOracleHome, (String)ConnectionArb.getString(367));
        JLabel jLabel4 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel4, (Component)this.tfOc4jInstanceName, (String)ConnectionArb.getString(368));
        IasRemoteDcmPanel.shrinkPreferredWidth(this.tfDcmServletHostName);
        IasRemoteDcmPanel.shrinkPreferredWidth((JComponent)this.tfDcmServletHttpPort);
        IasRemoteDcmPanel.shrinkPreferredWidth(this.tfRemoteOracleHome);
        IasRemoteDcmPanel.shrinkPreferredWidth(this.tfOc4jInstanceName);
        this.setLayout(new GridBagLayout());
        Insets insets = new Insets(5, 5, 5, 5);
        Insets insets2 = new Insets(0, 5, 5, 5);
        this.add((Component)jWrappedLabel, this.gbc(0, 0, 1, 1, 1.0, 0.0, 18, 2, insets));
        int n = 1;
        this.add(jLabel, this.gbc(0, n++, 1, 1, 0.0, 0.0, 17, 0, insets));
        this.add(this.tfDcmServletHostName, this.gbc(0, n++, 1, 1, 0.0, 0.0, 17, 2, insets2));
        this.add(jLabel2, this.gbc(0, n++, 1, 1, 0.0, 0.0, 17, 0, insets));
        this.add((Component)this.tfDcmServletHttpPort, this.gbc(0, n++, 1, 1, 0.0, 0.0, 17, 2, insets2));
        this.add(jLabel3, this.gbc(0, n++, 1, 1, 0.0, 0.0, 17, 0, insets));
        this.add(this.tfRemoteOracleHome, this.gbc(0, n++, 1, 1, 0.0, 0.0, 17, 2, insets2));
        this.add(jLabel4, this.gbc(0, n++, 1, 1, 0.0, 0.0, 17, 0, insets));
        this.add(this.tfOc4jInstanceName, this.gbc(0, n++, 1, 1, 0.0, 0.0, 17, 2, insets2));
        this.add(new JLabel(), this.gbc(0, n, 1, 1, 0.0, 1.0, 18, 0, insets));
        this.setHelpID("f1_dcmremotecxn_html");
    }

    public void onEntry(TraversableContext traversableContext) {
        ConnectionDescriptor connectionDescriptor;
        block6: {
            this.entryInit(traversableContext, Boolean.FALSE, this.tfDcmServletHostName);
            connectionDescriptor = IasRemoteDcmPanel.getConnectionDescriptor((Namespace)traversableContext);
            String string = connectionDescriptor.getHostname();
            if (string == null) {
                try {
                    string = InetAddress.getLocalHost().getHostName();
                }
                catch (UnknownHostException unknownHostException) {
                    string = "localhost";
                }
            }
            this.tfDcmServletHostName.setText(string);
            String string2 = connectionDescriptor.getPort();
            try {
                this.tfDcmServletHttpPort.setValue(Integer.parseInt(string2));
            }
            catch (NumberFormatException numberFormatException) {
                String string3 = connectionDescriptor.getConnectionType();
                if ("Oracle_AS_10g".equals(string3)) {
                    this.tfDcmServletHttpPort.setValue(18100);
                }
                if (!"Oracle_AS_10g_UNIX".equals(string3)) break block6;
                this.tfDcmServletHttpPort.setValue(1156);
            }
        }
        this.tfRemoteOracleHome.setText(connectionDescriptor.getProperty("remote-oracle-home"));
        this.tfOc4jInstanceName.setText(connectionDescriptor.getProperty("oc4j-instance-name"));
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        this.exitInit(traversableContext);
        ConnectionDescriptor connectionDescriptor = IasRemoteDcmPanel.getConnectionDescriptor((Namespace)traversableContext);
        String string = this.tfDcmServletHostName.getText();
        Number number = this.tfDcmServletHttpPort.getNumber();
        String string2 = this.tfRemoteOracleHome.getText();
        connectionDescriptor.setProperty("HOSTNAME", string);
        connectionDescriptor.setProperty("IIOP_PORT", number.toString());
        connectionDescriptor.setProperty("remote-oracle-home", string2);
        connectionDescriptor.setProperty("oc4j-instance-name", this.tfOc4jInstanceName.getText());
    }

    protected void validatePanel(TraversableContext traversableContext) throws ConnectionPanelException {
        String string = this.tfDcmServletHostName.getText();
        if (!ModelUtil.hasLength((String)string)) {
            throw new ConnectionPanelException(ConnectionArb.getString(369));
        }
        Number number = this.tfDcmServletHttpPort.getNumber();
        if (number == null) {
            throw new ConnectionPanelException(ConnectionArb.getString(370));
        }
        int n = number.intValue();
        if (n <= 0 || n >= 65536) {
            throw new ConnectionPanelException(ConnectionArb.format(371, Integer.toString(n)));
        }
        String string2 = this.tfRemoteOracleHome.getText();
        if (!ModelUtil.hasLength((String)string2)) {
            throw new ConnectionPanelException(ConnectionArb.getString(372));
        }
    }
}

