/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cm.dt.config;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.controls.URLPathField;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdeveloper.library.JLibraryManager;
import oracle.jdeveloper.library.Library;
import oracle.jdeveloper.library.LibraryList;
import oracle.jdeveloper.library.ListWrapper;
import oracle.jdevimpl.cm.dt.config.OtherJdbcDriverEntry;
import oracle.jdevimpl.library.LibrariesPanel;

class BaseDriverPanel
extends JPanel
implements ActionListener {
    private GridBagLayout gridBagLayout1;
    private JLabel lblDriver;
    private JLabel lblLibrary;
    private JLabel lblClasspath;
    private JTextField fldLibrary;
    private URLPathField fldClasspath;
    private JButton btnBrowse;
    private JPanel pnlClass;
    private BorderLayout layMode;
    private DriverClassPanel _currModePanel;
    private OtherJdbcDriverEntry _currEntry;
    private static final String BROWSE_CMD = "browse";

    void $init$() {
        this.gridBagLayout1 = new GridBagLayout();
        this.lblDriver = new JLabel();
        this.lblLibrary = new JLabel();
        this.lblClasspath = new JLabel();
        this.fldLibrary = new JTextField();
        this.fldClasspath = new URLPathField();
        this.btnBrowse = new JButton();
        this.pnlClass = new JPanel();
        this.layMode = new BorderLayout();
    }

    public BaseDriverPanel() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void setDriverPanel(DriverClassPanel driverClassPanel) {
        this.pnlClass.add((Component)driverClassPanel, "Center");
        this._currModePanel = driverClassPanel;
    }

    public void setEnabled(boolean bl) {
        this.btnBrowse.setEnabled(bl);
        this.fldLibrary.setEnabled(bl);
        this.fldClasspath.setEnabled(bl);
        if (this._currModePanel != null) {
            this._currModePanel.setEnabled(bl);
        }
        super.setEnabled(bl);
    }

    public void setSelectedDriver(String string) {
        this._currModePanel.setSelectedDriver(string);
    }

    public String getSelectedDriver() {
        return this._currModePanel.getSelectedDriver();
    }

    public Component getDefaultComponent() {
        return this._currModePanel.getDefaultComponent();
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        ResourceUtils.resLabel((JLabel)this.lblDriver, (Component)this.pnlClass, (String)ConnectionArb.getString(381));
        ResourceUtils.resLabel((JLabel)this.lblLibrary, (Component)this.fldLibrary, (String)ConnectionArb.getString(394));
        ResourceUtils.resLabel((JLabel)this.lblClasspath, (Component)this.fldClasspath, (String)ConnectionArb.getString(395));
        this.fldLibrary.setEnabled(false);
        this.fldClasspath.setEnabled(false);
        ResourceUtils.resButton((AbstractButton)this.btnBrowse, (String)ConnectionArb.getString(397));
        this.btnBrowse.addActionListener(this);
        this.pnlClass.setLayout(this.layMode);
        this.btnBrowse.setActionCommand(BROWSE_CMD);
        this.add((Component)this.lblDriver, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 12), 0, 0));
        this.add((Component)this.pnlClass, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.lblLibrary, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 12), 0, 0));
        this.add((Component)this.fldLibrary, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.btnBrowse, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(10, 12, 0, 0), 0, 0));
        this.add((Component)this.fldClasspath, new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.lblClasspath, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 12), 0, 0));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (BROWSE_CMD.equals(actionEvent.getActionCommand())) {
            LibraryList[] libraryListArray = JLibraryManager.getAllLibraryLists();
            ListWrapper[] listWrapperArray = new ListWrapper[libraryListArray.length];
            int n = libraryListArray.length - 1;
            while (n >= 0) {
                listWrapperArray[n] = new ListWrapper(libraryListArray[n]);
                --n;
            }
            LibrariesPanel librariesPanel = new LibrariesPanel();
            Library library = this._currEntry == null ? null : this._currEntry.getDriverLibraryInstance();
            librariesPanel.setSelectionMode(0);
            librariesPanel.initPanel(listWrapperArray, (Object)library);
            1 var7_7 = new 1(this, librariesPanel);
            if (OnePageWizardDialogFactory.runDialog((Component)this, (Component)librariesPanel, (Component)librariesPanel, (String)ConnectionArb.getString(398), (int)7, (VetoableChangeListener)var7_7)) {
                listWrapperArray = librariesPanel.getLibraryLists();
                int n2 = 0;
                while (n2 < listWrapperArray.length) {
                    listWrapperArray[n2].commit(true);
                    ++n2;
                }
                Library[] libraryArray = librariesPanel.getSelection();
                if (libraryArray != null && libraryArray.length == 1) {
                    library = libraryArray[0];
                    if (this._currEntry != null) {
                        this._currEntry.setDriverLibraryInstance(library);
                    }
                    this.fldLibrary.setText(library.getName());
                    this.fldClasspath.setURLPath(library.getClassPath());
                }
            }
        }
    }

    protected void updateSelection(OtherJdbcDriverEntry otherJdbcDriverEntry) {
        if (otherJdbcDriverEntry != null) {
            Library library = otherJdbcDriverEntry.getDriverLibraryInstance();
            this.fldLibrary.setText(library != null ? library.getName() : "");
            this.fldClasspath.setURLPath(library != null ? library.getClassPath() : null);
        } else {
            this.fldLibrary.setText("");
            this.fldClasspath.setURLPath(null);
        }
        this._currEntry = otherJdbcDriverEntry;
    }

    final class 1
    implements VetoableChangeListener {
        private final /* synthetic */ LibrariesPanel v$panel;
        final /* synthetic */ BaseDriverPanel this$0;

        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)propertyChangeEvent) && !this.v$panel.commitChanges()) {
                throw new PropertyVetoException("no", propertyChangeEvent);
            }
        }

        public 1(BaseDriverPanel baseDriverPanel, LibrariesPanel librariesPanel) {
            this.v$panel = librariesPanel;
            this.this$0 = baseDriverPanel;
        }
    }

    protected static abstract class DriverClassPanel
    extends JPanel {
        public abstract String getSelectedDriver();

        public abstract void setSelectedDriver(String var1);

        public abstract Component getDefaultComponent();

        protected DriverClassPanel() {
        }
    }
}

