/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cm.dt.config;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.GlobalSettings;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdevimpl.cm.dt.config.ConnectionOptions;
import oracle.jdevimpl.cm.dt.config.DriverRegistryPanel;
import oracle.jdevimpl.cm.dt.sqlplus.SqlPlusOptionsPanel;

public final class ConnectionOptionsPanel
extends DefaultTraversablePanel {
    private JCheckBox _chkValidateDateTime;
    private JCheckBox _chkDebug;
    private DriverRegistryPanel pnlDrivers;
    private GridBagLayout layMain;
    private JPanel pnlOptions;
    private GridBagLayout layOracleOptions;
    private SqlPlusOptionsPanel pnlPlus;

    void $init$() {
        this._chkValidateDateTime = new JCheckBox();
        this._chkDebug = new JCheckBox();
        this.pnlDrivers = new DriverRegistryPanel();
        this.layMain = new GridBagLayout();
        this.pnlOptions = new JPanel();
        this.layOracleOptions = new GridBagLayout();
        this.pnlPlus = new SqlPlusOptionsPanel();
    }

    public ConnectionOptionsPanel() {
        this.$init$();
        try {
            this.jbInit();
            this.setHelpID("f1_cdbdprefdatabaseconnections_html");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        ConnectionOptions connectionOptions = (ConnectionOptions)((Object)traversableContext.find("ConnectionOptions"));
        this.load(connectionOptions);
        this.pnlDrivers.onEntry(traversableContext);
        this.pnlPlus.onEntry(traversableContext);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        ConnectionOptions connectionOptions = (ConnectionOptions)((Object)traversableContext.find("ConnectionOptions"));
        this.commit(connectionOptions);
        this.pnlDrivers.onExit(traversableContext);
        this.pnlPlus.onExit(traversableContext);
    }

    private void jbInit() throws Exception {
        ResourceUtils.resButton((AbstractButton)this._chkValidateDateTime, (String)ConnectionArb.getString(376));
        ResourceUtils.resButton((AbstractButton)this._chkDebug, (String)ConnectionArb.getString(377));
        this.setLayout(this.layMain);
        this.pnlOptions.setLayout(this.layOracleOptions);
        int n = 0;
        this.pnlOptions.add((Component)this._chkValidateDateTime, new GridBagConstraints(0, n++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.pnlOptions.add((Component)this._chkDebug, new GridBagConstraints(0, n++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.pnlOptions.add((Component)((Object)this.pnlPlus), new GridBagConstraints(0, n++, 1, 1, 1.0, 1.0, 10, 1, new Insets(15, 0, 0, 0), 0, 0));
        this.add(this.pnlOptions, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)((Object)this.pnlDrivers), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(15, 0, 0, 0), 0, 0));
    }

    private void load(ConnectionOptions connectionOptions) {
        this._chkValidateDateTime.setSelected(connectionOptions.isValidateDateTime());
        this._chkDebug.setSelected(connectionOptions.isGeneratePlSqlDebugInfo());
    }

    private void commit(ConnectionOptions connectionOptions) {
        boolean bl = this._chkValidateDateTime.isSelected();
        connectionOptions.setValidateDateTime(bl);
        GlobalSettings.getInstance().setValidateDataTime(bl);
        connectionOptions.setGeneratePlSqlDebugInfo(this._chkDebug.isSelected());
    }
}

