/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cm.dt.config;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.DocumentListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ModelUtil;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdeveloper.library.LibraryList;
import oracle.jdevimpl.cm.dt.config.BaseDriverPanel;
import oracle.jdevimpl.cm.dt.config.ConnectionOptions;
import oracle.jdevimpl.cm.dt.config.OtherJdbcDriverEntry;

public final class DriverEditPanel
extends BaseDriverPanel {
    private OtherJdbcDriverEntry _currentEntry;
    private ConnectionOptions _opts;
    private DocumentListener _updateListener;
    private LibraryList[] _lists;
    private DriverClassEdit _editPanel;

    void $init$() {
        this._editPanel = new DriverClassEdit();
    }

    public DriverEditPanel() {
        this.$init$();
        this.setDriverPanel(this._editPanel);
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_cdbdregisterjdbcdriver_html");
    }

    public void setConnectionOptions(ConnectionOptions connectionOptions) {
        this._opts = connectionOptions;
    }

    public void setDriverEntry(OtherJdbcDriverEntry otherJdbcDriverEntry) throws TraversalException {
        if (otherJdbcDriverEntry != this._currentEntry) {
            if (this._currentEntry != null) {
                String string = this.getSelectedDriver();
                if (!IdeUtil.isPackageIdentifier((String)string)) {
                    throw new TraversalException(ConnectionArb.format(387, string));
                }
                if (ModelUtil.areEqual((Object)"oracle.jdbc.driver.OracleDriver", (Object)string) || ModelUtil.areEqual((Object)"oracle.jdbc.OracleDriver", (Object)string)) {
                    throw new TraversalException(ConnectionArb.getString(391));
                }
                if (ModelUtil.areDifferent((Object)this._currentEntry.getDriverClass(), (Object)string)) {
                    OtherJdbcDriverEntry otherJdbcDriverEntry2;
                    OtherJdbcDriverEntry otherJdbcDriverEntry3 = otherJdbcDriverEntry2 = this._opts != null ? this._opts.findDriverEntry(string) : null;
                    if (otherJdbcDriverEntry2 != null && otherJdbcDriverEntry2 != this._currentEntry) {
                        throw new TraversalException(ConnectionArb.format(390, string));
                    }
                    this._currentEntry.setDriverClass(string);
                }
            }
            this.updateSelection(otherJdbcDriverEntry);
            this._currentEntry = otherJdbcDriverEntry;
        }
        this.setEnabled(otherJdbcDriverEntry != null);
    }

    protected void setUpdateListener(DocumentListener documentListener) {
        this._updateListener = documentListener;
    }

    protected void updateSelection(OtherJdbcDriverEntry otherJdbcDriverEntry) {
        if (this._updateListener != null) {
            DriverClassEdit.mav$removeDocumentListener(this._editPanel, this._updateListener);
        }
        this._editPanel.setSelectedDriver(otherJdbcDriverEntry != null ? otherJdbcDriverEntry.getDriverClass() : "");
        if (this._updateListener != null) {
            DriverClassEdit.mav$addDocumentListener(this._editPanel, this._updateListener);
        }
        super.updateSelection(otherJdbcDriverEntry);
    }

    public static boolean editDriverEntry(Component component, OtherJdbcDriverEntry otherJdbcDriverEntry) {
        OtherJdbcDriverEntry otherJdbcDriverEntry2 = (OtherJdbcDriverEntry)((Object)otherJdbcDriverEntry.copyTo(null));
        ConnectionOptions connectionOptions = (ConnectionOptions)((Object)Ide.getSettings().getData("ConnectionOptions"));
        boolean bl = DriverEditPanel._editEntry(component, connectionOptions, otherJdbcDriverEntry2);
        if (bl) {
            otherJdbcDriverEntry2.copyTo((Object)otherJdbcDriverEntry);
            if (connectionOptions != null && connectionOptions.findDriverEntry(otherJdbcDriverEntry.getDriverClass()) == null) {
                connectionOptions.addDriverEntry(otherJdbcDriverEntry);
                connectionOptions.fireChangeEvent();
            }
        }
        return bl;
    }

    public static OtherJdbcDriverEntry createNewDriverEntry(Component component) {
        ConnectionOptions connectionOptions = (ConnectionOptions)((Object)Ide.getSettings().getData("ConnectionOptions"));
        OtherJdbcDriverEntry otherJdbcDriverEntry = new OtherJdbcDriverEntry();
        otherJdbcDriverEntry.setDriverClass(DriverEditPanel.getUniqueDriverName(connectionOptions));
        if (!DriverEditPanel._editEntry(component, connectionOptions, otherJdbcDriverEntry)) {
            return null;
        }
        if (connectionOptions != null) {
            connectionOptions.addDriverEntry(otherJdbcDriverEntry);
            connectionOptions.fireChangeEvent();
        }
        return otherJdbcDriverEntry;
    }

    private static boolean _editEntry(Component component, ConnectionOptions connectionOptions, OtherJdbcDriverEntry otherJdbcDriverEntry) {
        DriverEditPanel driverEditPanel = new DriverEditPanel();
        try {
            driverEditPanel.setDriverEntry(otherJdbcDriverEntry);
        }
        catch (TraversalException traversalException) {
            traversalException.showMessageDialog(component);
            boolean bl = false;
            return bl;
        }
        driverEditPanel.setConnectionOptions(connectionOptions);
        1 var5_6 = new 1(driverEditPanel);
        return OnePageWizardDialogFactory.runDialog((Component)component, (Component)driverEditPanel, (Component)driverEditPanel.getDefaultComponent(), (String)ConnectionArb.getString(389), (int)7, (VetoableChangeListener)var5_6);
    }

    private static String getUniqueDriverName(ConnectionOptions connectionOptions) {
        String string = "some.jdbc.Driver";
        String string2 = "some.jdbc.Driver";
        if (connectionOptions != null) {
            int n = 1;
            while (connectionOptions.findDriverEntry(string2) != null) {
                string2 = "some.jdbc.Driver" + n++;
            }
        }
        return string2;
    }

    public static final class 1
    implements VetoableChangeListener {
        private final /* synthetic */ DriverEditPanel v$panel;

        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)propertyChangeEvent)) {
                try {
                    this.v$panel.setDriverEntry(null);
                }
                catch (TraversalException traversalException) {
                    traversalException.showMessageDialog((Component)this.v$panel);
                    throw new PropertyVetoException("no", propertyChangeEvent);
                }
            }
        }

        public 1(DriverEditPanel driverEditPanel) {
            this.v$panel = driverEditPanel;
        }
    }

    private static class DriverClassEdit
    extends BaseDriverPanel.DriverClassPanel {
        private JTextField fldDriverName;

        void $init$() {
            this.fldDriverName = new JTextField();
        }

        DriverClassEdit() {
            this.$init$();
            this.setLayout(new BorderLayout());
            this.add((Component)this.fldDriverName, "Center");
        }

        public String getSelectedDriver() {
            return this.fldDriverName.getText();
        }

        public void setSelectedDriver(String string) {
            this.fldDriverName.setText(string);
        }

        public Component getDefaultComponent() {
            return this.fldDriverName;
        }

        public void setEnabled(boolean bl) {
            this.fldDriverName.setEnabled(bl);
            super.setEnabled(bl);
        }

        private void addDocumentListener(DocumentListener documentListener) {
            this.fldDriverName.getDocument().addDocumentListener(documentListener);
        }

        private void removeDocumentListener(DocumentListener documentListener) {
            this.fldDriverName.getDocument().removeDocumentListener(documentListener);
        }

        static void mav$removeDocumentListener(DriverClassEdit driverClassEdit, DocumentListener documentListener) {
            driverClassEdit.removeDocumentListener(documentListener);
        }

        static void mav$addDocumentListener(DriverClassEdit driverClassEdit, DocumentListener documentListener) {
            driverClassEdit.addDocumentListener(documentListener);
        }
    }
}

