/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cm.dt.config;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdevimpl.cm.dt.config.ConnectionOptions;
import oracle.jdevimpl.cm.dt.config.DriverEditPanel;
import oracle.jdevimpl.cm.dt.config.OtherJdbcDriverEntry;

public final class DriverRegistryPanel
extends DefaultTraversablePanel
implements DocumentListener {
    private GridBagLayout layMain;
    private JLabel lblName;
    private JScrollPane scrList;
    private JList lstDrivers;
    private JButton btnNew;
    private JButton btnDelete;
    private DriverEditPanel pnlEdit;
    private ListSelectionModel listSelectionModel1;
    private OtherJdbcDriverEntry _currentEntry;
    private DefaultListModel lstModel;

    void $init$() {
        this.layMain = new GridBagLayout();
        this.lblName = new JLabel();
        this.scrList = new JScrollPane();
        this.lstDrivers = new JList();
        this.btnNew = new JButton();
        this.btnDelete = new JButton();
        this.pnlEdit = new DriverEditPanel();
        this.listSelectionModel1 = new DefaultListSelectionModel();
        this.lstModel = new DefaultListModel();
    }

    public DriverRegistryPanel() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.pnlEdit.setUpdateListener(this);
        this.setLayout(this.layMain);
        ResourceUtils.resLabel((JLabel)this.lblName, (Component)this.lstDrivers, (String)ConnectionArb.getString(378));
        this.lstDrivers.setSelectionMode(0);
        this.lstDrivers.setModel(this.lstModel);
        this.lstDrivers.setSelectionModel(this.listSelectionModel1);
        this.lstDrivers.setVisibleRowCount(4);
        this.scrList.setVerticalScrollBarPolicy(22);
        ResourceUtils.resButton((AbstractButton)this.btnNew, (String)ConnectionArb.getString(379));
        this.btnNew.addActionListener(new 4());
        ResourceUtils.resButton((AbstractButton)this.btnDelete, (String)ConnectionArb.getString(380));
        this.btnDelete.addActionListener(new 3());
        this.btnDelete.setEnabled(false);
        this.listSelectionModel1.addListSelectionListener(new 2());
        this.add(this.lblName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 24), 0, 0));
        this.scrList.getViewport().add((Component)this.lstDrivers, null);
        this.add(this.scrList, new GridBagConstraints(0, 1, 1, 3, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 24), 0, 0));
        this.add(this.pnlEdit, new GridBagConstraints(0, 5, 2, 1, 1.0, 0.0, 10, 1, new Insets(15, 0, 0, 0), 0, 0));
        this.add(this.btnNew, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.btnDelete, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 11, 2, new Insets(5, 0, 0, 0), 0, 0));
    }

    public void onEntry(TraversableContext traversableContext) {
        ConnectionOptions connectionOptions = (ConnectionOptions)((Object)traversableContext.find("ConnectionOptions"));
        this.load(connectionOptions);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        ConnectionOptions connectionOptions = (ConnectionOptions)((Object)traversableContext.find("ConnectionOptions"));
        this.commit(connectionOptions);
    }

    private void load(ConnectionOptions connectionOptions) {
        this.lstModel.removeAllElements();
        this.lstDrivers.setSelectedIndex(-1);
        Iterator iterator = connectionOptions.getDriverRegistry().iterator();
        while (iterator.hasNext()) {
            this.lstModel.addElement(iterator.next());
        }
        if (this.lstModel.size() > 0) {
            this.lstDrivers.setSelectedIndex(0);
        } else {
            this.pnlEdit.setEnabled(false);
        }
    }

    private void commit(ConnectionOptions connectionOptions) throws TraversalException {
        this.pnlEdit.setDriverEntry(null);
        ListModel listModel = this.lstDrivers.getModel();
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < listModel.getSize()) {
            arrayList.add(listModel.getElementAt(n));
            ++n;
        }
        connectionOptions.setDriverRegistry(arrayList);
    }

    void _selectionChanged(ListSelectionEvent listSelectionEvent) {
        OtherJdbcDriverEntry otherJdbcDriverEntry = (OtherJdbcDriverEntry)((Object)this.lstDrivers.getSelectedValue());
        this._updateEntry(otherJdbcDriverEntry);
    }

    private void _updateEntry(OtherJdbcDriverEntry otherJdbcDriverEntry) {
        if (otherJdbcDriverEntry != this._currentEntry) {
            try {
                this.pnlEdit.setDriverEntry(otherJdbcDriverEntry);
            }
            catch (TraversalException traversalException) {
                OtherJdbcDriverEntry otherJdbcDriverEntry2 = this._currentEntry;
                SwingUtilities.invokeLater(new 1(this, otherJdbcDriverEntry2));
                return;
            }
            this._currentEntry = otherJdbcDriverEntry;
        }
        this.btnDelete.setEnabled(this._currentEntry != null);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateDriverList(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateDriverList(documentEvent);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateDriverList(documentEvent);
    }

    private void updateDriverList(DocumentEvent documentEvent) {
        int n = this.lstDrivers.getSelectedIndex();
        OtherJdbcDriverEntry otherJdbcDriverEntry = (OtherJdbcDriverEntry)((Object)this.lstDrivers.getSelectedValue());
        String string = this._getDocumentText(documentEvent.getDocument());
        if (n >= 0) {
            otherJdbcDriverEntry.setDriverClass(string);
            this.lstModel.setElementAt(otherJdbcDriverEntry, n);
        }
    }

    private String _getDocumentText(Document document) {
        String string;
        try {
            string = document.getText(0, document.getLength());
        }
        catch (BadLocationException badLocationException) {
            string = null;
        }
        return string;
    }

    static DriverEditPanel ra$pnlEdit(DriverRegistryPanel driverRegistryPanel) {
        return driverRegistryPanel.pnlEdit;
    }

    static DefaultListModel ra$lstModel(DriverRegistryPanel driverRegistryPanel) {
        return driverRegistryPanel.lstModel;
    }

    static JList ra$lstDrivers(DriverRegistryPanel driverRegistryPanel) {
        return driverRegistryPanel.lstDrivers;
    }

    static void mav$_updateEntry(DriverRegistryPanel driverRegistryPanel, OtherJdbcDriverEntry otherJdbcDriverEntry) {
        driverRegistryPanel._updateEntry(otherJdbcDriverEntry);
    }

    public final class 4
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                OtherJdbcDriverEntry otherJdbcDriverEntry = new OtherJdbcDriverEntry();
                otherJdbcDriverEntry.setDriverClass("some.jdbc.Driver");
                DriverRegistryPanel.ra$pnlEdit(DriverRegistryPanel.this).setDriverEntry(otherJdbcDriverEntry);
                DriverRegistryPanel.ra$lstModel(DriverRegistryPanel.this).addElement(otherJdbcDriverEntry);
                DriverRegistryPanel.ra$lstDrivers(DriverRegistryPanel.this).setSelectedValue((Object)otherJdbcDriverEntry, true);
            }
            catch (TraversalException traversalException) {
                traversalException.showMessageDialog((Component)((Object)DriverRegistryPanel.this));
            }
        }
    }

    public final class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            int n = DriverRegistryPanel.ra$lstDrivers(DriverRegistryPanel.this).getSelectedIndex();
            if (n >= 0) {
                DriverRegistryPanel.ra$lstModel(DriverRegistryPanel.this).removeElementAt(n);
                if (n >= DriverRegistryPanel.ra$lstModel(DriverRegistryPanel.this).size()) {
                    --n;
                }
                DriverRegistryPanel.ra$lstDrivers(DriverRegistryPanel.this).setSelectedIndex(n);
                if (n == -1) {
                    DriverRegistryPanel.mav$_updateEntry(DriverRegistryPanel.this, null);
                }
            }
        }
    }

    public final class 2
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            DriverRegistryPanel.this._selectionChanged(listSelectionEvent);
        }
    }

    public final class 1
    implements Runnable {
        private final /* synthetic */ OtherJdbcDriverEntry v$resetEntry;
        final /* synthetic */ DriverRegistryPanel this$0;

        public void run() {
            DriverRegistryPanel.ra$lstDrivers(this.this$0).setSelectedValue((Object)this.v$resetEntry, true);
        }

        public 1(DriverRegistryPanel driverRegistryPanel, OtherJdbcDriverEntry otherJdbcDriverEntry) {
            this.v$resetEntry = otherJdbcDriverEntry;
            this.this$0 = driverRegistryPanel;
        }
    }
}

