/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cm.dt.config;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import oracle.ide.Ide;
import oracle.ide.config.IdeSettings;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdevimpl.cm.dt.config.BaseDriverPanel;
import oracle.jdevimpl.cm.dt.config.ConnectionOptions;
import oracle.jdevimpl.cm.dt.config.DriverEditPanel;
import oracle.jdevimpl.cm.dt.config.OtherJdbcDriverEntry;

public class DriverSelectionPanel
extends BaseDriverPanel {
    private static final String NEW_CMD = "new";
    private static final String EDIT_CMD = "edit";

    public DriverSelectionPanel() {
        this.setDriverPanel(new DriverClassSelect(null));
    }

    private final class DriverClassSelect
    extends BaseDriverPanel.DriverClassPanel
    implements ActionListener,
    ItemListener {
        private NonNullableComboBoxModel mdlDriver;
        private JComboBox cmbDriver;
        private JButton btnNew;
        private JButton btnEdit;

        void $init$() {
            this.mdlDriver = new NonNullableComboBoxModel();
            this.cmbDriver = new JComboBox();
            this.btnNew = new JButton();
            this.btnEdit = new JButton();
        }

        private DriverClassSelect() {
            this.$init$();
            IdeSettings ideSettings = Ide.getSettings();
            ConnectionOptions connectionOptions = (ConnectionOptions)((Object)ideSettings.getData("ConnectionOptions"));
            if (connectionOptions != null) {
                List list = connectionOptions.getDriverRegistry();
                for (OtherJdbcDriverEntry otherJdbcDriverEntry : list) {
                    this.mdlDriver.addElement((Object)otherJdbcDriverEntry);
                }
            }
            this.setLayout(new GridBagLayout());
            this.cmbDriver.setModel(this.mdlDriver);
            this.cmbDriver.addItemListener(this);
            ResourceUtils.resButton((AbstractButton)this.btnNew, (String)ConnectionArb.getString(392));
            this.btnNew.addActionListener(this);
            ResourceUtils.resButton((AbstractButton)this.btnEdit, (String)ConnectionArb.getString(393));
            this.btnEdit.addActionListener(this);
            this.cmbDriver.setModel(this.mdlDriver);
            this.btnNew.setActionCommand(DriverSelectionPanel.NEW_CMD);
            this.btnEdit.setActionCommand(DriverSelectionPanel.EDIT_CMD);
            this.add((Component)this.cmbDriver, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.btnNew, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 12, 0, 0), 0, 0));
            this.add((Component)this.btnEdit, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 12, 0, 0), 0, 0));
        }

        public void setSelectedDriver(String string) {
            OtherJdbcDriverEntry otherJdbcDriverEntry = null;
            int n = this.mdlDriver.getSize() - 1;
            while (n >= 0) {
                OtherJdbcDriverEntry otherJdbcDriverEntry2 = (OtherJdbcDriverEntry)((Object)this.mdlDriver.getElementAt(n));
                if (ModelUtil.areEqual((Object)string, (Object)otherJdbcDriverEntry2.getDriverClass())) {
                    otherJdbcDriverEntry = otherJdbcDriverEntry2;
                    break;
                }
                --n;
            }
            if (otherJdbcDriverEntry == null) {
                otherJdbcDriverEntry = new OtherJdbcDriverEntry();
                otherJdbcDriverEntry.setDriverClass(string);
                this.mdlDriver.addElement((Object)otherJdbcDriverEntry);
            }
            this.mdlDriver.setSelectedItem((Object)otherJdbcDriverEntry);
            DriverSelectionPanel.this.updateSelection(otherJdbcDriverEntry);
        }

        public String getSelectedDriver() {
            OtherJdbcDriverEntry otherJdbcDriverEntry = (OtherJdbcDriverEntry)((Object)this.mdlDriver.getSelectedItem());
            return otherJdbcDriverEntry != null ? otherJdbcDriverEntry.getDriverClass() : null;
        }

        public Component getDefaultComponent() {
            return this.cmbDriver;
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            DriverSelectionPanel.this.updateSelection((OtherJdbcDriverEntry)((Object)this.mdlDriver.getSelectedItem()));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            OtherJdbcDriverEntry otherJdbcDriverEntry;
            String string = actionEvent.getActionCommand();
            if (DriverSelectionPanel.NEW_CMD.equals(string)) {
                OtherJdbcDriverEntry otherJdbcDriverEntry2 = DriverEditPanel.createNewDriverEntry(this);
                if (otherJdbcDriverEntry2 != null) {
                    this.mdlDriver.addElement((Object)otherJdbcDriverEntry2);
                    this.mdlDriver.setSelectedItem((Object)otherJdbcDriverEntry2);
                }
            } else if (DriverSelectionPanel.EDIT_CMD.equals(string) && (otherJdbcDriverEntry = (OtherJdbcDriverEntry)((Object)this.mdlDriver.getSelectedItem())) != null && DriverEditPanel.editDriverEntry(this, otherJdbcDriverEntry)) {
                DriverSelectionPanel.this.updateSelection(otherJdbcDriverEntry);
            }
        }

        public void setEnabled(boolean bl) {
            this.cmbDriver.setEnabled(bl);
            this.btnNew.setEnabled(bl);
            this.btnEdit.setEnabled(bl);
            super.setEnabled(bl);
        }

        DriverClassSelect(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

