/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cm.dt.explorer;

import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import oracle.ide.model.Node;
import oracle.ide.util.FastStringBuffer;
import oracle.ide.util.ModelUtil;
import oracle.jdeveloper.cm.CMException;
import oracle.jdeveloper.cm.CMUtils;
import oracle.jdeveloper.cm.ConnectionDescriptor;
import oracle.jdeveloper.cm.ConnectionManager;
import oracle.jdeveloper.cm.ConnectionType;
import oracle.jdeveloper.cm.IasRemoteDcmConnectionType;
import oracle.jdeveloper.cm.JbossConnectionType;
import oracle.jdeveloper.cm.TomcatConnectionType;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdeveloper.cm.dt.ConnectionNode;
import oracle.jdevimpl.cm.dt.explorer.BaseCMExplorer;
import oracle.jdevimpl.cm.dt.explorer.ConnectionExplorerCellRenderer;

public final class ConnectionExplorer
extends BaseCMExplorer {
    protected boolean isValidNode(Node node) {
        return node instanceof ConnectionNode;
    }

    protected DefaultMutableTreeNode buildTree() {
        ConnectionDescriptor connectionDescriptor;
        Node node = this.getNode();
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(node);
        ConnectionDescriptor connectionDescriptor2 = connectionDescriptor = node instanceof ConnectionNode ? ((ConnectionNode)node).getConnectionDescriptor() : null;
        if (connectionDescriptor != null) {
            String string;
            ConnectionManager connectionManager = ConnectionManager.getInstance();
            ConnectionType connectionType = connectionManager.getConnectionType(connectionDescriptor.getConnectionType());
            String string2 = connectionType != null ? connectionType.getName() : "";
            ConnectionExplorer.addNode(defaultMutableTreeNode, ConnectionArb.format(475, string2));
            String string3 = connectionType.getConnectionClassName();
            if (string3 != null && string3.equals("CLASS_DATABASE")) {
                string2 = connectionDescriptor.getJdbcDriver();
                string = ConnectionArb.format(476, string2);
                ConnectionExplorer.addNode(defaultMutableTreeNode, string);
            }
            if (connectionType != null) {
                Class<?> clazz = connectionType.getClass();
                if (JbossConnectionType.class.isAssignableFrom(clazz)) {
                    String string4 = connectionDescriptor.getProperty("JBoss_deploy_dir");
                    ConnectionExplorer.addNode(defaultMutableTreeNode, ConnectionArb.format(481, string4));
                    return defaultMutableTreeNode;
                }
                if (TomcatConnectionType.class.isAssignableFrom(clazz)) {
                    String string5 = connectionDescriptor.getProperty("Tomcat_webapps_dir");
                    ConnectionExplorer.addNode(defaultMutableTreeNode, ConnectionArb.format(480, string5));
                    return defaultMutableTreeNode;
                }
            }
            string2 = connectionDescriptor.getUsername();
            string = ConnectionArb.format(477, string2);
            ConnectionExplorer.addNode(defaultMutableTreeNode, string);
            if (connectionType != null && !IasRemoteDcmConnectionType.class.isAssignableFrom(connectionType.getClass())) {
                if ("J2EE_1.4".equals(connectionType.getTypeName())) {
                    ConnectionExplorer.addNode(defaultMutableTreeNode, ConnectionArb.format(483, this.formatJMXURL(connectionDescriptor)));
                    String string6 = connectionDescriptor.getProperty("JSR88_DEPLOYMENT_URL");
                    if (ModelUtil.hasLength((String)string6)) {
                        ConnectionExplorer.addNode(defaultMutableTreeNode, ConnectionArb.format(482, string6));
                    }
                } else {
                    try {
                        string2 = CMUtils.getUrl((String)"JDBC", (ConnectionDescriptor)connectionDescriptor);
                    }
                    catch (CMException cMException) {
                        string2 = ConnectionArb.getString(474);
                    }
                    ConnectionExplorer.addNode(defaultMutableTreeNode, ConnectionArb.format(478, string2));
                }
            }
        }
        return defaultMutableTreeNode;
    }

    protected TreeCellRenderer getCellRenderer() {
        return new ConnectionExplorerCellRenderer();
    }

    protected String getAccessibleName() {
        Node node = this.getNode();
        return node != null ? ConnectionArb.format(479, node.getShortLabel()) : null;
    }

    private String formatJMXURL(ConnectionDescriptor connectionDescriptor) {
        String string = connectionDescriptor.getProperty("JMX_CONNECTOR_HOST");
        String string2 = connectionDescriptor.getProperty("JMX_CONNECTOR_PORT");
        String string3 = connectionDescriptor.getProperty("JMX_CONNECTOR_PATH");
        if (!ModelUtil.hasLength((String)string) && ModelUtil.hasLength((String)string2)) {
            return ConnectionArb.getString(474);
        }
        FastStringBuffer fastStringBuffer = new FastStringBuffer();
        fastStringBuffer.append("service:jmx:rmi").append("://");
        if (ModelUtil.hasLength((String)string)) {
            fastStringBuffer.append(string);
            if (ModelUtil.hasLength((String)string2)) {
                fastStringBuffer.append(":").append(string2);
            }
        }
        if (ModelUtil.hasLength((String)string3)) {
            fastStringBuffer.append(string3);
        }
        return fastStringBuffer.toString();
    }

    private static void addNode(DefaultMutableTreeNode defaultMutableTreeNode, String string) {
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(string));
    }
}

