/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cm.dt.explorer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.model.UpdateMessage;
import oracle.jdevimpl.cm.dt.explorer.BaseElement;
import oracle.jdevimpl.cm.dt.explorer.MarkAndSweeper;
import oracle.jdevimpl.cm.dt.explorer.Markable;

public class FolderElement
extends BaseElement {
    protected MarkAndSweeper children;
    protected boolean quiet;

    public final boolean getQuiet() {
        return this.quiet;
    }

    public final void setQuiet(boolean bl) {
        this.quiet = bl;
    }

    public final void addChild(int n, BaseElement baseElement) {
        baseElement.mark(n);
        this.children.add(baseElement);
        if (!this.quiet) {
            this.fireAddUpdate((Object)this, baseElement);
        }
    }

    public final BaseElement findChild(String string) {
        return (BaseElement)this.children.get(string);
    }

    public final void removeChildren(BaseElement baseElement) {
        Markable markable = this.children.remove(baseElement.getLongLabel());
        if (markable != null && !this.quiet) {
            this.fireRemoveUpdate((Object)this, baseElement);
        }
    }

    public final void removeAllChildren() {
        this.children.removeAll();
        if (!this.quiet) {
            this.fireBigChangeUpdate(this);
        }
    }

    public final void clearAllMarks() {
        this.children.clearMarks();
    }

    public boolean sweep() {
        ArrayList arrayList = this.children.sweep();
        if (arrayList != null && !this.quiet) {
            this.fireRemoveUpdate((Object)this, arrayList);
        }
        return arrayList != null;
    }

    public final void fireAddUpdate(Object object, BaseElement baseElement) {
        UpdateMessage updateMessage = new UpdateMessage(UpdateMessage.CHILD_ADDED, object);
        List list = updateMessage.getAddObjects();
        list.add(baseElement);
        this.notifyObservers(this, updateMessage);
    }

    public final void fireAddUpdate(Object object, Collection collection) {
        UpdateMessage updateMessage = new UpdateMessage(UpdateMessage.CHILD_ADDED, object);
        List list = updateMessage.getAddObjects();
        list.addAll(collection);
        this.notifyObservers(this, updateMessage);
    }

    public final void fireRemoveUpdate(Object object, BaseElement baseElement) {
        UpdateMessage updateMessage = new UpdateMessage(UpdateMessage.CHILD_REMOVED, object);
        List list = updateMessage.getRemoveObjects();
        list.add(baseElement);
        this.notifyObservers(this, updateMessage);
    }

    public final void fireRemoveUpdate(Object object, Collection collection) {
        UpdateMessage updateMessage = new UpdateMessage(UpdateMessage.CHILD_REMOVED, object);
        List list = updateMessage.getRemoveObjects();
        list.addAll(collection);
        this.notifyObservers(this, updateMessage);
    }

    public final void fireBigChangeUpdate(Object object) {
        UpdateMessage updateMessage = new UpdateMessage(UpdateMessage.STRUCTURE_CHANGED, object);
        this.notifyObservers(this, updateMessage);
    }

    void $init$() {
        this.children = new MarkAndSweeper();
        this.quiet = false;
    }

    public FolderElement(String string, Icon icon, Context context) {
        super(string, icon, context, -1, -1);
        this.$init$();
    }

    public final boolean mayHaveChildren() {
        return true;
    }

    public final Iterator getChildren() {
        return this.children.iterator();
    }
}

