/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cm.dt.explorer;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.accessibility.Accessible;
import javax.swing.JMenuItem;
import javax.swing.tree.TreePath;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.explorer.TNode;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Observer;
import oracle.ide.model.UpdateMessage;
import oracle.ide.util.AccessibleUtils;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.view.View;
import oracle.ideimpl.explorer.BaseTreeExplorer;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdevimpl.cm.dt.explorer.BaseElement;
import oracle.jdevimpl.cm.dt.explorer.PlSqlSrcStructureBuilder;
import oracle.jdevimpl.java.JavaArb;

public final class PlSqlExplorer
extends BaseTreeExplorer
implements Observer,
Controller,
ContextMenuListener {
    private Node node;
    private PlSqlSrcStructureBuilder builder;
    private boolean observing;
    private List expandedPaths;
    private boolean expandTopLevelClasses;
    private static IdeAction gotoSourceAction;
    private static JMenuItem gotoSourceMenuItem;

    void $init$() {
        this.expandedPaths = new ArrayList();
    }

    public PlSqlExplorer() {
        this.$init$();
    }

    private static synchronized void initActions() {
        String string = JavaArb.getString((int)219);
        gotoSourceAction = IdeAction.get((int)Ide.findOrCreateCmdID((String)"cm.dt.GotoSource"), null, (String)string, (String)IdeMainWindow.ACTION_CATEGORY_SEARCH, null, (ArrayResourceBundle)JavaArb.getInstance(), (int)220, null, (boolean)false);
        gotoSourceMenuItem = Ide.getMenubar().createMenuItem((ToggleAction)gotoSourceAction);
    }

    public void setContext(Context context) {
        Node node;
        super.setContext(context);
        if (context != null && (node = this.getContext().getNode()) != null) {
            String string = node.getShortLabel();
            String string2 = ConnectionArb.format(506, string);
            if (this.tree != null) {
                AccessibleUtils.updateAccessibleName((Accessible)this.tree, (String)string2, (boolean)true);
            }
        }
    }

    public synchronized Element annotate(Context context) {
        Node node = context.getNode();
        if (node != this.node) {
            this.stopObserving();
            this.node = node;
            this.expandTopLevelClasses = true;
            try {
                this.builder = PlSqlSrcStructureBuilder.createInstance(context);
            }
            catch (Exception exception) {
                this.node = null;
                this.builder = null;
            }
        }
        return this.builder != null ? this.builder.getRootElement() : null;
    }

    public void stateChanged(int n) {
        View view = this.owner();
        ContextMenu contextMenu = view != null ? view.getContextMenu() : null;
        switch (n) {
            case 0: {
                if (!this.isObserving() && this.builder != null) {
                    this.startObserving();
                    this.rebuildTree();
                }
                if (contextMenu == null) break;
                contextMenu.addContextMenuListener((ContextMenuListener)this);
                break;
            }
            case 1: {
                if (contextMenu == null) break;
                contextMenu.removeContextMenuListener((ContextMenuListener)this);
                break;
            }
            case 2: {
                if (contextMenu != null) {
                    contextMenu.removeContextMenuListener((ContextMenuListener)this);
                }
                this.stopObserving();
            }
        }
    }

    private boolean isObserving() {
        return this.observing;
    }

    private void startObserving() {
        if (!this.observing && this.node != null) {
            this.node.attach((Observer)this);
            this.observing = true;
        }
    }

    private void stopObserving() {
        if (this.observing && this.node != null) {
            this.node.detach((Observer)this);
            this.observing = false;
        }
    }

    public void update(Object object, UpdateMessage updateMessage) {
        int n;
        if (this.isObserving() && this.node != null && this.builder != null && object == this.node && (n = updateMessage.getMessageID()) != UpdateMessage.CHILD_REMOVED && n != UpdateMessage.CHILD_ADDED && n != UpdateMessage.PROPERTY_SET && n != UpdateMessage.OBJECT_RENAMED && n != UpdateMessage.CHILD_RENAMED && n != UpdateMessage.OBJECT_OPENED && n != UpdateMessage.OBJECT_CLOSED && n != UpdateMessage.ATTRIBUTE_CHANGED && n != UpdateMessage.OBJECT_CLOSING) {
            this.rebuildTree();
        }
    }

    private void rebuildTree() {
        this.saveExpansion();
        this.builder.updateTree();
        this.setRoot(this.builder.getRootElement());
        this.restoreExpansion();
        if (this.expandTopLevelClasses) {
            this.expandTopLevelClasses = false;
            Element[] elementArray = this.builder.getTopLevelElements();
            int n = elementArray.length;
            int n2 = 0;
            while (n2 < n) {
                Element element = elementArray[n2];
                TNode tNode = this.findTNode(element, null);
                if (tNode != null && !tNode.isLeaf()) {
                    TreePath treePath = new TreePath(tNode.getPath());
                    this.tree.expandPath(treePath);
                }
                ++n2;
            }
        }
    }

    private void saveExpansion() {
        try {
            Enumeration enumeration = this.tree.getExpandedDescendants(new TreePath(((TNode)this.tree.getModel().getRoot()).getPath()));
            while (enumeration.hasMoreElements()) {
                this.expandedPaths.add(PlSqlExplorer.convertTreePathToString((TreePath)enumeration.nextElement()));
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private static String convertTreePathToString(TreePath treePath) {
        String string = "";
        Object[] objectArray = treePath.getPath();
        int n = 0;
        while (n < objectArray.length) {
            string = string + objectArray[n].toString() + ",";
            ++n;
        }
        return string;
    }

    private void restoreExpansion() {
        TNode tNode = (TNode)this.tree.getModel().getRoot();
        String[] stringArray = this.expandedPaths.toArray(new String[this.expandedPaths.size()]);
        Enumeration enumeration = tNode.breadthFirstEnumeration();
        block0: while (enumeration.hasMoreElements()) {
            TNode tNode2 = (TNode)enumeration.nextElement();
            TreePath treePath = new TreePath(tNode2.getPath());
            String string = PlSqlExplorer.convertTreePathToString(treePath);
            int n = 0;
            while (n < stringArray.length) {
                if (string.equals(stringArray[n])) {
                    this.tree.expandPath(treePath);
                    continue block0;
                }
                ++n;
            }
        }
        this.expandedPaths.clear();
    }

    public void menuWillShow(ContextMenu contextMenu) {
        BaseElement baseElement;
        Context context = contextMenu.getContext();
        if (context == null) {
            return;
        }
        Element[] elementArray = context.getSelection();
        if (elementArray == null || elementArray.length != 1) {
            return;
        }
        Element element = elementArray[0];
        if (element instanceof BaseElement && (baseElement = (BaseElement)element).getStartOffset() != -1) {
            if (gotoSourceAction == null) {
                PlSqlExplorer.initActions();
            }
            gotoSourceAction.addController((Controller)this);
            gotoSourceAction.setEnabled(true);
            contextMenu.add((Component)gotoSourceMenuItem, JDeveloperMenuConstants.SECTION_NAVIGATE_CTXT_MENU);
        }
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        Element element;
        if (context != null && context.getView() == this.owner() && (element = context.getElement()) instanceof BaseElement) {
            return ((BaseElement)element).handleDoubleClick();
        }
        return false;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        if (ideAction == gotoSourceAction) {
            Element element = context.getElement();
            if (element instanceof BaseElement) {
                BaseElement baseElement = (BaseElement)element;
                baseElement.handleDoubleClick();
            }
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        return ideAction == gotoSourceAction;
    }
}

