/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cm.dt.explorer;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.TextNode;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.ModelArb;
import oracle.ide.util.FastStringBuffer;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.parser.Lexer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.plsql.PlsqlParser;
import oracle.javatools.parser.plsql.data.PlsqlAdt;
import oracle.javatools.parser.plsql.data.PlsqlAdtBody;
import oracle.javatools.parser.plsql.data.PlsqlBlock;
import oracle.javatools.parser.plsql.data.PlsqlError;
import oracle.javatools.parser.plsql.data.PlsqlName;
import oracle.javatools.parser.plsql.data.PlsqlNode;
import oracle.javatools.parser.plsql.data.PlsqlPkg;
import oracle.javatools.parser.plsql.data.PlsqlRoot;
import oracle.javatools.parser.plsql.data.PlsqlSubprg;
import oracle.javatools.parser.plsql.data.PlsqlType;
import oracle.javatools.parser.plsql.data.PlsqlTypedef;
import oracle.javatools.parser.plsql.data.PlsqlVariable;
import oracle.jdeveloper.icons.JavaIcons;
import oracle.jdeveloper.profiler.ProfilerAPI;
import oracle.jdevimpl.cm.dt.explorer.BaseElement;
import oracle.jdevimpl.cm.dt.explorer.FolderElement;
import oracle.jdevimpl.cm.dt.explorer.PlSqlFunctionElement;
import oracle.jdevimpl.cm.dt.explorer.PlSqlRootElement;
import oracle.jdevimpl.java.JavaArb;

public final class PlSqlSrcStructureBuilder {
    private Context context;
    private PlSqlRootElement rootElement;
    private PlsqlRoot _root;
    private int _offset;
    private static Icon errorIcon = null;
    private static Icon errorFolderIcon = null;
    private static Icon fileIcon = null;
    private static Icon packageIcon = null;
    private static Icon varIcon = null;
    private static Icon typeIcon = null;
    private static Icon methodIcon = null;
    private static final int PROF_UPDATE = 2000;
    private static final int PROF_PARSE = 2001;
    private static final boolean PROF_UPDATE_ENABLED = ProfilerAPI.isActive && ProfilerAPI.isEventActive((int)2000);
    private static final boolean PROF_PARSE_ENABLED = ProfilerAPI.isActive && ProfilerAPI.isEventActive((int)2001);

    public static PlSqlSrcStructureBuilder createInstance(Context context) {
        PlSqlSrcStructureBuilder plSqlSrcStructureBuilder = new PlSqlSrcStructureBuilder(context);
        return plSqlSrcStructureBuilder;
    }

    private PlsqlRoot parse(TextBuffer textBuffer) {
        block7: {
            this._offset = PlSqlSrcStructureBuilder.findInitialOffset(textBuffer);
            textBuffer.readLock();
            try {
                if (this._offset > 0) {
                    ReadTextBuffer readTextBuffer = TextBufferFactory.createReadTextBuffer((String)textBuffer.getString(this._offset, textBuffer.getLength() - this._offset));
                    readTextBuffer.readLock();
                    try {
                        this._root = PlsqlParser.parsePlsql((ReadTextBuffer)readTextBuffer);
                        break block7;
                    }
                    finally {
                        readTextBuffer.readUnlock();
                    }
                }
                this._root = PlsqlParser.parsePlsql((ReadTextBuffer)textBuffer);
            }
            finally {
                textBuffer.readUnlock();
            }
        }
        return this._root;
    }

    private static int findInitialOffset(TextBuffer textBuffer) {
        int n = 0;
        textBuffer.readLock();
        try {
            int n2;
            Lexer lexer = PlsqlParser.createSqlLexer();
            lexer.setTextBuffer((ReadTextBuffer)textBuffer);
            LexerToken lexerToken = lexer.createLexerToken();
            block7: while (true) {
                int n3 = lexer.lex(lexerToken);
                n2 = lexerToken.getStartOffset();
                int n4 = lexerToken.getEndOffset();
                switch (n3) {
                    case 801: 
                    case 1058: 
                    case 1094: {
                        continue block7;
                    }
                    case 48: 
                    case 49: {
                        continue block7;
                    }
                }
                break;
            }
            n = n2;
        }
        finally {
            textBuffer.readUnlock();
        }
        return n;
    }

    private void createRootElement() {
        Node node = this.context.getNode();
        String string = URLFileSystem.getFileName((URL)node.getURL());
        this.rootElement = new PlSqlRootElement(string, this.context);
    }

    void $init$() {
        this._offset = 0;
    }

    private PlSqlSrcStructureBuilder(Context context) {
        this.$init$();
        this.context = context;
        this.createRootElement();
    }

    public Element getRootElement() {
        return this.rootElement;
    }

    public Element[] getTopLevelElements() {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        Iterator iterator = this.rootElement.getChildren();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            if (!(element instanceof PlSqlRootElement.TopLevelFolderElement)) continue;
            arrayList.add(element);
        }
        int n = arrayList.size();
        Element[] elementArray = arrayList.toArray(new Element[n]);
        return elementArray;
    }

    public void updateTree() {
        Node node = this.context.getNode();
        TextNode textNode = (TextNode)node;
        TextBuffer textBuffer = textNode.acquireTextBuffer();
        int n = -1;
        if (PROF_UPDATE_ENABLED) {
            n = ProfilerAPI.startEvent((int)2000, (String)"Updating explorer tree");
        }
        try {
            try {
                int n2 = -1;
                if (PROF_PARSE_ENABLED) {
                    n2 = ProfilerAPI.startEvent((int)2001, (String)"Parsing buffer");
                }
                PlsqlRoot plsqlRoot = this.parse(textBuffer);
                if (PROF_PARSE_ENABLED) {
                    ProfilerAPI.endEvent((int)n2);
                }
                if (plsqlRoot != null) {
                    boolean bl = this.rootElement.getQuiet();
                    this.rootElement.setQuiet(false);
                    this.build(plsqlRoot);
                    this.rootElement.setQuiet(bl);
                }
            }
            catch (Exception exception) {
                System.err.println("Exception thrown while building structure");
                exception.printStackTrace();
            }
        }
        finally {
            if (PROF_UPDATE_ENABLED) {
                ProfilerAPI.endEvent((int)n);
            }
            if (textNode != null) {
                textNode.releaseTextBuffer();
            }
        }
    }

    private void build(PlsqlRoot plsqlRoot) {
        PlsqlError[] plsqlErrorArray = plsqlRoot.getErrors();
        if (plsqlErrorArray.length != 0) {
            FolderElement folderElement = this.rootElement.getErrorsFolder();
            folderElement.removeAllChildren();
            this.fillInErrors(plsqlErrorArray, folderElement);
            return;
        }
        this.createRootElement();
        PlsqlNode[] plsqlNodeArray = plsqlRoot.getUnits();
        int n = 0;
        while (n < plsqlNodeArray.length) {
            PlsqlNode plsqlNode = plsqlNodeArray[n];
            switch (plsqlNode.getTreeKind()) {
                case 18: {
                    PlsqlPkg plsqlPkg = (PlsqlPkg)plsqlNode;
                    FolderElement folderElement = this.rootElement.getFolder(plsqlPkg.getName().toString(), n);
                    this.fillInPackage(plsqlPkg, folderElement);
                    break;
                }
                case 19: {
                    PlsqlAdt plsqlAdt = (PlsqlAdt)plsqlNode;
                    FolderElement folderElement = this.rootElement.getFolder(plsqlAdt.getName().toString(), n);
                    this.fillInADT(plsqlAdt, folderElement);
                    break;
                }
                case 22: {
                    PlsqlAdtBody plsqlAdtBody = (PlsqlAdtBody)plsqlNode;
                    FolderElement folderElement = this.rootElement.getFolder(plsqlAdtBody.getName().toString(), n);
                    this.fillInADTBody(plsqlAdtBody, folderElement);
                    break;
                }
                case 17: {
                    PlsqlSubprg plsqlSubprg = (PlsqlSubprg)plsqlNode;
                    FolderElement folderElement = this.rootElement.getFolder(plsqlSubprg.getName().toString(), n);
                    PlSqlFunctionElement plSqlFunctionElement = PlSqlFunctionElement.createElement(plsqlSubprg, this.context);
                    this.fillInFunction(plsqlSubprg, plSqlFunctionElement);
                    folderElement.addChild(0, plSqlFunctionElement);
                    break;
                }
            }
            ++n;
        }
    }

    private BaseElement createLeafElement(PlsqlNode plsqlNode, String string, String string2, Icon icon) {
        return new BaseElement(string, string2, icon, this.context, plsqlNode.getStartOffset() + this._offset, -1);
    }

    private BaseElement createLeafElement(PlsqlName plsqlName, String string, Icon icon) {
        return this.createLeafElement((PlsqlNode)plsqlName, plsqlName.toString(), string, icon);
    }

    private void fillInErrors(PlsqlError[] plsqlErrorArray, FolderElement folderElement) {
        boolean bl = folderElement.getQuiet();
        folderElement.setQuiet(true);
        folderElement.removeAllChildren();
        int n = 0;
        while (n < plsqlErrorArray.length) {
            PlsqlError plsqlError = plsqlErrorArray[n];
            if (plsqlError != null) {
                folderElement.addChild(n, this.createLeafElement((PlsqlNode)plsqlError, plsqlError.getErrorMessage(), "Error: ", PlSqlSrcStructureBuilder.getErrorIcon()));
            }
            ++n;
        }
        folderElement.setQuiet(bl);
    }

    private static String generateFunctionTooltip(PlsqlSubprg plsqlSubprg) {
        PlsqlType plsqlType = plsqlSubprg.getReturnType();
        String string = PlSqlFunctionElement.getFunctionLabel(plsqlSubprg);
        FastStringBuffer fastStringBuffer = new FastStringBuffer();
        if (plsqlType == null) {
            fastStringBuffer.append("Procedure: ");
            fastStringBuffer.append(string);
        } else {
            fastStringBuffer.append("Function: ");
            fastStringBuffer.append(string);
            fastStringBuffer.append(" : ");
            fastStringBuffer.append((Object)plsqlType.getTypeName());
        }
        return fastStringBuffer.toString();
    }

    private BaseElement createVariable(PlsqlVariable plsqlVariable) {
        BaseElement baseElement = this.createLeafElement(plsqlVariable.getName(), "Variable: ", PlSqlSrcStructureBuilder.getVariableIcon());
        return baseElement;
    }

    private BaseElement createTypeDef(PlsqlTypedef plsqlTypedef) {
        BaseElement baseElement = this.createLeafElement(plsqlTypedef.getName(), "Type: ", PlSqlSrcStructureBuilder.getTypeIcon());
        return baseElement;
    }

    private void fillInPackage(PlsqlPkg plsqlPkg, FolderElement folderElement) {
        folderElement.clearAllMarks();
        folderElement.setTooltip("Package: " + folderElement.getShortLabel());
        this.fillInCodeBlock((PlsqlBlock)plsqlPkg, folderElement);
        folderElement.sweep();
    }

    private void fillInADT(PlsqlAdt plsqlAdt, FolderElement folderElement) {
        folderElement.clearAllMarks();
        folderElement.setTooltip("Type: " + folderElement.getShortLabel());
        PlsqlNode[] plsqlNodeArray = plsqlAdt.getComponents();
        this.fillInDeclarations(plsqlNodeArray, folderElement);
        folderElement.sweep();
    }

    private void fillInADTBody(PlsqlAdtBody plsqlAdtBody, FolderElement folderElement) {
        folderElement.clearAllMarks();
        folderElement.setTooltip("Type Body: " + folderElement.getShortLabel());
        PlsqlNode[] plsqlNodeArray = plsqlAdtBody.getComponents();
        this.fillInDeclarations(plsqlNodeArray, folderElement);
        folderElement.sweep();
    }

    private void fillInFunction(PlsqlSubprg plsqlSubprg, PlSqlFunctionElement plSqlFunctionElement) {
        plSqlFunctionElement.setTooltip(PlSqlSrcStructureBuilder.generateFunctionTooltip(plsqlSubprg));
        PlsqlName plsqlName = plsqlSubprg.getName();
        plSqlFunctionElement.setStartOffset(plsqlName.getStartOffset() + this._offset);
        this.fillInCodeBlock((PlsqlBlock)plsqlSubprg, plSqlFunctionElement);
    }

    private void fillInCodeBlock(PlsqlBlock plsqlBlock, FolderElement folderElement) {
        PlsqlNode[] plsqlNodeArray = plsqlBlock.getDeclarations();
        this.fillInDeclarations(plsqlNodeArray, folderElement);
    }

    private void fillInDeclarations(PlsqlNode[] plsqlNodeArray, FolderElement folderElement) {
        int n = 0;
        int n2 = 0;
        while (n2 < plsqlNodeArray.length) {
            PlsqlNode plsqlNode = plsqlNodeArray[n2];
            BaseElement baseElement = this.processChildNode(plsqlNode);
            if (baseElement != null) {
                folderElement.addChild(n++, baseElement);
            }
            ++n2;
        }
    }

    private BaseElement processChildNode(PlsqlNode plsqlNode) {
        BaseElement baseElement = null;
        switch (plsqlNode.getTreeKind()) {
            case 17: 
            case 20: 
            case 23: {
                PlsqlSubprg plsqlSubprg = (PlsqlSubprg)plsqlNode;
                PlSqlFunctionElement plSqlFunctionElement = PlSqlFunctionElement.createElement(plsqlSubprg, this.context);
                this.fillInFunction(plsqlSubprg, plSqlFunctionElement);
                baseElement = plSqlFunctionElement;
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                PlsqlTypedef plsqlTypedef = (PlsqlTypedef)plsqlNode;
                baseElement = this.createTypeDef(plsqlTypedef);
                break;
            }
            case 7: 
            case 21: {
                PlsqlVariable plsqlVariable = (PlsqlVariable)plsqlNode;
                baseElement = this.createVariable(plsqlVariable);
                break;
            }
        }
        return baseElement;
    }

    public static Icon getErrorIcon() {
        if (errorIcon == null) {
            errorIcon = JavaArb.getIcon((int)27);
        }
        return errorIcon;
    }

    public static Icon getErrorFolderIcon() {
        if (errorFolderIcon == null) {
            errorFolderIcon = JavaArb.getIcon((int)28);
        }
        return errorFolderIcon;
    }

    public static Icon getFileIcon() {
        if (fileIcon == null) {
            fileIcon = ModelArb.getIcon((int)16);
        }
        return fileIcon;
    }

    public static Icon getPackageIcon() {
        if (packageIcon == null) {
            packageIcon = JavaIcons.getIcon((int)0);
        }
        return packageIcon;
    }

    public static Icon getVariableIcon() {
        if (varIcon == null) {
            varIcon = JavaIcons.getIcon((int)2);
        }
        return varIcon;
    }

    public static Icon getTypeIcon() {
        if (typeIcon == null) {
            typeIcon = JavaIcons.getIcon((int)2);
        }
        return typeIcon;
    }

    public static Icon getMethodIcon() {
        if (methodIcon == null) {
            methodIcon = JavaIcons.getIcon((int)3);
        }
        return methodIcon;
    }
}

