/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cm.dt.explorer;

import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import oracle.ide.model.Node;
import oracle.ide.util.ModelUtil;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.ora.RecycledObject;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdeveloper.cm.dt.browser.jdbc.RecycledObjectNode;
import oracle.jdeveloper.cm.dt.ui.TreeNodeMaker;
import oracle.jdevimpl.cm.dt.explorer.BaseCMExplorer;
import oracle.jdevimpl.cm.dt.explorer.DBObjectExplorerCellRenderer;

public class RecycledObjectExplorer
extends BaseCMExplorer {
    protected DefaultMutableTreeNode buildTree() {
        Node node = this.getNode();
        DefaultMutableTreeNode defaultMutableTreeNode = node instanceof RecycledObjectNode ? RecycledObjectExplorer.buildTree(((RecycledObjectNode)node).getRecycledObject()) : new DefaultMutableTreeNode(node.getShortLabel());
        return defaultMutableTreeNode;
    }

    public static DefaultMutableTreeNode buildTree(RecycledObject recycledObject) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(recycledObject);
        String string = recycledObject.getOriginalName();
        RecycledObjectExplorer.addNode(defaultMutableTreeNode, 633, string);
        RecycledObjectExplorer.addNode(defaultMutableTreeNode, 634, recycledObject.getOriginalType());
        RecycledObjectExplorer.addNode(defaultMutableTreeNode, 635, recycledObject.getCreateTime());
        RecycledObjectExplorer.addNode(defaultMutableTreeNode, 636, recycledObject.getOperation());
        RecycledObjectExplorer.addNode(defaultMutableTreeNode, 637, recycledObject.getDropTime());
        RecycledObjectExplorer.addNode(defaultMutableTreeNode, 638, Boolean.toString(recycledObject.canPurge()));
        RecycledObjectExplorer.addNode(defaultMutableTreeNode, 639, Boolean.toString(recycledObject.canUndrop()));
        TreeNodeMaker treeNodeMaker = new TreeNodeMaker(true, new String[]{"COLUMN"});
        DBObjectID dBObjectID = recycledObject.getBaseObjectID();
        if (dBObjectID != null) {
            try {
                DBObject dBObject = dBObjectID.resolveID();
                if (dBObject != null) {
                    if (ModelUtil.hasLength((String)string)) {
                        dBObject = (DBObject)dBObject.copyTo(null);
                        dBObject.setName(string);
                    }
                    defaultMutableTreeNode.add(treeNodeMaker.createTreeNode(dBObject));
                }
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        return defaultMutableTreeNode;
    }

    private static void addNode(DefaultMutableTreeNode defaultMutableTreeNode, int n, String string) {
        if (ModelUtil.hasLength((String)string)) {
            String string2 = ConnectionArb.getString(n) + ": " + string;
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(string2);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
    }

    protected boolean isValidNode(Node node) {
        return node instanceof RecycledObjectNode;
    }

    protected TreeCellRenderer getCellRenderer() {
        return new DBObjectExplorerCellRenderer();
    }
}

