/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cm.dt.impexp;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.RootPaneContainer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.ide.Ide;
import oracle.ide.controls.WaitCursor;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.help.HelpSystem;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.net.URLTextField;
import oracle.ide.net.WildcardURLFilter;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.ResourceUtils;
import oracle.ide.util.SwingWorker;
import oracle.jdeveloper.cm.ConnectionManager;
import oracle.jdeveloper.cm.ConnectionStore;
import oracle.jdeveloper.cm.DefaultConnectionStore;
import oracle.jdeveloper.cm.dt.ConnectionArb;

public class ImportExportPanel
extends JPanel
implements FocusListener,
DocumentListener,
ListSelectionListener,
ActionListener {
    private static final String BROWSE_ACTION = "BROWSE";
    private static final String FIELD_ACTION = "FIELD";
    private String mode;
    private GridBagLayout layout;
    private JLabel fileLabel;
    private URLTextField fileField;
    private JButton browseButton;
    private JLabel instructionLabel;
    private JScrollPane scrConns;
    private JList connectionList;
    private MultiLineLabel hintLabel;
    private BorderLayout borderLayout1;
    private JLabel lblMsg;
    private String _cType;
    private JEWTDialog _dlg;
    private URL _url;
    static final WildcardURLFilter PROPS_FILTER = new WildcardURLFilter(ConnectionArb.getString(145), URLFileSystem.isLocalFileSystemCaseSensitive(), ConnectionArb.getString(146));
    static final WildcardURLFilter XML_FILTER = new WildcardURLFilter(ConnectionArb.getString(143), URLFileSystem.isLocalFileSystemCaseSensitive(), ConnectionArb.getString(144));

    void $init$() {
        this.mode = "IMPORT";
        this.layout = new GridBagLayout();
        this.fileLabel = new JLabel();
        this.fileField = new URLTextField();
        this.browseButton = new JButton();
        this.instructionLabel = new JLabel();
        this.scrConns = new JScrollPane();
        this.connectionList = new JList();
        this.hintLabel = new MultiLineLabel();
        this.borderLayout1 = new BorderLayout();
        this.lblMsg = new JLabel();
    }

    public ImportExportPanel() {
        this.$init$();
        try {
            this.jbInit();
            this.postInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Component getDefaultFocus() {
        return this.fileField;
    }

    public void setConnectionClass(String string) {
        this._cType = string;
    }

    public URL getSelectedURL() {
        URL uRL = this.fileField.getURL();
        if (!URLFileSystem.isDirectoryPath((URL)uRL) && URLFileSystem.getSuffix((URL)uRL) == "") {
            URL uRL2 = URLFileSystem.getParent((URL)uRL);
            String string = URLFileSystem.getFileName((URL)uRL);
            uRL = URLFactory.newURL((URL)uRL2, (String)(string + ".xml"));
        }
        return uRL;
    }

    public Object[] getSelectedValues() {
        return this.connectionList.getSelectedValues();
    }

    void jbInit() throws Exception {
        ResourceUtils.resLabel((JLabel)this.fileLabel, (Component)this.fileField, (String)ConnectionArb.getString(132));
        this.fileField.getDocument().addDocumentListener(this);
        this.fileField.setActionCommand(FIELD_ACTION);
        this.fileField.setDirectoryOnly(false);
        this.fileField.setColumns(32);
        ResourceUtils.resButton((AbstractButton)this.browseButton, (String)ConnectionArb.getString(133));
        this.browseButton.setActionCommand(BROWSE_ACTION);
        this.lblMsg.setForeground(Color.blue);
        this.connectionList.addListSelectionListener(this);
        ResourceUtils.resLabel((JLabel)this.instructionLabel, (Component)this.connectionList, (String)ConnectionArb.getString(138));
        this.setLayout(this.layout);
        this.add((Component)this.hintLabel, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 15, 0), 0, 0));
        this.add((Component)this.fileLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 12), 0, 0));
        this.add((Component)this.fileField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.browseButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 12, 0, 0), 0, 0));
        this.add((Component)this.instructionLabel, new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 0), 0, 0));
        this.add((Component)this.scrConns, new GridBagConstraints(0, 3, 3, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.lblMsg, new GridBagConstraints(0, 4, 3, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.scrConns.getViewport().add((Component)this.connectionList, null);
    }

    private void postInit() {
        this.browseButton.addActionListener(this);
    }

    public Dimension getPreferredSize() {
        return new Dimension(550, 300);
    }

    public void setMode(String string) {
        this.mode = string;
        String string2 = null;
        this.hintLabel.setTextWrapper(WordWrapper.getTextWrapper());
        this.hintLabel.setPreferredAspectRatio(0.0f);
        if (this.mode.equals("EXPORT")) {
            this.hintLabel.setText(ConnectionArb.getString(135));
            this.populateList(ConnectionManager.getInstance());
            string2 = "f1_idedexportcxn_html";
            this.fileField.removeActionListener((ActionListener)this);
            this.fileField.removeFocusListener((FocusListener)this);
        } else {
            this.hintLabel.setText(ConnectionArb.getString(134));
            string2 = "f1_idedimportcxn_html";
            this.fileField.addActionListener((ActionListener)this);
            this.fileField.addFocusListener((FocusListener)this);
        }
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, string2);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (BROWSE_ACTION.equals(string)) {
            this.handleBrowse();
        } else if (FIELD_ACTION.equals(string)) {
            this.handleFile();
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this._updateOK();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this._updateOK();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this._updateOK();
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        this.handleFile();
    }

    public void addNotify() {
        super.addNotify();
        Container container = this.getParent();
        while (container != null) {
            if (container instanceof JEWTDialog) {
                this._dlg = (JEWTDialog)container;
                break;
            }
            container = container.getParent();
        }
        this._updateOK();
    }

    protected void handleBrowse() {
        URL uRL = this.fileField.getURL();
        if (uRL != null) {
            uRL = URLFileSystem.getParent((URL)uRL);
        } else {
            String string = Ide.getUserHomeDirectory();
            uRL = URLFactory.newDirURL((String)string);
        }
        URLChooser uRLChooser = DialogUtil.newURLChooser((URL)uRL);
        uRLChooser.clearChooseableURLFilters();
        uRLChooser.setURLFilter((URLFilter)XML_FILTER);
        uRLChooser.setShowJarsAsDirs(false);
        boolean bl = false;
        if (this.mode.equals("IMPORT")) {
            uRLChooser.addChooseableURLFilter((URLFilter)PROPS_FILTER);
            String string = ConnectionArb.getString(137);
            bl = uRLChooser.showOpenDialog((Component)this, string) == 0;
        } else if (this.mode.equals("EXPORT")) {
            String string = ConnectionArb.getString(136);
            bl = uRLChooser.showSaveDialog((Component)this, string) == 0;
        } else {
            throw new IllegalArgumentException("should never happen");
        }
        if (!bl) {
            return;
        }
        URL uRL2 = uRLChooser.getSelectedURL();
        if (uRL2 != null && !URLFileSystem.isDirectoryPath((URL)uRL2)) {
            String string = URLFileSystem.getSuffix((URL)uRL2);
            if (!ModelUtil.hasLength((String)string)) {
                URL uRL3 = URLFileSystem.getParent((URL)uRL2);
                String string2 = URLFileSystem.getFileName((URL)uRL2);
                uRL2 = URLFactory.newURL((URL)uRL3, (String)(string2 + ".xml"));
            }
            this.fileField.setURL(uRL2);
            this.handleFile();
        }
    }

    protected void handleFile() {
        this.lblMsg.setText("");
        URL uRL = this.fileField.getURL();
        if (ModelUtil.areDifferent((Object)uRL, (Object)this._url)) {
            this._url = uRL;
            if (this.mode.equals("IMPORT")) {
                WaitCursor waitCursor = Ide.getWaitCursor();
                JEWTDialog jEWTDialog = this._dlg;
                if (jEWTDialog != null) {
                    waitCursor.attach((RootPaneContainer)jEWTDialog);
                }
                waitCursor.show();
                1 var4_4 = new 1(this, uRL, waitCursor, jEWTDialog);
                var4_4.start();
            } else {
                this._updateOK();
            }
        }
    }

    protected void populateList(ConnectionManager connectionManager) {
        try {
            this.populateList(ImportExportPanel.getConnectionNames(connectionManager, this._cType));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void populateList(String[] stringArray) {
        int n = stringArray.length;
        this.connectionList.setListData(stringArray);
        if (n > 0) {
            this.connectionList.setSelectionInterval(0, n - 1);
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this._updateOK();
    }

    private void _updateOK() {
        boolean bl;
        boolean bl2 = bl = this.connectionList.getSelectedIndex() != -1;
        if (bl && "EXPORT".equals(this.mode)) {
            boolean bl3 = bl = this.fileField.getURL() != null;
        }
        if (this._dlg != null) {
            this._dlg.setOKButtonEnabled(bl);
        }
    }

    private static String[] getConnectionNames(ConnectionManager connectionManager, String string) throws IOException {
        return string != null ? connectionManager.getConnectionNamesForClass(string) : connectionManager.getConnectionNames();
    }

    static URLTextField ra$fileField(ImportExportPanel importExportPanel) {
        return importExportPanel.fileField;
    }

    static JLabel ra$lblMsg(ImportExportPanel importExportPanel) {
        return importExportPanel.lblMsg;
    }

    static String ra$_cType(ImportExportPanel importExportPanel) {
        return importExportPanel._cType;
    }

    static String[] maS$getConnectionNames(ConnectionManager connectionManager, String string) {
        return ImportExportPanel.getConnectionNames(connectionManager, string);
    }

    public final class 1
    extends SwingWorker {
        private final /* synthetic */ URL v$url;
        private final /* synthetic */ WaitCursor v$wc;
        private final /* synthetic */ JEWTDialog v$dialog;
        final /* synthetic */ ImportExportPanel this$0;

        public Object construct() {
            String[] stringArray;
            block3: {
                stringArray = null;
                if (URLFileSystem.exists((URL)this.v$url) && URLFileSystem.isRegularFile((URL)this.v$url)) {
                    String string = URLFileSystem.getPlatformPathName((URL)this.v$url);
                    try {
                        DefaultConnectionStore defaultConnectionStore = new DefaultConnectionStore(string, true);
                        ConnectionManager connectionManager = ConnectionManager.getPrivateInstance();
                        connectionManager.setConnectionStore((ConnectionStore)defaultConnectionStore);
                        stringArray = ImportExportPanel.maS$getConnectionNames(connectionManager, ImportExportPanel.ra$_cType(this.this$0));
                    }
                    catch (Throwable throwable) {
                        if (!(throwable instanceof ThreadDeath)) break block3;
                        throw (ThreadDeath)throwable;
                    }
                }
            }
            return stringArray;
        }

        public void finished() {
            try {
                Object object = this.get();
                if (object instanceof String[]) {
                    String[] stringArray = (String[])object;
                    if (stringArray.length == 0) {
                        String string = MessageFormat.format(ConnectionArb.getString(139), ImportExportPanel.ra$fileField(this.this$0).getText());
                        ImportExportPanel.ra$lblMsg(this.this$0).setText(string);
                        this.v$wc.hide();
                        if (this.v$dialog != null) {
                            this.v$wc.detach((RootPaneContainer)this.v$dialog);
                        }
                        return;
                    }
                    this.this$0.populateList(stringArray);
                }
            }
            finally {
                this.v$wc.hide();
                if (this.v$dialog != null) {
                    this.v$wc.detach((RootPaneContainer)this.v$dialog);
                }
            }
        }

        public 1(ImportExportPanel importExportPanel, URL uRL, WaitCursor waitCursor, JEWTDialog jEWTDialog) {
            this.v$dialog = jEWTDialog;
            this.v$wc = waitCursor;
            this.v$url = uRL;
            this.this$0 = importExportPanel;
        }
    }
}

