/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cm.dt.insight;

import java.net.URL;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controls.WaitCursor;
import oracle.ide.model.Node;
import oracle.ide.view.View;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.db.DBException;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.insight.AbstractInsight;
import oracle.javatools.editor.insight.InsightData;
import oracle.javatools.editor.insight.InsightProvider;
import oracle.javatools.editor.insight.InsightView;
import oracle.javatools.editor.insight.ListInsightView;
import oracle.javatools.parser.Lexer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.plsql.PlsqlParser;
import oracle.jdeveloper.cm.ds.db.DatabaseFactory;
import oracle.jdeveloper.cm.ds.db.insight.BaseInsightableItem;
import oracle.jdeveloper.cm.ds.db.insight.InsightableDatabase;
import oracle.jdeveloper.cm.ds.db.insight.InsightableObject;
import oracle.jdeveloper.cm.dt.CmUtil;
import oracle.jdeveloper.cm.dt.ConnectionNode;
import oracle.jdeveloper.cm.dt.ConnectionsProvider;
import oracle.jdevimpl.cm.dt.insight.DatabaseListInsightData;

public final class CompletionInsight
extends AbstractInsight
implements InsightProvider {
    private Context _ctx;
    private Thread _loadingThread;
    private int lastContextStart;

    public CompletionInsight(Context context) {
        this._ctx = context;
        BaseInsightableItem baseInsightableItem = this.getBaseInsightableItem();
        if (baseInsightableItem == null) {
            this._loadingThread = new Thread((Runnable)new InsightLoader(null), "DB Insight Thread");
            this._loadingThread.start();
        }
    }

    protected InsightProvider createInsightProvider() {
        return this;
    }

    public boolean isInsightTriggerChar(char c) {
        return c == '.';
    }

    protected boolean isAutomaticPartialComplete(InsightData insightData) {
        return true;
    }

    public InsightData getInsightData(BasicEditorPane basicEditorPane) {
        if (!this.isValidContext()) {
            return null;
        }
        this.lastContextStart = this.getContextStartOffset();
        WaitCursor waitCursor = Ide.getWaitCursor();
        waitCursor.show();
        DatabaseListInsightData databaseListInsightData = null;
        try {
            String string = this.getDefaultInsightContext();
            databaseListInsightData = new DatabaseListInsightData(this, string);
        }
        finally {
            waitCursor.hide();
        }
        return databaseListInsightData;
    }

    public InsightData updateInsightData(BasicEditorPane basicEditorPane, InsightData insightData) {
        TextBuffer textBuffer = this.getTextBuffer();
        int n = this.getCaretPosition();
        if (insightData instanceof DatabaseListInsightData) {
            if (this.getContextStartOffset() != this.lastContextStart) {
                return null;
            }
            DatabaseListInsightData databaseListInsightData = (DatabaseListInsightData)insightData;
            String string = this.getDefaultInsightContext();
            databaseListInsightData.updateContext(string);
            return databaseListInsightData;
        }
        return insightData;
    }

    public InsightView getInsightView() {
        return new ListInsightView();
    }

    public URL getURL() {
        Node node = this._ctx != null ? this._ctx.getNode() : null;
        return node != null ? node.getURL() : null;
    }

    public InsightableDatabase getDatabase() {
        Node node = this._ctx != null ? this._ctx.getNode() : null;
        InsightableObject insightableObject = null;
        if (node instanceof InsightableObject) {
            insightableObject = (InsightableObject)node;
        } else {
            View view = this._ctx.getView();
            if (view instanceof InsightableObject) {
                insightableObject = (InsightableObject)view;
            }
        }
        if (insightableObject != null) {
            try {
                InsightableDatabase insightableDatabase = DatabaseFactory.createInsightableDatabase(insightableObject.getDatabaseForInsight());
                return insightableDatabase;
            }
            catch (DBException dBException) {
                dBException.printStackTrace();
            }
        }
        return null;
    }

    private static ConnectionNode _getConnNode(URL uRL) {
        if (uRL == null) {
            return null;
        }
        String string = CmUtil.getConnName(uRL);
        ConnectionsProvider connectionsProvider = ConnectionsProvider.getInstance();
        return connectionsProvider.getConnectionNode(string);
    }

    synchronized BaseInsightableItem getBaseInsightableItem() {
        if (this._loadingThread != null) {
            try {
                try {
                    this._loadingThread.join();
                }
                catch (InterruptedException interruptedException) {}
            }
            finally {
                this._loadingThread = null;
            }
        }
        ConnectionNode connectionNode = CompletionInsight._getConnNode(this.getURL());
        return (BaseInsightableItem)connectionNode.getClientProperty("database-insight-data");
    }

    static boolean isPlSqlDelimiter(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': 
            case '\'': 
            case '(': 
            case ')': 
            case ',': 
            case ';': 
            case '[': 
            case ']': {
                return true;
            }
        }
        return false;
    }

    int getContextStartOffset() {
        TextBuffer textBuffer = this.getTextBuffer();
        int n = this.getCaretPosition();
        int n2 = CompletionInsight.getContextStartOffset((ReadTextBuffer)textBuffer, n);
        return n2;
    }

    static int getContextStartOffset(ReadTextBuffer readTextBuffer, int n) {
        int n2 = n - 1;
        while (n2 >= 0) {
            char c = readTextBuffer.getChar(n2);
            if (CompletionInsight.isPlSqlDelimiter(c)) break;
            --n2;
        }
        return n2 + 1;
    }

    String getDefaultInsightContext() {
        TextBuffer textBuffer = this.getTextBuffer();
        int n = this.getCaretPosition();
        int n2 = CompletionInsight.getContextStartOffset((ReadTextBuffer)textBuffer, n);
        int n3 = n - n2;
        String string = textBuffer.getString(n2, n3);
        return string;
    }

    private boolean isValidContext() {
        int n;
        TextBuffer textBuffer = this.getTextBuffer();
        int n2 = this.getCaretPosition();
        Lexer lexer = PlsqlParser.createSqlLexer();
        LexerToken lexerToken = lexer.createLexerToken();
        lexer.setTextBuffer((ReadTextBuffer)textBuffer);
        lexer.setPosition(0);
        block4: while ((n = lexer.lex(lexerToken)) != 0) {
            int n3 = lexerToken.getStartOffset();
            int n4 = lexerToken.getEndOffset();
            if (n4 < n2) continue;
            if (n2 < n3 || n2 == n3) break;
            switch (n) {
                case 33: 
                case 49: {
                    if (n2 == n4) break block4;
                    return false;
                }
                case 48: {
                    return false;
                }
            }
            break;
        }
        return true;
    }

    static ConnectionNode maS$_getConnNode(URL uRL) {
        return CompletionInsight._getConnNode(uRL);
    }

    private final class InsightLoader
    implements Runnable {
        public void run() {
            InsightableDatabase insightableDatabase = CompletionInsight.this.getDatabase();
            if (insightableDatabase != null) {
                BaseInsightableItem baseInsightableItem = insightableDatabase.buildInsightableObjectTree();
                ConnectionNode connectionNode = CompletionInsight.maS$_getConnNode(CompletionInsight.this.getURL());
                connectionNode.putClientProperty("database-insight-data", baseInsightableItem);
            }
        }

        private InsightLoader() {
        }

        InsightLoader(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

