/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cm.dt.runner;

import oracle.ide.util.FastStringBuffer;
import oracle.jdevimpl.cm.dt.runner.Mode;
import oracle.jdevimpl.cm.dt.runner.Parameter;
import oracle.jdevimpl.cm.dt.runner.Type;

class ParamImpl
implements Parameter {
    private String _name;
    private String _varName;
    private Type _type;
    private Mode _mode;
    private boolean _default;
    private boolean _return;

    ParamImpl(Type type) {
        this._name = "<Return Value>";
        this._varName = "v_Return";
        this._type = type;
        this._mode = Mode.OUT;
        this._default = false;
        this._return = true;
    }

    ParamImpl(String string, Type type, Mode mode, boolean bl) {
        this._name = string;
        this._varName = string;
        this._type = type;
        this._mode = mode;
        this._default = bl;
        this._return = false;
    }

    public boolean isReturn() {
        return this._return;
    }

    public boolean isDefaultProvided() {
        return this._default;
    }

    public String getVarName() {
        return this._varName;
    }

    public Type getType() {
        return this._type;
    }

    public String getParamName() {
        return this._name;
    }

    public Mode getMode() {
        return this._mode;
    }

    public void generateDeclaration(FastStringBuffer fastStringBuffer) {
        fastStringBuffer.append("  ");
        fastStringBuffer.append(this._varName);
        fastStringBuffer.append(" ");
        fastStringBuffer.append(this._type.getTypeName());
        fastStringBuffer.append(";\n");
    }

    public void generateInitialization(FastStringBuffer fastStringBuffer) {
        if (this._type.isOutputSupported()) {
            fastStringBuffer.append("  ");
        } else {
            fastStringBuffer.append("  ");
            fastStringBuffer.append("-- Modify the code to initialize the variable\n");
            fastStringBuffer.append("  ");
            fastStringBuffer.append("-- ");
        }
        fastStringBuffer.append(this._varName);
        fastStringBuffer.append(" := NULL;\n");
    }

    public void generateCallReference(FastStringBuffer fastStringBuffer) {
        fastStringBuffer.append("  ");
        fastStringBuffer.append(this._name);
        fastStringBuffer.append(" => ");
        fastStringBuffer.append(this._varName);
    }

    public void generateResultOutput(FastStringBuffer fastStringBuffer) {
        if (this._type.isOutputSupported()) {
            fastStringBuffer.append("  ");
        } else {
            fastStringBuffer.append("  ");
            fastStringBuffer.append("-- Modify the code to output the variable\n");
            fastStringBuffer.append("  ");
            fastStringBuffer.append("-- ");
        }
        fastStringBuffer.append("DBMS_OUTPUT.PUT_LINE('");
        fastStringBuffer.append(this._varName);
        fastStringBuffer.append(" = ' || ");
        fastStringBuffer.append(this._varName);
        fastStringBuffer.append(");\n");
    }
}

