/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cm.dt.runner;

import java.io.File;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import oracle.ide.Context;
import oracle.ide.log.StyledMessage;
import oracle.ide.model.DefaultDisplayable;
import oracle.ide.model.Displayable;
import oracle.ide.model.Node;
import oracle.ide.runner.AbstractStarterFactory;
import oracle.ide.runner.RunProcess;
import oracle.ide.runner.Starter;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.db.Database;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.jdeveloper.cm.CMException;
import oracle.jdeveloper.cm.ds.db.DatabaseFactory;
import oracle.jdeveloper.cm.dt.CmUtil;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdeveloper.cm.dt.browser.jdbc.PlSqlBaseNode;
import oracle.jdeveloper.runner.DatabaseRunHelper;
import oracle.jdeveloper.runner.JRunProcess;
import oracle.jdeveloper.runner.JStarter;
import oracle.jdeveloper.runner.JStarterFactory;
import oracle.jdevimpl.cm.dt.runner.PlSqlRunnerPanel;
import oracle.jdevimpl.runner.RunMgrArb;
import oracle.jdevimpl.runner.debug.DebuggingProcess;

public final class PlSqlStarterFactory
extends AbstractStarterFactory
implements JStarterFactory {
    public String getName() {
        return RunMgrArb.getString((int)86);
    }

    public boolean enableRunDebugActions(Context context) {
        Node node = RunProcess.getContextNodeForRun((Context)context);
        return node instanceof PlSqlBaseNode && ((PlSqlBaseNode)node).getDatabase() instanceof OracleDatabase && ((PlSqlBaseNode)node).isRunnable();
    }

    public Object canStart(RunProcess runProcess, Node node, List list) {
        Database database;
        PlSqlBaseNode plSqlBaseNode;
        Object object;
        if (runProcess instanceof JRunProcess && node instanceof PlSqlBaseNode && (object = PlSqlStarterFactory.findPlSqlBaseTarget(plSqlBaseNode = (PlSqlBaseNode)node, list)) != null && runProcess.canRun("Database", (Object)(database = plSqlBaseNode.getDatabase()), node, list)) {
            return object;
        }
        return null;
    }

    public Starter createStarter(RunProcess runProcess, Node node, Object object) {
        PlSqlBaseNode plSqlBaseNode = (PlSqlBaseNode)object;
        return new PlSqlStarter((JRunProcess)runProcess, plSqlBaseNode);
    }

    public Displayable getDisplayable(RunProcess runProcess, Context context, Node node, Object object) {
        return new 1();
    }

    private static Object findPlSqlBaseTarget(PlSqlBaseNode plSqlBaseNode, List list) {
        URL uRL = plSqlBaseNode.getURL();
        if (CmUtil.isCMUrl(uRL)) {
            if (!CmUtil.isFolder(uRL)) {
                Object object = plSqlBaseNode.getRunTarget();
                if (object != null) {
                    return object;
                }
                String string = RunMgrArb.format((int)90, (Object)plSqlBaseNode.getShortLabel());
                list.add(string);
            } else {
                String string = RunMgrArb.format((int)89, (Object)plSqlBaseNode.getShortLabel());
                list.add(string);
            }
        } else {
            String string = RunMgrArb.format((int)88, (Object)plSqlBaseNode.getShortLabel());
            list.add(string);
        }
        return null;
    }

    public final class 1
    extends DefaultDisplayable {
        public String getShortLabel() {
            return RunMgrArb.getString((int)87);
        }

        public Icon getIcon() {
            return ConnectionArb.getIcon(275);
        }
    }

    public class PlSqlStarter
    extends JStarter {
        private TextBuffer buf;
        private PlSqlBaseNode target;
        private Database database;
        private boolean connectHappened;
        private boolean dbSupportsCall;
        private static final String DBMS_OUTPUT_GET_LINE = "DBMS_OUTPUT.GET_LINE( ?, ? )";

        PlSqlStarter(JRunProcess jRunProcess, PlSqlBaseNode plSqlBaseNode) {
            super(jRunProcess, null);
            this.jrunProcess = jRunProcess;
            this.target = plSqlBaseNode;
        }

        private Database getDatabase() {
            String string;
            URL uRL;
            if (this.database == null && !this.connectHappened && (uRL = this.target.getURL()) != null && (string = CmUtil.getConnName(uRL)) != null) {
                try {
                    this.jrunProcess.getLogPage().log((Object)RunMgrArb.format((int)91, (Object)string));
                    this.database = DatabaseFactory.createDatabase(string);
                    this.connectHappened = true;
                    int n = this.database instanceof OracleDatabase ? ((OracleDatabase)this.database).getOracleDatabaseType() : 0;
                    this.dbSupportsCall = (n == 0 || 1 == n) ^ true;
                }
                catch (CMException cMException) {
                    cMException.printStackTrace();
                }
            }
            return this.database;
        }

        private void disconnect() {
            if (this.database != null) {
                this.jrunProcess.getLogPage().log((Object)RunMgrArb.format((int)92, (Object)this.database.getConnectionName()));
                this.database.close();
                this.database = null;
            }
        }

        public File getStartDirectory() {
            return null;
        }

        public String[] getStartCommand() {
            return null;
        }

        public boolean canStart(List list) {
            return true;
        }

        public boolean start() {
            if (this.getDatabase() != null) {
                boolean bl = this.jrunProcess instanceof DebuggingProcess;
                this.buf = PlSqlRunnerPanel.runDialog(this.target, bl);
                if (this.buf == null) {
                    this.disconnect();
                    return false;
                }
                DatabaseRunHelper databaseRunHelper = (DatabaseRunHelper)this.jrunProcess.getValue("Database", (Object)this.database, "DatabaseRunHelper");
                String[][] stringArray = databaseRunHelper != null ? databaseRunHelper.getDatabaseCommands((Object)this.database) : null;
                1 var4_4 = new 1(this, "PL/SQL Starter Thread", stringArray, databaseRunHelper);
                var4_4.start();
                return true;
            }
            this.disconnect();
            return false;
        }

        private void logMsg(String string) {
            this.logMsg(string, null);
        }

        private void logMsg(String string, AttributeSet attributeSet) {
            if (string != null) {
                if (!string.endsWith("\n")) {
                    string = string + "\n";
                }
                if (attributeSet != null) {
                    this.jrunProcess.log((Object)new StyledMessage(attributeSet, string));
                } else {
                    this.jrunProcess.log((Object)string);
                }
            }
        }

        private int executeSQL(String string, boolean bl) {
            int n = 0;
            if (bl) {
                boolean bl2 = true;
                StringBuffer stringBuffer = new StringBuffer(RunMgrArb.getString((int)93));
                String string2 = stringBuffer.toString();
                StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    this.logMsg(string2 + string3 + "\n");
                    if (!bl2) continue;
                    int n2 = stringBuffer.length() - 1;
                    while (n2 >= 0) {
                        stringBuffer.setCharAt(n2, ' ');
                        --n2;
                    }
                    string2 = stringBuffer.toString();
                    bl2 = false;
                }
            }
            Connection connection = this.database.getConnection();
            Statement statement = null;
            try {
                try {
                    statement = connection.createStatement();
                    statement.execute(string);
                }
                catch (SQLException sQLException) {
                    n = this.handleError(sQLException, bl);
                }
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {}
                    statement = null;
                }
            }
            return n;
        }

        private int handleError(SQLException sQLException, boolean bl) {
            int n = sQLException.getErrorCode();
            String string = sQLException.getMessage();
            if (bl) {
                this.logMsg(string, RunProcess.getSystemErrAttributeSet());
            }
            return n;
        }

        private int executePlSqlNode() {
            int n = 0;
            if (this.buf != null) {
                String string = this.buf.getString(0, this.buf.getLength());
                Statement statement = null;
                try {
                    try {
                        Connection connection = this.database.getConnection();
                        statement = connection.createStatement();
                        statement.setEscapeProcessing(false);
                        statement.execute(string);
                    }
                    catch (SQLException sQLException) {
                        n = this.handleError(sQLException, true);
                    }
                }
                finally {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            return n;
        }

        private String getSQL(String string, boolean bl) {
            return this.getSQL(string, this.dbSupportsCall, bl);
        }

        private String getSQL(String string, boolean bl, boolean bl2) {
            StringBuffer stringBuffer = new StringBuffer(100);
            if (bl) {
                stringBuffer.append("CALL ");
            } else {
                stringBuffer.append("BEGIN ");
            }
            stringBuffer.append(string);
            if (bl) {
                if (bl2) {
                    stringBuffer.append("()");
                }
            } else {
                stringBuffer.append("; END;");
            }
            return stringBuffer.toString();
        }

        private void enableDbmsOutput() {
            this.executeSQL(this.getSQL("DBMS_OUTPUT.DISABLE", true), false);
            this.executeSQL(this.getSQL("DBMS_OUTPUT.ENABLE", true), false);
        }

        private void logDbmsOutput() {
            Connection connection = this.database.getConnection();
            while (true) {
                Statement statement = null;
                try {
                    try {
                        String string = this.getSQL(DBMS_OUTPUT_GET_LINE, false);
                        statement = connection.prepareCall(string);
                        statement.registerOutParameter(1, 12);
                        statement.registerOutParameter(2, 4);
                        statement.execute();
                        String string2 = statement.getString(1);
                        int n = statement.getInt(2);
                        this.logMsg(string2, RunProcess.getSystemOutAttributeSet());
                        if (n <= 0) continue;
                        if (statement != null) {
                            try {
                                statement.close();
                                statement = null;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        return;
                    }
                    catch (Exception exception) {
                        if (statement != null) {
                            try {
                                statement.close();
                                statement = null;
                            }
                            catch (Exception exception2) {
                                // empty catch block
                            }
                        }
                        return;
                    }
                }
                finally {
                    if (statement == null) continue;
                    try {
                        statement.close();
                        statement = null;
                    }
                    catch (Exception exception) {}
                    continue;
                }
                break;
            }
        }

        public boolean canTerminate() {
            return false;
        }

        public void terminate() {
        }

        public void finished() {
            this.disconnect();
            super.finished();
        }

        static void mav$enableDbmsOutput(PlSqlStarter plSqlStarter) {
            plSqlStarter.enableDbmsOutput();
        }

        static int mav$executeSQL(PlSqlStarter plSqlStarter, String string, boolean bl) {
            return plSqlStarter.executeSQL(string, bl);
        }

        static int mav$executePlSqlNode(PlSqlStarter plSqlStarter) {
            return plSqlStarter.executePlSqlNode();
        }

        static Database ra$database(PlSqlStarter plSqlStarter) {
            return plSqlStarter.database;
        }

        static void mav$logDbmsOutput(PlSqlStarter plSqlStarter) {
            plSqlStarter.logDbmsOutput();
        }

        static JRunProcess ra$jrunProcess(PlSqlStarter plSqlStarter) {
            return plSqlStarter.jrunProcess;
        }

        public final class oracle.jdevimpl.cm.dt.runner.PlSqlStarterFactory$PlSqlStarter$1
        extends Thread {
            private final /* synthetic */ String[][] v$dbCommands;
            private final /* synthetic */ DatabaseRunHelper v$databaseRunHelper;
            final /* synthetic */ PlSqlStarter this$0;

            public void run() {
                PlSqlStarter.mav$enableDbmsOutput(this.this$0);
                boolean bl = false;
                if (this.v$dbCommands != null && this.v$dbCommands.length >= 1 && this.v$dbCommands[0] != null) {
                    int n = this.v$dbCommands[0].length;
                    int n2 = 0;
                    while (n2 < n) {
                        int n3 = PlSqlStarter.mav$executeSQL(this.this$0, this.v$dbCommands[0][n2], true);
                        if (n3 != 0) {
                            if (this.v$databaseRunHelper != null) {
                                this.v$databaseRunHelper.handleDatabaseError(this.v$dbCommands, 0, n2, n3);
                            }
                            bl = true;
                            break;
                        }
                        ++n2;
                    }
                }
                if (!bl && (this.v$databaseRunHelper == null || this.v$databaseRunHelper.waitForDatabase())) {
                    int n = PlSqlStarter.mav$executePlSqlNode(this.this$0);
                    boolean bl2 = false;
                    if (PlSqlStarter.ra$database(this.this$0) instanceof OracleDatabase && n == 6543) {
                        bl2 = true;
                    }
                    if (this.v$dbCommands != null && this.v$dbCommands.length >= 2 && this.v$dbCommands[1] != null) {
                        int n4 = this.v$dbCommands[1].length;
                        int n5 = 0;
                        while (n5 < n4) {
                            int n6 = PlSqlStarter.mav$executeSQL(this.this$0, this.v$dbCommands[1][n5], true);
                            if (n6 != 0 && this.v$databaseRunHelper != null) {
                                this.v$databaseRunHelper.handleDatabaseError(this.v$dbCommands, 1, n5, n6);
                            }
                            ++n5;
                        }
                    }
                    if (!bl2) {
                        PlSqlStarter.mav$logDbmsOutput(this.this$0);
                    }
                }
                SwingUtilities.invokeLater(new 1());
            }

            public oracle.jdevimpl.cm.dt.runner.PlSqlStarterFactory$PlSqlStarter$1(PlSqlStarter plSqlStarter, String string, String[][] stringArray, DatabaseRunHelper databaseRunHelper) {
                this.v$databaseRunHelper = databaseRunHelper;
                this.v$dbCommands = stringArray;
                this.this$0 = plSqlStarter;
                super(string);
            }

            public final class 1
            implements Runnable {
                public void run() {
                    PlSqlStarter.ra$jrunProcess(1.this.this$0).finished();
                    1.this.this$0.finished();
                }
            }
        }
    }
}

