/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cm.dt.runner;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import oracle.ide.util.FastStringBuffer;
import oracle.ide.util.ModelUtil;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.db.DBException;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.parser.plsql.data.PlsqlRoot;
import oracle.javatools.parser.plsql.data.PlsqlType;
import oracle.jdevimpl.cm.dt.runner.Mode;
import oracle.jdevimpl.cm.dt.runner.ParamTableModel;
import oracle.jdevimpl.cm.dt.runner.Parameter;

class Procedure {
    private static HashMap _docMap = new HashMap();
    private String _owner;
    private String _package;
    private String _name;
    private int _id;
    private int _overload;
    private OracleDatabase _db;
    private PlsqlRoot _parseTree;
    private PlsqlType[] _types;
    private String _displayValue;
    private ParamTableModel _model;
    private BasicDocument _document;
    static final String INDENT = "  ";

    public Procedure(String string, String string2, int n, OracleDatabase oracleDatabase, PlsqlRoot plsqlRoot) {
        this(string, null, string2, n, 0, oracleDatabase, plsqlRoot);
    }

    public Procedure(String string, String string2, String string3, int n, int n2, OracleDatabase oracleDatabase, PlsqlRoot plsqlRoot) {
        this._owner = string;
        this._package = string2;
        this._name = string3;
        this._id = n;
        this._overload = n2;
        this._db = oracleDatabase;
        this._parseTree = plsqlRoot;
    }

    public String toString() {
        if (this._displayValue == null) {
            this._displayValue = this._overload > 0 ? this._name + "(" + this._overload + ")" : this._name;
        }
        return this._displayValue;
    }

    public ParamTableModel getTableModel() throws SQLException {
        if (this._model == null) {
            this._model = new ParamTableModel(this);
        }
        return this._model;
    }

    public OracleDatabase getDatabase() {
        return this._db;
    }

    public String getPackage() {
        return this._package;
    }

    public String getName() {
        return this._name;
    }

    public int getOverload() {
        return this._overload;
    }

    public String getOwner() {
        return this._owner;
    }

    public int getObjectID() {
        return this._id;
    }

    public PlsqlRoot getParseTree() {
        return this._parseTree;
    }

    public BasicDocument getDocument() throws SQLException {
        if (this._document == null) {
            this._document = (BasicDocument)_docMap.get(this._getHashName());
            if (this._document == null) {
                TextBuffer textBuffer = this._generateBuffer();
                this._document = new BasicDocument("foo.plsql", textBuffer);
            }
        }
        return this._document;
    }

    public void saveDocument() {
        if (this._document != null) {
            _docMap.put(this._getHashName(), this._document);
        }
    }

    public void resetDocument() {
        this._document = null;
        _docMap.remove(this._getHashName());
    }

    private TextBuffer _generateBuffer() throws SQLException {
        boolean bl;
        FastStringBuffer fastStringBuffer;
        block22: {
            fastStringBuffer = new FastStringBuffer();
            bl = true;
            try {
                String string = this._db.getUserName();
                bl = ModelUtil.areDifferent((Object)string, (Object)this._owner);
            }
            catch (DBException dBException) {
                Throwable throwable = dBException.getCause();
                if (!(throwable instanceof SQLException)) break block22;
                throw (SQLException)throwable;
            }
        }
        ParamTableModel paramTableModel = this.getTableModel();
        int n = paramTableModel.getRowCount();
        if (n == 0) {
            fastStringBuffer.append("BEGIN\n  ");
            fastStringBuffer.append(this._getCallName(bl));
            fastStringBuffer.append("();\nEND;");
        } else {
            Parameter parameter = null;
            ArrayList<Parameter> arrayList = new ArrayList<Parameter>();
            Parameter parameter2 = paramTableModel.getParameter(0);
            if (parameter2.isReturn()) {
                parameter = parameter2;
            } else {
                arrayList.add(parameter2);
            }
            int n2 = 1;
            while (n2 < n) {
                arrayList.add(paramTableModel.getParameter(n2));
                ++n2;
            }
            n = arrayList.size();
            fastStringBuffer.append("DECLARE\n");
            int n3 = 0;
            while (n3 < n) {
                parameter2 = (Parameter)arrayList.get(n3);
                parameter2.generateDeclaration(fastStringBuffer);
                ++n3;
            }
            if (parameter != null) {
                parameter.generateDeclaration(fastStringBuffer);
            }
            fastStringBuffer.append("BEGIN\n");
            int n4 = 0;
            while (n4 < n) {
                parameter2 = (Parameter)arrayList.get(n4);
                Mode mode = parameter2.getMode();
                if (!mode.equals(Mode.OUT)) {
                    parameter2.generateInitialization(fastStringBuffer);
                }
                ++n4;
            }
            fastStringBuffer.append("\n");
            fastStringBuffer.append(INDENT);
            if (parameter != null) {
                fastStringBuffer.append(parameter.getVarName());
                fastStringBuffer.append(" := ");
            }
            fastStringBuffer.append(this._getCallName(bl));
            fastStringBuffer.append("(");
            if (n > 0) {
                fastStringBuffer.append("\n");
                fastStringBuffer.append(INDENT);
                parameter2 = (Parameter)arrayList.get(0);
                parameter2.generateCallReference(fastStringBuffer);
                int n5 = 1;
                while (n5 < n) {
                    fastStringBuffer.append(",\n");
                    fastStringBuffer.append(INDENT);
                    parameter2 = (Parameter)arrayList.get(n5);
                    parameter2.generateCallReference(fastStringBuffer);
                    ++n5;
                }
                fastStringBuffer.append("\n");
                fastStringBuffer.append(INDENT);
            }
            fastStringBuffer.append(");\n");
            int n6 = 0;
            while (n6 < n) {
                parameter2 = (Parameter)arrayList.get(n6);
                Mode mode = parameter2.getMode();
                if (!mode.equals(Mode.IN)) {
                    parameter2.generateResultOutput(fastStringBuffer);
                }
                ++n6;
            }
            if (parameter != null) {
                parameter.generateResultOutput(fastStringBuffer);
            }
            fastStringBuffer.append("END;\n");
        }
        char[] cArray = new char[fastStringBuffer.length()];
        fastStringBuffer.getChars(0, cArray.length, cArray, 0);
        TextBuffer textBuffer = TextBufferFactory.createGapTextBuffer();
        textBuffer.writeLock();
        try {
            try {
                textBuffer.insert(0, cArray);
            }
            catch (Exception exception) {}
        }
        finally {
            textBuffer.writeUnlock();
        }
        return textBuffer;
    }

    private String _getCallName(boolean bl) {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(100);
        if (bl && ModelUtil.hasLength((String)this._owner)) {
            fastStringBuffer.append(this._db.getExternalName(this._owner)).append('.');
        }
        if (ModelUtil.hasLength((String)this._package)) {
            fastStringBuffer.append(this._db.getExternalName(this._package)).append('.');
        }
        fastStringBuffer.append(this._db.getExternalName(this._name));
        return fastStringBuffer.toString();
    }

    private String _getHashName() {
        FastStringBuffer fastStringBuffer = new FastStringBuffer();
        fastStringBuffer.append(this._getCallName(true));
        if (this._overload > 0) {
            fastStringBuffer.append("(" + this._overload + ")");
        }
        String string = null;
        try {
            Connection connection = this._db.getConnection();
            string = connection.getMetaData().getURL();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (ModelUtil.hasLength(string)) {
            fastStringBuffer.append('@').append(string);
        }
        return fastStringBuffer.toString();
    }
}

