/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cm.dt.sqlplus;

import java.awt.Component;
import java.io.IOException;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.checkboxlist.CheckBoxListModel;
import oracle.ide.dialogs.SelectFilesPanel;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.MenuSpec;
import oracle.ide.util.ModelUtil;
import oracle.ide.wizard.Wizard;
import oracle.ide.wizard.WizardManager;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdeveloper.cm.ConnectionManager;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdeveloper.cm.dt.DatabaseConnectionNode;
import oracle.jdevimpl.cm.dt.sqlplus.SqlNode;
import oracle.jdevimpl.cm.dt.sqlplus.SqlPlusInfo;
import oracle.jdevimpl.cm.dt.sqlplus.SqlPlusRunner;
import oracle.jdevimpl.cm.dt.sqlplus.SqlPlusUtils;

public final class SqlPlusAddin
extends Wizard
implements ContextMenuListener,
Controller,
Addin {
    private static final String SQLPLUS_LABEL = ConnectionArb.getString(111);
    private static final String _name = StringUtils.stripMnemonic((String)SQLPLUS_LABEL);
    private static final Integer _mnemonic = new Integer(StringUtils.getMnemonicKeyCode((String)SQLPLUS_LABEL));
    public static final int SQLPLUS_COMMAND_NAME = Ide.findOrCreateCmdID((String)"ConnectionsSqlPlusCommand");
    static final IdeAction SQLPLUS_ACTION = IdeAction.get((int)SQLPLUS_COMMAND_NAME, (String)_name, (Integer)_mnemonic);
    private static JMenuItem SQLPLUS_MENU;
    private static JMenuItem RUN_IN_SQLPLUS_MENU;
    private static boolean _menusBuilt;
    private MenuSpec _menuSpec;

    public void initialize() {
        WizardManager wizardManager = WizardManager.getInstance();
        wizardManager.registerWizard((Wizard)this);
        SQLPLUS_ACTION.addController((Controller)this);
        NavigatorManager navigatorManager = NavigatorManager.getWorkspaceNavigatorManager();
        navigatorManager.addContextMenuListener((ContextMenuListener)this, null);
        EditorManager.getEditorManager().getContextMenu().addContextMenuListener((ContextMenuListener)this, SqlNode.class);
    }

    public String getShortLabel() {
        return _name;
    }

    public boolean isAvailable(Context context) {
        return SqlPlusUtils.canInvokeSqlPlus(context);
    }

    public boolean invoke(Context context) {
        return context != null && SqlPlusUtils.invokeSqlPlus(context);
    }

    public Icon getIcon() {
        return this.getMenuSpecification().getIcon();
    }

    public MenuSpec getMenuSpecification() {
        if (this._menuSpec == null) {
            this._menuSpec = new MenuSpec(_name, _mnemonic, null);
        }
        return this._menuSpec;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == SQLPLUS_COMMAND_NAME) {
            return this._doSqlPlus(context);
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        return false;
    }

    public void menuWillShow(ContextMenu contextMenu) {
        Context context = contextMenu.getContext();
        Element element = SqlPlusAddin.getElement(context);
        if (element == null) {
            return;
        }
        SqlPlusAddin._buildMenus(contextMenu);
        if (element instanceof SqlNode) {
            this._addSqlPlus(contextMenu);
        } else if (element instanceof DatabaseConnectionNode) {
            String string = ((DatabaseConnectionNode)element).getConnectionName();
            String string2 = SqlPlusUtils.getSqlPlusPath();
            SqlPlusInfo sqlPlusInfo = new SqlPlusInfo(string2, string);
            SQLPLUS_ACTION.setEnabled(sqlPlusInfo.isComplete());
            contextMenu.add((Component)SQLPLUS_MENU, JDeveloperMenuConstants.SECTION_CONNECTION_WINDOW_SQL_CTXT);
        }
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    private static synchronized void _buildMenus(ContextMenu contextMenu) {
        if (!_menusBuilt) {
            SQLPLUS_MENU = contextMenu.createMenuItem((ToggleAction)SQLPLUS_ACTION);
            RUN_IN_SQLPLUS_MENU = contextMenu.createMenuItem((ToggleAction)SQLPLUS_ACTION);
            String string = ConnectionArb.getString(113);
            RUN_IN_SQLPLUS_MENU.setText(StringUtils.stripMnemonic((String)string));
            RUN_IN_SQLPLUS_MENU.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
            _menusBuilt = true;
        }
    }

    private void _addSqlPlus(ContextMenu contextMenu) {
        String string = ConnectionArb.getString(113);
        int n = StringUtils.getMnemonicKeyCode((String)string);
        JMenu jMenu = contextMenu.createSubMenu(StringUtils.stripMnemonic((String)string), new Integer(n));
        String[] stringArray = this._getOracleJdbcConnections();
        int n2 = stringArray.length;
        Icon icon = ConnectionArb.getIcon(2);
        int n3 = 0;
        while (n3 < n2) {
            JMenuItem jMenuItem = contextMenu.createMenuItem((ToggleAction)SQLPLUS_ACTION);
            jMenuItem.setText(stringArray[n3]);
            jMenuItem.setIcon(icon);
            jMenu.add(jMenuItem);
            ++n3;
        }
        if (n2 > 0) {
            SQLPLUS_ACTION.setEnabled(true);
            this.addMenuItem(contextMenu, jMenu);
        } else {
            SQLPLUS_ACTION.setEnabled(false);
            this.addMenuItem(contextMenu, RUN_IN_SQLPLUS_MENU);
        }
    }

    private void addMenuItem(ContextMenu contextMenu, JMenuItem jMenuItem) {
        Context context = contextMenu.getContext();
        if (context.getView() instanceof NavigatorWindow) {
            contextMenu.add((Component)jMenuItem);
        } else if (context.getView() instanceof CodeEditor) {
            contextMenu.add((Component)jMenuItem, MenuConstants.SECTION_RUN_CTXT_MENU);
        }
    }

    private String[] _getOracleJdbcConnections() {
        try {
            String[] stringArray = ConnectionManager.getInstance().getConnectionNames(null, true);
            return stringArray;
        }
        catch (IOException iOException) {
            return new String[0];
        }
    }

    private boolean _doSqlPlus(Context context) {
        String string = null;
        Element element = SqlPlusAddin.getElement(context);
        if (element instanceof DatabaseConnectionNode) {
            string = ((DatabaseConnectionNode)element).getConnectionName();
        }
        SqlPlusInfo sqlPlusInfo = null;
        if (ModelUtil.hasLength((String)string)) {
            sqlPlusInfo = new SqlPlusInfo(SqlPlusUtils.getSqlPlusPath(), string);
        } else {
            try {
                JMenuItem jMenuItem = (JMenuItem)context.getEvent().getSource();
                String string2 = jMenuItem.getText();
                Node node = context.getNode();
                if (node != null && string2 != null && SqlPlusAddin.checkForSave(node)) {
                    URL uRL = node.getURL();
                    sqlPlusInfo = new SqlPlusInfo(SqlPlusUtils.getSqlPlusPath(), string2, uRL);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (sqlPlusInfo != null && sqlPlusInfo.isComplete()) {
            SqlPlusRunner.runPlus(sqlPlusInfo);
        }
        return true;
    }

    private static Element getElement(Context context) {
        Element[] elementArray;
        Element element = null;
        if (context != null && (elementArray = context.getSelection()) != null && elementArray.length == 1) {
            element = elementArray[0];
        }
        return element;
    }

    private static boolean checkForSave(Node node) {
        boolean bl = true;
        if (node.isOpen() && node.isDirty()) {
            bl = false;
            CheckBoxListModel checkBoxListModel = new CheckBoxListModel();
            checkBoxListModel.addElement((Object)node, node.getIcon(), true, true, URLFileSystem.getPlatformPathName((URL)node.getURL()));
            int n = SelectFilesPanel.showDialog((String)IdeArb.getString((int)285), (String)IdeArb.format((int)217, (Object)checkBoxListModel.findTextForElement(0)), (String)IdeArb.getString((int)220), (CheckBoxListModel)checkBoxListModel, (boolean)true);
            switch (n) {
                case 0: {
                    Command command = CommandProcessor.createCommand((String)"oracle.ide.cmd.SaveCommand", (Context)Context.newIdeContext((Node)node));
                    try {
                        bl = CommandProcessor.getInstance().invoke(command) == 0;
                    }
                    catch (Exception exception) {}
                    break;
                }
                case 1: {
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                }
            }
        }
        return bl;
    }
}

