/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cm.dt.sqlplus;

import java.net.URL;
import java.text.MessageFormat;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.cm.ConnectionDescriptor;
import oracle.jdeveloper.cm.ConnectionManager;

public final class SqlPlusInfo {
    private String _connName;
    private String _sqlPlusPath;
    private String _userName;
    private String _connString;
    private URL _scriptName;
    private String _role;
    private static final String CONNECT_STRING_PATTERN = "(DESCRIPTION=(ADDRESS_LIST=(ADDRESS=(PROTOCOL=TCP)(HOST={0})(PORT={1})))(CONNECT_DATA=({2})))";
    private static final String SID_PATTERN = "SID={0}";
    private static final String SERVICE_NAME_PATTERN = "SERVICE_NAME={0}";

    public SqlPlusInfo() {
    }

    public SqlPlusInfo(String string) {
        this();
        this.setSQLPlusPath(string);
    }

    public SqlPlusInfo(String string, String string2) {
        this();
        this.setSQLPlusPath(string);
        this.setConnectionName(string2);
    }

    public SqlPlusInfo(String string, String string2, URL uRL) {
        this();
        this.setSQLPlusPath(string);
        this.setConnectionName(string2);
        this.setScriptName(uRL);
    }

    public String getConnectionName() {
        return this._connName;
    }

    public void setConnectionName(String string) {
        this._connName = string != null && string.length() == 0 ? null : string;
        if (this._connName != null) {
            this._updateInfo();
        }
    }

    public void setScriptName(URL uRL) {
        this._scriptName = uRL;
    }

    public URL getScriptName() {
        return this._scriptName;
    }

    private void _clearInfo() {
        this._userName = null;
        this._connString = null;
    }

    private static boolean _isOracleJDBCType(ConnectionDescriptor connectionDescriptor) {
        return connectionDescriptor != null && connectionDescriptor.getConnectionType() != null && (connectionDescriptor.getConnectionType().equals("JDBC") || connectionDescriptor.getConnectionType().equals("ORACLE_JSERVER"));
    }

    private void _updateInfo() {
        this._clearInfo();
        try {
            ConnectionManager connectionManager = ConnectionManager.getInstance();
            ConnectionDescriptor connectionDescriptor = connectionManager.getConnectionDescriptor(this._connName);
            if (SqlPlusInfo._isOracleJDBCType(connectionDescriptor)) {
                this._userName = connectionDescriptor.getUsername();
                this._role = connectionDescriptor.getRole();
                String string = connectionDescriptor.getURL();
                if (string != null) {
                    String string2 = connectionDescriptor.getOracleJdbcType();
                    int n = string.indexOf(64);
                    if (n >= 0) {
                        String string3 = string.substring(n + 1);
                        if ("thin".equals(string2)) {
                            if (string3.startsWith("(")) {
                                this._connString = string;
                            } else if (string3.startsWith("//")) {
                                n = string3.indexOf(47, 2);
                                if (n > 2) {
                                    String string4 = string3.substring(2, n);
                                    String string5 = string3.substring(n + 1);
                                    n = string4.indexOf(58);
                                    if (n > 0) {
                                        Object[] objectArray = new String[]{string4.substring(0, n), string4.substring(n + 1), MessageFormat.format(SERVICE_NAME_PATTERN, string5)};
                                        this._connString = MessageFormat.format(CONNECT_STRING_PATTERN, objectArray);
                                    }
                                }
                            } else if (!string3.startsWith("ldap://")) {
                                this._connString = SqlPlusInfo.namedHostToConnString(string3);
                            }
                        } else {
                            this._connString = string3;
                        }
                    }
                } else {
                    String string6 = connectionDescriptor.getHostname();
                    String string7 = connectionDescriptor.getJdbcPort();
                    String string8 = null;
                    String string9 = connectionDescriptor.getSid();
                    if (string9 != null) {
                        string8 = MessageFormat.format(SID_PATTERN, string9);
                    } else {
                        String string10 = connectionDescriptor.getProperty("ServiceName");
                        if (string10 != null) {
                            string8 = MessageFormat.format(SERVICE_NAME_PATTERN, string10);
                        }
                    }
                    this._connString = string8 != null ? MessageFormat.format(CONNECT_STRING_PATTERN, string6, string7, string8) : null;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String namedHostToConnString(String string) {
        int n = string.indexOf(58);
        int n2 = string.indexOf(58, n + 1);
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1, n2);
        String string4 = string.substring(n2 + 1);
        if (string2 == null || string3 == null || string4 == null) {
            return null;
        }
        return MessageFormat.format(CONNECT_STRING_PATTERN, string2, string3, MessageFormat.format(SID_PATTERN, string4));
    }

    public String getSQLPlusPath() {
        return this._sqlPlusPath;
    }

    public void setSQLPlusPath(String string) {
        this._sqlPlusPath = string != null && string.length() == 0 ? null : string;
    }

    public String getUserName() {
        return this._userName;
    }

    public String getRole() {
        return this._role;
    }

    public String getConnectionString() {
        return this._connString;
    }

    public boolean isComplete() {
        return ModelUtil.hasLength((String)this._userName) && ModelUtil.hasLength((String)this._connString) && ModelUtil.hasLength((String)this._connName);
    }
}

