/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cm.dt.sqlplus;

import java.net.URL;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.IdeSettings;
import oracle.ide.model.Node;
import oracle.jdeveloper.cm.dt.CmUtil;
import oracle.jdeveloper.cm.dt.ConnectionContext;
import oracle.jdeveloper.cm.dt.ConnectionNode;
import oracle.jdevimpl.cm.dt.sqlplus.SqlPlusInfo;
import oracle.jdevimpl.cm.dt.sqlplus.SqlPlusOptions;
import oracle.jdevimpl.cm.dt.sqlplus.SqlPlusRunner;

public final class SqlPlusUtils {
    private SqlPlusUtils() {
    }

    public static String getSqlPlusPath() {
        SqlPlusOptions sqlPlusOptions = SqlPlusUtils.getSqlPlusOptions();
        return sqlPlusOptions != null ? sqlPlusOptions.getSqlPlusPath() : null;
    }

    public static SqlPlusOptions getSqlPlusOptions() {
        try {
            IdeSettings ideSettings = Ide.getSettings();
            SqlPlusOptions sqlPlusOptions = (SqlPlusOptions)((Object)ideSettings.getData("SqlPlusOptions"));
            return sqlPlusOptions;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean canInvokeSqlPlus(Context context) {
        String string = SqlPlusUtils.getConnectionName(context);
        if (string == null) {
            return false;
        }
        SqlPlusInfo sqlPlusInfo = new SqlPlusInfo(SqlPlusUtils.getSqlPlusPath(), string);
        return sqlPlusInfo.isComplete();
    }

    private static String getConnectionName(Context context) {
        if (context == null) {
            return null;
        }
        ConnectionNode connectionNode = ConnectionContext.getConnectionNode(context);
        if (connectionNode != null) {
            return connectionNode.getConnectionName();
        }
        Node node = context.getNode();
        if (node == null) {
            return null;
        }
        URL uRL = node.getURL();
        if (!CmUtil.isCMUrl(uRL)) {
            return null;
        }
        String string = CmUtil.getConnName(uRL);
        return string;
    }

    public static URL getSqlFile(Node node) {
        return node != null ? node.getURL() : null;
    }

    public static boolean invokeSqlPlus(Context context) {
        String string = SqlPlusUtils.getConnectionName(context);
        if (string == null) {
            return false;
        }
        SqlPlusInfo sqlPlusInfo = new SqlPlusInfo(SqlPlusUtils.getSqlPlusPath(), string);
        if (sqlPlusInfo.isComplete()) {
            SqlPlusRunner.runPlus(sqlPlusInfo);
            return true;
        }
        return false;
    }
}

