/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cm.dt.wizards;

import java.lang.ref.WeakReference;
import oracle.ide.Context;
import oracle.ide.wizard.Wizard;
import oracle.javatools.db.Database;
import oracle.jdeveloper.cm.ds.db.DBUtil;
import oracle.jdeveloper.cm.dt.CmUtil;
import oracle.jdeveloper.cm.dt.ConnectionNode;
import oracle.jdeveloper.cm.dt.DatabaseConnectionNode;
import oracle.jdeveloper.cm.dt.browser.ConnectionBrowser;
import oracle.jdeveloper.cm.dt.wizard.DBWizardFactory;
import oracle.jdeveloper.cm.dt.wizard.DBWizardFactoryRegistry;
import oracle.jdevimpl.cm.dt.browser.jdbc.JdbcBrowser;

public abstract class DBWizard
extends Wizard {
    private ContextCache _lastContext;

    void $init$() {
        this._lastContext = new ContextCache(null);
    }

    public abstract String getDBObjectType();

    public boolean isAvailable(Context context) {
        boolean bl = false;
        ConnectionNode connectionNode = CmUtil.getConnectionNode(context);
        if (connectionNode instanceof DatabaseConnectionNode && connectionNode.isOpen()) {
            Boolean bl2 = this._lastContext.isAvailable(context);
            if (bl2 != null) {
                bl = bl2;
            } else {
                ConnectionBrowser connectionBrowser = connectionNode.getConnectionBrowser();
                if (connectionBrowser instanceof JdbcBrowser) {
                    Database database = ((JdbcBrowser)connectionBrowser).getDatabase();
                    DBWizardFactory dBWizardFactory = DBWizardFactoryRegistry.getDBWizardFactory(database);
                    bl = dBWizardFactory != null && dBWizardFactory.canCreateDBObject(context, database, this.getDBObjectType());
                }
                this._lastContext.setAvailable(context, bl);
            }
        }
        return bl;
    }

    public boolean invoke(Context context) {
        boolean bl = false;
        ConnectionNode connectionNode = CmUtil.getConnectionNode(context);
        if (connectionNode != null) {
            connectionNode.ensureOpen();
            ConnectionBrowser connectionBrowser = connectionNode.getConnectionBrowser();
            if (connectionBrowser instanceof JdbcBrowser) {
                Database database = ((JdbcBrowser)connectionBrowser).getDatabase();
                DBWizardFactory dBWizardFactory = DBWizardFactoryRegistry.getDBWizardFactory(database);
                if (dBWizardFactory != null) {
                    bl = dBWizardFactory.createDBObject(context, database, this.getDBObjectType());
                } else {
                    DBWizardFactoryRegistry.showUnsupportedDBError(DBUtil.getDisplayName(this.getDBObjectType()), connectionNode.getShortLabel());
                }
            }
        }
        return bl;
    }

    public DBWizard() {
        this.$init$();
    }

    private static class ContextCache {
        private WeakReference _ref;
        private Boolean _available;

        Boolean isAvailable(Context context) {
            Context context2;
            Context context3 = context2 = this._ref != null ? (Context)this._ref.get() : null;
            if (context2 != null && context2.equals((Object)context)) {
                return this._available;
            }
            return null;
        }

        void setAvailable(Context context, boolean bl) {
            this._ref = new WeakReference<Context>(context);
            this._available = bl;
        }

        private ContextCache() {
        }

        ContextCache(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

