/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cm.dt.wizards.table;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ModelUtil;
import oracle.javatools.db.Column;
import oracle.javatools.db.ColumnConstraint;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.ora.Oracle9iR2;
import oracle.jdeveloper.cm.dt.verifier.table.AbstractColumnInfoVerifier;
import oracle.jdevimpl.cm.dt.wizards.CmWizardsArb;

public class EditColumnInfoVerifier
extends AbstractColumnInfoVerifier {
    private List _colSet;
    private Set _conColSet;

    void $init$() {
        this._colSet = new ArrayList();
        this._conColSet = new HashSet();
    }

    public EditColumnInfoVerifier() {
        this.$init$();
    }

    public void initializeVerifier(DBObjectProvider dBObjectProvider, SchemaObject schemaObject, SchemaObject schemaObject2) {
        super.initializeVerifier(dBObjectProvider, schemaObject, schemaObject2);
        Table table = (Table)schemaObject2;
        Column[] columnArray = table.getColumns();
        int n = 0;
        while (n < columnArray.length) {
            this._colSet.add(columnArray[n]);
            ++n;
        }
        Constraint[] constraintArray = table.getConstraints();
        int n2 = 0;
        while (n2 < constraintArray.length) {
            Constraint constraint = constraintArray[n2];
            if (constraint instanceof ColumnConstraint) {
                Column[] columnArray2 = ((ColumnConstraint)constraint).getColumns();
                int n3 = 0;
                while (n3 < columnArray2.length) {
                    Column column = columnArray2[n3];
                    this._conColSet.add(column);
                    ++n3;
                }
            }
            ++n2;
        }
    }

    public boolean canRemoveColumn(Column column) {
        return this._conColSet.contains(column) ^ true;
    }

    public boolean canMoveColumnUp(Column column) {
        return this.isNewColumn(column);
    }

    public boolean canMoveColumnDown(Column column) {
        return this.isNewColumn(column);
    }

    public boolean canChangeColumnComment(Column column) {
        return this.isNewColumn(column);
    }

    public boolean canChangeColumnDefaultValue(Column column) {
        return this.isNewColumn(column);
    }

    public boolean canChangeColumnNotNullState(Column column) {
        return this.isNewColumn(column);
    }

    public boolean canChangeColumnType(Column column) {
        return this.isNewColumn(column);
    }

    public boolean canChangeColumnSize(Column column) {
        if (!this.isNewColumn(column)) {
            try {
                DataTypeUsage dataTypeUsage = column.getDataTypeUsage();
                DataType dataType = DataTypeHelper.getDataType((DataTypeUsage)dataTypeUsage);
                DataTypeAttribute dataTypeAttribute = dataType.getDataTypeAttribute("size");
                if (dataTypeAttribute != null && dataTypeAttribute.isDeclarable() && !dataTypeAttribute.isMandatory()) {
                    boolean bl = dataTypeUsage.getAttributeValue("size") != null;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        return true;
    }

    public boolean canRenameColumn(Column column) {
        return this.getProvider() instanceof Oracle9iR2;
    }

    private boolean isNewColumn(Column column) {
        return this._colSet.contains(column) ^ true;
    }

    public void verifyColumn(Column column, Column column2) throws TraversalException {
        super.verifyColumn(column, column2);
        if (ModelUtil.areDifferent((Object)column, (Object)column2) && !this.isNewColumn(column)) {
            DataTypeAttribute dataTypeAttribute;
            DataTypeUsage dataTypeUsage = column2.getDataTypeUsage();
            DataTypeUsage dataTypeUsage2 = column.getDataTypeUsage();
            DBObjectID dBObjectID = dataTypeUsage.getDataTypeID();
            DBObjectID dBObjectID2 = dataTypeUsage2.getDataTypeID();
            if (ModelUtil.areDifferent((Object)dBObjectID2, (Object)dBObjectID)) {
                throw new TraversalException(CmWizardsArb.getString(76), CmWizardsArb.getString(75));
            }
            DataType dataType = null;
            try {
                dataType = dBObjectID == null ? null : (DataType)dBObjectID.resolveID();
            }
            catch (DBException dBException) {
                // empty catch block
            }
            if (dataType == null) {
                throw new TraversalException(DBArb.format((int)147, (Object)column2.getName()), DBArb.getString((int)148));
            }
            DataTypeAttribute dataTypeAttribute2 = dataTypeAttribute = dataType.getDataTypeAttribute("precision") == null ? dataType.getDataTypeAttribute("size") : dataType.getDataTypeAttribute("precision");
            if (dataTypeAttribute != null && dataTypeAttribute.isDeclarable()) {
                Long l = DataTypeHelper.getLongAttributeValue((DataTypeUsage)dataTypeUsage2, (String)"precision");
                l = l == null ? DataTypeHelper.getLongAttributeValue((DataTypeUsage)dataTypeUsage2, (String)"size") : l;
                long l2 = l != null ? l : 0L;
                l = DataTypeHelper.getLongAttributeValue((DataTypeUsage)dataTypeUsage, (String)"precision");
                l = l == null ? DataTypeHelper.getLongAttributeValue((DataTypeUsage)dataTypeUsage, (String)"size") : l;
                long l3 = l != null ? l : 0L;
                long l4 = 0L;
                long l5 = 0L;
                DataTypeAttribute dataTypeAttribute3 = dataType.getDataTypeAttribute("scale");
                if (dataTypeAttribute3 != null && dataTypeAttribute3.isDeclarable()) {
                    l = (Long)column.getDataTypeUsage().getAttributeValue("scale");
                    l4 = l == null ? 0L : l;
                    l = (Long)column2.getDataTypeUsage().getAttributeValue("scale");
                    long l6 = l5 = l == null ? 0L : l;
                }
                if (l2 > l3) {
                    throw new TraversalException(CmWizardsArb.getString(74), CmWizardsArb.getString(75));
                }
                if (l4 > l5) {
                    throw new TraversalException(CmWizardsArb.getString(77), CmWizardsArb.getString(75));
                }
                if (l2 - l4 > l3 - l5) {
                    throw new TraversalException(CmWizardsArb.getString(78), CmWizardsArb.getString(75));
                }
            }
        }
    }
}

