/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cm.dt.wizards.table;

import oracle.ide.Context;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.CommitListener;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.Database;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.jdeveloper.cm.dt.ui.OracleDBWizardFactory;
import oracle.jdeveloper.cm.dt.ui.table.TableInfoPanel;
import oracle.jdeveloper.cm.dt.verifier.table.AbstractIndexInfoVerifier;
import oracle.jdeveloper.cm.dt.wizard.SchemaObjectFinishPanel;
import oracle.jdeveloper.cm.dt.wizard.table.TableWizardLauncher;
import oracle.jdevimpl.cm.dt.wizards.CmWizardsArb;
import oracle.jdevimpl.cm.dt.wizards.table.CreationColumnInfoVerifier;
import oracle.jdevimpl.cm.dt.wizards.table.CreationConstraintsInfoVerifier;
import oracle.jdevimpl.cm.dt.wizards.table.CreationStorageInfoVerifier;
import oracle.jdevimpl.cm.dt.wizards.table.CreationTableInfoVerifier;
import oracle.jdevimpl.cm.dt.wizards.table.TablePanelLibrary;

public class OracleTableWizardLauncher
extends TableWizardLauncher {
    public static final String HELP_WELCOME = "f1_bdbwcreatetablewelcome_html";
    public static final String HELP_TABLE_INFO = "f1_bdbwcreatetabletablename_html";
    public static final String HELP_COLUMN = "f1_bdbwcreatetablecolumns_html";
    public static final String HELP_PK = "f1_bdbwcreateprimarykey_html";
    public static final String HELP_UK = "f1_bdbwcreatetableuniqueconstraints_html";
    public static final String HELP_FK = "f1_bdbwcreatetableforeignkey_html";
    public static final String HELP_CHECK = "f1_bdbwcreatetablecheckconstraints_html";
    public static final String HELP_INDEX = "f1_bdbwcreatetableindexes_html";
    public static final String HELP_ORA_STORAGE = "f1_bdbwcreatetablestorageoptions_html";
    public static final String HELP_EXT_TABLE = "f1_bdbwcreatetableexternaloptions_html";
    public static final String HELP_IOT = "f1_bdbwcreatetableiotoptions_html";
    public static final String HELP_PARTITION = "f1_bdbwcreatetablepartitionoptions_html";
    public static final String HELP_PARTITION_DEF = "f1_bdbwcreatetablepartitiondefinitions_html";
    public static final String HELP_SUBPARTITION_TEMP = "f1_bdbwcreatetablesubpartitiontemplates_html";
    public static final String HELP_FINISH = "f1_bdbwcreatetablefinish_html";
    private static final String WELCOME_KEY = "OracleTableWizardKey";

    public OracleTableWizardLauncher(Context context, OracleDatabase oracleDatabase) {
        super(context, (Database)oracleDatabase, CmWizardsArb.getString(11));
        Table table = (Table)this.get("NewObject");
        table.setProperty("OracleStorageProperties", (Object)new OracleStorageProperties());
        this.put("Tablespaces", oracleDatabase.listTablespaces());
        this.put("DDlGenerator", oracleDatabase.getDDLGenerator());
        this.registerVerifier("TableInfoVerifier", CreationTableInfoVerifier.class);
        this.registerVerifier("ColumnInfoVerifier", CreationColumnInfoVerifier.class);
        this.registerVerifier("ConstraintsInfoVerifier", CreationConstraintsInfoVerifier.class);
        this.registerVerifier("IndexVerifier", AbstractIndexInfoVerifier.class);
        this.registerVerifier("StorageInfoVerifier", CreationStorageInfoVerifier.class);
        this.put("PANEL_LIBRARY", new TablePanelLibrary());
        this.addWelcomePage(CmWizardsArb.getString(15), CmWizardsArb.getString(16), WELCOME_KEY, HELP_WELCOME);
        this.addPage(TableInfoPanel.class.getName(), HELP_TABLE_INFO, CmWizardsArb.getString(19));
        this.addFinishPage(SchemaObjectFinishPanel.class.getName(), HELP_FINISH, CmWizardsArb.getString(174));
        this.addCommitListener(new TableCommitListener(null));
    }

    public boolean runWizardImpl() {
        return super.runGenericWizard();
    }

    private static class TableCommitListener
    implements CommitListener {
        public void checkCommit(ApplyEvent applyEvent) {
        }

        public void rollback(ApplyEvent applyEvent) {
        }

        public void cancel(ApplyEvent applyEvent) {
        }

        public void commit(ApplyEvent applyEvent) throws TraversalException {
            OracleDBWizardFactory.createOracleObject(applyEvent.getTraversableContext(), "NewObject", CmWizardsArb.getString(13), CmWizardsArb.getString(14));
        }

        private TableCommitListener() {
        }

        TableCommitListener(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

