/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cm.dt.wizards.table;

import oracle.ide.Context;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.ora.OracleDDLGenerator;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.jdeveloper.cm.ds.db.DBUtil;
import oracle.jdeveloper.cm.dt.ui.TabbedDialogLauncher;
import oracle.jdeveloper.cm.dt.ui.table.CheckConstraintsPanel;
import oracle.jdeveloper.cm.dt.ui.table.ColumnInfoPanel;
import oracle.jdeveloper.cm.dt.ui.table.FKConstraintsPanel;
import oracle.jdeveloper.cm.dt.ui.table.IndexPanel;
import oracle.jdeveloper.cm.dt.ui.table.PKConstraintPanel;
import oracle.jdeveloper.cm.dt.ui.table.StorageInfoPanel;
import oracle.jdeveloper.cm.dt.ui.table.UniqueConstraintsPanel;
import oracle.jdeveloper.cm.dt.verifier.table.AbstractIndexInfoVerifier;
import oracle.jdeveloper.cm.dt.wizard.DBWizardLauncher;
import oracle.jdevimpl.cm.dt.wizards.CmWizardsArb;
import oracle.jdevimpl.cm.dt.wizards.table.CreationColumnInfoVerifier;
import oracle.jdevimpl.cm.dt.wizards.table.CreationConstraintsInfoVerifier;
import oracle.jdevimpl.cm.dt.wizards.table.CreationStorageInfoVerifier;
import oracle.jdevimpl.cm.dt.wizards.table.CreationTableInfoVerifier;
import oracle.jdevimpl.cm.dt.wizards.table.EditColumnInfoVerifier;
import oracle.jdevimpl.cm.dt.wizards.table.EditConstraintInfoVerifier;
import oracle.jdevimpl.cm.dt.wizards.table.EditIndexInfoVerifier;
import oracle.jdevimpl.cm.dt.wizards.table.EditStorageInfoVerifier;
import oracle.jdevimpl.cm.dt.wizards.table.EditTableInfoVerifier;

public class TabbedOracleTableLauncher
extends TabbedDialogLauncher {
    public TabbedOracleTableLauncher(OracleDatabase oracleDatabase, Schema schema) {
        super((Database)oracleDatabase, schema);
        this.put("Tablespaces", oracleDatabase.listTablespaces());
        this.put("DDlGenerator", new OracleDDLGenerator((DBObjectProvider)oracleDatabase));
        this.addTab(ColumnInfoPanel.class, "f1_bdbwcreatetablecolumns_html", CmWizardsArb.getString(41));
        this.addTab(PKConstraintPanel.class, "f1_bdbwcreateprimarykey_html", CmWizardsArb.getString(115));
        this.addTab(UniqueConstraintsPanel.class, "f1_bdbwcreatetableuniqueconstraints_html", CmWizardsArb.getString(116));
        this.addTab(FKConstraintsPanel.class, "f1_bdbwcreatetableforeignkey_html", CmWizardsArb.getString(101));
        this.addTab(CheckConstraintsPanel.class, "f1_bdbwcreatetablecheckconstraints_html", CmWizardsArb.getString(98));
        this.addTab(IndexPanel.class, "f1_bdbwcreatetableindexes_html", CmWizardsArb.getString(388));
        this.addTab(StorageInfoPanel.class, "f1_bdbwcreatetablestorageoptions_html", CmWizardsArb.getString(147));
    }

    public boolean createObject() {
        Schema schema = this.getSchema();
        DBObjectProvider dBObjectProvider = this.getProvider();
        Table table = new Table(dBObjectProvider.getUniqueName("TABLE", (DBObject)schema, null), schema);
        table.setID(TemporaryObjectID.createID((DBObject)table));
        this.put("NewObject", table);
        this.put("OriginalObject", null);
        table.setProperty("OracleStorageProperties", (Object)new OracleStorageProperties());
        this.registerVerifier("SchemaObjectInfoVerifier", CreationTableInfoVerifier.class);
        this.registerVerifier("TableInfoVerifier", CreationTableInfoVerifier.class);
        this.registerVerifier("ColumnInfoVerifier", CreationColumnInfoVerifier.class);
        this.registerVerifier("ConstraintsInfoVerifier", CreationConstraintsInfoVerifier.class);
        this.registerVerifier("IndexVerifier", AbstractIndexInfoVerifier.class);
        this.registerVerifier("StorageInfoVerifier", CreationStorageInfoVerifier.class);
        this.addTab(TabbedDialogLauncher.CreateSQLTab.class, null, "SQL");
        return this.createObjectImpl();
    }

    public boolean editObject(SchemaObject schemaObject) {
        SchemaObject schemaObject2 = (SchemaObject)DBUtil.makeTemporaryCopy((DBObject)schemaObject);
        this.put("NewObject", schemaObject);
        this.put("OriginalObject", schemaObject2);
        this.registerVerifier("SchemaObjectInfoVerifier", EditTableInfoVerifier.class);
        this.registerVerifier("TableInfoVerifier", EditTableInfoVerifier.class);
        this.registerVerifier("ColumnInfoVerifier", EditColumnInfoVerifier.class);
        this.registerVerifier("ConstraintsInfoVerifier", EditConstraintInfoVerifier.class);
        this.registerVerifier("IndexVerifier", EditIndexInfoVerifier.class);
        this.registerVerifier("StorageInfoVerifier", EditStorageInfoVerifier.class);
        this.addTab(TabbedDialogLauncher.EditSQLTab.class, null, "SQL");
        return this.createObjectImpl();
    }

    public static boolean createTable(Context context, OracleDatabase oracleDatabase) {
        try {
            Schema schema = DBWizardLauncher.determineSchema(context, (Database)oracleDatabase);
            TabbedOracleTableLauncher tabbedOracleTableLauncher = new TabbedOracleTableLauncher(oracleDatabase, schema);
            boolean bl = tabbedOracleTableLauncher.createObject();
            return bl;
        }
        catch (DBException dBException) {
            return false;
        }
    }

    public static boolean editTable(OracleDatabase oracleDatabase, Table table) {
        TabbedOracleTableLauncher tabbedOracleTableLauncher = new TabbedOracleTableLauncher(oracleDatabase, table.getSchema());
        return tabbedOracleTableLauncher.editObject((SchemaObject)table);
    }
}

