/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cm.dt.wizards.trigger;

import java.util.List;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ModelUtil;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Trigger;
import oracle.jdeveloper.cm.dt.verifier.AbstractSchemaObjectVerifier;
import oracle.jdeveloper.cm.dt.verifier.SchemaObjectInfoVerifier;
import oracle.jdeveloper.cm.dt.verifier.trigger.TriggerVerifier;
import oracle.jdevimpl.cm.dt.wizards.CmWizardsArb;

public class CreateTriggerVerifier
extends AbstractSchemaObjectVerifier
implements SchemaObjectInfoVerifier,
TriggerVerifier {
    private DBObjectProvider _prov;
    private Trigger _trigger;
    private boolean canChangeSchema;

    public void verifyTrigger(boolean bl) throws TraversalException {
        Schema schema = this._trigger.getSchema();
        if (schema == null) {
            throw new TraversalException(CmWizardsArb.getString(228), CmWizardsArb.getString(227), null);
        }
        Schema schema2 = this._trigger.getTableOwner();
        switch (this._trigger.getBaseType()) {
            case 0: 
            case 1: {
                if (schema2 == null) {
                    throw new TraversalException(CmWizardsArb.getString(233), CmWizardsArb.getString(227), null);
                }
                String string = this._trigger.getTableName();
                if (ModelUtil.hasLength((String)string)) break;
                throw new TraversalException(CmWizardsArb.getString(232), CmWizardsArb.getString(227), null);
            }
            case 2: {
                if (schema2 != null) break;
                throw new TraversalException(CmWizardsArb.getString(235), CmWizardsArb.getString(227), null);
            }
        }
        List list = this._trigger.getEvents();
        if (list.size() == 0) {
            throw new TraversalException(CmWizardsArb.getString(234), CmWizardsArb.getString(227), null);
        }
    }

    public void initializeVerifier(DBObjectProvider dBObjectProvider, SchemaObject schemaObject, SchemaObject schemaObject2) {
        super.initializeVerifier(dBObjectProvider, schemaObject, schemaObject2);
        this._prov = dBObjectProvider;
        this._trigger = (Trigger)schemaObject2;
        Schema schema = this._trigger.getSchema();
        Schema schema2 = null;
        try {
            Schema[] schemaArray = dBObjectProvider.listSchemas();
            int n = 0;
            while (n < schemaArray.length) {
                Schema schema3 = schemaArray[n];
                if (ModelUtil.areDifferent((Object)schema3, (Object)schema)) {
                    schema2 = schema3;
                    break;
                }
                ++n;
            }
        }
        catch (DBException dBException) {
            // empty catch block
        }
        this.canChangeSchema = schema2 != null ? dBObjectProvider.hasPriviledge("TRIGGER", schema2, "CREATE") : false;
    }

    public void verifyName(String string) throws TraversalException {
        if (!this._prov.isValidName("TRIGGER", string)) {
            throw new TraversalException(CmWizardsArb.format(236, string), CmWizardsArb.getString(227), null);
        }
    }

    public boolean canChangeName() {
        return true;
    }

    public boolean canChangeSchema() {
        return this.canChangeSchema;
    }

    public boolean canCreateSchema() {
        return false;
    }

    public void verifySchemaName(String string) throws TraversalException {
    }

    public void verifyObject() throws TraversalException {
    }
}

