/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cm.dt.wizards.trigger;

import oracle.ide.Context;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.Trigger;
import oracle.javatools.db.View;
import oracle.javatools.db.ora.OracleDDLGenerator;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.jdeveloper.cm.dt.ui.TabbedDialogLauncher;
import oracle.jdeveloper.cm.dt.wizard.DBWizardLauncher;
import oracle.jdevimpl.cm.dt.wizards.CmWizardsArb;
import oracle.jdevimpl.cm.dt.wizards.trigger.CreateTriggerVerifier;
import oracle.jdevimpl.cm.dt.wizards.trigger.TriggerPanel;

public class OracleTriggerLauncher
extends TabbedDialogLauncher {
    public OracleTriggerLauncher(Database database, Schema schema, Object object) {
        super(database, schema);
        this.put("ParentObject", object);
        this.put("DDlGenerator", new OracleDDLGenerator((DBObjectProvider)database));
    }

    public boolean createObject() {
        Trigger trigger = null;
        Schema schema = this.getSchema();
        DBObjectProvider dBObjectProvider = this.getProvider();
        String string = dBObjectProvider.getUniqueName("TRIGGER", (DBObject)schema, null);
        trigger = new Trigger(schema, string);
        Object object = this.find("ParentObject");
        if (object instanceof Table) {
            Table table = (Table)object;
            trigger.setBaseType(0);
            trigger.setTableOwner(table.getSchema());
            trigger.setTableName(table.getName());
        } else if (object instanceof View) {
            View view = (View)object;
            trigger.setBaseType(1);
            trigger.setTableOwner(view.getSchema());
            trigger.setTableName(view.getName());
        } else if (object instanceof Schema) {
            trigger.setBaseType(2);
            trigger.setTableOwner((Schema)object);
        }
        this.put("NewObject", trigger);
        this.registerVerifier("SchemaObjectInfoVerifier", CreateTriggerVerifier.class);
        this.registerVerifier("TriggerVerifier", CreateTriggerVerifier.class);
        this.addTab(TriggerPanel.class, "f1_bdbdcreatetrigger_html", "Trigger");
        this.addTab(TabbedDialogLauncher.CreateSQLTab.class, "f1_bdbwcreatetablefinish_html", CmWizardsArb.getString(183));
        this.setTitle(CmWizardsArb.getString(205));
        return this.createObjectImpl();
    }

    public boolean editObject(SchemaObject schemaObject) {
        return false;
    }

    public static boolean createTrigger(Context context, OracleDatabase oracleDatabase) {
        try {
            Schema schema = DBWizardLauncher.determineSchema(context, (Database)oracleDatabase);
            OracleTriggerLauncher oracleTriggerLauncher = new OracleTriggerLauncher((Database)oracleDatabase, schema, context.getProperty("ParentObject"));
            boolean bl = oracleTriggerLauncher.createObject();
            return bl;
        }
        catch (DBException dBException) {
            return false;
        }
    }
}

