/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cm.dt.wizards.view;

import oracle.ide.Context;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.CommitListener;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.View;
import oracle.javatools.db.ora.OracleDDLGenerator;
import oracle.javatools.db.ora.OracleSQLQuery;
import oracle.javatools.db.sql.SQLQuery;
import oracle.jdeveloper.cm.dt.ui.OracleDBWizardFactory;
import oracle.jdeveloper.cm.dt.ui.view.ViewChoicePanel;
import oracle.jdeveloper.cm.dt.ui.view.ViewInfoPanel;
import oracle.jdeveloper.cm.dt.wizard.DBWizardLauncher;
import oracle.jdeveloper.cm.dt.wizard.SchemaObjectFinishPanel;
import oracle.jdevimpl.cm.dt.wizards.CmWizardsArb;
import oracle.jdevimpl.cm.dt.wizards.view.CreateViewVerifier;

public class OracleViewWizardLauncher
extends DBWizardLauncher {
    private static final String WELCOME_KEY = "OracleViewWizardKey";
    public static final String HELP_WELCOME = "f1_dbviewwizardwelcome_html";
    public static final String HELP_VIEW_INFO = "f1_dbviewwizardviewinfo_html";
    public static final String HELP_VIEW_CHOICE = "f1_dbviewwizardviewcreation_html";
    public static final String HELP_MANUAL_QUERY = "f1_dbviewwizardentiresqlquery_html";
    public static final String HELP_FINISH = "f1_dbviewwizardfinish_html";

    public OracleViewWizardLauncher(Context context, Database database) {
        super(context, database, CmWizardsArb.getString(185));
        this.setShowStepNumber(true);
        this.registerVerifier("ViewInfoVerifier", CreateViewVerifier.class);
        Schema schema = (Schema)this.find("Schema");
        View view = new View(database.getUniqueName("VIEW", (DBObject)schema, null), schema);
        view.setSQLQuery((SQLQuery)new OracleSQLQuery());
        view.setID(TemporaryObjectID.createID((DBObject)view));
        this.put("NewObject", view);
        this.put("OriginalObject", null);
        this.put("DDlGenerator", new OracleDDLGenerator((DBObjectProvider)database));
        this.addWelcomePage(CmWizardsArb.getString(189), CmWizardsArb.getString(190), WELCOME_KEY, HELP_WELCOME);
        this.addPage(ViewInfoPanel.class.getName(), HELP_VIEW_INFO, CmWizardsArb.getString(285));
        this.addPage(ViewChoicePanel.class.getName(), HELP_VIEW_CHOICE, CmWizardsArb.getString(295));
        this.addFinishPage(SchemaObjectFinishPanel.class.getName(), HELP_FINISH, CmWizardsArb.getString(174));
        this.addCommitListener(new ViewCommitListener(null));
    }

    public boolean runWizardImpl() {
        return super.runGenericWizard();
    }

    private static class ViewCommitListener
    implements CommitListener {
        public void checkCommit(ApplyEvent applyEvent) {
        }

        public void rollback(ApplyEvent applyEvent) {
        }

        public void cancel(ApplyEvent applyEvent) {
        }

        public void commit(ApplyEvent applyEvent) throws TraversalException {
            OracleDBWizardFactory.createOracleObject(applyEvent.getTraversableContext(), "NewObject", CmWizardsArb.getString(187), CmWizardsArb.getString(188));
        }

        private ViewCommitListener() {
        }

        ViewCommitListener(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

