/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.probe;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.ide.log.MessagePage;
import oracle.javatools.db.Database;
import oracle.javatools.db.PlSql;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SpecPlSql;
import oracle.jdeveloper.cm.ds.db.DBUtil;
import oracle.jdevimpl.debugger.probe.DebugProbeArb;
import oracle.jdevimpl.debugger.probe.DebugProbeArrayElementInfo;
import oracle.jdevimpl.debugger.probe.DebugProbeBackTrace;
import oracle.jdevimpl.debugger.probe.DebugProbeBreakpoint;
import oracle.jdevimpl.debugger.probe.DebugProbeBreakpointException;
import oracle.jdevimpl.debugger.probe.DebugProbeBreakpointPackageFileLine;
import oracle.jdevimpl.debugger.probe.DebugProbeClassInfo;
import oracle.jdevimpl.debugger.probe.DebugProbeClassLoaderInfo;
import oracle.jdevimpl.debugger.probe.DebugProbeDataArrayInfo;
import oracle.jdevimpl.debugger.probe.DebugProbeDataInfo;
import oracle.jdevimpl.debugger.probe.DebugProbeFieldInfo;
import oracle.jdevimpl.debugger.probe.DebugProbeLocation;
import oracle.jdevimpl.debugger.probe.DebugProbeRuntimeInfo;
import oracle.jdevimpl.debugger.probe.DebugProbeStackFrameInfo;
import oracle.jdevimpl.debugger.probe.DebugProbeThreadGroupInfo;
import oracle.jdevimpl.debugger.probe.DebugProbeThreadInfo;
import oracle.jdevimpl.debugger.probe.DebugProbeValue;
import oracle.jdevimpl.debugger.probe.DebugProbeVariableInfo;
import oracle.jdevimpl.debugger.shared.DebugEventMulticaster;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.support.DebugBreakpoint;
import oracle.jdevimpl.debugger.support.DebugBreakpointAllocationClass;
import oracle.jdevimpl.debugger.support.DebugBreakpointAllocationThreshold;
import oracle.jdevimpl.debugger.support.DebugBreakpointClass;
import oracle.jdevimpl.debugger.support.DebugBreakpointClassLoad;
import oracle.jdevimpl.debugger.support.DebugBreakpointDeadlock;
import oracle.jdevimpl.debugger.support.DebugBreakpointException;
import oracle.jdevimpl.debugger.support.DebugBreakpointFileLine;
import oracle.jdevimpl.debugger.support.DebugBreakpointLogListener;
import oracle.jdevimpl.debugger.support.DebugBreakpointMethod;
import oracle.jdevimpl.debugger.support.DebugBreakpointMethodBytecode;
import oracle.jdevimpl.debugger.support.DebugBreakpointPackageFileLine;
import oracle.jdevimpl.debugger.support.DebugBreakpointWatchpoint;
import oracle.jdevimpl.debugger.support.DebugCapabilities;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugClassLoaderInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugFieldInfo;
import oracle.jdevimpl.debugger.support.DebugHeapInfo;
import oracle.jdevimpl.debugger.support.DebugHeapObjectInfo;
import oracle.jdevimpl.debugger.support.DebugHeapSubset;
import oracle.jdevimpl.debugger.support.DebugListener;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugMonitorInfo;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugThreadGroupInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;

public final class DebugProbe
implements Runnable,
DebugCapabilities,
DebugVirtualMachine {
    private Database db;
    int major;
    int minor;
    private String debuggerSessionId;
    private String debuggeeSessionId;
    int stoppedCount;
    private DebugProbeRuntimeInfo runtimeInfo;
    private DebugProbeBackTrace backTrace;
    private DebugProbeThreadGroupInfo mainThreadGroup;
    private DebugProbeThreadInfo mainThread;
    private List breakpoints;
    private DebugProbeBreakpoint currentBreakpoint;
    private List classes;
    private Map classesByName;
    private Map classesByNameWithoutPackage;
    private Map locationClassesByName;
    private Map primitiveClassesByName;
    private Map arrayClassesByName;
    DebugProbeClassLoaderInfo bootstrapClassLoaderInfo;
    DebugProbeClassInfo unknownClass;
    private String runCommand;
    private int timeout;
    private static int MIN_TIMEOUT = 1;
    private static int BIG_TIMEOUT = 60;
    private Thread runningThread;
    private List afterSynchronize;
    private Object[] syncObjects;
    private boolean[] syncValues;
    private static final int SYNC_NEED_SYNC = 0;
    private static final int SYNC_STOPPED = 1;
    private static final int SYNC_TERMINATED = 2;
    private static final int SYNC_TERMINATE_REQUESTED = 3;
    private static final int SYNC_COUNT = 4;
    DebugListener debugListener;
    private DebugBreakpointLogListener bpLogListener;
    static final int error_success = 0;
    static final int error_no_debug_info = 2;
    static final int error_no_such_object = 3;
    static final int error_value_malformed = 7;
    static final int error_indexed_table = 18;
    static final int error_illegal_index = 19;
    static final int error_timeout = 31;
    static final int error_nullvalue = 32;
    private static final String RunCommand_Run = "0";
    private static final String RunCommand_StepInto = "DBMS_DEBUG.break_any_call";
    private static final String RunCommand_StepOver = "DBMS_DEBUG.break_next_line";
    private static final String RunCommand_StepOut = "DBMS_DEBUG.break_any_return";

    DebugProbe(Database database, int n, int n2, String string) {
        this.initSync();
        this.db = database;
        this.major = n;
        this.minor = n2;
        this.debuggerSessionId = string;
        this.stoppedCount = 0;
        this.runtimeInfo = new DebugProbeRuntimeInfo(this);
        this.backTrace = new DebugProbeBackTrace(this);
        this.mainThreadGroup = new DebugProbeThreadGroupInfo(this, "main");
        this.mainThread = new DebugProbeThreadInfo(this, this.mainThreadGroup, "main");
        this.breakpoints = new ArrayList();
        this.classes = new ArrayList();
        this.classesByName = new HashMap();
        this.classesByNameWithoutPackage = new HashMap();
        this.locationClassesByName = new HashMap();
        this.primitiveClassesByName = new HashMap();
        this.arrayClassesByName = new HashMap();
        this.unknownClass = DebugProbeClassInfo.makePrimitiveClass(this, DebugProbeArb.getString(5));
        this.addBuiltInClass("BOOLEAN");
        this.addBuiltInClass("NUMBER");
        this.addBuiltInClass("PLS_INTEGER");
        this.addBuiltInClass("VARCHAR");
        this.addBuiltInClass("UNKNOWN");
        this.afterSynchronize = new ArrayList();
        this.afterSynchronize.add(new 2());
        this.setSyncValue(0, true);
        this.setTimeout(BIG_TIMEOUT);
    }

    public void afterConnection(MessagePage messagePage) {
    }

    public synchronized void addDebugListener(DebugListener debugListener) {
        this.debugListener = DebugEventMulticaster.add((DebugListener)this.debugListener, (DebugListener)debugListener);
    }

    public synchronized void removeDebugListener(DebugListener debugListener) {
        this.debugListener = DebugEventMulticaster.remove((DebugListener)this.debugListener, (DebugListener)debugListener);
    }

    public synchronized void addBreakpointLogListener(DebugBreakpointLogListener debugBreakpointLogListener) {
        this.bpLogListener = DebugEventMulticaster.add((DebugBreakpointLogListener)this.bpLogListener, (DebugBreakpointLogListener)debugBreakpointLogListener);
    }

    public synchronized void removeBreakpointLogListener(DebugBreakpointLogListener debugBreakpointLogListener) {
        this.bpLogListener = DebugEventMulticaster.remove((DebugBreakpointLogListener)this.bpLogListener, (DebugBreakpointLogListener)debugBreakpointLogListener);
    }

    public boolean wasRunning() {
        return false;
    }

    public synchronized void disconnect() {
        this.disconnect(true);
    }

    public synchronized void disconnect(boolean bl) {
        if (bl) {
            this.setSyncValue(3, true);
            if (!this.isRunning()) {
                this.doRunCommand(RunCommand_Run);
            }
        } else {
            throw new UnsupportedOperationException("Disconnect without terminating is not allowed");
        }
    }

    private synchronized void detach() {
        this.callDetachSession();
        this.db.close();
        this.incrementStoppedCount();
        this.db = null;
    }

    public boolean isConnected() {
        return this.db != null;
    }

    public boolean isStopped() {
        return this.getSyncValue(1);
    }

    public boolean isRunning() {
        return this.runningThread != null;
    }

    public boolean isTerminated() {
        return this.getSyncValue(2);
    }

    public void setNonDebuggablePackages(String string) {
    }

    public void setDebuggablePackages(String string, String string2) {
    }

    public void requestCodeCoverage(String string, String string2) {
    }

    public void unrequestCodeCoverage(String string, String string2) {
    }

    public void discardCodeCoverage() {
    }

    public synchronized DebugBreakpointPackageFileLine putBreakpointPackageFileLine(String string, String string2, int n) {
        DebugProbeBreakpointPackageFileLine debugProbeBreakpointPackageFileLine = new DebugProbeBreakpointPackageFileLine(this, string, string2, n);
        this.addBreakpoint(debugProbeBreakpointPackageFileLine);
        return debugProbeBreakpointPackageFileLine;
    }

    public synchronized DebugBreakpointFileLine putBreakpointFileLine(String string, int n) {
        return null;
    }

    public synchronized DebugBreakpointMethodBytecode putBreakpointMethodBytecode(String string, int n) {
        return null;
    }

    public synchronized DebugBreakpointMethod putBreakpointMethod(String string) {
        return null;
    }

    public synchronized DebugBreakpointClass putBreakpointClass(String string) {
        return null;
    }

    public synchronized DebugBreakpointException putBreakpointException(String string) {
        return this.putBreakpointException(string, true, true);
    }

    public synchronized DebugBreakpointException putBreakpointException(String string, boolean bl, boolean bl2) {
        if (this.checkVersion(2, 4)) {
            DebugProbeBreakpointException debugProbeBreakpointException = new DebugProbeBreakpointException(this, string, bl, bl2);
            this.addBreakpoint(debugProbeBreakpointException);
            return debugProbeBreakpointException;
        }
        return null;
    }

    public synchronized DebugBreakpointClassLoad putBreakpointClassLoad(String string) {
        return null;
    }

    public synchronized DebugBreakpointAllocationThreshold putBreakpointAllocationThreshold(int n) {
        return null;
    }

    public synchronized DebugBreakpointAllocationClass putBreakpointAllocationClass(String string) {
        return null;
    }

    public synchronized DebugBreakpointDeadlock putBreakpointDeadlock() {
        return null;
    }

    public synchronized DebugBreakpointWatchpoint putBreakpointWatchpoint(String string, String string2, boolean bl, boolean bl2) {
        return null;
    }

    public synchronized void removeAllBreakpoints() {
        int n = this.breakpoints.size() - 1;
        while (n >= 0) {
            DebugProbeBreakpoint debugProbeBreakpoint = (DebugProbeBreakpoint)this.breakpoints.get(n);
            debugProbeBreakpoint.prepareForChange();
            --n;
        }
        this.breakpoints.clear();
    }

    private void addBreakpoint(DebugProbeBreakpoint debugProbeBreakpoint) {
        this.breakpoints.add(debugProbeBreakpoint);
        if (!this.getSyncValue(0)) {
            this.putBreakpoint(debugProbeBreakpoint);
        } else {
            this.afterSynchronize.add(new 1(this, debugProbeBreakpoint));
        }
    }

    synchronized void putBreakpoint(DebugProbeBreakpoint debugProbeBreakpoint) {
        if (debugProbeBreakpoint instanceof DebugProbeBreakpointPackageFileLine) {
            int n;
            DebugProbeBreakpointPackageFileLine debugProbeBreakpointPackageFileLine = (DebugProbeBreakpointPackageFileLine)debugProbeBreakpoint;
            DebugProbeLocation debugProbeLocation = DebugProbeLocation.makeLocation(this, debugProbeBreakpointPackageFileLine.getPackage(), debugProbeBreakpointPackageFileLine.getFilename(), debugProbeBreakpointPackageFileLine.getLine());
            if (debugProbeLocation != null && (n = this.callSetBreakpoint(debugProbeLocation)) != -1) {
                debugProbeBreakpointPackageFileLine.verified(n, debugProbeLocation);
                if (!debugProbeBreakpointPackageFileLine.getEnabled()) {
                    this.callDisableBreakpoint(n);
                }
                if (this.debugListener != null) {
                    this.debugListener.breakpointChanged((DebugBreakpoint)debugProbeBreakpointPackageFileLine);
                }
            }
        } else if (debugProbeBreakpoint instanceof DebugProbeBreakpointException) {
            // empty if block
        }
    }

    synchronized boolean removeBreakpoint(DebugProbeBreakpoint debugProbeBreakpoint) {
        if (this.breakpoints.indexOf(debugProbeBreakpoint) != -1) {
            this.breakpoints.remove(debugProbeBreakpoint);
            return true;
        }
        return false;
    }

    public synchronized void resume() {
        this.doRunCommand(RunCommand_Run);
    }

    public synchronized boolean didStepFinish() {
        return true;
    }

    public synchronized void continueStep() {
        this.doRunCommand(RunCommand_Run);
    }

    public synchronized void start(boolean bl) {
        this.doRunCommand(bl ? RunCommand_StepOver : RunCommand_StepInto);
    }

    public synchronized void setPauseInterval(int n) {
    }

    public synchronized void pauseProgram() {
    }

    public void cancelPauseProgram() {
    }

    public synchronized int getCurrentStatus() {
        if (this.currentBreakpoint instanceof DebugProbeBreakpointPackageFileLine) {
            return 1;
        }
        if (this.currentBreakpoint instanceof DebugProbeBreakpointException) {
            return 1;
        }
        return 0;
    }

    public synchronized DebugBreakpoint getCurrentBreakpoint() {
        return this.currentBreakpoint;
    }

    public synchronized DebugThreadInfo getCurrentThread() {
        return this.mainThread;
    }

    public synchronized DebugDataObjectInfo getCurrentThrow() {
        return null;
    }

    public synchronized boolean isCurrentThrowHandled() {
        return false;
    }

    public synchronized DebugLocation getCurrentThrowHandler() {
        return null;
    }

    public DebugDataObjectInfo getWatchpointObject() {
        return null;
    }

    public DebugFieldInfo getWatchpointField() {
        return null;
    }

    public DebugDataInfo getWatchpointFieldFutureValue() {
        return null;
    }

    public synchronized DebugThreadInfo[][] getDeadlockedThreads() {
        return new DebugThreadInfo[0][];
    }

    public synchronized DebugThreadGroupInfo[] listTopThreadGroups() {
        DebugThreadGroupInfo[] debugThreadGroupInfoArray = new DebugThreadGroupInfo[]{this.mainThreadGroup};
        return debugThreadGroupInfoArray;
    }

    public synchronized DebugThreadGroupInfo[] listAllThreadGroups() {
        return this.listTopThreadGroups();
    }

    public synchronized DebugThreadInfo[] listThreads() {
        DebugThreadInfo[] debugThreadInfoArray = new DebugThreadInfo[]{this.mainThread};
        return debugThreadInfoArray;
    }

    public synchronized DebugMonitorInfo[] listMonitorsInUse() {
        return new DebugMonitorInfo[0];
    }

    public synchronized DebugThreadInfo[] listWaitingThreads() {
        return new DebugThreadInfo[0];
    }

    public synchronized DebugThreadInfo[] listBlockedThreads() {
        return new DebugThreadInfo[0];
    }

    public synchronized DebugClassInfo[] listClasses() {
        return this.listClasses(false);
    }

    public DebugClassInfo[] listClasses(boolean bl) {
        return this.classes.toArray(new DebugClassInfo[this.classes.size()]);
    }

    public synchronized int countClasses() {
        return this.classes.size();
    }

    public DebugClassInfo findFirstClassByName(String string) {
        return this.findFirstClassByName(string, false);
    }

    public DebugClassInfo findFirstClassByName(String string, boolean bl) {
        return DebugShared.getFirstClass((Map)(bl ? this.classesByNameWithoutPackage : this.classesByName), (String)string);
    }

    public DebugClassLoaderInfo[] listClassLoaders() {
        DebugClassLoaderInfo[] debugClassLoaderInfoArray = new DebugClassLoaderInfo[]{DebugProbeClassLoaderInfo.makeClassLoaderInfo(this)};
        return debugClassLoaderInfoArray;
    }

    public synchronized int countHeap(DebugHeapSubset debugHeapSubset) {
        return 0;
    }

    public synchronized DebugHeapInfo getHeap(DebugHeapSubset debugHeapSubset) {
        return null;
    }

    public int getSizeOfAddress() {
        return 0;
    }

    public synchronized DebugHeapInfo getHeap(DebugHeapSubset debugHeapSubset, int n) {
        return null;
    }

    public synchronized boolean isHeapAddressValid(long l) {
        return false;
    }

    public synchronized DebugHeapObjectInfo getHeapObjectAtAddress(long l) {
        return null;
    }

    public void doGarbageCollection() {
    }

    public DebugCapabilities getCapabilities() {
        return this;
    }

    public boolean canPutBreakpointPackageFileLine() {
        return true;
    }

    public boolean canPutBreakpointFileLine() {
        return false;
    }

    public boolean canPutBreakpointMethodBytecode() {
        return false;
    }

    public boolean canPutBreakpointMethod() {
        return false;
    }

    public boolean canPutBreakpointClass() {
        return false;
    }

    public boolean canPutBreakpointException() {
        return true;
    }

    public boolean canPutBreakpointClassLoad() {
        return false;
    }

    public boolean canPutBreakpointAllocationThreshold() {
        return false;
    }

    public boolean canPutBreakpointAllocationClass() {
        return false;
    }

    public boolean canPutBreakpointDeadlock() {
        return false;
    }

    public boolean canPutBreakpointWatchpoint() {
        return false;
    }

    public boolean canSetDebuggablePackages() {
        return false;
    }

    public boolean canPauseProgram() {
        return false;
    }

    public boolean canRedefineClasses() {
        return false;
    }

    public boolean canCountObjectsOfClass() {
        return false;
    }

    public boolean canCountMemoryOfClass() {
        return false;
    }

    public boolean canSetDebuggableClass() {
        return false;
    }

    public boolean canGetHeap() {
        return false;
    }

    public boolean canDoGarbageCollection() {
        return false;
    }

    public boolean canDoCodeCoverage() {
        return false;
    }

    public boolean canDisassembleMethod() {
        return false;
    }

    public boolean canGetBytecodes() {
        return false;
    }

    public boolean canInvokeMethod() {
        return false;
    }

    public boolean canGetMonitors() {
        return false;
    }

    public boolean canGetMonitorEntryLocation() {
        return false;
    }

    public boolean canListSlots() {
        return false;
    }

    public boolean canPopFrames() {
        return false;
    }

    public boolean canSuspendThread() {
        return false;
    }

    public boolean canResumeThread() {
        return false;
    }

    public boolean canListRegisters() {
        return false;
    }

    public boolean canListFloatRegisters() {
        return false;
    }

    public boolean canStepToEndOfMethod() {
        return false;
    }

    public boolean canContinueStep() {
        return false;
    }

    public boolean canGetReturnValue() {
        return false;
    }

    public boolean canGetReturnedValue() {
        return false;
    }

    public boolean canSetLocation() {
        return false;
    }

    public boolean canPin() {
        return false;
    }

    public boolean canGetAddresses() {
        return false;
    }

    public boolean canGetUniqueIDs() {
        return false;
    }

    public void addConnectionLog(Object object) {
    }

    public void removeConnectionLog(Object object) {
    }

    public synchronized String getName() {
        if ("Oracle Database".equals(this.db.getDatabaseType())) {
            return "Oracle";
        }
        return DebugProbeArb.getString(2);
    }

    public int getLanguages() {
        return 2;
    }

    public String[] redefineClasses(Map map) {
        return new String[0];
    }

    private void initSync() {
        this.syncObjects = new Object[4];
        this.syncValues = new boolean[4];
        int n = 0;
        while (n < 4) {
            this.syncObjects[n] = new Integer(n);
            this.syncValues[n] = false;
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setSyncValue(int n, boolean bl) {
        Object object = this.syncObjects[n];
        synchronized (object) {
            boolean bl2 = this.syncValues[n];
            this.syncValues[n] = bl;
            boolean bl3 = bl2;
            return bl3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getSyncValue(int n) {
        Object object = this.syncObjects[n];
        synchronized (object) {
            boolean bl = this.syncValues[n];
            return bl;
        }
    }

    synchronized void throwIfRunning() {
        if (this.runningThread != null) {
            throw new IllegalStateException("Program Is Running");
        }
    }

    private void incrementStoppedCount() {
        ++this.stoppedCount;
        this.backTrace.clear();
    }

    private synchronized void doRunCommand(String string) {
        this.throwIfRunning();
        this.runCommand = string;
        this.runningThread = new Thread((Runnable)this, "RunningThread");
        this.runningThread.start();
    }

    private void connectionLost() {
        this.detach();
        if (this.debugListener != null) {
            this.debugListener.connectionLost();
        }
    }

    private void programTerminated() {
        this.detach();
        if (this.debugListener != null) {
            this.debugListener.programTerminated();
        }
    }

    public void run() {
        this.setSyncValue(1, false);
        this.incrementStoppedCount();
        this.currentBreakpoint = null;
        while (true) {
            if (this.getSyncValue(0)) {
                if (this.callSynchronize() != 0) {
                    this.connectionLost();
                    return;
                }
                if (this.isTerminated()) {
                    this.programTerminated();
                    return;
                }
                this.setTimeout(BIG_TIMEOUT);
                int n = this.afterSynchronize.size();
                int n2 = 0;
                while (n2 < n) {
                    Runnable runnable = (Runnable)this.afterSynchronize.get(n2);
                    runnable.run();
                    ++n2;
                }
                this.afterSynchronize.clear();
                this.setSyncValue(0, false);
            }
            this.incrementStoppedCount();
            if (this.callContinue() != 0) {
                this.connectionLost();
                return;
            }
            if (this.isTerminated()) {
                this.programTerminated();
                return;
            }
            if (this.runtimeInfo.reason == 25) {
                this.setSyncValue(0, true);
                this.setSyncValue(3, false);
                this.setTimeout(MIN_TIMEOUT);
            } else {
                this.setTimeout(BIG_TIMEOUT);
            }
            if (this.runtimeInfo.reason == 3 || this.runtimeInfo.reason == 11) {
                this.updateClasses();
                DebugProbeBreakpoint debugProbeBreakpoint = this.checkForBreakpointHit();
                if (debugProbeBreakpoint != null) {
                    this.currentBreakpoint = debugProbeBreakpoint;
                    break;
                }
                if (this.runCommand == RunCommand_Run) continue;
                break;
            }
            if (this.runtimeInfo.reason == 9 || this.runtimeInfo.reason == 6) break;
        }
        this.runningThread = null;
        this.incrementStoppedCount();
        this.updateClasses();
        this.setSyncValue(1, true);
        if (this.debugListener != null) {
            this.debugListener.programStopped();
        }
    }

    private void setTimeout(int n) {
        if (this.timeout != n) {
            try {
                this.timeout = n;
                Connection connection = this.db.getConnection();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("begin\n");
                stringBuffer.append("  DBMS_DEBUG.default_timeout := " + this.timeout + ";\n");
                stringBuffer.append("end;");
                String string = stringBuffer.toString();
                CallableStatement callableStatement = connection.prepareCall(string);
                try {
                    callableStatement.execute();
                }
                finally {
                    callableStatement.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private int callSynchronize() {
        int n = -1;
        try {
            Connection connection = this.db.getConnection();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("DECLARE\n");
            stringBuffer.append("  request binary_integer := " + this.runtimeInfo.info_request() + ";\n");
            stringBuffer.append("  info DBMS_DEBUG.runtime_info;\n");
            stringBuffer.append("begin\n");
            stringBuffer.append("  ? := DBMS_DEBUG.synchronize(info, request);\n");
            stringBuffer.append(this.runtimeInfo.code("info"));
            stringBuffer.append("end;");
            String string = stringBuffer.toString();
            boolean bl = false;
            do {
                CallableStatement callableStatement = connection.prepareCall(string);
                try {
                    callableStatement.registerOutParameter(1, 4);
                    this.runtimeInfo.registerParameters(callableStatement, 2);
                    callableStatement.execute();
                    n = callableStatement.getInt(1);
                    this.runtimeInfo.getParameters(callableStatement, 2);
                }
                finally {
                    callableStatement.close();
                }
                bl = false;
                if (n != 31) continue;
                if (this.isDebuggeeDead()) {
                    n = 0;
                    this.setSyncValue(2, true);
                    continue;
                }
                bl = true;
            } while (bl);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    private int callContinue() {
        int n = -1;
        try {
            boolean bl = false;
            do {
                String string;
                if (this.getSyncValue(3)) {
                    string = "DBMS_DEBUG.abort_execution";
                    this.setTimeout(BIG_TIMEOUT);
                } else {
                    string = this.getBreakFlags();
                    this.setTimeout(MIN_TIMEOUT);
                }
                Connection connection = this.db.getConnection();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("DECLARE\n");
                stringBuffer.append("  request binary_integer := " + this.runtimeInfo.info_request() + ";\n");
                stringBuffer.append("  info DBMS_DEBUG.runtime_info;\n");
                stringBuffer.append("begin\n");
                stringBuffer.append("  ? := DBMS_DEBUG.continue(info, " + string + ", request);\n");
                stringBuffer.append(this.runtimeInfo.code("info"));
                stringBuffer.append("end;");
                String string2 = stringBuffer.toString();
                CallableStatement callableStatement = connection.prepareCall(string2);
                try {
                    callableStatement.registerOutParameter(1, 4);
                    this.runtimeInfo.registerParameters(callableStatement, 2);
                    callableStatement.execute();
                    n = callableStatement.getInt(1);
                    this.runtimeInfo.getParameters(callableStatement, 2);
                }
                finally {
                    callableStatement.close();
                }
                bl = false;
                if (n == 31) {
                    if (this.isDebuggeeDead()) {
                        n = 0;
                        this.setSyncValue(2, true);
                        continue;
                    }
                    bl = true;
                    continue;
                }
                if (n != 0 || this.runtimeInfo.stackDepth != 1 || this.runtimeInfo.lineNumber != 0) continue;
                bl = true;
            } while (bl);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    private int callSetBreakpoint(DebugProbeLocation debugProbeLocation) {
        int n = -1;
        try {
            Connection connection = this.db.getConnection();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("DECLARE\n");
            stringBuffer.append("  pi  DBMS_DEBUG.program_info;\n");
            stringBuffer.append("  bn  BINARY_INTEGER;\n");
            stringBuffer.append("begin\n");
            stringBuffer.append("  pi.NameSpace := " + DebugProbeLocation.getNameSpaceFromLibunitType(debugProbeLocation.piLibunitType) + ";\n");
            stringBuffer.append("  pi.Owner     := '" + debugProbeLocation.piOwner + "';\n");
            stringBuffer.append("  pi.Name      := '" + debugProbeLocation.piName + "';\n");
            stringBuffer.append("  pi.Line#     := " + debugProbeLocation.piLineNumber + ";\n");
            stringBuffer.append("  ? := DBMS_DEBUG.set_breakpoint(pi, pi.Line#, bn);\n");
            stringBuffer.append("  ? := bn;\n");
            stringBuffer.append("end;");
            String string = stringBuffer.toString();
            CallableStatement callableStatement = connection.prepareCall(string);
            try {
                callableStatement.registerOutParameter(1, 4);
                callableStatement.registerOutParameter(2, 4);
                callableStatement.execute();
                int n2 = callableStatement.getInt(1);
                n = callableStatement.getInt(2);
                if (n2 != 0) {
                    n = -1;
                }
            }
            finally {
                callableStatement.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    void callEnableBreakpoint(int n) {
        try {
            Connection connection = this.db.getConnection();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("begin\n");
            stringBuffer.append("  ? := DBMS_DEBUG.enable_breakpoint(" + n + ");\n");
            stringBuffer.append("end;");
            String string = stringBuffer.toString();
            CallableStatement callableStatement = connection.prepareCall(string);
            try {
                callableStatement.registerOutParameter(1, 4);
                callableStatement.execute();
                int n2 = callableStatement.getInt(1);
            }
            finally {
                callableStatement.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void callDisableBreakpoint(int n) {
        try {
            Connection connection = this.db.getConnection();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("begin\n");
            stringBuffer.append("  ? := DBMS_DEBUG.disable_breakpoint(" + n + ");\n");
            stringBuffer.append("end;");
            String string = stringBuffer.toString();
            CallableStatement callableStatement = connection.prepareCall(string);
            try {
                callableStatement.registerOutParameter(1, 4);
                callableStatement.execute();
                int n2 = callableStatement.getInt(1);
            }
            finally {
                callableStatement.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void callDeleteBreakpoint(int n) {
        try {
            Connection connection = this.db.getConnection();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("begin\n");
            stringBuffer.append("  ? := DBMS_DEBUG.delete_breakpoint(" + n + ");\n");
            stringBuffer.append("end;");
            String string = stringBuffer.toString();
            CallableStatement callableStatement = connection.prepareCall(string);
            try {
                callableStatement.registerOutParameter(1, 4);
                callableStatement.execute();
                int n2 = callableStatement.getInt(1);
            }
            finally {
                callableStatement.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static boolean isNameBadForGetValue(String string) {
        int n = string.indexOf("(");
        int n2 = string.indexOf(")");
        if (n != -1) {
            if (n2 == -1) {
                return true;
            }
            if (n2 < n) {
                return true;
            }
            int n3 = string.indexOf("(", n + 1);
            if (n3 != -1) {
                return true;
            }
            int n4 = string.indexOf(")", n2 + 1);
            if (n4 != -1) {
                return true;
            }
            try {
                String string2 = string.substring(n + 1, n2);
                if (string2.startsWith("0x") || string2.startsWith("0X")) {
                    int n5 = Integer.parseInt(string2.substring(2), 16);
                }
                int n6 = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                boolean bl = true;
                return bl;
            }
        } else if (n2 != -1) {
            return true;
        }
        return false;
    }

    private DebugProbeValue callGetValue(Object object, String string, String string2) {
        DebugProbeStackFrameInfo debugProbeStackFrameInfo = null;
        DebugProbeClassInfo debugProbeClassInfo = null;
        if (object instanceof DebugProbeStackFrameInfo) {
            debugProbeStackFrameInfo = (DebugProbeStackFrameInfo)object;
        } else if (object instanceof DebugProbeClassInfo) {
            debugProbeClassInfo = (DebugProbeClassInfo)object;
        }
        if (debugProbeStackFrameInfo == null && debugProbeClassInfo == null) {
            return null;
        }
        if (debugProbeClassInfo != null) {
            if (debugProbeClassInfo.piLibunitType != 9 && debugProbeClassInfo.piLibunitType != 11) {
                return null;
            }
            if (!this.checkVersion(2, 2)) {
                return null;
            }
        }
        if (DebugProbe.isNameBadForGetValue(string)) {
            return null;
        }
        DebugProbeValue debugProbeValue = null;
        try {
            Connection connection = this.db.getConnection();
            StringBuffer stringBuffer = new StringBuffer();
            if (debugProbeStackFrameInfo != null) {
                stringBuffer.append("begin\n");
                stringBuffer.append("  ? := DBMS_DEBUG.get_value('" + string + "', " + debugProbeStackFrameInfo.probeFrameNumber + ", ?);\n");
                stringBuffer.append("end;");
            } else {
                stringBuffer.append("DECLARE\n");
                stringBuffer.append("  pi        DBMS_DEBUG.program_info;\n");
                stringBuffer.append("begin\n");
                stringBuffer.append("  pi.NameSpace := " + DebugProbeLocation.getNameSpaceFromLibunitType(debugProbeClassInfo.piLibunitType) + ";\n");
                stringBuffer.append("  pi.Owner     := '" + debugProbeClassInfo.piOwner + "';\n");
                stringBuffer.append("  pi.Name      := '" + debugProbeClassInfo.piName + "';\n");
                stringBuffer.append("  ? := DBMS_DEBUG.get_value('" + string + "', pi, ?);\n");
                stringBuffer.append("end;");
            }
            String string3 = stringBuffer.toString();
            CallableStatement callableStatement = connection.prepareCall(string3);
            try {
                callableStatement.registerOutParameter(1, 4);
                callableStatement.registerOutParameter(2, 12);
                callableStatement.execute();
                int n = callableStatement.getInt(1);
                String string4 = callableStatement.getString(2);
                if (n == 0 && string4 != null || n == 32 || n == 18) {
                    debugProbeValue = new DebugProbeValue(n, string4, string2);
                }
            }
            finally {
                callableStatement.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return debugProbeValue;
    }

    private int callSetValue(Object object, String string, String string2) {
        DebugProbeStackFrameInfo debugProbeStackFrameInfo = null;
        DebugProbeClassInfo debugProbeClassInfo = null;
        if (object instanceof DebugProbeStackFrameInfo) {
            debugProbeStackFrameInfo = (DebugProbeStackFrameInfo)object;
        } else if (object instanceof DebugProbeClassInfo) {
            debugProbeClassInfo = (DebugProbeClassInfo)object;
        }
        if (debugProbeStackFrameInfo == null && debugProbeClassInfo == null) {
            return -1;
        }
        if (debugProbeClassInfo != null) {
            if (debugProbeClassInfo.piLibunitType != 9 && debugProbeClassInfo.piLibunitType != 11) {
                return -1;
            }
            if (!this.checkVersion(2, 2)) {
                return -1;
            }
        }
        if (DebugProbe.isNameBadForGetValue(string)) {
            return -1;
        }
        int n = -1;
        try {
            Connection connection = this.db.getConnection();
            String string3 = string + " := " + string2 + ";";
            StringBuffer stringBuffer = new StringBuffer();
            if (debugProbeStackFrameInfo != null) {
                stringBuffer.append("begin\n");
                stringBuffer.append("  ? := DBMS_DEBUG.set_value(" + debugProbeStackFrameInfo.probeFrameNumber + ", '" + string3 + "');\n");
                stringBuffer.append("end;");
            } else {
                stringBuffer.append("DECLARE\n");
                stringBuffer.append("  pi        DBMS_DEBUG.program_info;\n");
                stringBuffer.append("begin\n");
                stringBuffer.append("  pi.NameSpace := " + DebugProbeLocation.getNameSpaceFromLibunitType(debugProbeClassInfo.piLibunitType) + ";\n");
                stringBuffer.append("  pi.Owner     := '" + debugProbeClassInfo.piOwner + "';\n");
                stringBuffer.append("  pi.Name      := '" + debugProbeClassInfo.piName + "';\n");
                stringBuffer.append("  ? := DBMS_DEBUG.set_value(pi, '" + string3 + "');\n");
                stringBuffer.append("end;");
            }
            String string4 = stringBuffer.toString();
            CallableStatement callableStatement = connection.prepareCall(string4);
            try {
                callableStatement.registerOutParameter(1, 4);
                callableStatement.execute();
                n = callableStatement.getInt(1);
                if (n == 0) {
                    // empty if block
                }
            }
            finally {
                callableStatement.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    private String callPrintInstantiations() {
        String string = null;
        if (this.checkVersion(2, 4)) {
            try {
                Connection connection = this.db.getConnection();
                int n = 23;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("DECLARE\n");
                stringBuffer.append("  pis     DBMS_DEBUG.backtrace_table;\n");
                stringBuffer.append("  each    BINARY_INTEGER;\n");
                stringBuffer.append("  pi      DBMS_DEBUG.program_info;\n");
                stringBuffer.append("  buffer  varchar2(5000):='';\n");
                stringBuffer.append("begin\n");
                stringBuffer.append("  DBMS_DEBUG.print_instantiations(pis, " + n + ");\n");
                stringBuffer.append("  each := pis.FIRST;\n");
                stringBuffer.append("  WHILE (each IS NOT NULL) LOOP\n");
                stringBuffer.append("    pi := pis(each);\n");
                stringBuffer.append("    buffer := buffer || pi.LibunitType || '.' || pi.Owner || '.' || pi.Name || ';';\n");
                stringBuffer.append("    each := pis.NEXT(each);\n");
                stringBuffer.append("  END LOOP;\n");
                stringBuffer.append("  ? := buffer;\n");
                stringBuffer.append("end;");
                String string2 = stringBuffer.toString();
                CallableStatement callableStatement = connection.prepareCall(string2);
                try {
                    callableStatement.registerOutParameter(1, 12);
                    callableStatement.execute();
                    string = callableStatement.getString(1);
                }
                finally {
                    callableStatement.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return string;
    }

    private String callSQLERRM(int n) {
        String string = null;
        try {
            Connection connection = this.db.getConnection();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("begin\n");
            stringBuffer.append("  ? := SQLERRM(" + n + ");\n");
            stringBuffer.append("end;");
            String string2 = stringBuffer.toString();
            CallableStatement callableStatement = connection.prepareCall(string2);
            try {
                callableStatement.registerOutParameter(1, 12);
                callableStatement.execute();
                string = callableStatement.getString(1);
            }
            finally {
                callableStatement.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    String callShowFrameSource(DebugProbeStackFrameInfo debugProbeStackFrameInfo) {
        String string = null;
        DebugClassInfo debugClassInfo = debugProbeStackFrameInfo.getLocation().getClassInfo();
        if (debugClassInfo != null && (string = this.getSource((DebugProbeClassInfo)debugClassInfo)) != null) {
            return string;
        }
        if (this.checkVersion(2, 4)) {
            try {
                Connection connection = this.db.getConnection();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("DECLARE\n");
                stringBuffer.append("  buffer     varchar2(32767):='';\n");
                stringBuffer.append("  first      binary_integer := 1;\n");
                stringBuffer.append("  last       binary_integer;\n");
                stringBuffer.append("  lines      DBMS_DEBUG.vc2_table;\n");
                stringBuffer.append("  notBlank   binary_integer;\n");
                stringBuffer.append("  each       binary_integer;\n");
                stringBuffer.append("  line       varchar2(90);\n");
                stringBuffer.append("begin\n");
                stringBuffer.append("  LOOP\n");
                stringBuffer.append("    last := first + 20;\n");
                stringBuffer.append("    DBMS_DEBUG.show_frame_source(first, last, lines, " + debugProbeStackFrameInfo.probeFrameNumber + ");\n");
                stringBuffer.append("    notBlank := 0;\n");
                stringBuffer.append("    each := lines.FIRST;\n");
                stringBuffer.append("    WHILE (each IS NOT NULL) LOOP\n");
                stringBuffer.append("      line := lines(each);\n");
                stringBuffer.append("      buffer := buffer || line || '\n';\n");
                stringBuffer.append("      IF LENGTH(line) > 0 THEN\n");
                stringBuffer.append("        notBlank := notBlank + 1;\n");
                stringBuffer.append("      END IF;\n");
                stringBuffer.append("      each := lines.NEXT(each);\n");
                stringBuffer.append("    END LOOP;\n");
                stringBuffer.append("    first := last + 1;\n");
                stringBuffer.append("    EXIT WHEN notBlank = 0;\n");
                stringBuffer.append("  END LOOP;\n");
                stringBuffer.append("  ? := buffer;\n");
                stringBuffer.append("end;");
                String string2 = stringBuffer.toString();
                CallableStatement callableStatement = connection.prepareCall(string2);
                try {
                    callableStatement.registerOutParameter(1, 12);
                    callableStatement.execute();
                    string = callableStatement.getString(1);
                    string = "*" + string;
                    string = string.trim();
                    string = new String(string.substring(1));
                }
                finally {
                    callableStatement.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return string;
    }

    String getSource(DebugProbeClassInfo debugProbeClassInfo) {
        String string = null;
        try {
            String string2;
            boolean bl = false;
            switch (debugProbeClassInfo.piLibunitType) {
                default: {
                    string2 = null;
                    break;
                }
                case 7: {
                    string2 = "PROCEDURE";
                    break;
                }
                case 8: {
                    string2 = "FUNCTION";
                    break;
                }
                case 9: {
                    string2 = "PACKAGE";
                    break;
                }
                case 11: {
                    string2 = "PACKAGE";
                    bl = true;
                }
            }
            if (string2 != null) {
                SchemaObject schemaObject = this.db.getObject(string2, this.db.getSchema(debugProbeClassInfo.piOwner), debugProbeClassInfo.piName);
                if (schemaObject instanceof SpecPlSql && bl) {
                    string = ((SpecPlSql)schemaObject).getBodySource();
                } else if (schemaObject instanceof PlSql) {
                    string = ((PlSql)schemaObject).getSource();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    private void callDetachSession() {
        try {
            Connection connection = this.db.getConnection();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("begin\n");
            stringBuffer.append("  DBMS_DEBUG.detach_session;\n");
            stringBuffer.append("end;");
            String string = stringBuffer.toString();
            CallableStatement callableStatement = connection.prepareCall(string);
            try {
                callableStatement.execute();
            }
            finally {
                callableStatement.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void stepInto() {
        this.doRunCommand(RunCommand_StepInto);
    }

    void stepOver() {
        this.doRunCommand(RunCommand_StepOver);
    }

    void stepOut() {
        this.doRunCommand(RunCommand_StepOut);
    }

    boolean checkVersion(int n, int n2) {
        if (this.major > n) {
            return true;
        }
        if (this.major == n) {
            return this.minor >= n2;
        }
        return false;
    }

    int getStackFrameCount() {
        this.backTrace.fill(this.db, this.runtimeInfo.stackDepth);
        return this.backTrace.getStackFrameCount();
    }

    DebugStackFrameInfo getStackFrame(int n) {
        this.backTrace.fill(this.db, this.runtimeInfo.stackDepth);
        return this.backTrace.getStackFrame(n);
    }

    DebugStackFrameInfo[] listStack() {
        this.backTrace.fill(this.db, this.runtimeInfo.stackDepth);
        return this.backTrace.listStack();
    }

    private String getBreakFlags() {
        String string = this.runCommand;
        int n = this.breakpoints.size() - 1;
        while (n >= 0) {
            DebugProbeBreakpoint debugProbeBreakpoint = (DebugProbeBreakpoint)this.breakpoints.get(n);
            if (debugProbeBreakpoint instanceof DebugProbeBreakpointException && debugProbeBreakpoint.getEnabled()) {
                string = string + " + DBMS_DEBUG.break_exception";
                break;
            }
            --n;
        }
        return string;
    }

    private DebugProbeBreakpoint checkForBreakpointHit() {
        DebugProbeBreakpoint debugProbeBreakpoint = null;
        List list = this.findBreakpoints();
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            DebugProbeBreakpoint debugProbeBreakpoint2 = (DebugProbeBreakpoint)list.get(n2);
            if (this.doBreakpointActions(debugProbeBreakpoint2)) {
                debugProbeBreakpoint = debugProbeBreakpoint2;
            }
            ++n2;
        }
        return debugProbeBreakpoint;
    }

    private List findBreakpoints() {
        ArrayList<DebugProbeBreakpoint> arrayList = new ArrayList<DebugProbeBreakpoint>();
        int n = this.breakpoints.size();
        int n2 = 0;
        while (n2 < n) {
            DebugProbeBreakpoint debugProbeBreakpoint = (DebugProbeBreakpoint)this.breakpoints.get(n2);
            if (debugProbeBreakpoint.isThisYourEvent(this.runtimeInfo, this.mainThread)) {
                arrayList.add(debugProbeBreakpoint);
            }
            ++n2;
        }
        return arrayList;
    }

    private boolean doBreakpointActions(DebugProbeBreakpoint debugProbeBreakpoint) {
        if (debugProbeBreakpoint.enableOtherBPs != null && debugProbeBreakpoint.enableOtherBPs.length() > 0) {
            int n = this.breakpoints.size();
            int n2 = 0;
            while (n2 < n) {
                DebugProbeBreakpoint debugProbeBreakpoint2 = (DebugProbeBreakpoint)this.breakpoints.get(n2);
                if (debugProbeBreakpoint.enableOtherBPs.equals(debugProbeBreakpoint2.name) && !debugProbeBreakpoint2.enabled) {
                    debugProbeBreakpoint2.setEnabled(true);
                    if (this.debugListener != null) {
                        this.debugListener.breakpointChanged((DebugBreakpoint)debugProbeBreakpoint2);
                    }
                }
                ++n2;
            }
        }
        if (debugProbeBreakpoint.disableOtherBPs != null && debugProbeBreakpoint.disableOtherBPs.length() > 0) {
            int n = this.breakpoints.size();
            int n3 = 0;
            while (n3 < n) {
                DebugProbeBreakpoint debugProbeBreakpoint3 = (DebugProbeBreakpoint)this.breakpoints.get(n3);
                if (debugProbeBreakpoint.disableOtherBPs.equals(debugProbeBreakpoint3.name) && debugProbeBreakpoint3.enabled) {
                    debugProbeBreakpoint3.setEnabled(false);
                    if (this.debugListener != null) {
                        this.debugListener.breakpointChanged((DebugBreakpoint)debugProbeBreakpoint3);
                    }
                }
                ++n3;
            }
        }
        if (debugProbeBreakpoint.log) {
            DebugProbeThreadInfo debugProbeThreadInfo = this.mainThread;
            DebugStackFrameInfo[] debugStackFrameInfoArray = debugProbeThreadInfo.listStack();
            if (debugProbeBreakpoint instanceof DebugProbeBreakpointPackageFileLine) {
                this.bpLogListener.logBreakpoint((DebugBreakpoint)debugProbeBreakpoint, (DebugThreadInfo)debugProbeThreadInfo, debugStackFrameInfoArray);
            } else if (debugProbeBreakpoint instanceof DebugProbeBreakpointException) {
                String string = "$Oracle.EXCEPTION_ORA_" + this.runtimeInfo.oer;
                String string2 = this.callSQLERRM(this.runtimeInfo.getSQLCode());
                this.bpLogListener.logException((DebugBreakpoint)debugProbeBreakpoint, string, string2, (DebugThreadInfo)debugProbeThreadInfo, debugStackFrameInfoArray);
            }
        }
        return debugProbeBreakpoint.stop;
    }

    DebugProbeValue getVariableValue(DebugProbeStackFrameInfo debugProbeStackFrameInfo, String string, String string2) {
        return this.callGetValue(debugProbeStackFrameInfo, string, string2);
    }

    static Object findDataRoot(Object object, StringBuffer stringBuffer) {
        if (object instanceof DebugProbeDataInfo) {
            DebugProbeDataInfo debugProbeDataInfo = (DebugProbeDataInfo)object;
            return DebugProbe.findDataRoot(debugProbeDataInfo.owner, stringBuffer);
        }
        if (object instanceof DebugProbeVariableInfo) {
            DebugProbeVariableInfo debugProbeVariableInfo = (DebugProbeVariableInfo)object;
            if (stringBuffer != null) {
                stringBuffer.append(debugProbeVariableInfo.name);
            }
            return debugProbeVariableInfo.sf;
        }
        if (object instanceof DebugProbeFieldInfo) {
            DebugProbeFieldInfo debugProbeFieldInfo = (DebugProbeFieldInfo)object;
            if (stringBuffer != null) {
                stringBuffer.append(debugProbeFieldInfo.name);
            }
            return debugProbeFieldInfo.declaringClass;
        }
        if (object instanceof DebugProbeArrayElementInfo) {
            DebugProbeArrayElementInfo debugProbeArrayElementInfo = (DebugProbeArrayElementInfo)object;
            Object object2 = DebugProbe.findDataRoot(debugProbeArrayElementInfo.array, stringBuffer);
            if (object2 != null) {
                if (stringBuffer != null) {
                    stringBuffer.append('(');
                    stringBuffer.append(debugProbeArrayElementInfo.index);
                    stringBuffer.append(')');
                }
                return object2;
            }
        }
        return null;
    }

    DebugProbeValue modifyData(DebugProbeDataInfo debugProbeDataInfo, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        Object object = DebugProbe.findDataRoot(debugProbeDataInfo, stringBuffer);
        if (object != null) {
            String string3 = stringBuffer.toString();
            if (object instanceof DebugProbeStackFrameInfo) {
                DebugProbeStackFrameInfo debugProbeStackFrameInfo = (DebugProbeStackFrameInfo)object;
                debugProbeStackFrameInfo.clearCachedData();
                int n = this.callSetValue(debugProbeStackFrameInfo, string3, string2);
                if (n == 0) {
                    return this.callGetValue(debugProbeStackFrameInfo, string3, string);
                }
            } else if (object instanceof DebugProbeClassInfo) {
                DebugProbeClassInfo debugProbeClassInfo = (DebugProbeClassInfo)object;
                debugProbeClassInfo.clearCachedData();
                int n = this.callSetValue(debugProbeClassInfo, string3, string2);
                if (n == 0) {
                    return this.callGetValue(debugProbeClassInfo, string3, string);
                }
            }
        }
        return null;
    }

    DebugProbeArrayElementInfo getArrayElement(DebugProbeDataArrayInfo debugProbeDataArrayInfo, int n, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Object object = DebugProbe.findDataRoot(debugProbeDataArrayInfo, stringBuffer);
        if (object != null) {
            stringBuffer.append('(');
            stringBuffer.append(n);
            stringBuffer.append(')');
            String string2 = stringBuffer.toString();
            DebugProbeValue debugProbeValue = null;
            if (object instanceof DebugProbeStackFrameInfo) {
                DebugProbeStackFrameInfo debugProbeStackFrameInfo = (DebugProbeStackFrameInfo)object;
                debugProbeValue = this.callGetValue(debugProbeStackFrameInfo, string2, string);
            } else if (object instanceof DebugProbeClassInfo) {
                DebugProbeClassInfo debugProbeClassInfo = (DebugProbeClassInfo)object;
                debugProbeValue = this.callGetValue(debugProbeClassInfo, string2, string);
            }
            if (debugProbeValue != null) {
                return new DebugProbeArrayElementInfo(this, debugProbeDataArrayInfo, n, debugProbeValue);
            }
        }
        return null;
    }

    private void updateClasses() {
        String string = this.callPrintInstantiations();
        if (string != null) {
            String string2 = Integer.toString(9);
            String string3 = "$Oracle." + DBUtil.getArgusNameForType("PACKAGE");
            String string4 = Integer.toString(11);
            String string5 = "$Oracle." + DBUtil.getArgusNameForType("PACKAGE", "Body");
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            while (stringTokenizer.hasMoreTokens()) {
                DebugProbeClassInfo debugProbeClassInfo;
                String string6 = stringTokenizer.nextToken();
                int n = string6.indexOf(46);
                if (n == -1) continue;
                String string7 = string6.substring(0, n);
                String string8 = string6.substring(n);
                String string9 = null;
                if (string7.equals(string2)) {
                    string9 = string3 + string8;
                } else if (string7.equals(string4)) {
                    string9 = string5 + string8;
                }
                if (string9 == null || (debugProbeClassInfo = (DebugProbeClassInfo)this.classesByName.get(string9)) != null) continue;
                debugProbeClassInfo = DebugProbeClassInfo.makeObjectClass(this, string9);
                this.addClass(debugProbeClassInfo);
            }
        }
    }

    private void addClass(DebugProbeClassInfo debugProbeClassInfo) {
        this.classes.add(debugProbeClassInfo);
        DebugShared.putClass((Map)this.classesByName, (String)debugProbeClassInfo.name, (DebugClassInfo)debugProbeClassInfo);
        DebugShared.putClass((Map)this.classesByNameWithoutPackage, (String)debugProbeClassInfo.getNameWithoutPackage(), (DebugClassInfo)debugProbeClassInfo);
    }

    DebugProbeValue getFieldValue(DebugProbeClassInfo debugProbeClassInfo, String string, String string2) {
        return this.callGetValue(debugProbeClassInfo, string, string2);
    }

    DebugProbeClassInfo getClassInfoForLocation(DebugProbeLocation debugProbeLocation) {
        String string = DebugProbeClassInfo.makeClassName(debugProbeLocation.piLibunitType, debugProbeLocation.piOwner, debugProbeLocation.piName);
        DebugProbeClassInfo debugProbeClassInfo = (DebugProbeClassInfo)this.classesByName.get(string);
        if (debugProbeClassInfo == null && (debugProbeClassInfo = (DebugProbeClassInfo)this.locationClassesByName.get(string)) == null) {
            debugProbeClassInfo = DebugProbeClassInfo.makeObjectClass(this, string);
            this.locationClassesByName.put(string, debugProbeClassInfo);
        }
        return debugProbeClassInfo;
    }

    private void addBuiltInClass(String string) {
        DebugProbeClassInfo debugProbeClassInfo = DebugProbeClassInfo.makePrimitiveClass(this, string);
        this.addClass(debugProbeClassInfo);
    }

    DebugProbeClassInfo getClassInfoForDataType(DebugProbeValue debugProbeValue) {
        DebugProbeClassInfo debugProbeClassInfo = null;
        String string = debugProbeValue.getType();
        if (string != null) {
            if (debugProbeValue.isArray()) {
                debugProbeClassInfo = (DebugProbeClassInfo)this.arrayClassesByName.get(string);
                if (debugProbeClassInfo == null) {
                    debugProbeClassInfo = DebugProbeClassInfo.makeArrayClass(this, string);
                    this.arrayClassesByName.put(string, debugProbeClassInfo);
                }
            } else {
                debugProbeClassInfo = (DebugProbeClassInfo)this.primitiveClassesByName.get(string);
                if (debugProbeClassInfo == null) {
                    debugProbeClassInfo = DebugProbeClassInfo.makePrimitiveClass(this, string);
                    this.primitiveClassesByName.put(string, debugProbeClassInfo);
                }
            }
        }
        if (debugProbeClassInfo == null) {
            debugProbeClassInfo = this.unknownClass;
        }
        return debugProbeClassInfo;
    }

    private String getDebuggeeSessionId() {
        String string = null;
        try {
            Connection connection = this.db.getConnection();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("declare\n");
            stringBuffer.append("  results      sys.dbms_debug_vc2coll;\n");
            stringBuffer.append("  errm         VARCHAR2(100);\n");
            stringBuffer.append("begin\n");
            stringBuffer.append("  DBMS_DEBUG.execute(\n");
            stringBuffer.append("    'declare ' ||\n");
            stringBuffer.append("    '  vc  SYS.dbms_debug_vc2coll := SYS.dbms_debug_vc2coll(); '||\n");
            stringBuffer.append("    'begin ' ||\n");
            stringBuffer.append("    '  vc.EXTEND(2); ' ||\n");
            stringBuffer.append("    '  vc(1) := DBMS_SESSION.unique_session_id; ' ||\n");
            stringBuffer.append("    '  vc(2) := null; ' ||\n");
            stringBuffer.append("    '  :1 := vc; ' ||\n");
            stringBuffer.append("    'end;',\n");
            stringBuffer.append("    -1, 1, results, errm);\n");
            stringBuffer.append("  ? := results(1);\n");
            stringBuffer.append("end;");
            String string2 = stringBuffer.toString();
            CallableStatement callableStatement = connection.prepareCall(string2);
            try {
                callableStatement.registerOutParameter(1, 12);
                callableStatement.execute();
                string = callableStatement.getString(1);
                if (string != null && string.length() == 0) {
                    string = null;
                }
            }
            finally {
                callableStatement.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    private boolean isDebuggeeDead() {
        boolean bl = false;
        if (this.debuggeeSessionId != null) {
            try {
                Connection connection = this.db.getConnection();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("declare\n");
                stringBuffer.append("  dead binary_integer;\n");
                stringBuffer.append("begin\n");
                stringBuffer.append("  IF DBMS_SESSION.is_session_alive('" + this.debuggeeSessionId + "') THEN\n");
                stringBuffer.append("    dead := 0;\n");
                stringBuffer.append("  ELSE\n");
                stringBuffer.append("    dead := 1;\n");
                stringBuffer.append("  END IF;\n");
                stringBuffer.append("  ? := dead;\n");
                stringBuffer.append("end;");
                String string = stringBuffer.toString();
                CallableStatement callableStatement = connection.prepareCall(string);
                try {
                    callableStatement.registerOutParameter(1, 4);
                    callableStatement.execute();
                    bl = callableStatement.getInt(1) == 1;
                }
                finally {
                    callableStatement.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return bl;
    }

    static String mav$getDebuggeeSessionId(DebugProbe debugProbe) {
        return debugProbe.getDebuggeeSessionId();
    }

    static void wa$debuggeeSessionId(DebugProbe debugProbe, String string) {
        debugProbe.debuggeeSessionId = string;
    }

    public final class 2
    implements Runnable {
        public void run() {
            DebugProbe.wa$debuggeeSessionId(DebugProbe.this, DebugProbe.mav$getDebuggeeSessionId(DebugProbe.this));
        }
    }

    public final class 1
    implements Runnable {
        private final /* synthetic */ DebugProbeBreakpoint v$bp;
        final /* synthetic */ DebugProbe this$0;

        public void run() {
            this.this$0.putBreakpoint(this.v$bp);
        }

        public 1(DebugProbe debugProbe, DebugProbeBreakpoint debugProbeBreakpoint) {
            this.v$bp = debugProbeBreakpoint;
            this.this$0 = debugProbe;
        }
    }
}

