/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.probe;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.util.ArrayList;
import oracle.javatools.db.Database;
import oracle.jdevimpl.debugger.probe.DebugProbe;
import oracle.jdevimpl.debugger.probe.DebugProbeStackFrameInfo;

final class DebugProbeBackTrace {
    DebugProbe dp;
    int stackDepth;
    DebugProbeStackFrameInfo[] stackFrames;

    DebugProbeBackTrace(DebugProbe debugProbe) {
        this.dp = debugProbe;
    }

    void clear() {
        if (this.stackFrames != null) {
            int n = 0;
            while (n < this.stackDepth) {
                this.stackFrames[n].clear();
                ++n;
            }
        }
        this.stackDepth = 0;
        this.stackFrames = null;
    }

    static String code(int n, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 1;
        while (n2 <= n) {
            stringBuffer.append(DebugProbeStackFrameInfo.code(string + "(" + n2 + ")"));
            ++n2;
        }
        return stringBuffer.toString();
    }

    static int registerParameters(int n, CallableStatement callableStatement, int n2) throws Exception {
        int n3 = n - 1;
        while (n3 >= 0) {
            n2 = DebugProbeStackFrameInfo.registerParameters(callableStatement, n2);
            --n3;
        }
        return n2;
    }

    int getParameters(int n, CallableStatement callableStatement, int n2) throws Exception {
        ArrayList<DebugProbeStackFrameInfo> arrayList = new ArrayList<DebugProbeStackFrameInfo>();
        int n3 = 1;
        int n4 = n - 1;
        while (n4 >= 0) {
            DebugProbeStackFrameInfo debugProbeStackFrameInfo = new DebugProbeStackFrameInfo(this.dp, n4, n3);
            n2 = debugProbeStackFrameInfo.getParameters(callableStatement, n2);
            if (!debugProbeStackFrameInfo.location.isAnonymousBlock()) {
                arrayList.add(0, debugProbeStackFrameInfo);
            }
            ++n3;
            --n4;
        }
        this.stackDepth = n = arrayList.size();
        this.stackFrames = new DebugProbeStackFrameInfo[n];
        int n5 = 0;
        while (n5 < n) {
            this.stackFrames[n5] = (DebugProbeStackFrameInfo)arrayList.get(n5);
            this.stackFrames[n5].frameNumber = n5;
            ++n5;
        }
        return n2;
    }

    String dump(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(string2);
        stringBuffer.append("\n");
        int n = 0;
        while (n < this.stackDepth) {
            stringBuffer.append(this.stackFrames[n].dump(string + "  ", "stackFrames[" + n + "]"));
            ++n;
        }
        return stringBuffer.toString();
    }

    void fill(Database database, int n) {
        if (this.stackFrames == null && this.dp.checkVersion(2, 1) && n > 0) {
            try {
                Connection connection = database.getConnection();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("DECLARE\n");
                stringBuffer.append("  backtrace   DBMS_DEBUG.backtrace_table;\n");
                stringBuffer.append("begin\n");
                stringBuffer.append("  DBMS_DEBUG.print_backtrace(backtrace);\n");
                stringBuffer.append(DebugProbeBackTrace.code(n, "backtrace"));
                stringBuffer.append("end; ");
                String string = stringBuffer.toString();
                CallableStatement callableStatement = connection.prepareCall(string);
                try {
                    DebugProbeBackTrace.registerParameters(n, callableStatement, 1);
                    callableStatement.execute();
                    this.getParameters(n, callableStatement, 1);
                }
                finally {
                    callableStatement.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    DebugProbeStackFrameInfo[] listStack() {
        return this.stackFrames;
    }

    int getStackFrameCount() {
        return this.stackDepth;
    }

    DebugProbeStackFrameInfo getStackFrame(int n) {
        if (n < this.stackDepth) {
            return this.stackFrames[n];
        }
        return null;
    }
}

