/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.probe;

import oracle.jdevimpl.debugger.probe.DebugProbe;
import oracle.jdevimpl.debugger.probe.DebugProbeBreakpoint;
import oracle.jdevimpl.debugger.probe.DebugProbeRuntimeInfo;
import oracle.jdevimpl.debugger.probe.DebugProbeThreadInfo;
import oracle.jdevimpl.debugger.support.DebugBreakpointException;

final class DebugProbeBreakpointException
extends DebugProbeBreakpoint
implements DebugBreakpointException {
    String exception;
    boolean caught;
    boolean uncaught;

    DebugProbeBreakpointException(DebugProbe debugProbe, String string, boolean bl, boolean bl2) {
        super(debugProbe);
        this.exception = string;
        this.caught = bl;
        this.uncaught = bl2;
    }

    public String getExceptionClassname() {
        return this.exception;
    }

    public boolean getCaught() {
        return this.caught;
    }

    public boolean getUncaught() {
        return this.uncaught;
    }

    public void setExceptionClassname(String string) {
        this.setExceptionClassname(string, true, true);
    }

    public void setExceptionClassname(String string, boolean bl, boolean bl2) {
        this.prepareForChange();
        this.exception = string;
        this.caught = bl;
        this.uncaught = bl2;
        if (this.dp != null) {
            this.dp.putBreakpoint(this);
        }
    }

    boolean isThisYourEvent(DebugProbeRuntimeInfo debugProbeRuntimeInfo, DebugProbeThreadInfo debugProbeThreadInfo) {
        if (debugProbeRuntimeInfo.reason == 11) {
            boolean bl = false;
            if (debugProbeRuntimeInfo.isOerSupported() && debugProbeRuntimeInfo.oer != 0) {
                if (this.exception.equals("java.lang.Throwable") || this.exception.equals("$Oracle.Builtin.EXCEPTION") || this.exception.equals("$Oracle.Builtin.EXCEPTION_ORA")) {
                    bl = true;
                } else {
                    String string = "$Oracle.EXCEPTION_ORA_";
                    if (this.exception.startsWith("$Oracle.EXCEPTION_ORA_")) {
                        try {
                            int n = Integer.parseInt(this.exception.substring("$Oracle.EXCEPTION_ORA_".length()));
                            if (n == 0 || n == debugProbeRuntimeInfo.oer) {
                                bl = true;
                            }
                        }
                        catch (Exception exception) {
                            bl = true;
                        }
                    }
                }
            } else {
                bl = true;
            }
            if (bl) {
                return super.isThisYourEvent(debugProbeRuntimeInfo, debugProbeThreadInfo);
            }
        }
        return false;
    }
}

