/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.probe;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.jdevimpl.debugger.probe.DebugProbe;
import oracle.jdevimpl.debugger.probe.DebugProbeArrayElementInfo;
import oracle.jdevimpl.debugger.probe.DebugProbeClassInfo;
import oracle.jdevimpl.debugger.probe.DebugProbeDataCompositeInfo;
import oracle.jdevimpl.debugger.probe.DebugProbeValue;
import oracle.jdevimpl.debugger.probe.DebugProbeVariableContainer;
import oracle.jdevimpl.debugger.support.DebugArrayElementInfo;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataArrayInfo;

final class DebugProbeDataArrayInfo
extends DebugProbeDataCompositeInfo
implements DebugDataArrayInfo {
    private String elementType;
    private Map cachedNonNullArrayElements;
    private List cachedNullArrayElements;

    DebugProbeDataArrayInfo(DebugProbe debugProbe, DebugProbeClassInfo debugProbeClassInfo, DebugProbeValue debugProbeValue, Object object) {
        super(debugProbe, debugProbeClassInfo, debugProbeValue, object);
        this.figureOutElementType();
        this.cachedNonNullArrayElements = new HashMap();
        this.cachedNullArrayElements = new ArrayList();
    }

    private void figureOutElementType() {
        Object object = DebugProbe.findDataRoot(this.owner, null);
        if (object instanceof DebugProbeVariableContainer) {
            String string;
            DebugProbeVariableContainer debugProbeVariableContainer = (DebugProbeVariableContainer)object;
            String string2 = this.dpv.getType();
            if (string2 != null && (string = debugProbeVariableContainer.getTypeDefinition(string2)) != null) {
                this.elementType = DebugProbeDataArrayInfo.getTableElementType(string);
            }
        }
    }

    static String isTableElementName(String string) {
        int n;
        int n2;
        int n3;
        int n4 = string.indexOf("(");
        if (n4 != -1 && (n3 = string.indexOf(")")) != -1 && n3 > n4 && (n2 = string.indexOf("(", n4 + 1)) == -1 && (n = string.indexOf(")", n3 + 1)) == -1) {
            return string.substring(0, n4);
        }
        return null;
    }

    static String getTableElementType(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (!string2.equalsIgnoreCase("OF")) continue;
            if (!stringTokenizer.hasMoreTokens()) break;
            return stringTokenizer.nextToken();
        }
        return null;
    }

    public DebugClassInfo getArrayElementClassInfo() {
        return this.dp.unknownClass;
    }

    public int getArrayStart() {
        return 1;
    }

    public int getArrayCount() {
        return this.getArrayCount(false);
    }

    public DebugArrayElementInfo[] getArrayElements() {
        return this.getArrayElements(1, -1, false);
    }

    public DebugArrayElementInfo[] getArrayElements(int n, int n2) {
        return this.getArrayElements(n, n2, false);
    }

    public int getArrayCount(boolean bl) {
        this.throwIfExpired();
        return -1;
    }

    public DebugArrayElementInfo[] getArrayElements(boolean bl) {
        this.throwIfExpired();
        return new DebugArrayElementInfo[0];
    }

    public DebugArrayElementInfo[] getArrayElements(int n, int n2, boolean bl) {
        this.throwIfExpired();
        if (n2 != -1) {
            ArrayList<DebugProbeArrayElementInfo> arrayList = new ArrayList<DebugProbeArrayElementInfo>();
            int n3 = n;
            while (n3 < n + n2) {
                Integer n4 = new Integer(n3);
                DebugProbeArrayElementInfo debugProbeArrayElementInfo = (DebugProbeArrayElementInfo)this.cachedNonNullArrayElements.get(n4);
                if (debugProbeArrayElementInfo == null && !this.cachedNullArrayElements.contains(n4)) {
                    debugProbeArrayElementInfo = this.dp.getArrayElement(this, n3, this.elementType);
                    if (debugProbeArrayElementInfo == null) {
                        this.cachedNullArrayElements.add(n4);
                    } else {
                        this.cachedNonNullArrayElements.put(n4, debugProbeArrayElementInfo);
                    }
                }
                if (debugProbeArrayElementInfo != null) {
                    arrayList.add(debugProbeArrayElementInfo);
                }
                ++n3;
            }
            return arrayList.toArray(new DebugProbeArrayElementInfo[arrayList.size()]);
        }
        return new DebugArrayElementInfo[0];
    }

    public boolean equals(Object object) {
        if (object instanceof DebugProbeDataArrayInfo) {
            return super.equals(object);
        }
        return false;
    }
}

