/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.probe;

import java.util.List;
import oracle.ide.model.Project;
import oracle.ide.util.ModelUtil;
import oracle.jdevimpl.debugger.probe.DebugProbe;
import oracle.jdevimpl.debugger.probe.DebugProbeClassInfo;
import oracle.jdevimpl.debugger.probe.DebugProbeLocation;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugDisassembleInfo;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;

final class DebugProbeMethodInfo
implements DebugMethodInfo {
    DebugProbe dp;
    DebugProbeClassInfo classInfo;
    String piEntryPointName;
    String name;

    DebugProbeMethodInfo(DebugProbe debugProbe, DebugProbeClassInfo debugProbeClassInfo, String string) {
        this.dp = debugProbe;
        this.classInfo = debugProbeClassInfo;
        this.piEntryPointName = string;
        this.name = DebugProbeMethodInfo.makeMethodName(debugProbeClassInfo, string);
    }

    public DebugVirtualMachine getVM() {
        return this.dp;
    }

    public boolean hasExpired() {
        return this.classInfo.hasExpired();
    }

    private void throwIfExpired() {
        if (this.hasExpired()) {
            throw new IllegalStateException("Method has expired");
        }
    }

    public DebugClassInfo getClassInfo() {
        return this.classInfo;
    }

    public boolean isCompiled() {
        return false;
    }

    public String getName() {
        return this.name;
    }

    public String getNameWithoutClass() {
        return DebugShared.getNameWithoutClass((String)this.name);
    }

    public String getNameWithoutSignature() {
        return DebugShared.getNameWithoutSignature((String)this.name);
    }

    public String getNameWithoutClassOrSignature() {
        return DebugShared.getNameWithoutClassOrSignature((String)this.name);
    }

    public String getParameterSignature() {
        return DebugShared.getMethodParameterSignature((String)this.name);
    }

    public int getAccess() {
        return 0;
    }

    public int[] getMethodLineRange() {
        int[] nArray = new int[]{0, 0};
        return nArray;
    }

    public int[] getMethodLines() {
        return new int[0];
    }

    public int[] getCodeCoverage() {
        return new int[0];
    }

    public double getCodeCoverageRatio() {
        return 0.0;
    }

    public DebugLocation getFirstLocation() {
        return this.getLocation(this.classInfo.getSourceFilename(), 1);
    }

    public DebugLocation getLocation(String string, int n) {
        this.throwIfExpired();
        if (ModelUtil.areEqual((Object)string, (Object)this.classInfo.getSourceFilename())) {
            return new DebugProbeLocation(this.dp, this.classInfo, n, this.piEntryPointName);
        }
        return null;
    }

    public DebugDisassembleInfo[] disassembleMethod(boolean bl, boolean bl2, boolean bl3, Project project) {
        return new DebugDisassembleInfo[0];
    }

    public boolean hasMethodChanged() {
        return false;
    }

    public byte[] getBytecodes() {
        return new byte[0];
    }

    public byte getBytecode(int n) {
        return 0;
    }

    public DebugDataInfo invoke(List list) {
        return null;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof DebugProbeMethodInfo) {
            DebugProbeMethodInfo debugProbeMethodInfo = (DebugProbeMethodInfo)object;
            return ModelUtil.areEqual((Object)this.dp, (Object)debugProbeMethodInfo.dp) && ModelUtil.areEqual((Object)this.name, (Object)debugProbeMethodInfo.name);
        }
        return false;
    }

    static String makeMethodName(DebugProbeClassInfo debugProbeClassInfo, String string) {
        String string2 = " " + debugProbeClassInfo.name + "." + string + "()";
        return string2;
    }
}

