/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.probe;

import java.sql.CallableStatement;
import java.util.ArrayList;
import java.util.List;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.parser.plsql.old.PlsqlParser;
import oracle.javatools.parser.plsql.old.symbol.CodeBlockSymbol;
import oracle.javatools.parser.plsql.old.symbol.CompoundStatement;
import oracle.javatools.parser.plsql.old.symbol.FunctionSymbol;
import oracle.javatools.parser.plsql.old.symbol.NameSymbol;
import oracle.javatools.parser.plsql.old.symbol.PackageSymbol;
import oracle.javatools.parser.plsql.old.symbol.RootSymbol;
import oracle.javatools.parser.plsql.old.symbol.Statement;
import oracle.jdevimpl.debugger.probe.DebugProbe;
import oracle.jdevimpl.debugger.probe.DebugProbeDataArrayInfo;
import oracle.jdevimpl.debugger.probe.DebugProbeLocation;
import oracle.jdevimpl.debugger.probe.DebugProbeValue;
import oracle.jdevimpl.debugger.probe.DebugProbeVariableContainer;
import oracle.jdevimpl.debugger.probe.DebugProbeVariableInfo;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugStackSlotInfo;
import oracle.jdevimpl.debugger.support.DebugVariableInfo;

final class DebugProbeStackFrameInfo
extends DebugProbeVariableContainer
implements DebugStackFrameInfo {
    DebugProbe dp;
    boolean expired;
    int frameNumber;
    int probeFrameNumber;
    DebugProbeLocation location;
    private DebugProbeVariableInfo[] arguments;
    private DebugProbeVariableInfo[] locals;
    private String _sourceCode;
    private int _locationOffset;

    DebugProbeStackFrameInfo(DebugProbe debugProbe, int n, int n2) {
        this.$init$();
        this.dp = debugProbe;
        this.frameNumber = n;
        this.probeFrameNumber = n2;
    }

    public boolean hasExpired() {
        return this.expired;
    }

    public int getFrameNumber() {
        return this.frameNumber;
    }

    public DebugLocation getLocation() {
        return this.location;
    }

    public DebugVariableInfo[] listArguments() {
        this.lookForVariables();
        return this.arguments;
    }

    public DebugVariableInfo[] listLocals() {
        this.lookForVariables();
        return this.locals;
    }

    public DebugVariableInfo getVariable(String string) {
        DebugProbeValue debugProbeValue = this.dp.getVariableValue(this, string, null);
        if (debugProbeValue != null) {
            String string2 = this.figureOutVariableType(string);
            if (string2 != null) {
                debugProbeValue.setType(string2);
            }
            return new DebugProbeVariableInfo(this.dp, this, string, debugProbeValue, false, false);
        }
        return null;
    }

    public DebugStackSlotInfo[] listSlots() {
        return new DebugStackSlotInfo[0];
    }

    public int getLanguage() {
        return 2;
    }

    public boolean popBackToHere() {
        return false;
    }

    void clear() {
        this.expired = true;
    }

    static String code(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("  ? := " + string + ".LibunitType;\n");
        stringBuffer.append("  ? := " + string + ".Owner;\n");
        stringBuffer.append("  ? := " + string + ".Name;\n");
        stringBuffer.append("  ? := " + string + ".Line#;\n");
        stringBuffer.append("  ? := " + string + ".EntrypointName;\n");
        return stringBuffer.toString();
    }

    static int registerParameters(CallableStatement callableStatement, int n) throws Exception {
        callableStatement.registerOutParameter(n++, 4);
        callableStatement.registerOutParameter(n++, 12);
        callableStatement.registerOutParameter(n++, 12);
        callableStatement.registerOutParameter(n++, 4);
        callableStatement.registerOutParameter(n++, 12);
        return n;
    }

    int getParameters(CallableStatement callableStatement, int n) throws Exception {
        int n2 = callableStatement.getInt(n++);
        String string = callableStatement.getString(n++);
        String string2 = callableStatement.getString(n++);
        int n3 = callableStatement.getInt(n++);
        String string3 = callableStatement.getString(n++);
        this.location = new DebugProbeLocation(this.dp, n2, string, string2, n3, string3);
        return n;
    }

    String dump(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(string2);
        stringBuffer.append("\n");
        stringBuffer.append(string);
        stringBuffer.append("  libunitType:    ");
        stringBuffer.append(this.location.piLibunitType);
        stringBuffer.append("\n");
        stringBuffer.append(string);
        stringBuffer.append("  owner:          ");
        stringBuffer.append(this.location.piOwner);
        stringBuffer.append("\n");
        stringBuffer.append(string);
        stringBuffer.append("  name:           ");
        stringBuffer.append(this.location.piName);
        stringBuffer.append("\n");
        stringBuffer.append(string);
        stringBuffer.append("  lineNumber:     ");
        stringBuffer.append(this.location.piLineNumber);
        stringBuffer.append("\n");
        stringBuffer.append(string);
        stringBuffer.append("  entryPointName: ");
        stringBuffer.append(this.location.piEntryPointName);
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    private String getSourceCode() {
        if (this._sourceCode == null) {
            this._sourceCode = this.dp.callShowFrameSource(this);
        }
        return this._sourceCode;
    }

    void $init$() {
        this._locationOffset = -1;
    }

    private int getLocationOffset() {
        String string;
        if (this._locationOffset == -1 && this.location != null && this.location.piLineNumber > 0 && (string = this.getSourceCode()) != null) {
            int n = 1;
            int n2 = 0;
            while (true) {
                if (this.location.piLineNumber == n) {
                    this._locationOffset = n2;
                    break;
                }
                if ((n2 = string.indexOf("\n", n2)) == -1) break;
                ++n2;
                ++n;
            }
        }
        return this._locationOffset;
    }

    private void lookForVariables() {
        if (this.arguments == null || this.locals == null) {
            ArrayList arrayList;
            ArrayList arrayList2;
            block5: {
                ArrayList arrayList3 = new ArrayList();
                arrayList2 = new ArrayList();
                arrayList = new ArrayList();
                String string = this.getSourceCode();
                if (string != null) {
                    int n = this.getLocationOffset();
                    try {
                        ReadTextBuffer readTextBuffer = TextBufferFactory.createReadTextBuffer((String)string);
                        RootSymbol rootSymbol = PlsqlParser.parse((ReadTextBuffer)readTextBuffer);
                        if (rootSymbol != null) {
                            this.processPackages(rootSymbol.getPackages(), n, arrayList3, arrayList2, arrayList);
                            this.processFunctions(rootSymbol.getFunctions(), n, arrayList3, arrayList2, arrayList);
                        }
                    }
                    catch (Throwable throwable) {
                        if (!(throwable instanceof ThreadDeath)) break block5;
                        throw (ThreadDeath)throwable;
                    }
                }
            }
            this.arguments = arrayList.toArray(new DebugProbeVariableInfo[arrayList.size()]);
            this.locals = arrayList2.toArray(new DebugProbeVariableInfo[arrayList2.size()]);
        }
    }

    private void processPackages(PackageSymbol[] packageSymbolArray, int n, List list, List list2, List list3) {
        if (packageSymbolArray != null) {
            int n2 = packageSymbolArray.length;
            int n3 = 0;
            while (n3 < n2) {
                PackageSymbol packageSymbol = packageSymbolArray[n3];
                if (n >= packageSymbol.getStartOffset() && n < packageSymbol.getEndOffset()) {
                    this.processFunctions(packageSymbol.getFunctions(), n, list, list2, list3);
                }
                ++n3;
            }
        }
    }

    private void processFunctions(FunctionSymbol[] functionSymbolArray, int n, List list, List list2, List list3) {
        if (functionSymbolArray != null) {
            int n2 = functionSymbolArray.length;
            int n3 = 0;
            while (n3 < n2) {
                FunctionSymbol functionSymbol = functionSymbolArray[n3];
                if (n >= functionSymbol.getStartOffset() && n < functionSymbol.getEndOffset()) {
                    this.processCodeBlock((CodeBlockSymbol)functionSymbol, n, list, list2, list3);
                    this.processVariables(functionSymbol.getParameters(), list, list3);
                }
                ++n3;
            }
        }
    }

    private void processCodeBlock(CodeBlockSymbol codeBlockSymbol, int n, List list, List list2, List list3) {
        this.processFunctions(codeBlockSymbol.getFunctions(), n, list, list2, list3);
        this.processStatements(codeBlockSymbol.getStatements(), n, list, list2, list3);
        this.processTypes(codeBlockSymbol.getTypes());
        this.processVariables(codeBlockSymbol.getVariables(), list, list2);
    }

    private void processStatements(Statement[] statementArray, int n, List list, List list2, List list3) {
        if (statementArray != null) {
            int n2 = statementArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Statement statement = statementArray[n3];
                if (n >= statement.getStartOffset() && n < statement.getEndOffset()) {
                    NameSymbol nameSymbol;
                    CodeBlockSymbol codeBlockSymbol;
                    if (statement instanceof CompoundStatement) {
                        CompoundStatement compoundStatement = (CompoundStatement)statement;
                        this.processStatements(compoundStatement.getClauses(), n, list, list2, list3);
                    }
                    if ((codeBlockSymbol = statement.getBlock()) != null && n >= codeBlockSymbol.getStartOffset() && n < codeBlockSymbol.getEndOffset()) {
                        this.processCodeBlock(codeBlockSymbol, n, list, list2, list3);
                    }
                    if (statement instanceof CompoundStatement && (nameSymbol = ((CompoundStatement)statement).getVariableName()) != null) {
                        String string = nameSymbol.getValue();
                        this.processVariable(string, null, list, list2);
                    }
                }
                ++n3;
            }
        }
    }

    private String figureOutVariableType(String string) {
        String string2 = null;
        boolean bl = false;
        String string3 = string;
        String string4 = DebugProbeDataArrayInfo.isTableElementName(string);
        if (string4 != null) {
            string3 = string4;
            bl = true;
        }
        this.lookForVariables();
        DebugProbeVariableInfo debugProbeVariableInfo = DebugProbeStackFrameInfo.lookForVariableNamed(string3, this.arguments);
        if (debugProbeVariableInfo == null) {
            debugProbeVariableInfo = DebugProbeStackFrameInfo.lookForVariableNamed(string3, this.locals);
        }
        if (debugProbeVariableInfo != null) {
            string2 = debugProbeVariableInfo.dpv.getType();
            String string5 = this.getTypeDefinition(string2);
            if (string5 != null) {
                string2 = string5;
            }
            if (bl) {
                string2 = DebugProbeDataArrayInfo.getTableElementType(string2);
            }
        }
        return string2;
    }

    private static DebugProbeVariableInfo lookForVariableNamed(String string, DebugProbeVariableInfo[] debugProbeVariableInfoArray) {
        if (string != null) {
            int n = debugProbeVariableInfoArray.length - 1;
            while (n >= 0) {
                if (string.equalsIgnoreCase(debugProbeVariableInfoArray[n].name)) {
                    return debugProbeVariableInfoArray[n];
                }
                --n;
            }
        }
        return null;
    }

    protected Object getVariable(String string, String string2) {
        DebugProbeValue debugProbeValue = this.dp.getVariableValue(this, string, string2);
        if (debugProbeValue != null) {
            return new DebugProbeVariableInfo(this.dp, this, string, debugProbeValue, false, false);
        }
        return null;
    }

    void clearCachedData() {
        this.arguments = null;
        this.locals = null;
    }
}

