/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import oracle.ide.model.Node;
import oracle.ide.runner.SmartDataProvider;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.plsql.old.PlsqlLexer;
import oracle.javatools.parser.plsql.old.PlsqlParser;
import oracle.javatools.parser.plsql.old.PlsqlSyntaxRecognizer;
import oracle.javatools.parser.plsql.old.symbol.ErrorReporter;
import oracle.javatools.parser.plsql.old.symbol.ExpressionList;
import oracle.javatools.parser.plsql.old.symbol.ExpressionSymbol;
import oracle.jdeveloper.cm.dt.browser.jdbc.PlSqlBaseNode;
import oracle.jdevimpl.runner.debug.SmartPlsqlOperator;

public final class SmartPlsql
implements SmartDataProvider {
    public static void main(String[] stringArray) {
        SmartPlsql smartPlsql = new SmartPlsql();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            System.out.println("................................................................................");
            System.out.println("exp is \"" + string + "\"");
            ArrayList arrayList = new ArrayList();
            ReadTextBuffer readTextBuffer = TextBufferFactory.createReadTextBuffer((String)string);
            smartPlsql.getExpressions(readTextBuffer, 0, string.length(), arrayList);
            int n2 = 0;
            while (n2 < arrayList.size()) {
                System.out.println("expressions " + n2 + " is \"" + arrayList.get(n2) + "\"");
                ++n2;
            }
            System.out.println();
            ++n;
        }
    }

    public boolean canUnderstand(Node node) {
        return node instanceof PlSqlBaseNode;
    }

    public void getExpressions(ReadTextBuffer readTextBuffer, int n, int n2, List list) {
        try {
            int n3;
            int n4;
            PlsqlLexer plsqlLexer = new PlsqlLexer();
            LexerToken lexerToken = plsqlLexer.createLexerToken();
            plsqlLexer.setTextBuffer(readTextBuffer);
            plsqlLexer.setPosition(n);
            plsqlLexer.setSkipComments(true);
            while ((n4 = plsqlLexer.lex(lexerToken)) != 0 && (n3 = lexerToken.getStartOffset()) <= n2) {
                switch (n4) {
                    case 11: 
                    case 12: {
                        int n5 = SmartPlsql.usePlsqlParser(readTextBuffer, n3, list);
                        if (n5 == -1) break;
                        plsqlLexer.setPosition(n5);
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static int usePlsqlParser(ReadTextBuffer readTextBuffer, int n, List list) {
        PlsqlParser.ParsingOptions parsingOptions = new PlsqlParser.ParsingOptions();
        parsingOptions.reportErrors = true;
        parsingOptions.inputType = 2;
        parsingOptions.parseDepth = 2;
        parsingOptions.startOffset = n;
        ErrorReporter errorReporter = PlsqlParser.parse((ReadTextBuffer)readTextBuffer, (PlsqlParser.ParsingOptions)parsingOptions);
        if (errorReporter instanceof ExpressionSymbol) {
            ExpressionSymbol expressionSymbol = (ExpressionSymbol)errorReporter;
            SmartPlsql.processExpressionSymbol(expressionSymbol, list);
            return expressionSymbol.getEndOffset();
        }
        return -1;
    }

    private static StringBuffer[] processExpressionSymbol(ExpressionSymbol expressionSymbol, List list) {
        StringBuffer[] stringBufferArray = null;
        if (expressionSymbol != null) {
            ArrayList arrayList = new ArrayList();
            StringBuffer[] stringBufferArray2 = SmartPlsql.processExpressionList(expressionSymbol, arrayList);
            StringBuffer[] stringBufferArray3 = SmartPlsql.processExpressionSymbol(expressionSymbol.getFirstOperand(), arrayList);
            StringBuffer[] stringBufferArray4 = SmartPlsql.processExpressionSymbol(expressionSymbol.getSecondOperand(), arrayList);
            StringBuffer[] stringBufferArray5 = SmartPlsql.processExpressionSymbol(expressionSymbol.getThirdOperand(), arrayList);
            switch (expressionSymbol.getCategory()) {
                case 711: {
                    stringBufferArray = SmartPlsql.processPrefixOperator(expressionSymbol, stringBufferArray3, list);
                    break;
                }
                case 760: {
                    stringBufferArray = SmartPlsql.processArguments(expressionSymbol, stringBufferArray2);
                    break;
                }
                case 750: {
                    stringBufferArray = SmartPlsql.processPrimary(expressionSymbol, stringBufferArray2, list);
                }
            }
            list.addAll(arrayList);
        }
        return stringBufferArray;
    }

    private static boolean isPlsqlIdentifierStart(char c) {
        return Character.isJavaIdentifierStart(c);
    }

    private static StringBuffer[] processExpressionList(ExpressionSymbol expressionSymbol, List list) {
        StringBuffer[] stringBufferArray = null;
        if (expressionSymbol instanceof ExpressionList) {
            int n = expressionSymbol.getCategory();
            ExpressionSymbol[] expressionSymbolArray = ((ExpressionList)expressionSymbol).getExpressions();
            if (expressionSymbolArray != null) {
                int n2 = expressionSymbolArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    StringBuffer[] stringBufferArray2 = SmartPlsql.processExpressionSymbol(expressionSymbolArray[n3], list);
                    stringBufferArray = stringBufferArray == null || stringBufferArray.length == 0 ? stringBufferArray2 : SmartPlsqlOperator.performOperation(stringBufferArray, stringBufferArray2, new 6(n));
                    ++n3;
                }
            }
        }
        return stringBufferArray;
    }

    private static StringBuffer[] processPrefixOperator(ExpressionSymbol expressionSymbol, StringBuffer[] stringBufferArray, List list) {
        StringBuffer[] stringBufferArray2 = null;
        if (stringBufferArray != null) {
            switch (expressionSymbol.getExactCode()) {
                case 1096: {
                    stringBufferArray2 = SmartPlsqlOperator.performOperation(stringBufferArray, new 5(list));
                    break;
                }
                case 100: {
                    stringBufferArray2 = SmartPlsqlOperator.performOperation(stringBufferArray, new 4(list));
                    break;
                }
                case 111: {
                    stringBufferArray2 = SmartPlsqlOperator.performOperation(stringBufferArray, new 3(list));
                }
            }
        }
        return stringBufferArray2;
    }

    private static StringBuffer[] processArguments(ExpressionSymbol expressionSymbol, StringBuffer[] stringBufferArray) {
        StringBuffer[] stringBufferArray2 = SmartPlsqlOperator.performOperation(stringBufferArray, new 2());
        return stringBufferArray2;
    }

    private static StringBuffer[] processPrimary(ExpressionSymbol expressionSymbol, StringBuffer[] stringBufferArray, List list) {
        StringBuffer[] stringBufferArray2 = null;
        String string = expressionSymbol.getName().getValue();
        if (PlsqlSyntaxRecognizer.isLiteralToken((int)expressionSymbol.getExactCode())) {
            stringBufferArray2 = new StringBuffer[]{new StringBuffer(string)};
        } else if (expressionSymbol instanceof ExpressionList && stringBufferArray != null && stringBufferArray.length > 0) {
            stringBufferArray2 = SmartPlsql.processMethodInvocation(string);
            stringBufferArray2 = SmartPlsqlOperator.performOperation(stringBufferArray2, stringBufferArray, new 1());
            SmartPlsql.addPrimaryParts(stringBufferArray2, list);
        } else {
            stringBufferArray2 = new StringBuffer[]{new StringBuffer(string)};
            SmartPlsql.addPrimaryParts(stringBufferArray2, list);
        }
        return stringBufferArray2;
    }

    private static StringBuffer[] processMethodInvocation(String string) {
        int n;
        String string2 = string.toUpperCase();
        if (string2.regionMatches(n = string.lastIndexOf(46) + 1, "GET", 0, 3)) {
            return SmartPlsql.fixGetter(string, n, 3);
        }
        if (string2.regionMatches(n, "SET", 0, 3)) {
            return SmartPlsql.fixGetter(string, n, 3);
        }
        if (string2.regionMatches(n, "IS", 0, 2)) {
            return SmartPlsql.fixGetter(string, n, 2);
        }
        StringBuffer[] stringBufferArray = new StringBuffer[]{new StringBuffer(string)};
        return stringBufferArray;
    }

    private static StringBuffer[] fixGetter(String string, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.delete(n, n + n2);
        char c = stringBuffer.charAt(n);
        if (!Character.isLowerCase(c)) {
            stringBuffer.setCharAt(n, Character.toLowerCase(c));
        }
        String string2 = stringBuffer.toString();
        StringBuffer[] stringBufferArray = new StringBuffer[]{new StringBuffer(string2), new StringBuffer(string2)};
        stringBufferArray[1].insert(n, '_');
        return stringBufferArray;
    }

    private static void addPrimaryParts(StringBuffer[] stringBufferArray, List list) {
        if (stringBufferArray != null) {
            int n = stringBufferArray.length - 1;
            while (n >= 0) {
                SmartPlsql.addPrimaryParts(stringBufferArray[n].toString(), list);
                --n;
            }
        }
    }

    private static void addPrimaryParts(String string, List list) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".(", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            stringBuffer.append(string2);
            if (string2.equals(".") || string2.equals("(")) continue;
            SmartPlsql.addExpression(stringBuffer, list);
        }
    }

    private static void addExpression(StringBuffer[] stringBufferArray, List list) {
        if (stringBufferArray != null) {
            int n = stringBufferArray.length - 1;
            while (n >= 0) {
                SmartPlsql.addExpression(stringBufferArray[n].toString(), list);
                --n;
            }
        }
    }

    private static void addExpression(StringBuffer stringBuffer, List list) {
        SmartPlsql.addExpression(stringBuffer.toString(), list);
    }

    private static void addExpression(String string, List list) {
        list.add(string);
    }

    static boolean maS$isPlsqlIdentifierStart(char c) {
        return SmartPlsql.isPlsqlIdentifierStart(c);
    }

    static void maS$addExpression(StringBuffer stringBuffer, List list) {
        SmartPlsql.addExpression(stringBuffer, list);
    }

    public static final class 6
    extends SmartPlsqlOperator {
        private final /* synthetic */ int v$category;

        public void operate(StringBuffer stringBuffer, StringBuffer stringBuffer2) {
            if (this.v$category == 750) {
                if (stringBuffer2.length() > 0 && stringBuffer2.charAt(0) == '(') {
                    stringBuffer.append(stringBuffer2);
                } else {
                    stringBuffer.append(".").append(stringBuffer2);
                }
            } else if (this.v$category == 760) {
                stringBuffer.append(",").append(stringBuffer2);
            }
        }

        public 6(int n) {
            this.v$category = n;
        }
    }

    public static final class 5
    extends SmartPlsqlOperator {
        private final /* synthetic */ List v$listOfExpressions;

        public void operate(StringBuffer stringBuffer) {
            boolean bl = SmartPlsql.maS$isPlsqlIdentifierStart(stringBuffer.charAt(0));
            stringBuffer.insert(0, "NOT ");
            if (bl) {
                SmartPlsql.maS$addExpression(stringBuffer, this.v$listOfExpressions);
            }
        }

        public 5(List list) {
            this.v$listOfExpressions = list;
        }
    }

    public static final class 4
    extends SmartPlsqlOperator {
        private final /* synthetic */ List v$listOfExpressions;

        public void operate(StringBuffer stringBuffer) {
            boolean bl = SmartPlsql.maS$isPlsqlIdentifierStart(stringBuffer.charAt(0));
            stringBuffer.insert(0, "+");
            if (bl) {
                SmartPlsql.maS$addExpression(stringBuffer, this.v$listOfExpressions);
            }
        }

        public 4(List list) {
            this.v$listOfExpressions = list;
        }
    }

    public static final class 3
    extends SmartPlsqlOperator {
        private final /* synthetic */ List v$listOfExpressions;

        public void operate(StringBuffer stringBuffer) {
            boolean bl = SmartPlsql.maS$isPlsqlIdentifierStart(stringBuffer.charAt(0));
            stringBuffer.insert(0, "-");
            if (bl) {
                SmartPlsql.maS$addExpression(stringBuffer, this.v$listOfExpressions);
            }
        }

        public 3(List list) {
            this.v$listOfExpressions = list;
        }
    }

    public static final class 2
    extends SmartPlsqlOperator {
        public void operate(StringBuffer stringBuffer) {
            stringBuffer.insert(0, "(").append(")");
        }
    }

    public static final class 1
    extends SmartPlsqlOperator {
        public void operate(StringBuffer stringBuffer, StringBuffer stringBuffer2) {
            stringBuffer.append(stringBuffer2);
        }
    }
}

