/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.profile;

import java.awt.Component;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.editor.EditorManager;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.model.Element;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.util.ArrayResourceBundle;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdeveloper.cm.dt.browser.jdbc.PlSqlBaseNode;
import oracle.jdevimpl.runner.profile.ProfArb;

public class ProfilerShell
implements Addin,
Controller {
    static JMenuItem startSampleMenu;
    static IdeAction actionStartSample;
    private static final int PROFILE_START_SAMPLE_CMD_ID;
    private static final String ACCELERATOR_PATH = "oracle/jdevimpl/runner/profile/accelerator.xml";
    static ContextMenu contextMenu;

    static {
        PROFILE_START_SAMPLE_CMD_ID = Ide.findOrCreateCmdID((String)"ProfileShellStartSampleCommand");
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == PROFILE_START_SAMPLE_CMD_ID) {
            Element element;
            Element[] elementArray = context.getSelection();
            if (elementArray.length == 1 && (element = elementArray[0]) instanceof PlSqlBaseNode) {
                PlSqlBaseNode plSqlBaseNode = (PlSqlBaseNode)element;
                JOptionPane.showMessageDialog(null, "Execution profile action for " + plSqlBaseNode.getObjectType() + ": " + plSqlBaseNode.getShortLabel());
            }
            return true;
        }
        return false;
    }

    private boolean isTargetNode(Context context) {
        Element element;
        Element[] elementArray = context.getSelection();
        boolean bl = false;
        if (elementArray.length == 1 && (element = elementArray[0]) instanceof PlSqlBaseNode) {
            PlSqlBaseNode plSqlBaseNode = (PlSqlBaseNode)element;
            String string = plSqlBaseNode.getObjectType();
            bl = "FUNCTION".equals(string) || "PROCEDURE".equals(string) || "PACKAGE".equals(string) || "TRIGGER".equals(string) || "TYPE".equals(string);
        }
        return bl;
    }

    public boolean update(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == PROFILE_START_SAMPLE_CMD_ID) {
            boolean bl = this.isTargetNode(context);
            String string = "";
            if (bl) {
                PlSqlBaseNode plSqlBaseNode = (PlSqlBaseNode)context.getSelection()[0];
                string = plSqlBaseNode.getShortLabel();
            }
            String string2 = ProfArb.getString((int)13) + string;
            actionStartSample.putValue("Name", (Object)string2);
            ideAction.setEnabled(bl);
            return true;
        }
        return false;
    }

    public void initialize() {
        this.createMenus();
        actionStartSample.setEnabled(false);
    }

    private void createMenus() {
        this.createRunMenuItem();
        this.createContextMenuItems();
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        keyStrokeContextRegistry.addAcceleratorDefinitionFile(this.getClass().getClassLoader(), ACCELERATOR_PATH);
    }

    void createRunMenuItem() {
        Menubar menubar = Ide.getMenubar();
        JMenu jMenu = MenuManager.getJMenu((String)"Run");
        String string = jMenu.getText();
        actionStartSample = IdeAction.get((int)PROFILE_START_SAMPLE_CMD_ID, null, (String)ProfArb.getString((int)13), (String)string, (Integer)ProfArb.getInteger((int)14), (ArrayResourceBundle)ProfArb.getInstance(), (int)15, null, (boolean)false);
        actionStartSample.addController((Controller)this);
        actionStartSample.putValue("NoCtxName", (Object)ProfArb.getString((int)13));
        startSampleMenu = menubar.createMenuItem((ToggleAction)actionStartSample, JDeveloperMenuConstants.WEIGHT_RUN_PROFILE_EXECUTION);
        menubar.add((Component)startSampleMenu, jMenu, JDeveloperMenuConstants.SECTION_RUN_PROFILE);
    }

    void createContextMenuItems() {
        EditorManager editorManager = EditorManager.getEditorManager();
        ContextMenu contextMenu = editorManager.getContextMenu();
        contextMenu.addContextMenuListener((ContextMenuListener)new 2());
        NavigatorManager navigatorManager = NavigatorManager.getConnectionNavigatorManager();
        ContextMenu contextMenu2 = navigatorManager.getContextMenu();
        contextMenu2.addContextMenuListener((ContextMenuListener)new 1());
    }

    static boolean mav$isTargetNode(ProfilerShell profilerShell, Context context) {
        return profilerShell.isTargetNode(context);
    }

    public final class 2
    implements ContextMenuListener {
        public void menuWillShow(ContextMenu contextMenu) {
            Context context = contextMenu.getContext();
            if (ProfilerShell.mav$isTargetNode(ProfilerShell.this, context)) {
                JMenuItem jMenuItem = contextMenu.createMenuItem((ToggleAction)actionStartSample);
                contextMenu.add((Component)jMenuItem, MenuConstants.SECTION_RUN_CTXT_MENU);
            }
        }

        public void menuWillHide(ContextMenu contextMenu) {
        }

        public boolean handleDefaultAction(Context context) {
            return false;
        }
    }

    public final class 1
    implements ContextMenuListener {
        public void menuWillShow(ContextMenu contextMenu) {
            Context context = contextMenu.getContext();
            if (ProfilerShell.mav$isTargetNode(ProfilerShell.this, context)) {
                JMenuItem jMenuItem = contextMenu.createMenuItem((ToggleAction)actionStartSample);
                contextMenu.add((Component)jMenuItem, MenuConstants.SECTION_RUN_CTXT_MENU);
            }
        }

        public void menuWillHide(ContextMenu contextMenu) {
        }

        public boolean handleDefaultAction(Context context) {
            return false;
        }
    }
}

