/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.sqlj.compiler;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import oracle.ide.Addin;
import oracle.ide.compiler.Compiler;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.Navigable;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.cm.CMException;
import oracle.jdeveloper.cm.CMUtils;
import oracle.jdeveloper.cm.ConnectionDescriptor;
import oracle.jdeveloper.cm.ConnectionManager;
import oracle.jdeveloper.compiler.Helpers;
import oracle.jdeveloper.compiler.JCompiler;
import oracle.jdeveloper.compiler.OjcConfiguration;
import oracle.jdeveloper.compiler.Translator;
import oracle.jdeveloper.compiler.UnifiedBuildSystem;
import oracle.jdeveloper.model.JavaProject;
import oracle.jdevimpl.sqlj.compiler.Res;
import oracle.jdevimpl.sqlj.compiler.SqljInternal;
import oracle.jdevimpl.sqlj.compiler.SqljUtil;
import oracle.jdevimpl.sqlj.config.SqljConfiguration;
import oracle.jdevimpl.sqlj.config.SqljConfigurationPanel;
import oracle.ojc.compiler.Scanner;
import oracle.ojc.interfaces.ErrorInfo;
import oracle.ojc.interfaces.IdeEnv;
import oracle.ojc.interfaces.Log;
import oracle.ojc.interfaces.Storage;

public class Sqlj
implements Addin,
Translator {
    private Translator.Log log;
    private IdeEnv ide;
    private SqljInternal sqlj;
    private SqljConfiguration sqljConfig;
    private boolean warnAll;
    private boolean warnVerbose;
    private boolean warnNull;
    private boolean warnPortable;
    private boolean warnPrecision;
    private boolean warnStrict;
    private boolean online;
    private HashStructure contexts;
    private boolean useCache;
    private String codegen;
    public static final String SQLJ_CONFIG_DATA_KEY = SqljConfiguration.class.getName();

    void $init$() {
        this.log = null;
        this.ide = new MainEnv();
        this.sqlj = null;
        this.sqljConfig = null;
    }

    public Sqlj() {
        this.$init$();
    }

    public String getName() {
        return "SQLJ";
    }

    public ArrayList getInputTypes() {
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add(".sqlj");
        return arrayList;
    }

    public ArrayList getOutputTypes() {
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add(".java");
        return arrayList;
    }

    public boolean canBuild(Storage storage) {
        return storage.getName().endsWith(".sqlj");
    }

    public boolean needToBuild(Storage storage) {
        return storage.getName().endsWith(".java");
    }

    public void setProject(Project project) {
    }

    public void updateProject(Project project) {
    }

    public void setParameter(String string, String string2) {
        throw new Error();
    }

    public void setLog(Translator.Log log) {
        this.log = log;
    }

    public int translate(Project project, boolean bl, ArrayList arrayList, ArrayList arrayList2) {
        try {
            URL uRL;
            String string;
            Storage[] storageArray;
            if (this.sqlj == null) {
                this.sqlj = new SqljInternal(this.ide);
            }
            this.sqlj.setProjectURL(project.getURL());
            Project project2 = project;
            OjcConfiguration ojcConfiguration = OjcConfiguration.getInstance((PropertyStorage)project2);
            this.sqljConfig = SqljConfiguration.getInstance((PropertyStorage)project2);
            boolean bl2 = UnifiedBuildSystem.showCompileProgress ^ true;
            1 var8_8 = new 1(this, bl2);
            this.codegen = this.sqljConfig.getCodegen();
            this.warnAll = this.sqljConfig.isWarnAll();
            if (!this.warnAll) {
                this.warnNull = this.sqljConfig.isWarnNull();
                this.warnPrecision = this.sqljConfig.isWarnPrecision();
                this.warnPortable = this.sqljConfig.isWarnPortable();
                this.warnStrict = this.sqljConfig.isWarnStrict();
            }
            this.online = this.sqljConfig.isCheckSemantics();
            if (this.online) {
                this.useCache = true;
                this.contexts = this.sqljConfig.getContextConnectionMap();
            }
            Storage[] storageArray2 = new Storage[arrayList.size()];
            int n = 0;
            while (n < arrayList.size()) {
                storageArray2[n] = (Storage)arrayList.get(n);
                ++n;
            }
            if (storageArray2 != null && storageArray2.length > 0 && (storageArray = this._translate(project, storageArray2, string = URLFileSystem.getPlatformPathName((URL)(uRL = JavaProject.getInstance((Project)project2).getOutputDirectory())), var8_8, bl)) != null) {
                int n2 = 0;
                while (n2 < storageArray.length) {
                    arrayList2.add(storageArray[n2]);
                    ++n2;
                }
            }
            this.sqlj.cleanup();
        }
        catch (Throwable throwable) {
            Compiler.getCompiler().logOutMsg("SQLJ precompiler internal error\n");
        }
        return 0;
    }

    public void initialize() {
        JCompiler.getInstance().registerTranslator((Translator)this);
        Navigable navigable = new Navigable(Res.getString(0), SqljConfigurationPanel.class);
        JCompiler.getInstance().registerNavigable(navigable);
    }

    private void addDependentJavaFiles(Storage[] storageArray) {
        Storage[] storageArray2 = new Storage[storageArray.length];
        boolean bl = false;
        int n = 0;
        while (n < storageArray.length) {
            if (storageArray[n].getName().endsWith(".java")) {
                storageArray2[n] = storageArray[n];
                bl = true;
            } else {
                storageArray2[n] = null;
            }
            ++n;
        }
        this.sqlj.addDependentJavaFiles((Storage[])(bl ? storageArray2 : null));
    }

    private Storage[] _translate(Project project, Storage[] storageArray, String string, Log log, boolean bl) {
        Properties properties = this.createProperties();
        Storage[] storageArray2 = new Storage[storageArray.length];
        int n = 0;
        this.addDependentJavaFiles(storageArray);
        ArrayList<Storage> arrayList = new ArrayList<Storage>();
        ArrayList<Storage> arrayList2 = new ArrayList<Storage>();
        int n2 = 0;
        while (n2 < storageArray.length) {
            if (!storageArray[n2].getName().endsWith(".java")) {
                Storage storage = storageArray[n2];
                String string2 = SqljUtil.getOutputPathName((Project)project, (String)storage.getPath());
                if (this.ide.authorizeParsing(storage, "translating SQLJ")) {
                    Storage storage2 = Helpers.createFileStorage((String)string2);
                    boolean bl2 = (bl || this.needsRebuild(storage, storage2)) ^ true;
                    if (!bl2) {
                        if (UnifiedBuildSystem.showCompileProgress) {
                            log.println("  compiling " + storage.toString());
                        }
                        arrayList.add(storage);
                        arrayList2.add(storage2);
                    }
                }
            }
            ++n2;
        }
        if (arrayList.size() > 0) {
            ArrayList arrayList3 = this.sqlj.translate(arrayList, arrayList2, log, properties);
            int n3 = 0;
            while (n3 < arrayList.size()) {
                Storage storage = (Storage)arrayList.get(n3);
                Storage storage3 = (Storage)arrayList2.get(n3);
                if (arrayList3 != null && ((Boolean)arrayList3.get(n3)).booleanValue()) {
                    storageArray2[n++] = storage3;
                } else {
                    storage3.close();
                }
                storage.close();
                ++n3;
            }
        }
        if (n == 0) {
            storageArray2 = null;
        } else if (n < storageArray2.length) {
            Storage[] storageArray3 = new Storage[n];
            System.arraycopy(storageArray2, 0, storageArray3, 0, n);
            storageArray2 = storageArray3;
        }
        return storageArray2;
    }

    private boolean needsRebuild(Storage storage, Storage storage2) {
        Storage storage3 = Helpers.createFileStorage((String)storage2.toString());
        return storage.modDate() > storage3.modDate();
    }

    private Properties createProperties() {
        String string;
        Properties properties = new Properties();
        properties.put("verbose", "true");
        properties.put("status", "true");
        properties.put("codegen", this.codegen);
        if (this.warnAll) {
            string = "all";
        } else {
            string = "none";
            if (this.warnVerbose) {
                string = string + ",verbose";
            }
            if (this.warnNull) {
                string = string + ",nulls";
            }
            if (this.warnPrecision) {
                string = string + ",precision";
            }
            if (this.warnPortable) {
                string = string + ",portable";
            }
            if (this.warnStrict) {
                string = string + ",strict";
            }
        }
        properties.put("warn", string);
        if (this.online) {
            properties.put("cache", this.useCache ? "1" : "0");
            if (this.contexts != null && this.contexts.size() > 0) {
                ConnectionManager connectionManager = ConnectionManager.getInstance();
                String string2 = "";
                for (String string3 : this.contexts.keySet()) {
                    ConnectionDescriptor connectionDescriptor;
                    String string4 = this.contexts.getString(string3);
                    if (string3 == null || string3.equals(SqljConfiguration.NO_CONTEXT)) {
                        string3 = "";
                    }
                    if (string4 == null || string4.length() <= 0) continue;
                    try {
                        connectionDescriptor = connectionManager.getConnectionDescriptor(string4);
                    }
                    catch (IOException iOException) {
                        connectionDescriptor = null;
                    }
                    if (!this._isJdbcConnectionDescriptor(connectionDescriptor)) continue;
                    String string5 = connectionDescriptor.getJdbcDriver();
                    String string6 = connectionDescriptor.getUsername();
                    String string7 = connectionDescriptor.getPassword();
                    String string8 = null;
                    try {
                        string8 = CMUtils.getUrl((String)"JDBC", (ConnectionDescriptor)connectionDescriptor);
                    }
                    catch (CMException cMException) {
                        // empty catch block
                    }
                    boolean bl = connectionDescriptor.isDeployPassword();
                    if (string5 != null && string5.length() > 0) {
                        if (string2.length() > 0) {
                            string2 = string2 + ",";
                        }
                        string2 = string2 + string5;
                    }
                    String string9 = string3 != null && string3.length() > 0 ? "@" + string3 : "";
                    if (string6 == null) continue;
                    properties.put("user" + string9, string6);
                    if (string7 != null && string7.length() > 0) {
                        properties.put("password" + string9, string7);
                    }
                    properties.put("url" + string9, string8);
                    String string10 = "oracle.sqlj.checker.OracleChecker";
                    properties.put("online" + string9, string10);
                }
                properties.put("driver", string2);
            }
        }
        this.sqljConfig.addAdditionalParameters(properties);
        return properties;
    }

    private boolean _isJdbcConnectionDescriptor(ConnectionDescriptor connectionDescriptor) {
        if (connectionDescriptor == null) {
            return false;
        }
        String string = connectionDescriptor.getConnectionType();
        if (string == null) {
            return false;
        }
        return string.equals("JDBC") || string.equals("ORACLE_JSERVER") || string.equals("JDBC");
    }

    static Translator.Log ra$log(Sqlj sqlj) {
        return sqlj.log;
    }

    public final class 1
    implements Log {
        static final /* synthetic */ boolean $assertionsDisabled;
        private final /* synthetic */ boolean v$quiet;
        final /* synthetic */ Sqlj this$0;

        static {
            $assertionsDisabled = 1.class.desiredAssertionStatus() ^ true;
        }

        public void redirect(String string) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }

        public void print(String string) {
            if (!this.v$quiet) {
                System.out.println("Log.print(): " + string);
            }
        }

        public void println(String string) {
            if (!this.v$quiet) {
                Compiler.getCompiler().logOutMsg(string + "\n");
            }
        }

        public void printError(Storage storage, int n, ErrorInfo errorInfo) {
            Sqlj.ra$log(this.this$0).error(storage, Scanner.positionToLine((int)n), Scanner.positionToColumn((int)n), errorInfo.getNumber(), errorInfo.getMessage());
        }

        public void printWarning(Storage storage, int n, ErrorInfo errorInfo) {
            Sqlj.ra$log(this.this$0).warning(storage, Scanner.positionToLine((int)n), Scanner.positionToColumn((int)n), errorInfo.getNumber(), errorInfo.getMessage());
        }

        public int nerrors() {
            return Sqlj.ra$log(this.this$0).nerrors();
        }

        public int nwarnings() {
            return Sqlj.ra$log(this.this$0).nwarnings();
        }

        public 1(Sqlj sqlj, boolean bl) {
            this.v$quiet = bl;
            this.this$0 = sqlj;
        }
    }

    public class MainEnv
    implements IdeEnv {
        public boolean authorizeParsing(Storage storage, String string) {
            return Thread.currentThread().isInterrupted() ^ true;
        }

        public boolean authorizeChecking(Storage storage, String string) {
            return Thread.currentThread().isInterrupted() ^ true;
        }

        public boolean authorizeWriting(Storage storage, String string, byte[] byArray, int n, int n2) {
            return Thread.currentThread().isInterrupted() ^ true;
        }

        MainEnv() {
        }
    }
}

